/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.Dump$;
import org.nlogo.api.JobOwner;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ$;
import org.nlogo.core.I18N$;
import org.nlogo.core.Monitor;
import org.nlogo.core.Monitor$;
import org.nlogo.editor.Colorizer;
import org.nlogo.nvm.Procedure;
import org.nlogo.swing.MouseUtils;
import org.nlogo.swing.RoundedBorderPanel;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.Events;
import org.nlogo.window.JobWidget;
import org.nlogo.window.MonitorEditPanel;
import org.nlogo.window.MonitorWidget$;
import org.nlogo.window.Widget;
import scala.;
import scala.$less$colon$less$;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class MonitorWidget
extends JobWidget
implements Editable,
ToMonitorModel,
Events.RuntimeErrorEvent.Handler,
Events.PeriodicUpdateEvent.Handler,
Events.JobRemovedEvent.Handler,
MouseListener {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MonitorWidget.class.getDeclaredField("valueLabel$lzy1"));
    private final CompilerServices compiler;
    private final Colorizer colorizer;
    private boolean jobRunning;
    private boolean hasError;
    private String _name;
    private Option<Object> _value;
    private String valueString;
    private int _decimalPlaces;
    private boolean lastMousePressedWasPopupTrigger;
    private int _fontSize;
    private final JLabel nameLabel;
    private volatile Object valueLabel$lzy1;
    private final ValuePanel valuePanel;
    private final JLabel unitsLabel;

    public MonitorWidget(MersenneTwisterFast random, CompilerServices compiler, Colorizer colorizer) {
        this.compiler = compiler;
        this.colorizer = colorizer;
        super(random);
        this.jobRunning = false;
        this.hasError = false;
        this._name = "";
        this._value = Option$.MODULE$.empty();
        this.valueString = "";
        this._decimalPlaces = MonitorWidget$.org$nlogo$window$MonitorWidget$$$DefaultDecimalPlaces;
        this.lastMousePressedWasPopupTrigger = false;
        this._fontSize = MonitorWidget$.org$nlogo$window$MonitorWidget$$$DefaultFontSize;
        this.nameLabel = new JLabel(I18N$.MODULE$.gui().get("edit.monitor.previewName"));
        this.valuePanel = new ValuePanel(this.valueLabel());
        this.unitsLabel = new JLabel();
        this.unitsLabel.setVisible(false);
        this.addMouseListener(this);
        this.setLayout(new GridBagLayout());
        this.initGUI();
    }

    private MersenneTwisterFast random$accessor() {
        return super.random();
    }

    private JLabel valueLabel() {
        Object object = this.valueLabel$lzy1;
        if (object instanceof JLabel) {
            return (JLabel)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JLabel)this.valueLabel$lzyINIT1();
    }

    private Object valueLabel$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.valueLabel$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    JLabel jLabel = null;
                    try {
                        jLabel = new JLabel();
                        serializable = jLabel == null ? LazyVals.NullValue$.MODULE$ : jLabel;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.valueLabel$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return jLabel;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void initGUI() {
        this.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.anchor = 18;
        c.insets = this._oldSize() ? new Insets(this.zoom(3.0), this.zoom(6.0), 0, this.zoom(6.0)) : new Insets(this.zoom(6.0), this.zoom(8.0), this.zoom(6.0), this.zoom(8.0));
        this.add((Component)this.nameLabel, c);
        this.nameLabel.setFont(this.nameLabel.getFont().deriveFont(this._boldState()));
        c.gridwidth = 1;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = this._oldSize() ? new Insets(0, this.zoom(6.0), this.zoom(6.0), this.zoom(6.0)) : new Insets(0, this.zoom(8.0), this.zoom(8.0), this.zoom(8.0));
        this.add((Component)this.valuePanel, c);
        c.gridx = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = this._oldSize() ? new Insets(0, 0, this.zoom(6.0), this.zoom(6.0)) : new Insets(0, 0, this.zoom(8.0), this.zoom(8.0));
        this.add((Component)this.unitsLabel, c);
        this.unitsLabel.setFont(this.unitsLabel.getFont().deriveFont(this._boldState()));
    }

    public void setDisplayName(String name) {
        this._name = name;
        this.chooseDisplayName();
        this.repaint();
    }

    @Override
    public String name() {
        return this._name;
    }

    public void setFontSize(int size) {
        int n;
        this._fontSize = size;
        if (this.originalFont() != null) {
            int zoomDiff = this.getFont().getSize() - this.originalFont().getSize();
            n = zoomDiff + size;
        } else {
            n = size;
        }
        int newFontSize = n;
        this.setFont(this.getFont().deriveFont((float)newFontSize));
        if (this.originalFont() != null) {
            this.originalFont_$eq(this.originalFont().deriveFont((float)size));
        }
        this.resetZoomInfo();
        this.resetSizeInfo();
    }

    @Override
    public void setFont(Font f) {
        if (this.isZoomed() || this.getFont() == null) {
            super.setFont(f);
            this.valueLabel().setFont(f);
        } else {
            Font newFont = this.getFont().deriveFont((float)this.fontSize());
            super.setFont(newFont);
            this.valueLabel().setFont(newFont);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public int fontSize() {
        return this._fontSize;
    }

    @Override
    public String units() {
        return this.unitsLabel.getText();
    }

    public void setUnits(String value) {
        this.unitsLabel.setText(value.trim());
        this.unitsLabel.setVisible(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value.trim())));
        this.revalidate();
        this.repaint();
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.monitor");
    }

    @Override
    public EditPanel editPanel() {
        return new MonitorEditPanel(this, this.compiler, this.colorizer);
    }

    @Override
    public Option<Editable> getEditable() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public AgentKind kind() {
        return AgentKindJ$.MODULE$.Observer();
    }

    @Override
    public boolean ownsPrimaryJobs() {
        return false;
    }

    @Override
    public void procedure_$eq(Procedure procedure) {
        super.procedure_$eq(procedure);
        this.halt();
        if (procedure != null) {
            this.hasError = false;
            new Events.AddJobEvent(this, this.agents(), procedure).raise(this);
            this.jobRunning = true;
        }
        this.syncTheme();
        this.repaint();
    }

    public Object value() {
        return this._value.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public void value(Object value) {
        String newString;
        this._value = Option$.MODULE$.apply(value);
        String string = newString = Dump$.MODULE$.logoObject(value);
        String string2 = this.valueString;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.valueString = newString;
            this.valueLabel().setText(this.valueString);
            this.repaint();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void chooseDisplayName() {
        if (this.name() == null) ** GOTO lbl-1000
        v0 = this.name();
        var1_1 = "";
        if (!(v0 != null ? v0.equals(var1_1) == false : var1_1 != null)) lbl-1000:
        // 2 sources

        {
            v1 = this.getSourceName();
            var2_2 = "";
            if (!(v1 != null ? v1.equals(var2_2) == false : var2_2 != null)) {
                this.displayName(I18N$.MODULE$.gui().get("edit.monitor.previewName"));
            } else {
                this.displayName(this.getSourceName());
            }
        } else {
            this.displayName(this.name());
        }
        this.nameLabel.setText(this.displayName());
        if (this.nameLabel.getPreferredSize().width > this.nameLabel.getWidth()) {
            this.nameLabel.setToolTipText(this.nameLabel.getText());
            return;
        }
        this.nameLabel.setToolTipText(null);
    }

    private String getSourceName() {
        return this.innerSource().trim().replaceAll("\\s+", " ");
    }

    @Override
    public void removeNotify() {
        if (EventQueue.isDispatchThread()) {
            this.halt();
        }
        super.removeNotify();
    }

    @Override
    public void suppressRecompiles(boolean suppressRecompiles) {
        String string = this.innerSource().trim();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.recompilePending(false);
        }
        super.suppressRecompiles(suppressRecompiles);
    }

    @Override
    public void syncTheme() {
        this.setBackgroundColor(InterfaceColors$.MODULE$.monitorBackground());
        if (this.anyErrors()) {
            this.nameLabel.setForeground(Color.RED);
        } else {
            this.nameLabel.setForeground(InterfaceColors$.MODULE$.widgetText());
        }
        this.valueLabel().setForeground(InterfaceColors$.MODULE$.displayAreaText());
        this.unitsLabel.setForeground(InterfaceColors$.MODULE$.widgetText());
        this.valuePanel.syncTheme();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._oldSize()) {
            return new Dimension(MonitorWidget$.org$nlogo$window$MonitorWidget$$$MinWidth, this.fontSize() * 4 + 1);
        }
        return new Dimension(100, 60);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._oldSize()) {
            return new Dimension(100, this.getMinimumSize().height);
        }
        return new Dimension(100, 60);
    }

    @Override
    public int decimalPlaces() {
        return this._decimalPlaces;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        if (decimalPlaces != this._decimalPlaces) {
            this._decimalPlaces = decimalPlaces;
            this.setWrapSource(this.innerSource());
            return;
        }
    }

    @Override
    public void innerSource_$eq(String innerSource) {
        super.innerSource_$eq(innerSource);
        this.chooseDisplayName();
    }

    public void setWrapSource(String innerSource) {
        String string = innerSource.trim();
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.source("", "", "");
            this.halt();
        } else {
            this.source("to __monitor [] __observercode loop [ __updatemonitor __monitorprecision (", innerSource, "\n) " + this.decimalPlaces() + " ] end");
        }
        this.chooseDisplayName();
    }

    public String wrapSource() {
        return this.innerSource();
    }

    @Override
    public void handle(Events.RuntimeErrorEvent e) {
        MonitorWidget monitorWidget = this;
        JobOwner jobOwner = e.jobOwner;
        if (!(monitorWidget != null ? !monitorWidget.equals(jobOwner) : jobOwner != null)) {
            this.hasError = true;
            this.halt();
            this.syncTheme();
            this.repaint();
            return;
        }
    }

    @Override
    public void handle(Events.PeriodicUpdateEvent e) {
        if (!this.jobRunning && this.procedure() != null) {
            this.hasError = false;
            this.jobRunning = true;
            new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
        }
        this.syncTheme();
        this.repaint();
    }

    @Override
    public void handle(Events.JobRemovedEvent e) {
        JobOwner jobOwner = e.owner;
        MonitorWidget monitorWidget = this;
        if (!(jobOwner != null ? !jobOwner.equals(monitorWidget) : monitorWidget != null)) {
            this.jobRunning = false;
            this.value(this.hasError ? I18N$.MODULE$.gui().get("tabs.run.widgets.monitor.notApplicable") : "");
            return;
        }
    }

    public void halt() {
        new Events.RemoveJobEvent(this).raise(this);
    }

    @Override
    public void load(org.nlogo.core.Widget model) {
        org.nlogo.core.Widget widget = model;
        if (widget instanceof Monitor) {
            Monitor monitor = (Monitor)widget;
            this.setUnits((String)monitor.units().getOrElse(MonitorWidget::load$$anonfun$1));
            this.setDisplayName((String)monitor.display().getOrElse(MonitorWidget::load$$anonfun$2));
            this._decimalPlaces = monitor.precision();
            this.setFontSize(monitor.fontSize());
            monitor.source().foreach(innerSource -> this.setWrapSource((String)innerSource));
            this.oldSize(monitor.oldSize());
            this.setSize(monitor.width(), monitor.height());
            this.chooseDisplayName();
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && !e.isPopupTrigger() && this.error().isDefined() && !this.lastMousePressedWasPopupTrigger) {
            new Events.EditWidgetEvent(this).raise(this);
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastMousePressedWasPopupTrigger = e.isPopupTrigger();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private static final String load$$anonfun$1() {
        return "";
    }

    private static final String load$$anonfun$2() {
        return "";
    }

    public static interface ToMonitorModel {
        public int decimalPlaces();

        public String units();

        public int fontSize();

        public String innerSource();

        public String name();

        public static org.nlogo.core.Widget model$(ToMonitorModel $this) {
            return $this.model();
        }

        default public org.nlogo.core.Widget model() {
            Rectangle b = ((Widget)((Object)this)).getUnzoomedBounds();
            Option<String> display = ((Widget)((Object)this)).RichWidgetString(this.name()).potentiallyEmptyStringToOption();
            Option<String> src = ((Widget)((Object)this)).RichWidgetString(this.innerSource()).potentiallyEmptyStringToOption();
            int n = b.x;
            int n2 = b.y;
            int n3 = b.width;
            int n4 = b.height;
            boolean bl = ((Widget)((Object)this))._oldSize();
            int n5 = this.decimalPlaces();
            int n6 = this.fontSize();
            None$ none$ = this.units().isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.units());
            return Monitor$.MODULE$.apply(src, n, n2, n3, n4, bl, display, n5, n6, (Option<String>)none$);
        }
    }

    public class ValuePanel
    extends JPanel
    implements Transparent,
    MouseUtils,
    RoundedBorderPanel,
    ThemeSync {
        private boolean org$nlogo$swing$MouseUtils$$useHandCursor;
        private boolean org$nlogo$swing$MouseUtils$$hover;
        private boolean org$nlogo$swing$MouseUtils$$pressed;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        private Color org$nlogo$swing$RoundedBorderPanel$$borderColor;
        private int org$nlogo$swing$RoundedBorderPanel$$diameter;
        private boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        private boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;

        public ValuePanel(JLabel label) {
            if (MonitorWidget.this == null) {
                throw new NullPointerException();
            }
            super(new GridBagLayout());
            Transparent.$init$(this);
            MouseUtils.$init$(this);
            RoundedBorderPanel.$init$(this);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.anchor = 17;
            c.insets = new Insets(0, MonitorWidget.this.zoom(6.0), 0, MonitorWidget.this.zoom(6.0));
            this.add((Component)label, c);
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$useHandCursor() {
            return this.org$nlogo$swing$MouseUtils$$useHandCursor;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$hover() {
            return this.org$nlogo$swing$MouseUtils$$hover;
        }

        @Override
        public boolean org$nlogo$swing$MouseUtils$$pressed() {
            return this.org$nlogo$swing$MouseUtils$$pressed;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$useHandCursor_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$useHandCursor = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$hover_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$hover = x$1;
        }

        @Override
        public void org$nlogo$swing$MouseUtils$$pressed_$eq(boolean x$1) {
            this.org$nlogo$swing$MouseUtils$$pressed = x$1;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
        }

        @Override
        public Color org$nlogo$swing$RoundedBorderPanel$$borderColor() {
            return this.org$nlogo$swing$RoundedBorderPanel$$borderColor;
        }

        @Override
        public int org$nlogo$swing$RoundedBorderPanel$$diameter() {
            return this.org$nlogo$swing$RoundedBorderPanel$$diameter;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
        }

        @Override
        public boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled() {
            return this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$borderColor_$eq(Color x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$borderColor = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$diameter_$eq(int x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$diameter = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$hoverEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled = x$1;
        }

        @Override
        public void org$nlogo$swing$RoundedBorderPanel$$pressedEnabled_$eq(boolean x$1) {
            this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled = x$1;
        }

        @Override
        public /* synthetic */ void org$nlogo$swing$RoundedBorderPanel$$super$paintComponent(Graphics x$0) {
            super.paintComponent(x$0);
        }

        @Override
        public void paintComponent(Graphics g) {
            this.setDiameter(Int$.MODULE$.int2double(MonitorWidget.this.zoom(6.0)));
            RoundedBorderPanel.paintComponent$(this, g);
        }

        @Override
        public void syncTheme() {
            this.setBackgroundColor(InterfaceColors$.MODULE$.displayAreaBackground());
            this.setBorderColor(InterfaceColors$.MODULE$.monitorBorder());
        }

        public final /* synthetic */ MonitorWidget org$nlogo$window$MonitorWidget$ValuePanel$$$outer() {
            return MonitorWidget.this;
        }
    }
}

