/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import org.nlogo.core.I18N$;
import org.nlogo.core.TextBox;
import org.nlogo.core.TextBox$;
import org.nlogo.core.Widget;
import org.nlogo.theme.ClassicTheme$;
import org.nlogo.theme.ColorTheme;
import org.nlogo.theme.DarkTheme$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.LightTheme$;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.NoteEditPanel;
import org.nlogo.window.SingleErrorWidget;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class NoteWidget
extends SingleErrorWidget
implements Editable {
    private final JEditorPane textPane;
    private final int MIN_WIDTH;
    private final int DEFAULT_WIDTH;
    private final int MIN_HEIGHT;
    private int _width;
    private String _text;
    private int _fontSize;
    private Color _textColorLight;
    private Color _textColorDark;
    private Color _backgroundLight;
    private Color _backgroundDark;
    private boolean _markdown;
    private final HtmlRenderer renderer;
    private final Parser parser;
    private final String css;

    public NoteWidget() {
        HtmlRenderer renderer;
        Parser parser;
        block3: {
            Tuple2 tuple2;
            block2: {
                this.textPane = new JEditorPane(this){
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        super("text/html", "");
                        this.setEditable(false);
                        this.setOpaque(false);
                        this.setCaret(new SilentCaret());
                    }
                };
                this.setBorder(new EmptyBorder(0, 3, 0, 4));
                this.setLayout(new BoxLayout(this, 1));
                this.add(this.textPane);
                Predef$.MODULE$.locally((Object)this.add(Box.createVerticalGlue()));
                this.MIN_WIDTH = 15;
                this.DEFAULT_WIDTH = 150;
                this.MIN_HEIGHT = 18;
                this._width = this.DEFAULT_WIDTH();
                this._text = "";
                this._fontSize = this.textPane.getFont().getSize();
                this._textColorLight = Color.BLACK;
                this._textColorDark = Color.WHITE;
                this._backgroundLight = InterfaceColors$.MODULE$.Transparent();
                this._backgroundDark = InterfaceColors$.MODULE$.Transparent();
                this._markdown = false;
                ArrayList<Extension> extensions = new ArrayList<Extension>();
                extensions.add(EscapedCharacterExtension.create());
                extensions.add(TypographicExtension.create());
                extensions.add(AutolinkExtension.create());
                MutableDataSet options = new MutableDataSet();
                options.setFrom((MutableDataSetter)ParserEmulationProfile.PEGDOWN);
                options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
                options.set(HtmlRenderer.HARD_BREAK, (Object)"<br />\n");
                options.set(TypographicExtension.ENABLE_QUOTES, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                options.set(TypographicExtension.ENABLE_SMARTS, (Object)BoxesRunTime.boxToBoolean((boolean)true));
                options.set(Parser.MATCH_CLOSING_FENCE_CHARACTERS, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                options.set(Parser.EXTENSIONS, extensions);
                DataHolder opts = options.toImmutable();
                tuple2 = Tuple2$.MODULE$.apply((Object)HtmlRenderer.builder((DataHolder)opts).build(), (Object)Parser.builder((DataHolder)opts).build());
                if (tuple2 == null) break block2;
                HtmlRenderer htmlRenderer = (HtmlRenderer)tuple2._1();
                parser = (Parser)tuple2._2();
                if (htmlRenderer == null) break block2;
                renderer = htmlRenderer;
                if (parser != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        Parser parser2 = parser;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)renderer, (Object)parser2);
        this.renderer = (HtmlRenderer)tuple2._1();
        this.parser = (Parser)tuple2._2();
        this.css = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("<head>\n                      |  <style type=\"text/css\">\n                      |    ul, ol {\n                      |      margin-left: 8px;\n                      |    }\n                      |  </style>\n                      |</head>"));
    }

    public int MIN_WIDTH() {
        return this.MIN_WIDTH;
    }

    public int DEFAULT_WIDTH() {
        return this.DEFAULT_WIDTH;
    }

    public int MIN_HEIGHT() {
        return this.MIN_HEIGHT;
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.note");
    }

    @Override
    public EditPanel editPanel() {
        return new NoteEditPanel(this);
    }

    @Override
    public Option<Editable> getEditable() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public boolean isNote() {
        return true;
    }

    private void wrapText() {
        if (this._markdown) {
            String text = this.renderer.render((Node)this.parser.parse(this._text));
            this.textPane.setText("<html>" + this.css + "<body style=\"width: " + (double)this.textPane.getWidth() / 1.3 + "px\">" + text + "</body></html>");
        } else {
            this.textPane.setText(this._text.replace("\n", "<br>"));
        }
        this.repaint();
    }

    public String text() {
        return this._text;
    }

    public void setText(String newText) {
        this._text = newText;
        this.displayName_$eq(newText);
        this.wrapText();
    }

    public int fontSize() {
        return this._fontSize;
    }

    public void setFontSize(int size) {
        this._fontSize = size;
        if (this.isZoomed() && this.originalFont() != null) {
            int zoomDiff = this.getFont().getSize() - this.originalFont().getSize();
            this.textPane.setFont(this.textPane.getFont().deriveFont((float)(size + zoomDiff)));
        } else {
            this.textPane.setFont(this.textPane.getFont().deriveFont((float)size));
        }
        if (this.originalFont() != null) {
            this.originalFont_$eq(this.originalFont().deriveFont((float)size));
        }
        this.resetZoomInfo();
        this.resetSizeInfo();
        this.wrapText();
    }

    public Color textColorLight() {
        return this._textColorLight;
    }

    public void setTextColorLight(Color color) {
        this._textColorLight = color;
        this.syncTheme();
    }

    public Color textColorDark() {
        return this._textColorDark;
    }

    public void setTextColorDark(Color color) {
        this._textColorDark = color;
        this.syncTheme();
    }

    public Color backgroundLight() {
        return this._backgroundLight;
    }

    public void setBackgroundLight(Color color) {
        this._backgroundLight = color;
        this.syncTheme();
    }

    public Color backgroundDark() {
        return this._backgroundDark;
    }

    public void setBackgroundDark(Color color) {
        this._backgroundDark = color;
        this.syncTheme();
    }

    public boolean markdown() {
        return this._markdown;
    }

    public void setMarkdown(boolean value) {
        this._markdown = value;
        this.wrapText();
    }

    @Override
    public void setBounds(Rectangle r) {
        if (r.width > 0) {
            this._width = r.width;
        }
        super.setBounds(r);
        this.wrapText();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width > 0) {
            this._width = width;
        }
        super.setBounds(x, y, width, height);
        this.wrapText();
    }

    @Override
    public boolean editFinished() {
        this.syncTheme();
        return super.editFinished();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.MIN_WIDTH(), this.MIN_HEIGHT());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.MIN_WIDTH()), this._width), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.MIN_HEIGHT()), this.textPane.getPreferredSize().height + 8));
    }

    @Override
    public void syncTheme() {
        ColorTheme colorTheme = InterfaceColors$.MODULE$.getTheme();
        if (ClassicTheme$.MODULE$.equals(colorTheme) || LightTheme$.MODULE$.equals(colorTheme)) {
            this.setBackgroundColor(this._backgroundLight);
            this.textPane.setForeground(this._textColorLight);
        } else if (DarkTheme$.MODULE$.equals(colorTheme)) {
            this.setBackgroundColor(this._backgroundDark);
            this.textPane.setForeground(this._textColorDark);
        } else {
            throw new IllegalStateException();
        }
        this.repaint();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Widget model() {
        b = this.getUnzoomedBounds();
        if (this.text() == null) ** GOTO lbl-1000
        v0 = this.text().trim();
        var3_2 = "";
        if (v0 == null ? var3_2 != null : v0.equals(var3_2) == false) {
            v1 = Some$.MODULE$.apply((Object)this.text());
        } else lbl-1000:
        // 2 sources

        {
            v1 = None$.MODULE$;
        }
        txt = v1;
        return TextBox$.MODULE$.apply((Option<String>)txt, b.x, b.y, b.width, b.height, this.fontSize(), this.markdown(), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.textColorLight().getRGB())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.textColorDark().getRGB())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.backgroundLight().getRGB())), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.backgroundDark().getRGB())));
    }

    @Override
    public void load(Widget model) {
        Widget widget = model;
        if (widget instanceof TextBox) {
            TextBox note = (TextBox)widget;
            this.setText((String)note.display().getOrElse(NoteWidget::load$$anonfun$1));
            this.setFontSize(note.fontSize());
            this.setMarkdown(note.markdown());
            note.textColorLight().foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> this.setTextColorLight(new Color(c, true)));
            note.textColorDark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> this.setTextColorDark(new Color(c, true)));
            note.backgroundLight().foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> this.setBackgroundLight(new Color(c, true)));
            note.backgroundDark().foreach((Function1)(JFunction1.mcVI.sp & Serializable)c -> this.setBackgroundDark(new Color(c, true)));
            this.syncTheme();
            this.setSize(note.width(), note.height());
            return;
        }
    }

    private static final String load$$anonfun$1() {
        return "";
    }

    public class SilentCaret
    extends DefaultCaret {
        @Override
        public void adjustVisibility(Rectangle nloc) {
        }
    }
}

