/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import org.nlogo.agent.OutputObject;
import org.nlogo.awt.Fonts$;
import org.nlogo.awt.LineBreaker$;
import org.nlogo.swing.MouseUtils;
import org.nlogo.swing.RoundedBorderPanel;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.TextArea;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.OutputArea$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public class OutputArea
extends JPanel
implements Transparent,
MouseUtils,
RoundedBorderPanel,
ThemeSync {
    private boolean org$nlogo$swing$MouseUtils$$useHandCursor;
    private boolean org$nlogo$swing$MouseUtils$$hover;
    private boolean org$nlogo$swing$MouseUtils$$pressed;
    private Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
    private Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
    private Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
    private Color org$nlogo$swing$RoundedBorderPanel$$borderColor;
    private int org$nlogo$swing$RoundedBorderPanel$$diameter;
    private boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
    private boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
    private final TextArea text;
    private double zoomFactor;
    public final ScrollPane org$nlogo$window$OutputArea$$scrollPane;
    private boolean addCarriageReturn;
    private Option<String> lastTemporaryAddition;

    public static OutputArea withNextFocus(Component component) {
        return OutputArea$.MODULE$.withNextFocus(component);
    }

    public OutputArea(TextArea text) {
        this.text = text;
        Transparent.$init$(this);
        MouseUtils.$init$(this);
        RoundedBorderPanel.$init$(this);
        this.setOpaque(false);
        this.zoomFactor = 1.0;
        this.org$nlogo$window$OutputArea$$scrollPane = new ScrollPane(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.text(), 22, 30);
                this.setBorder(null);
            }
        };
        this.addCarriageReturn = false;
        this.lastTemporaryAddition = Option$.MODULE$.empty();
        text.setEditable(false);
        text.setDragEnabled(false);
        this.fontSize(12);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.org$nlogo$window$OutputArea$$scrollPane, c);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Override
    public boolean org$nlogo$swing$MouseUtils$$useHandCursor() {
        return this.org$nlogo$swing$MouseUtils$$useHandCursor;
    }

    @Override
    public boolean org$nlogo$swing$MouseUtils$$hover() {
        return this.org$nlogo$swing$MouseUtils$$hover;
    }

    @Override
    public boolean org$nlogo$swing$MouseUtils$$pressed() {
        return this.org$nlogo$swing$MouseUtils$$pressed;
    }

    @Override
    public void org$nlogo$swing$MouseUtils$$useHandCursor_$eq(boolean x$1) {
        this.org$nlogo$swing$MouseUtils$$useHandCursor = x$1;
    }

    @Override
    public void org$nlogo$swing$MouseUtils$$hover_$eq(boolean x$1) {
        this.org$nlogo$swing$MouseUtils$$hover = x$1;
    }

    @Override
    public void org$nlogo$swing$MouseUtils$$pressed_$eq(boolean x$1) {
        this.org$nlogo$swing$MouseUtils$$pressed = x$1;
    }

    @Override
    public Color org$nlogo$swing$RoundedBorderPanel$$backgroundColor() {
        return this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor;
    }

    @Override
    public Color org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor() {
        return this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor;
    }

    @Override
    public Color org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor() {
        return this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor;
    }

    @Override
    public Color org$nlogo$swing$RoundedBorderPanel$$borderColor() {
        return this.org$nlogo$swing$RoundedBorderPanel$$borderColor;
    }

    @Override
    public int org$nlogo$swing$RoundedBorderPanel$$diameter() {
        return this.org$nlogo$swing$RoundedBorderPanel$$diameter;
    }

    @Override
    public boolean org$nlogo$swing$RoundedBorderPanel$$hoverEnabled() {
        return this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled;
    }

    @Override
    public boolean org$nlogo$swing$RoundedBorderPanel$$pressedEnabled() {
        return this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled;
    }

    @Override
    public void org$nlogo$swing$RoundedBorderPanel$$backgroundColor_$eq(Color x$1) {
        this.org$nlogo$swing$RoundedBorderPanel$$backgroundColor = x$1;
    }

    @Override
    public void org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor_$eq(Color x$1) {
        this.org$nlogo$swing$RoundedBorderPanel$$backgroundHoverColor = x$1;
    }

    @Override
    public void org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor_$eq(Color x$1) {
        this.org$nlogo$swing$RoundedBorderPanel$$backgroundPressedColor = x$1;
    }

    @Override
    public void org$nlogo$swing$RoundedBorderPanel$$borderColor_$eq(Color x$1) {
        this.org$nlogo$swing$RoundedBorderPanel$$borderColor = x$1;
    }

    @Override
    public void org$nlogo$swing$RoundedBorderPanel$$diameter_$eq(int x$1) {
        this.org$nlogo$swing$RoundedBorderPanel$$diameter = x$1;
    }

    @Override
    public void org$nlogo$swing$RoundedBorderPanel$$hoverEnabled_$eq(boolean x$1) {
        this.org$nlogo$swing$RoundedBorderPanel$$hoverEnabled = x$1;
    }

    @Override
    public void org$nlogo$swing$RoundedBorderPanel$$pressedEnabled_$eq(boolean x$1) {
        this.org$nlogo$swing$RoundedBorderPanel$$pressedEnabled = x$1;
    }

    @Override
    public /* synthetic */ void org$nlogo$swing$RoundedBorderPanel$$super$paintComponent(Graphics x$0) {
        super.paintComponent(x$0);
    }

    public TextArea text() {
        return this.text;
    }

    public double zoomFactor() {
        return this.zoomFactor;
    }

    public void zoomFactor_$eq(double x$1) {
        this.zoomFactor = x$1;
    }

    public OutputArea() {
        this(new DefaultTextArea());
    }

    public String valueText() {
        return this.text().getText();
    }

    public String getTextForExport() {
        if (this.addCarriageReturn) {
            return this.text().getText() + "\n";
        }
        return this.text().getText();
    }

    public int fontSize() {
        return this.text().getFont().getSize();
    }

    public void fontSize(int fontSize) {
        this.text().setFont(new Font(Fonts$.MODULE$.platformMonospacedFont(), 0, fontSize));
    }

    public void clear() {
        this.text().setText("");
        this.addCarriageReturn = false;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(OutputArea$.org$nlogo$window$OutputArea$$$MinimumWidth, this.text().getMinimumSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(OutputArea$.org$nlogo$window$OutputArea$$$PreferredWidth, OutputArea$.org$nlogo$window$OutputArea$$$PreferredHeight);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setDiameter((double)6 * this.zoomFactor());
        RoundedBorderPanel.paintComponent$(this, g);
    }

    @Override
    public void syncTheme() {
        this.setBackgroundColor(InterfaceColors$.MODULE$.commandOutputBackground());
        this.setBorderColor(InterfaceColors$.MODULE$.outputBorder());
        this.text().syncTheme();
        this.org$nlogo$window$OutputArea$$scrollPane.setBackground(InterfaceColors$.MODULE$.commandOutputBackground());
    }

    public void append(OutputObject oo, boolean wrapLines) {
        String str;
        Object message = oo.get();
        this.lastTemporaryAddition.foreach(addition -> {
            String contents = this.text().getText();
            if (contents.length() >= addition.length()) {
                String string = contents.substring(contents.length() - addition.length());
                String string2 = addition;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    this.text().replaceRange("", contents.length() - addition.length(), contents.length());
                    return;
                }
            }
        });
        this.lastTemporaryAddition = None$.MODULE$;
        FontMetrics metrics = this.getFontMetrics(this.text().getFont());
        if (wrapLines) {
            message = LineBreaker$.MODULE$.breakLines((String)message, metrics, this.text().getWidth() - OutputArea$.org$nlogo$window$OutputArea$$$GuessScrollBarWidth).mkString("\n") + "\n";
        }
        StringBuilder buf = new StringBuilder();
        if (this.addCarriageReturn) {
            buf.append('\n');
            this.addCarriageReturn = false;
        }
        buf.append((String)message);
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) == '\n') {
            buf.setLength(buf.length() - 1);
            this.addCarriageReturn = true;
        }
        String cut = metrics.stringWidth(str = buf.toString()) > Short.MAX_VALUE ? str.substring(0, Short.MAX_VALUE / metrics.charWidth('a') - 3) + "..." : str;
        this.text().append(cut);
        this.lastTemporaryAddition = None$.MODULE$;
        if (oo.isTemporary()) {
            this.text().select(this.text().getText().length() - cut.length(), this.text().getText().length());
            this.lastTemporaryAddition = Some$.MODULE$.apply((Object)this.text().getSelectedText());
        }
        EventQueue.invokeLater(new Runnable(this){
            private final /* synthetic */ OutputArea $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.org$nlogo$window$OutputArea$$scrollPane.getVerticalScrollBar().setValue(this.$outer.org$nlogo$window$OutputArea$$scrollPane.getVerticalScrollBar().getMaximum());
                this.$outer.org$nlogo$window$OutputArea$$scrollPane.getHorizontalScrollBar().setValue(0);
            }
        });
    }

    public static class DefaultTextArea
    extends TextArea {
        public DefaultTextArea() {
            super(0, 0, "");
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(50, (int)((double)this.getRowHeight() * 1.25));
        }
    }

    public static class DefaultTextAreaWithNextFocus
    extends DefaultTextArea {
        private final Component nextComponent;

        public DefaultTextAreaWithNextFocus(Component nextComponent) {
            this.nextComponent = nextComponent;
        }

        @Override
        public void transferFocus() {
            this.nextComponent.requestFocus();
        }
    }
}

