/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JSlider;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.MersenneTwisterFast;
import org.nlogo.core.Direction;
import org.nlogo.core.Horizontal$;
import org.nlogo.core.I18N$;
import org.nlogo.core.Slider;
import org.nlogo.core.Slider$;
import org.nlogo.core.Vertical$;
import org.nlogo.core.Widget;
import org.nlogo.editor.Colorizer;
import org.nlogo.window.AbstractSliderWidget;
import org.nlogo.window.EditPanel;
import org.nlogo.window.Editable;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceGlobalWidget;
import org.nlogo.window.MultiErrorWidget;
import org.nlogo.window.SliderData;
import org.nlogo.window.SliderEditPanel;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class SliderWidget
extends MultiErrorWidget
implements AbstractSliderWidget,
InterfaceGlobalWidget,
Editable,
Events.PeriodicUpdateEvent.Handler,
Events.AfterLoadEvent.Handler {
    private String _name;
    private String org$nlogo$window$AbstractSliderWidget$$_units;
    private boolean org$nlogo$window$AbstractSliderWidget$$_vertical;
    private SliderData org$nlogo$window$AbstractSliderWidget$$sliderData;
    private AbstractSliderWidget.Label nameComponent;
    private AbstractSliderWidget.TextField valueComponent;
    private AbstractSliderWidget.Label unitsComponent;
    private JSlider slider;
    private boolean jumpOnClick;
    private final boolean eventOnReleaseOnly;
    private final CompilerServices compiler;
    private final Colorizer colorizer;
    private final ExtensionManager extensionManager;
    private String _minimumCode;
    private String _maximumCode;
    private String _incrementCode;
    private double defaultValue;
    private boolean nameChanged;

    public SliderWidget(boolean eventOnReleaseOnly, MersenneTwisterFast random, CompilerServices compiler, Colorizer colorizer, ExtensionManager extensionManager) {
        this.eventOnReleaseOnly = eventOnReleaseOnly;
        this.compiler = compiler;
        this.colorizer = colorizer;
        this.extensionManager = extensionManager;
        AbstractSliderWidget.$init$(this);
        this._minimumCode = "0";
        this._maximumCode = "100";
        this._incrementCode = "1";
        this.defaultValue = 1.0;
        this.nameChanged = false;
        Statics.releaseFence();
    }

    @Override
    public String _name() {
        return this._name;
    }

    @Override
    public String org$nlogo$window$AbstractSliderWidget$$_units() {
        return this.org$nlogo$window$AbstractSliderWidget$$_units;
    }

    @Override
    public boolean org$nlogo$window$AbstractSliderWidget$$_vertical() {
        return this.org$nlogo$window$AbstractSliderWidget$$_vertical;
    }

    @Override
    public SliderData org$nlogo$window$AbstractSliderWidget$$sliderData() {
        return this.org$nlogo$window$AbstractSliderWidget$$sliderData;
    }

    @Override
    public AbstractSliderWidget.Label nameComponent() {
        return this.nameComponent;
    }

    @Override
    public AbstractSliderWidget.TextField valueComponent() {
        return this.valueComponent;
    }

    @Override
    public AbstractSliderWidget.Label unitsComponent() {
        return this.unitsComponent;
    }

    @Override
    public JSlider slider() {
        return this.slider;
    }

    @Override
    public boolean jumpOnClick() {
        return this.jumpOnClick;
    }

    @Override
    public void _name_$eq(String x$1) {
        this._name = x$1;
    }

    @Override
    public void org$nlogo$window$AbstractSliderWidget$$_units_$eq(String x$1) {
        this.org$nlogo$window$AbstractSliderWidget$$_units = x$1;
    }

    @Override
    public void org$nlogo$window$AbstractSliderWidget$$_vertical_$eq(boolean x$1) {
        this.org$nlogo$window$AbstractSliderWidget$$_vertical = x$1;
    }

    @Override
    public void jumpOnClick_$eq(boolean x$1) {
        this.jumpOnClick = x$1;
    }

    @Override
    public void org$nlogo$window$AbstractSliderWidget$_setter_$org$nlogo$window$AbstractSliderWidget$$sliderData_$eq(SliderData x$0) {
        this.org$nlogo$window$AbstractSliderWidget$$sliderData = x$0;
    }

    @Override
    public void org$nlogo$window$AbstractSliderWidget$_setter_$nameComponent_$eq(AbstractSliderWidget.Label x$0) {
        this.nameComponent = x$0;
    }

    @Override
    public void org$nlogo$window$AbstractSliderWidget$_setter_$valueComponent_$eq(AbstractSliderWidget.TextField x$0) {
        this.valueComponent = x$0;
    }

    @Override
    public void org$nlogo$window$AbstractSliderWidget$_setter_$unitsComponent_$eq(AbstractSliderWidget.Label x$0) {
        this.unitsComponent = x$0;
    }

    @Override
    public void org$nlogo$window$AbstractSliderWidget$_setter_$slider_$eq(JSlider x$0) {
        this.slider = x$0;
    }

    @Override
    public /* synthetic */ void org$nlogo$window$AbstractSliderWidget$$super$paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public SliderWidget(MersenneTwisterFast random, CompilerServices compiler, Colorizer colorizer, ExtensionManager extensionManager) {
        this(false, random, compiler, colorizer, extensionManager);
    }

    public String minimumCode() {
        return this._minimumCode;
    }

    public void setMinimumCode(String s) {
        this._minimumCode = s;
        this.updateConstraints();
    }

    public String maximumCode() {
        return this._maximumCode;
    }

    public void setMaximumCode(String s) {
        this._maximumCode = s;
        this.updateConstraints();
    }

    public String incrementCode() {
        return this._incrementCode;
    }

    public void setIncrementCode(String s) {
        this._incrementCode = s;
        this.updateConstraints();
    }

    @Override
    public String classDisplayName() {
        return I18N$.MODULE$.gui().get("tabs.run.widgets.slider");
    }

    @Override
    public EditPanel editPanel() {
        return new SliderEditPanel(this, this.compiler, this.colorizer, this.extensionManager);
    }

    @Override
    public Option<Editable> getEditable() {
        return Some$.MODULE$.apply((Object)this);
    }

    @Override
    public Object valueObject() {
        return BoxesRunTime.boxToDouble((double)AbstractSliderWidget.value$(this));
    }

    @Override
    public void setValue(double v) {
        if (!this.anyErrors() && (v != this.value() || v < this.minimum() || v > this.effectiveMaximum())) {
            AbstractSliderWidget.setValue$(this, v);
            new Events.InterfaceGlobalEvent(this, false, false, true, false).raise(this);
            return;
        }
    }

    public void setValue(double v, boolean buttonRelease) {
        boolean valueChanged;
        boolean bl = valueChanged = v != this.value() || v < this.minimum() || v > this.effectiveMaximum();
        if (valueChanged) {
            AbstractSliderWidget.setValue$(this, v);
            if (!this.eventOnReleaseOnly) {
                new Events.InterfaceGlobalEvent(this, false, false, true, buttonRelease).raise(this);
            }
        }
        if (this.eventOnReleaseOnly && buttonRelease) {
            new Events.InterfaceGlobalEvent(this, false, false, valueChanged, buttonRelease).raise(this);
            return;
        }
    }

    @Override
    public void forceValue(double v) {
        AbstractSliderWidget.forceValue$(this, v);
        new Events.InterfaceGlobalEvent(this, false, false, true, false).raise(this);
    }

    @Override
    public void valueObject(Object v) {
        Double d;
        Object object = v;
        if (object instanceof Double && !BoxesRunTime.equals((Object)(d = (Double)object), (Object)BoxesRunTime.boxToDouble((double)this.value()))) {
            AbstractSliderWidget.forceValue$(this, Predef$.MODULE$.Double2double(d));
            return;
        }
    }

    public void setNameWrapper(String n) {
        this.nameChanged = !n.equals(this.name()) || this.nameChanged;
        this.setName(n, false);
    }

    @Override
    public void setVarName(String n) {
        this.setName(n, true);
    }

    private void setName(String name, boolean sendEvent) {
        AbstractSliderWidget.setVarName$(this, name);
        if (sendEvent) {
            new Events.InterfaceGlobalEvent(this, true, false, false, false).raise(this);
            return;
        }
    }

    @Override
    public boolean editFinished() {
        super.editFinished();
        this.removeAllErrors();
        this.setName(this.name(), this.nameChanged);
        this.nameChanged = false;
        this.updateConstraints();
        this.forceValue(StrictMath.min(StrictMath.max(this.value(), this.minimum()), this.maximum()));
        return true;
    }

    @Override
    public boolean setSliderConstraint(SliderConstraint con) {
        if (!this.anyErrors() && AbstractSliderWidget.setSliderConstraint$(this, con)) {
            this.revalidate();
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public void updateConstraints() {
        new Events.AddSliderConstraintEvent(this, this.name(), this.minimumCode(), this.maximumCode(), this.incrementCode(), Predef$.MODULE$.double2Double(this.defaultValue)).raise(this);
    }

    @Override
    public Option<String> errorString() {
        try {
            if (this.checkRecursive(this.compiler, this.minimumCode(), this.name()) || this.checkRecursive(this.compiler, this.maximumCode(), this.name()) || this.checkRecursive(this.compiler, this.incrementCode(), this.name())) {
                return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().get("edit.general.recursive"));
            }
            if (StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(this.minimumCode())) >= StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(this.maximumCode()))) {
                return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().get("edit.slider.invalidBounds"));
            }
            if (StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(this.incrementCode())) > StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(this.maximumCode())) - StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(this.minimumCode()))) {
                return Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().get("edit.slider.invalidIncrement"));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return None$.MODULE$;
    }

    @Override
    public void handle(Events.AfterLoadEvent e) {
        this.updateConstraints();
        this.forceValue(this.defaultValue);
    }

    @Override
    public void handle(Events.PeriodicUpdateEvent e) {
        new Events.InterfaceGlobalEvent(this, false, true, false, false).raise(this);
        if (!this.anyErrors()) {
            this.setSliderConstraint(this.constraint());
            return;
        }
    }

    @Override
    public void load(Widget model) {
        Widget widget = model;
        if (widget instanceof Slider) {
            Slider s = (Slider)widget;
            String min = s.min();
            String max = s.max();
            double v = s.default();
            String inc = s.step();
            this.setUnits(this.RichStringOption(s.units()).optionToPotentiallyEmptyString());
            Direction direction = s.direction();
            Vertical$ vertical$ = Vertical$.MODULE$;
            this.setVertical(!(direction != null ? !direction.equals(vertical$) : vertical$ != null));
            this.setVarName(this.RichStringOption(s.display()).optionToPotentiallyEmptyString());
            this.setMinimumCode(min);
            this.setMaximumCode(max);
            this.setMinimumCode(min);
            this.setIncrementCode(inc);
            this.defaultValue = v;
            this.oldSize(s.oldSize());
            this.setSize(s.width(), s.height());
            return;
        }
    }

    @Override
    public Widget model() {
        Option<String> savedName = this.RichWidgetString(this.name()).potentiallyEmptyStringToOption();
        Option<String> savedUnits = this.RichWidgetString(this.units()).potentiallyEmptyStringToOption();
        Direction dir = (Direction)((Object)(this.vertical() ? Vertical$.MODULE$ : Horizontal$.MODULE$));
        Rectangle b = this.getUnzoomedBounds();
        int n = b.x;
        int n2 = b.y;
        int n3 = b.width;
        int n4 = b.height;
        boolean bl = this._oldSize();
        String string = this.minimumCode();
        String string2 = this.maximumCode();
        double d = this.value();
        String string3 = this.incrementCode();
        return Slider$.MODULE$.apply(savedName, n, n2, n3, n4, bl, savedName, string, string2, d, string3, savedUnits, dir);
    }
}

