/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.core.I18N$;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.Events;
import org.nlogo.window.MultiErrorWidget;
import org.nlogo.window.Switch$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxedUnit;

public abstract class Switch
extends MultiErrorWidget
implements Events.AfterLoadEvent.Handler {
    private BooleanConstraint constraint = new BooleanConstraint();
    private final JLabel label = new JLabel(I18N$.MODULE$.gui().get("edit.switch.previewName"));
    private final Toggle toggle = new Toggle();
    private boolean nameChanged = false;
    private String _name = "";

    public static int CHANNEL_HEIGHT() {
        return Switch$.MODULE$.CHANNEL_HEIGHT();
    }

    public static int MINHEIGHT() {
        return Switch$.MODULE$.MINHEIGHT();
    }

    public static int MINWIDTH() {
        return Switch$.MODULE$.MINWIDTH();
    }

    public Switch() {
        this.setLayout(new GridBagLayout());
        this.initGUI();
        MouseAdapter mouseListener = new MouseAdapter(this){
            private final /* synthetic */ Switch $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mousePressed(MouseEvent e) {
                new Events.InputBoxLoseFocusEvent().raise(this.$outer);
                if (e.getButton() == 1) {
                    this.$outer.isOn_$eq(!this.$outer.isOn());
                    return;
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.label().addMouseListener(mouseListener);
        this.toggle().addMouseListener(mouseListener);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public BooleanConstraint constraint() {
        return this.constraint;
    }

    public void constraint_$eq(BooleanConstraint x$1) {
        this.constraint = x$1;
    }

    public JLabel label() {
        return this.label;
    }

    public Toggle toggle() {
        return this.toggle;
    }

    public boolean nameChanged() {
        return this.nameChanged;
    }

    public void nameChanged_$eq(boolean x$1) {
        this.nameChanged = x$1;
    }

    public String _name() {
        return this._name;
    }

    public void _name_$eq(String x$1) {
        this._name = x$1;
    }

    @Override
    public void initGUI() {
        this.removeAll();
        if (this._oldSize()) {
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, this.zoom(6.0), 0, this.zoom(6.0));
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)this.label(), c);
            c.insets = new Insets(this.zoom(6.0), 0, this.zoom(6.0), this.zoom(6.0));
            c.fill = 3;
            c.weightx = 0.0;
            c.weighty = 1.0;
            c.anchor = 13;
            this.add((Component)this.toggle(), c);
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, this.zoom(8.0), 0, this.zoom(8.0));
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)this.label(), c);
        this.label().setFont(this.label().getFont().deriveFont(this._boldState()));
        c.insets = new Insets(this.zoom(8.0), 0, this.zoom(8.0), this.zoom(8.0));
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 13;
        this.add((Component)this.toggle(), c);
    }

    public boolean isOn() {
        return this.constraint().defaultValue();
    }

    public void isOn_$eq(boolean on) {
        if (this.isOn() != on) {
            this.constraint().defaultValue_$eq(Predef$.MODULE$.boolean2Boolean(on));
            this.updateConstraints();
            this.repaint();
            new Events.DirtyEvent((Option<String>)None$.MODULE$).raise(this);
            return;
        }
    }

    public String name() {
        return this._name();
    }

    public void setVarName(String name) {
        this._name_$eq(name);
        String string = name;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.displayName(I18N$.MODULE$.gui().get("edit.switch.previewName"));
        } else {
            this.displayName(name);
        }
        this.label().setText(this.displayName());
        this.repaint();
    }

    @Override
    public void updateConstraints() {
        if (this._name().length() > 0) {
            new Events.AddBooleanConstraintEvent(this._name(), Predef$.MODULE$.boolean2Boolean(this.isOn())).raise(this);
            return;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._oldSize()) {
            return new Dimension(super.getPreferredSize().width, Switch$.MODULE$.MINHEIGHT());
        }
        return new Dimension(super.getPreferredSize().width, 40);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this._oldSize()) {
            return new Dimension(Switch$.MODULE$.MINWIDTH(), Switch$.MODULE$.MINHEIGHT());
        }
        return new Dimension(50, 40);
    }

    @Override
    public void syncTheme() {
        this.setBackgroundColor(InterfaceColors$.MODULE$.switchBackground());
        this.label().setForeground(InterfaceColors$.MODULE$.widgetText());
    }

    public class Toggle
    extends JPanel {
        public boolean org$nlogo$window$Switch$Toggle$$hover;

        public Toggle() {
            if (Switch.this == null) {
                throw new NullPointerException();
            }
            this.org$nlogo$window$Switch$Toggle$$hover = false;
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Toggle $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void mouseEntered(MouseEvent e) {
                    this.$outer.org$nlogo$window$Switch$Toggle$$hover = true;
                    this.$outer.repaint();
                }

                public void mouseExited(MouseEvent e) {
                    this.$outer.org$nlogo$window$Switch$Toggle$$hover = false;
                    this.$outer.repaint();
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(Switch.this.zoom(10.0), super.getPreferredSize().height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        @Override
        public void paintComponent(Graphics g) {
            int d;
            Graphics2D g2d = Utils$.MODULE$.initGraphics2D(g);
            if (Switch.this.isOn()) {
                g2d.setColor(InterfaceColors$.MODULE$.switchToggleBackgroundOn());
            } else {
                g2d.setColor(InterfaceColors$.MODULE$.switchToggleBackgroundOff());
            }
            g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.getWidth(), this.getWidth());
            int y = Switch.this.isOn() ? 0 : this.getHeight() - this.getWidth();
            int n = d = Switch.this.isOn() ? 3 : -3;
            if (this.org$nlogo$window$Switch$Toggle$$hover) {
                g2d.setPaint(new RadialGradientPaint((float)this.getWidth() / 2.0f, (float)y + (float)this.getWidth() / 2.0f + (float)d, (float)this.getWidth() / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{InterfaceColors$.MODULE$.widgetHoverShadow(), InterfaceColors$.MODULE$.Transparent()}));
                g2d.fillOval(0, y + d, this.getWidth(), this.getWidth());
            }
            g2d.setColor(InterfaceColors$.MODULE$.switchToggleBackgroundOn());
            g2d.fillOval(0, y, this.getWidth(), this.getWidth());
            g2d.setColor(InterfaceColors$.MODULE$.switchToggle());
            g2d.fillOval(1, y + 1, this.getWidth() - 2, this.getWidth() - 2);
        }

        public final /* synthetic */ Switch org$nlogo$window$Switch$Toggle$$$outer() {
            return Switch.this;
        }
    }
}

