/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Exceptions;
import org.nlogo.api.Patch;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.WorkspaceContext;
import org.nlogo.awt.Colors;
import org.nlogo.awt.Hierarchy;
import org.nlogo.awt.ImageSelection;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.I18N;
import org.nlogo.core.Shape;
import org.nlogo.shape.VectorShape;
import org.nlogo.swing.Menu;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.PopupMenu;
import org.nlogo.theme.InterfaceColors;
import org.nlogo.window.Events;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.LocalViewInterface;
import org.nlogo.window.ProceduresInterface;
import org.nlogo.window.ViewMouseHandler;
import scala.Option;

public class View
extends JComponent
implements Events.LoadBeginEvent.Handler,
Events.LoadEndEvent.Handler,
Events.CompiledEvent.Handler,
Events.IconifiedEvent.Handler,
ViewSettings,
ActionListener,
LocalViewInterface {
    protected final GUIWorkspace workspace;
    final ViewMouseHandler mouser;
    public RendererInterface renderer;
    private boolean paintingImmediately = false;
    private boolean framesSkipped = false;
    private int fontSize = 13;
    boolean iconified = false;
    private Image offscreenImage = null;
    private Graphics2D gOff = null;
    private boolean dirty = true;
    public int frameCount = 0;
    private boolean frozen = false;
    protected double patchSize = 13.0;
    private double zoom = 1.0;
    protected double viewWidth;
    protected double viewHeight;
    public boolean renderPerspective = true;

    public View(GUIWorkspace workspace) {
        this.workspace = workspace;
        this.setOpaque(true);
        this.renderer = workspace.newRenderer();
        this.mouser = new ViewMouseHandler(this, workspace.world(), this);
        this.addMouseListener(this.mouser);
        this.addMouseMotionListener(this.mouser);
        workspace.viewManager().add(this);
    }

    public boolean displayOn() {
        return !this.workspace.getGlView().isFullscreen() && this.workspace.world().displayOn() && this.workspace.displaySwitchOn();
    }

    @Override
    public void displaySwitch(boolean on) {
        this.workspace.viewWidget().displaySwitch().setOn(on);
    }

    @Override
    public boolean displaySwitch() {
        return this.workspace.viewWidget().displaySwitch().isSelected();
    }

    @Override
    public void incrementalUpdateFromEventThread() {
        this.paintImmediately();
    }

    public void dirty() {
        this.dirty = true;
    }

    @Override
    public void framesSkipped() {
        this.framesSkipped = true;
    }

    @Override
    public int fontSize() {
        return this.fontSize;
    }

    @Override
    public void resetMouseCors() {
        this.mouser.resetMouseCors();
    }

    @Override
    public double mouseXCor() {
        return this.mouser.mouseXCor();
    }

    @Override
    public double mouseYCor() {
        return this.mouser.mouseYCor();
    }

    @Override
    public boolean mouseDown() {
        return this.mouser.mouseDown();
    }

    @Override
    public boolean mouseInside() {
        return this.mouser.mouseInside();
    }

    public void mouseDown(boolean mouseDown) {
        this.mouser.mouseDown(mouseDown);
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = (int)(this.viewWidth * this.patchSize());
        int height = (int)(this.viewHeight * this.patchSize());
        return new Dimension(width, height);
    }

    @Override
    public void handle(Events.IconifiedEvent e) {
        if (e.frame == Hierarchy.getFrame(this)) {
            this.iconified = e.iconified;
        }
    }

    public boolean iconified() {
        return this.iconified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beClean() {
        if (this.dirty && this.getWidth() > 0 && this.getHeight() > 0) {
            if (this.workspace.jobManager.isInterrupted()) {
                return false;
            }
            if (this.offscreenImage == null) {
                this.offscreenImage = this.createImage(this.getWidth(), this.getHeight());
                if (this.offscreenImage != null) {
                    this.gOff = (Graphics2D)this.offscreenImage.getGraphics();
                    this.gOff.setFont(this.getFont());
                    World world = this.workspace.world();
                    synchronized (world) {
                        this.renderer.paint(this.gOff, (ViewSettings)this);
                    }
                }
            }
            this.dirty = false;
        }
        return true;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Rectangle bounds = this.getBounds();
        if (width != bounds.width || height != bounds.height || x != bounds.x || y != bounds.y) {
            super.setBounds(x, y, width, height);
            this.discardOffscreenImage();
        }
    }

    public void discardOffscreenImage() {
        this.offscreenImage = null;
        this.gOff = null;
        this.dirty = true;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isDead()) {
            if (this.paintingImmediately) {
                this.workspace.updateManager().beginPainting();
            }
            super.paint(g);
            if (this.paintingImmediately) {
                this.workspace.updateManager().donePainting();
            }
            if (this.workspace.world().observer().perspective() instanceof AgentFollowingPerspective) {
                this.mouser.updateMouseCors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        ++this.frameCount;
        if (this.frozen || !this.workspace.world().displayOn()) {
            if (this.dirty) {
                g.setColor(InterfaceColors.viewBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g.drawImage(this.offscreenImage, 0, 0, null);
            }
            this.framesSkipped = false;
        } else if (this.paintingImmediately) {
            if (this.offscreenImage == null) {
                this.offscreenImage = this.createImage(this.getWidth(), this.getHeight());
                this.gOff = (Graphics2D)this.offscreenImage.getGraphics();
                this.gOff.setFont(this.getFont());
            }
            World world = this.workspace.world();
            synchronized (world) {
                this.renderer.paint(this.gOff, (ViewSettings)this);
            }
            g.drawImage(this.offscreenImage, 0, 0, null);
            this.framesSkipped = false;
        } else if (this.beClean()) {
            g.drawImage(this.offscreenImage, 0, 0, null);
            this.framesSkipped = false;
        } else {
            this.framesSkipped = true;
        }
    }

    @Override
    public void paintImmediately(boolean force) {
        if (this.viewIsVisible() && (this.framesSkipped || force)) {
            this.paintImmediately();
        }
    }

    @Override
    public boolean viewIsVisible() {
        return !this.iconified && this.isShowing();
    }

    public void paintImmediately() {
        this.paintingImmediately = true;
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        this.paintingImmediately = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage exportView() {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setFont(this.getFont());
        World world = this.workspace.world();
        synchronized (world) {
            this.renderer.paint(graphics, (ViewSettings)this);
        }
        return image;
    }

    void freeze() {
        if (!this.frozen) {
            this.frozen = true;
            if (this.workspace.world().displayOn()) {
                this.beClean();
            }
        }
    }

    void thaw() {
        if (this.frozen) {
            this.frozen = false;
            this.repaint();
        }
    }

    @Override
    public void shapeChanged(Shape shape) {
        this.dirty = true;
        new Events.DirtyEvent((Option<String>)Option.empty()).raise(this);
        this.renderer.resetCache(this.patchSize());
        this.repaint();
    }

    @Override
    public void handle(Events.LoadBeginEvent e) {
        this.setVisible(false);
        this.renderer = this.workspace.newRenderer();
    }

    @Override
    public void handle(Events.LoadEndEvent e) {
        this.renderer.changeTopology(this.workspace.world().wrappingAllowedInX(), this.workspace.world().wrappingAllowedInY());
        this.setVisible(true);
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        if (e.sourceOwner instanceof ProceduresInterface) {
            this.renderer.resetCache(this.patchSize());
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.dirty = true;
            this.beClean();
        }
    }

    void setTrueFontSize(int size) {
        this.fontSize = size;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.discardOffscreenImage();
    }

    @Override
    public void applyNewFontSize(int newFontSize, int zoom) {
        Font font = this.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), newFontSize + zoom);
        this.setTrueFontSize(newFontSize);
        this.setFont(newFont);
        this.dirty();
        this.repaint();
    }

    @Override
    public Component getExportWindowFrame() {
        return this.workspace.viewWidget();
    }

    @Override
    public double patchSize() {
        return this.patchSize * this.zoom;
    }

    public void visualPatchSize(double patchSize) {
        double oldZoom = this.zoom;
        this.zoom = patchSize / this.patchSize;
        if (this.zoom != oldZoom) {
            this.renderer.resetCache(this.patchSize());
        }
    }

    @Override
    public double viewWidth() {
        return this.viewWidth;
    }

    @Override
    public double viewHeight() {
        return this.viewHeight;
    }

    public void setSize(int worldWidth, int worldHeight, double patchSize) {
        this.patchSize = patchSize;
        this.viewWidth = worldWidth;
        this.viewHeight = worldHeight;
        this.renderer.resetCache(this.patchSize());
    }

    @Override
    public Perspective perspective() {
        return this.workspace.world().observer().perspective();
    }

    @Override
    public boolean drawSpotlight() {
        return true;
    }

    @Override
    public double viewOffsetX() {
        return this.workspace.world().observer().followOffsetX();
    }

    @Override
    public double viewOffsetY() {
        return this.workspace.world().observer().followOffsetY();
    }

    @Override
    public boolean renderPerspective() {
        return this.renderPerspective;
    }

    @Override
    public WorkspaceContext workspaceContext() {
        return this.workspace.workspaceContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateContextMenu(PopupMenu menu, Point p) {
        menu.add(new MenuItem(new AbstractAction(I18N.guiJ().get("tabs.run.widget.view.copy")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new ImageSelection(View.this.exportView()), null);
            }
        }, true));
        menu.add(new MenuItem(new AbstractAction(I18N.guiJ().get("tabs.run.widget.view.export")){

            @Override
            public void actionPerformed(ActionEvent e) {
                View.this.workspace.doExportView(View.this);
            }
        }, true));
        menu.add(new MenuItem(this.workspace.getSwitchTo3DViewAction(), true));
        menu.addSeparator();
        menu.add(new MenuItem(new AbstractAction(I18N.guiJ().get("tabs.run.widget.view.inspectGlobals")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                View.this.workspace.inspectAgent(AgentKindJ.Observer());
            }
        }, true));
        if (!this.workspace.world().observer().atHome2D()) {
            menu.addSeparator();
            menu.add(new MenuItem(new AbstractAction("<html>" + Colors.colorize("reset-perspective", InterfaceColors.commandColor())){

                @Override
                public void actionPerformed(ActionEvent e) {
                    View.this.workspace.world().observer().resetPerspective();
                    View.this.workspace.viewManager().incrementalUpdateFromEventThread();
                }
            }, true));
        }
        p = new Point(p);
        this.mouser.translatePointToXCorYCor(p);
        World world = this.workspace.world();
        synchronized (world) {
            double xcor = this.mouser.translatePointToUnboundedX(p.x);
            double ycor = this.mouser.translatePointToUnboundedY(p.y);
            Patch patch = null;
            try {
                patch = this.workspace.world().getPatchAt(xcor, ycor);
                menu.addSeparator();
                menu.add(new AgentMenuItem((Agent)((Object)patch), AgentMenuType.INSPECT, "inspect", false));
            }
            catch (AgentException e) {
                Exceptions.ignore(e);
            }
            boolean linksAdded = false;
            AgentIterator links = this.workspace.world().links().iterator();
            while (links.hasNext()) {
                Link link = (Link)links.next();
                if (link.hidden() || !(this.workspace.world().protractor().distance(link, xcor, ycor, true) < link.lineThickness() + 0.5)) continue;
                if (!linksAdded) {
                    menu.addSeparator();
                    linksAdded = true;
                }
                menu.add(new AgentMenuItem(link, AgentMenuType.INSPECT, "inspect", false));
            }
            boolean turtlesAdded = false;
            AgentIterator turtles = this.workspace.world().turtles().iterator();
            while (turtles.hasNext()) {
                VectorShape shape;
                Turtle turtle = (Turtle)turtles.next();
                if (turtle.hidden()) continue;
                double offset = turtle.size() * 0.5;
                if (offset * this.workspace.world().patchSize() < 3.0) {
                    offset += 3.0 / this.workspace.world().patchSize();
                }
                if ((shape = (VectorShape)this.workspace.world().turtleShapeList().shape(turtle.shape())).isRotatable() && !turtle.hidden()) {
                    double dist = this.workspace.world().protractor().distance(turtle, xcor, ycor, true);
                    if (!(dist <= offset)) continue;
                    if (!turtlesAdded) {
                        menu.addSeparator();
                        turtlesAdded = true;
                    }
                    this.addTurtleToContextMenu(menu, turtle);
                    continue;
                }
                double xCor = turtle.xcor();
                double yCor = turtle.ycor();
                double xMouse = xcor;
                double yMouse = ycor;
                if (this.workspace.world().wrappingAllowedInX()) {
                    double x = xCor > xMouse ? xMouse + (double)this.workspace.world().worldWidth() : xMouse - (double)this.workspace.world().worldWidth();
                    double d = xMouse = StrictMath.abs(xMouse - xCor) < StrictMath.abs(x - xCor) ? xMouse : x;
                }
                if (this.workspace.world().wrappingAllowedInY()) {
                    double y = yCor > yMouse ? yMouse + (double)this.workspace.world().worldHeight() : yMouse - (double)this.workspace.world().worldHeight();
                    double d = yMouse = StrictMath.abs(yMouse - yCor) < StrictMath.abs(y - yCor) ? yMouse : y;
                }
                if (!(xMouse >= xCor - offset) || !(xMouse <= xCor + offset) || !(yMouse >= yCor - offset) || !(yMouse <= yCor + offset)) continue;
                if (!turtlesAdded) {
                    menu.addSeparator();
                    turtlesAdded = true;
                }
                this.addTurtleToContextMenu(menu, turtle);
            }
            int x = 0;
            int y = 0;
            if (patch != null) {
                x = (int)StrictMath.round(this.renderer.graphicsX(((org.nlogo.agent.Patch)patch).pxcor + 1, this.patchSize(), this.viewOffsetX()));
                y = (int)StrictMath.round(this.renderer.graphicsY(((org.nlogo.agent.Patch)patch).pycor - 1, this.patchSize(), this.viewOffsetY()));
                p.x += StrictMath.min(x - p.x, 15);
                p.y += StrictMath.min(y - p.y, 15);
            }
        }
    }

    private void addTurtleToContextMenu(PopupMenu menu, Turtle turtle) {
        AgentMenu submenu = new AgentMenu(turtle);
        submenu.add(new AgentMenuItem(turtle, AgentMenuType.INSPECT, "inspect", true));
        submenu.addSeparator();
        submenu.add(new AgentMenuItem(turtle, AgentMenuType.WATCH, "watch", true));
        submenu.add(new AgentMenuItem(turtle, AgentMenuType.FOLLOW, "follow", true));
        menu.add(submenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AgentMenuItem item = (AgentMenuItem)e.getSource();
        switch (item.type) {
            case INSPECT: {
                double minWidthOrHeight = StrictMath.min(this.workspace.world().worldWidth() / 2, this.workspace.world().worldHeight() / 2);
                double radius = StrictMath.min(3.0, minWidthOrHeight / 2.0);
                this.workspace.inspectAgent(item.agent.kind(), item.agent, radius);
                return;
            }
            case FOLLOW: {
                int distance = (int)((Turtle)item.agent).size() * 5;
                Perspective newPerspective = PerspectiveJ.create(2, item.agent, StrictMath.max(1, StrictMath.min(distance, 100)));
                this.workspace.world().observer().setPerspective(newPerspective);
                break;
            }
            case WATCH: {
                this.workspace.world().observer().home();
                Perspective newPerspective = PerspectiveJ.create(3, item.agent);
                this.workspace.world().observer().setPerspective(newPerspective);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.workspace.viewManager().incrementalUpdateFromEventThread();
    }

    private class AgentMenuItem
    extends MenuItem {
        Agent agent;
        AgentMenuType type;
        boolean submenu;

        AgentMenuItem(Agent agent, AgentMenuType type, String caption, boolean submenu) {
            super("<html>" + Colors.colorize(caption, InterfaceColors.commandColor()) + " " + Colors.colorize(agent.classDisplayName(), InterfaceColors.reporterColor()) + Colors.colorize(agent.toString().substring(agent.classDisplayName().length()), InterfaceColors.constantColor()));
            this.submenu = false;
            this.agent = agent;
            this.type = type;
            this.addActionListener(View.this);
            this.submenu = submenu;
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
            super.menuSelectionChanged(isIncluded);
            if (!this.submenu) {
                View.this.renderer.outlineAgent(isIncluded ? this.agent : null);
                View.this.workspace.viewManager().incrementalUpdateFromEventThread();
            }
        }
    }

    static enum AgentMenuType {
        INSPECT,
        FOLLOW,
        WATCH;

    }

    private class AgentMenu
    extends Menu {
        Agent agent;
        int type;

        AgentMenu(Agent agent) {
            super(agent.toString());
            this.agent = agent;
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
            super.menuSelectionChanged(isIncluded);
            View.this.renderer.outlineAgent(isIncluded ? this.agent : null);
            View.this.workspace.viewManager().incrementalUpdateFromEventThread();
        }
    }
}

