/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.AbstractModelLoader$;
import org.nlogo.api.Version;
import org.nlogo.api.Version$;
import org.nlogo.core.Model;
import org.nlogo.fileformat.ConversionResult;
import org.nlogo.fileformat.FailedConversionResult;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public interface OpenModel<OpenParameter> {
    public Try<Model> readModel(AbstractModelLoader var1, OpenParameter var2);

    public static Option runOpenModelProcess$(OpenModel $this, Object openParam, URI uri, Controller controller, AbstractModelLoader loader, Function2 modelConverter, Version currentVersion) {
        return $this.runOpenModelProcess(openParam, uri, controller, loader, (Function2<Model, Path, ConversionResult>)modelConverter, currentVersion);
    }

    default public Option<Model> runOpenModelProcess(OpenParameter openParam, URI uri2, Controller controller, AbstractModelLoader loader, Function2<Model, Path, ConversionResult> modelConverter, Version currentVersion) {
        boolean isValidURI = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)uri2).flatMap((Function1 & Serializable)uri -> AbstractModelLoader$.MODULE$.getURIExtension((URI)uri)).map((Function1 & Serializable)ext -> true).getOrElse(OpenModel::$anonfun$3));
        if (!isValidURI) {
            controller.invalidModel(uri2);
            return None$.MODULE$;
        }
        Try<Model> try_ = this.readModel(loader, openParam);
        if (try_ instanceof Success) {
            Model model = (Model)((Success)try_).value();
            if (!model.version().startsWith("NetLogo")) {
                controller.invalidModelVersion(uri2, model.version());
                return None$.MODULE$;
            }
            if (this.shouldCancelOpeningModel(model, controller, currentVersion)) {
                return None$.MODULE$;
            }
            ConversionResult conversionResult = (ConversionResult)modelConverter.apply((Object)model, (Object)Paths.get(uri2));
            if (conversionResult instanceof FailedConversionResult) {
                FailedConversionResult res = (FailedConversionResult)conversionResult;
                return controller.errorAutoconvertingModel(res);
            }
            ConversionResult res = conversionResult;
            return Some$.MODULE$.apply((Object)res.model());
        }
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                controller.errorOpeningURI(uri2, exception);
                return None$.MODULE$;
            }
            Throwable ex = throwable;
            throw ex;
        }
        throw new MatchError(try_);
    }

    private boolean shouldCancelOpeningModel(Model model, Controller controller, Version currentVersion) {
        boolean modelArityDiffers;
        int modelArity = Version$.MODULE$.is3D(model.version()) ? 3 : 2;
        boolean bl = modelArityDiffers = Version$.MODULE$.is3D(model.version()) != currentVersion.is3D();
        if (modelArityDiffers) {
            return !controller.shouldOpenModelOfDifferingArity(modelArity, model.version());
        }
        if (!currentVersion.knownVersion(model.version())) {
            return !controller.shouldOpenModelOfUnknownVersion(model.version());
        }
        if (!currentVersion.compatibleVersion(model.version())) {
            return !controller.shouldOpenModelOfLegacyVersion(model.version());
        }
        return false;
    }

    private static boolean $anonfun$3() {
        return false;
    }

    public static interface Controller {
        public void errorOpeningURI(URI var1, Exception var2);

        public Option<Model> errorAutoconvertingModel(FailedConversionResult var1);

        public void invalidModel(URI var1);

        public void invalidModelVersion(URI var1, String var2);

        public boolean shouldOpenModelOfDifferingArity(int var1, String var2);

        public boolean shouldOpenModelOfUnknownVersion(String var1);

        public boolean shouldOpenModelOfLegacyVersion(String var1);
    }

    public class InvalidModelException
    extends Exception {
        public InvalidModelException(String message) {
            if (OpenModel.this == null) {
                throw new NullPointerException();
            }
            super(message);
        }

        public final /* synthetic */ OpenModel org$nlogo$workspace$OpenModel$InvalidModelException$$$outer() {
            return OpenModel.this;
        }
    }
}

