/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.vid;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jcodec.api.SequenceEncoder;
import org.jcodec.scale.AWTUtil;
import org.nlogo.extensions.vid.Recorder;
import org.nlogo.extensions.vid.Recorder$AlreadyStarted$;
import org.nlogo.extensions.vid.Recorder$NoFrames$;
import org.nlogo.extensions.vid.Recorder$NotRecording$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class MP4Recorder
implements Recorder {
    private Option<SequenceEncoder> activeRecording = Option$.MODULE$.empty();
    private Option<Path> recordingPath = Option$.MODULE$.empty();
    private Option<Tuple2<Object, Object>> activeResolution = Option$.MODULE$.empty();

    @Override
    public boolean isRecording() {
        return this.activeRecording.isDefined();
    }

    @Override
    public void start() {
        if (this.activeRecording.isDefined()) {
            throw Recorder$AlreadyStarted$.MODULE$;
        }
        Path path = Files.createTempFile("vid", "mp4", new FileAttribute[0]);
        this.recordingPath = Some$.MODULE$.apply((Object)path);
        this.activeRecording = Some$.MODULE$.apply((Object)new SequenceEncoder(path.toFile()));
    }

    @Override
    public void setResolution(int width, int height) {
        if (this.activeResolution.isEmpty()) {
            this.activeResolution = Some$.MODULE$.apply(this.roundResolution(width, height));
            return;
        }
    }

    private Tuple2<Object, Object> roundResolution(int width, int height) {
        if (width % 2 == 1 && height % 2 == 1) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(width + 1)), (Object)BoxesRunTime.boxToInteger((int)(height + 1)));
        }
        if (width % 2 == 1) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(width + 1)), (Object)BoxesRunTime.boxToInteger((int)height));
        }
        if (height % 2 == 1) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)width), (Object)BoxesRunTime.boxToInteger((int)(height + 1)));
        }
        return new Tuple2.mcII.sp(width, height);
    }

    @Override
    public void save(Path dest) {
        if (!this.activeRecording.isDefined()) {
            throw Recorder$NotRecording$.MODULE$;
        }
        if (!Files.exists(dest.toAbsolutePath().getParent(), new LinkOption[0])) {
            throw new FileNotFoundException("no such directory: " + dest.toAbsolutePath().toString());
        }
        try {
            try {
                this.activeRecording.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.finish());
                this.recordingPath.foreach((Function1 & Serializable)src -> Files.copy(src, dest, StandardCopyOption.REPLACE_EXISTING));
            }
            catch (IndexOutOfBoundsException e) {
                throw Recorder$NoFrames$.MODULE$;
            }
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.recordingPath = None$.MODULE$;
        this.activeRecording = None$.MODULE$;
        this.activeResolution = None$.MODULE$;
    }

    @Override
    public void recordFrame(BufferedImage image) {
        if (this.activeResolution.isEmpty()) {
            this.activeResolution = Some$.MODULE$.apply(this.roundResolution(image.getWidth(), image.getHeight()));
        }
        if (this.activeRecording.isDefined()) {
            this.activeRecording.foreach((Function1)(JProcedure1 & Serializable)recording -> this.activeResolution.foreach((Function1)(JProcedure1 & Serializable)res -> {
                BufferedImage rgbImage = new BufferedImage(res._1$mcI$sp(), res._2$mcI$sp(), 1);
                rgbImage.getGraphics().drawImage(image, 0, 0, res._1$mcI$sp(), res._2$mcI$sp(), 0, 0, image.getWidth(), image.getHeight(), null);
                recording.encodeNativeFrame(AWTUtil.fromBufferedImage((BufferedImage)rgbImage));
            }));
            return;
        }
        throw new RuntimeException("No recording has been started!");
    }
}

