/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import com.jogamp.opengl.glu.GLUtessellatorCallback;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.nlogo.app.App$;
import org.nlogo.core.ShapeList$;
import org.nlogo.gl.render.Polygons$;
import org.nlogo.gl.render.Tessellator;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Curve;
import org.nlogo.shape.Element;
import org.nlogo.shape.Line;
import org.nlogo.shape.Polygon;
import org.nlogo.shape.Rectangle;
import org.nlogo.shape.VectorShape;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import view25d.view.Observer;
import view25d.view.VarviewWindow;
import view25d.view.VarviewWindow$;
import view25d.view.gl.NetLogoGLU;

public abstract class MouseableGLWindow
extends MouseAdapter
implements GLEventListener {
    private final VarviewWindow viewer;
    private final Observer observer;
    private GLJPanel canvas;
    private int oldx;
    private int oldy;
    private boolean dragging;
    private final Map<String, Object> compiledShapes;
    private final NetLogoGLU nlGLU;
    private GLU glu;
    private boolean areShapesStale;

    public MouseableGLWindow(VarviewWindow viewer) {
        this.viewer = viewer;
        this.observer = new Observer(0.0, 0.0, 49.5);
        this.canvas = null;
        this.oldx = 0;
        this.oldy = 0;
        this.dragging = false;
        this.compiledShapes = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.nlGLU = new NetLogoGLU();
        this.glu = null;
        this.areShapesStale = false;
    }

    public Observer observer() {
        return this.observer;
    }

    public void updateObserverPerspectiveAnglesWithDeltas(double thetax, double thetay) {
        this.observer().updatePerspectiveAngles(thetax, thetay);
        this.canvas().repaint();
    }

    public double[] getObserverPerspectiveAngles() {
        return new double[]{this.observer().heading(), this.observer().pitch()};
    }

    public void shiftObserverFocusPoint(double deltax, double deltay) {
        this.observer().objectiveShift(deltax, deltay);
        this.canvas().repaint();
    }

    public double[] getObserverPerspectiveFocusPoint() {
        return new double[]{this.observer().rotx(), this.observer().roty()};
    }

    public void zoomToDistance(double dist) {
        this.observer().zoomToDistance(dist);
        this.canvas().repaint();
    }

    public double getObserverDistance() {
        return this.observer().dist();
    }

    public GLJPanel canvas() {
        return this.canvas;
    }

    public void canvas_$eq(GLJPanel x$1) {
        this.canvas = x$1;
    }

    public int oldx() {
        return this.oldx;
    }

    public void oldx_$eq(int x$1) {
        this.oldx = x$1;
    }

    public int oldy() {
        return this.oldy;
    }

    public void oldy_$eq(int x$1) {
        this.oldy = x$1;
    }

    public boolean dragging() {
        return this.dragging;
    }

    public void dragging_$eq(boolean x$1) {
        this.dragging = x$1;
    }

    public void setCanvas(GLJPanel glCanvas) {
        this.canvas_$eq(glCanvas);
    }

    public void repaintCanvas() {
        this.canvas().repaint();
    }

    public abstract void setupCompiledDisplayLists(GL2 var1);

    public void setupLightingAndViewPort(GL2 gl, GLU glu) {
        gl.glShadeModel(7425);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearDepth(1.0);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        gl.glHint(3152, 4353);
        gl.glEnable(2896);
        gl.glLightfv(1, 4611, FloatBuffer.wrap(new float[]{-1.0f, -0.3f, 0.4f, 0.0f}));
        gl.glLightfv(1, 4608, FloatBuffer.wrap(new float[]{0.25f, 0.25f, 0.25f, 1.0f}));
        gl.glLightfv(1, 4609, FloatBuffer.wrap(new float[]{0.35f, 0.35f, 0.35f, 1.0f}));
        gl.glLightfv(1, 4610, FloatBuffer.wrap(new float[]{0.0f, 0.0f, 0.0f, 0.0f}));
        gl.glEnable(1);
        gl.glLightfv(2, 4611, FloatBuffer.wrap(new float[]{1.0f, 0.6f, -0.5f, 0.0f}));
        gl.glLightfv(2, 4608, FloatBuffer.wrap(new float[]{0.25f, 0.25f, 0.25f, 1.0f}));
        gl.glLightfv(2, 4609, FloatBuffer.wrap(new float[]{0.35f, 0.35f, 0.35f, 1.0f}));
        gl.glLightfv(2, 4610, FloatBuffer.wrap(new float[]{0.0f, 0.0f, 0.0f, 0.0f}));
        gl.glEnable(2);
        gl.glLightfv(16385, 4611, new float[]{1.2f * (float)this.viewer.maxPxcor(), 1.2f * (float)this.viewer.maxPycor(), 70.0f, 1.0f}, 0);
        gl.glLightfv(16385, 4608, new float[]{0.4f, 0.4f, 0.4f, 1.0f}, 0);
        gl.glLightfv(16385, 4610, new float[]{0.7f, 0.7f, 0.7f, 1.0f}, 0);
        gl.glEnable(16385);
        gl.glEnable(2977);
        gl.glColorMaterial(1028, 5634);
        gl.glEnable(2903);
        gl.glGetIntegerv(3415, IntBuffer.wrap(new int[]{1}));
        this.mainViewport(gl, glu);
        this.observer().goHome(this.viewer);
    }

    private void mainViewport(GL2 gl, GLU glu) {
        gl.glViewport(0, 0, this.viewer.viewWidth(), this.viewer.viewHeight());
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        int zClip = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.viewer.worldWidth()), this.viewer.worldHeight()) * 40;
        glu.gluPerspective(45.0, Float$.MODULE$.float2double((float)this.viewer.viewWidth() / (float)this.viewer.viewHeight()), 0.1, Int$.MODULE$.int2double(zClip));
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void setColorAndStandardMaterial(GL2 gl, float red, float green, float blue) {
        float[] rgb = new float[]{red, green, blue};
        gl.glMaterialfv(1028, 4608, rgb, 0);
        gl.glMaterialfv(1028, 4610, rgb, 0);
        gl.glMaterialf(1028, 5633, 0.5f);
        gl.glColor3f(red, green, blue);
    }

    public void drawAxesIfDragging(GL2 gl, int axisHeadHandle) {
        if (this.dragging()) {
            double zmax = 10.0 * this.viewer.zScale() + 1.0;
            this.setColorAndStandardMaterial(gl, 0.9f, 0.0f, 0.0f);
            gl.glLineWidth(2.4f);
            gl.glBegin(1);
            gl.glVertex3i(0, 0, 0);
            gl.glVertex3i(this.viewer.maxPxcor() + 1, 0, 0);
            gl.glVertex3i(0, 0, 0);
            gl.glVertex3d(0.0, Int$.MODULE$.int2double(this.viewer.maxPycor() + 1), 0.0);
            gl.glVertex3i(0, 0, 0);
            gl.glVertex3d(0.0, 0.0, zmax);
            gl.glVertex3i(0, 0, 0);
            gl.glEnd();
            gl.glPushMatrix();
            gl.glTranslated(Int$.MODULE$.int2double(this.viewer.maxPxcor() + 1), 0.0, 0.0);
            gl.glRotated(90.0, 0.0, 1.0, 0.0);
            gl.glCallList(axisHeadHandle);
            gl.glPopMatrix();
            gl.glPushMatrix();
            gl.glTranslated(0.0, Int$.MODULE$.int2double(this.viewer.maxPycor() + 1), 0.0);
            gl.glRotated(-90.0, 1.0, 0.0, 0.0);
            gl.glCallList(axisHeadHandle);
            gl.glPopMatrix();
            gl.glPushMatrix();
            gl.glTranslated(0.0, 0.0, zmax);
            gl.glCallList(axisHeadHandle);
            gl.glPopMatrix();
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int nx = e.getX();
        int ny = e.getY();
        int n = this.viewer.getMode();
        if (VarviewWindow$.MODULE$.ORBIT() == n) {
            this.observer().updatePerspectiveAngles((double)(nx - this.oldx()) / 2.0, (double)(this.oldy() - ny) / 2.0);
        } else if (VarviewWindow$.MODULE$.MOVE() == n) {
            this.observer().shift((double)(nx - this.oldx()) / 2.0, (double)(this.oldy() - ny) / 2.0);
        } else if (VarviewWindow$.MODULE$.ZOOM() == n) {
            this.observer().zoomby(Int$.MODULE$.int2double(this.oldy() - ny));
        } else if (VarviewWindow$.MODULE$.SCALEZ() == n) {
            this.viewer.zoomZby((double)(this.oldy() - ny) / 30.0);
        }
        this.oldx_$eq(nx);
        this.oldy_$eq(ny);
        this.canvas().repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.observer().zoomby(-e.getPreciseWheelRotation());
        this.canvas().repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.oldx_$eq(e.getX());
        this.oldy_$eq(e.getY());
        this.dragging_$eq(true);
        this.canvas().repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.dragging_$eq(false);
        this.canvas().repaint();
    }

    public Map<String, Object> compiledShapes() {
        return this.compiledShapes;
    }

    public NetLogoGLU nlGLU() {
        return this.nlGLU;
    }

    public GLU glu() {
        return this.glu;
    }

    public void glu_$eq(GLU x$1) {
        this.glu = x$1;
    }

    public boolean areShapesStale() {
        return this.areShapesStale;
    }

    public void areShapesStale_$eq(boolean x$1) {
        this.areShapesStale = x$1;
    }

    public void compileShape(NetLogoGLU nlGLU, GL2 gl, GLU glu, VectorShape shape, int index, boolean rotatable) {
        Tessellator tessellator = new Tessellator();
        GLUtessellator tess = GLU.gluNewTess();
        GLU.gluTessCallback((GLUtessellator)tess, (int)100106, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100110, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100107, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100108, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100111, (GLUtessellatorCallback)tessellator);
        GLU.gluTessCallback((GLUtessellator)tess, (int)100109, (GLUtessellatorCallback)tessellator);
        GLU.gluTessProperty((GLUtessellator)tess, (int)100140, (double)100130.0);
        gl.glNewList(index, 4864);
        if (!rotatable) {
            gl.glDisable(2896);
        }
        List elements = shape.getElementsJ();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), elements.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Element element = (Element)elements.get(i);
            if (element instanceof Rectangle) {
                Rectangle rect = (Rectangle)element;
                nlGLU.renderRectangle(gl, i, rect, rotatable);
                return;
            }
            if (element instanceof Polygon) {
                Polygon polygon = (Polygon)element;
                Polygons$.MODULE$.renderPolygon(gl, glu, tessellator, tess, i, polygon, rotatable, false);
                return;
            }
            if (element instanceof Circle) {
                Circle circle = (Circle)element;
                nlGLU.renderCircle(gl, glu, i, circle, rotatable);
                return;
            }
            if (element instanceof Line) {
                Line line = (Line)element;
                nlGLU.renderLine(gl, i, line);
                return;
            }
            if (element instanceof Curve) {
                Curve curve = (Curve)element;
                throw new IllegalStateException();
            }
        });
        if (!rotatable) {
            gl.glEnable(2896);
        }
        gl.glDisable(2884);
        gl.glEndList();
    }

    public void compileShapes(GL2 gl, Map<String, Object> compiledShapes, boolean rotatable) {
        App$.MODULE$.app().workspace().world().turtleShapeList().names().foreach((Function1 & Serializable)name -> {
            int handle = gl.glGenLists(1);
            VectorShape shape = (VectorShape)App$.MODULE$.app().workspace().world().turtleShapeList().shape(name);
            this.compileShape(this.nlGLU(), gl, this.glu(), shape, handle, false);
            return (Map)compiledShapes.$plus$eq((Object)Tuple2$.MODULE$.apply(name, (Object)BoxesRunTime.boxToInteger((int)handle)));
        });
    }

    public void setDeletedShapesToDefaultShape(Map<String, Object> compiledShapes) {
        compiledShapes.keysIterator().toSet().$minus$minus((IterableOnce)App$.MODULE$.app().workspace().world().turtleShapeList().names()).foreach((Function1 & Serializable)name -> (Map)compiledShapes.$plus$eq((Object)Tuple2$.MODULE$.apply(name, compiledShapes.apply((Object)ShapeList$.MODULE$.DefaultShapeName()))));
    }

    public void updateTurtleDisplayList() {
        this.areShapesStale_$eq(true);
    }

    public void init(GLAutoDrawable drawable) {
        this.compiledShapes().clear();
        GL2 gl = (GL2)drawable.getGL();
        this.glu_$eq(new GLU());
        this.setupCompiledDisplayLists(gl);
        this.setupLightingAndViewPort(gl, this.glu());
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        this.viewer.viewWidth_$eq(width);
        this.viewer.viewHeight_$eq(height);
        this.mainViewport((GL2)drawable.getGL(), this.glu());
    }
}

