/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentSet;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.api.Color$;
import org.nlogo.api.Context;
import org.nlogo.api.Link;
import org.nlogo.api.LogoException;
import org.nlogo.api.Turtle;
import org.nlogo.app.App$;
import org.nlogo.theme.ThemeSync;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import view25d.View25DExtension$;
import view25d.view.LinkValue;
import view25d.view.LinkValue$;
import view25d.view.MouseableGLWindow;
import view25d.view.TurtleValue;
import view25d.view.TurtleValue$;
import view25d.view.TurtleView;
import view25d.view.TurtleViewOptions;
import view25d.view.VarviewWindow;
import view25d.view.gl.TurtleGL;

public class TurtleViewGUI
extends VarviewWindow
implements TurtleView,
ThemeSync {
    private Option stemColorReporterOpt;
    private AgentSet agents;
    private final AgentSet initialAgents;
    public final AnonymousReporter view25d$view$TurtleViewGUI$$reporter;
    private final TurtleGL glManager;
    private TurtleValue[] turtleReporterValues;
    private LinkValue[] linkValues;
    private Color[][] patchColorMatrix;
    private TurtleViewOptions viewOptions;

    public TurtleViewGUI(String title, AgentSet initialAgents, AnonymousReporter reporter) {
        this.initialAgents = initialAgents;
        this.view25d$view$TurtleViewGUI$$reporter = reporter;
        super(title);
        TurtleView.$init$(this);
        this.glManager = new TurtleGL(this);
        this.turtleReporterValues = new TurtleValue[0];
        this.linkValues = new LinkValue[0];
        this.patchColorMatrix = (Color[][])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Color[0][]), ClassTag$.MODULE$.apply(Color.class).wrap());
        this.viewOptions = new TurtleViewOptions(this, true, true, true, false, true, false);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(this){
            private final /* synthetic */ TurtleViewGUI $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void windowClosing(WindowEvent e) {
                View25DExtension$.MODULE$.removeTurtleWindowWithTitle(this.$outer.view25d$view$TurtleViewGUI$$title$accessor());
            }
        });
        GLJPanel glCanvas = new GLJPanel((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.get((String)"GL2")));
        glCanvas.addGLEventListener((GLEventListener)this.glManager);
        glCanvas.addMouseListener((MouseListener)this.glManager);
        glCanvas.addMouseMotionListener((MouseMotionListener)this.glManager);
        glCanvas.addMouseWheelListener((MouseWheelListener)this.glManager);
        this.glManager.setCanvas(glCanvas);
        this.mainPanel().add((Component)glCanvas, "Center");
        this.mainPanel().add((Component)this.viewOptions(), "North");
        this.setSize(new Dimension(600, 640));
        this.centerWindow(this);
        this.syncTheme();
    }

    public Option stemColorReporterOpt() {
        return this.stemColorReporterOpt;
    }

    @Override
    public AgentSet agents() {
        return this.agents;
    }

    public void stemColorReporterOpt_$eq(Option x$1) {
        this.stemColorReporterOpt = x$1;
    }

    @Override
    public void agents_$eq(AgentSet x$1) {
        this.agents = x$1;
    }

    public String view25d$view$TurtleViewGUI$$title$accessor() {
        return super.title();
    }

    @Override
    public AgentSet initialAgents() {
        return this.initialAgents;
    }

    @Override
    public MouseableGLWindow getGLWindow() {
        return this.glManager;
    }

    public TurtleValue[] turtleReporterValues() {
        return this.turtleReporterValues;
    }

    public void turtleReporterValues_$eq(TurtleValue[] x$1) {
        this.turtleReporterValues = x$1;
    }

    public LinkValue[] linkValues() {
        return this.linkValues;
    }

    public void linkValues_$eq(LinkValue[] x$1) {
        this.linkValues = x$1;
    }

    public Color[][] patchColorMatrix() {
        return this.patchColorMatrix;
    }

    public void patchColorMatrix_$eq(Color[][] x$1) {
        this.patchColorMatrix = x$1;
    }

    public TurtleViewOptions viewOptions() {
        return this.viewOptions;
    }

    public void viewOptions_$eq(TurtleViewOptions x$1) {
        this.viewOptions = x$1;
    }

    @Override
    public void manuallyRefreshReporterView(Context context) {
        this.updateArrayList(context);
        this.glManager.repaintCanvas();
    }

    @Override
    public void updateTurtleShapes() {
        this.glManager.updateTurtleDisplayList();
        this.glManager.repaintCanvas();
    }

    private void updateArrayList(Context context) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])CollectionConverters$.MODULE$.IterableHasAsScala(this.agents().agents()).asScala().toArray(ClassTag$.MODULE$.apply(Agent.class)));
        this.turtleReporterValues_$eq((TurtleValue[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(context, this){
            private final Context context$1;
            private final /* synthetic */ TurtleViewGUI $outer;
            {
                this.context$1 = context$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Agent x) {
                Turtle turtle;
                Agent agent = x;
                return agent instanceof Turtle && !(turtle = (Turtle)agent).hidden();
            }

            public final Object applyOrElse(Agent x, Function1 function1) {
                Turtle turtle;
                Agent agent = x;
                if (agent instanceof Turtle && !(turtle = (Turtle)agent).hidden()) {
                    return TurtleValue$.MODULE$.apply(turtle.shape(), Color$.MODULE$.getColor(turtle.color()), turtle.xcor(), turtle.ycor(), turtle.size(), BoxesRunTime.unboxToDouble((Object)this.$outer.view25d$view$TurtleViewGUI$$reporter.report(this.context$1, new Object[]{turtle})), 0.0, this.$outer.getStemColor(this.context$1, turtle));
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(TurtleValue.class)));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.getLinkSetFromTurtleSet(this.agents()).toArray(ClassTag$.MODULE$.apply(Link.class)));
        this.linkValues_$eq((LinkValue[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)link -> {
            Turtle end1 = link.end1();
            Turtle end2 = link.end2();
            return LinkValue$.MODULE$.apply(link.shape(), Color$.MODULE$.getColor(link.color()), link.lineThickness(), end1.xcor(), end1.ycor(), BoxesRunTime.unboxToDouble((Object)this.view25d$view$TurtleViewGUI$$reporter.report(context, new Object[]{end1})), end2.xcor(), end2.ycor(), BoxesRunTime.unboxToDouble((Object)this.view25d$view$TurtleViewGUI$$reporter.report(context, new Object[]{end2})));
        }, ClassTag$.MODULE$.apply(LinkValue.class)));
        if (this.viewOptions().usePColor()) {
            this.updatePColors();
            return;
        }
    }

    private void updatePColors() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.worldWidth()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.worldHeight()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)j -> {
            try {
                this.patchColorMatrix()[i$1][j] = Color$.MODULE$.getColor(App$.MODULE$.app().workspace().world().getPatchAt(Int$.MODULE$.int2double(i + this.minPxcor()), Int$.MODULE$.int2double(j + this.minPycor())).pcolor());
            }
            catch (AgentException e) {
                e.printStackTrace();
            }
        }));
    }

    @Override
    public void setupForRendering(int wWidth, int wHeight, int minX, int maxX, int minY, int maxY) {
        this.worldWidth_$eq(wWidth);
        this.worldHeight_$eq(wHeight);
        this.minPxcor_$eq(minX);
        this.minPycor_$eq(minY);
        this.maxPxcor_$eq(maxX);
        this.maxPycor_$eq(maxY);
        this.turtleReporterValues_$eq(new TurtleValue[0]);
        this.linkValues_$eq(new LinkValue[0]);
        this.patchColorMatrix_$eq((Color[][])Array$.MODULE$.fill(this.worldWidth(), this::setupForRendering$$anonfun$1, ClassTag$.MODULE$.apply(Color.class).wrap()));
    }

    @Override
    public void resetPerspective() {
        this.glManager.observer().goHome(this);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.glManager.repaintCanvas();
        if (this.viewOptions().usePColor()) {
            this.updatePColors();
            return;
        }
    }

    @Override
    public void zoomZby(double change) {
        if (-change < this.zScale()) {
            this.zScale_$eq(this.zScale() + change);
        }
        this.glManager.repaintCanvas();
    }

    public double trimStemColor(double stemColor) {
        return RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(stemColor), 0.0)), 139.9);
    }

    public double getStemColor(Context context, Turtle turtle) {
        return BoxesRunTime.unboxToDouble((Object)this.stemColorReporterOpt().map((Function1 & Serializable)stemColorReporter -> {
            double d;
            try {
                d = this.trimStemColor(BoxesRunTime.unboxToDouble((Object)stemColorReporter.report(context, new Object[]{turtle})));
            }
            catch (Throwable t) {
                throw new LogoException(t){};
            }
            return d;
        }).getOrElse(TurtleViewGUI::getStemColor$$anonfun$2));
    }

    @Override
    public void syncTheme() {
        this.dashboard().syncTheme();
        this.viewOptions().syncTheme();
    }

    private static final Color setupForRendering$$anonfun$1$$anonfun$1() {
        return Color.BLUE;
    }

    private final Color[] setupForRendering$$anonfun$1() {
        return (Color[])Array$.MODULE$.fill(this.worldHeight(), TurtleViewGUI::setupForRendering$$anonfun$1$$anonfun$1, ClassTag$.MODULE$.apply(Color.class));
    }

    private static final double getStemColor$$anonfun$2() {
        return 4.5;
    }
}

