/*
 * Decompiled with CFR 0.152.
 */
package view25d.view.gl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import java.awt.Point;
import java.nio.FloatBuffer;
import org.nlogo.shape.Circle;
import org.nlogo.shape.Line;
import org.nlogo.shape.Rectangle;
import scala.Float$;

public class NetLogoGLU {
    private final int smoothness;
    private final boolean is3D;
    private GLUquadric quadric = null;

    public NetLogoGLU() {
        this.smoothness = 16;
        this.is3D = false;
    }

    public void setQuadric(GLUquadric quad) {
        this.quadric = quad;
    }

    public void renderRectangle(GL2 gl, int offset, Rectangle rect, boolean rotatable) {
        float zDepth = 0.01f + (float)offset * 1.0E-4f;
        if (!rect.marked()) {
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(rect.displayColor(null).getRGBColorComponents(null)));
        }
        Point[] corners = rect.getCorners();
        this.renderRectangle(gl, (float)corners[0].x * 0.001f - 0.15f, (float)corners[1].x * 0.001f - 0.15f, (float)(300 - corners[1].y) * 0.001f - 0.15f, (float)(300 - corners[0].y) * 0.001f - 0.15f, -zDepth, zDepth, !rect.filled(), rotatable);
        if (!rect.marked()) {
            gl.glPopAttrib();
            return;
        }
    }

    public void renderRectangle(GL2 gl, float x0, float x1, float y0, float y1, float z0, float z1, boolean filled, boolean rotatable) {
        this.renderRectangularPrism(gl, x0, x1, y0, y1, z0, z1, filled, false, rotatable);
    }

    public void renderRectangularPrism(GL2 gl, float left, float right, float back, float front, float bottom, float top, boolean hollow, boolean hasBottom, boolean hasSides) {
        if (hollow) {
            gl.glPolygonMode(1032, 6913);
        }
        gl.glBegin(7);
        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(left, front, top);
        gl.glVertex3f(left, back, top);
        gl.glVertex3f(right, back, top);
        gl.glVertex3f(right, front, top);
        if (hasBottom) {
            gl.glNormal3f(0.0f, 0.0f, -1.0f);
            gl.glVertex3f(left, front, bottom);
            gl.glVertex3f(right, front, bottom);
            gl.glVertex3f(right, back, bottom);
            gl.glVertex3f(left, back, bottom);
        }
        gl.glEnd();
        if (hollow) {
            gl.glPolygonMode(1032, 6914);
            gl.glDisable(2884);
        }
        if (hasSides) {
            gl.glBegin(7);
            gl.glNormal3f(-1.0f, 0.0f, 0.0f);
            gl.glVertex3f(left, front, top);
            gl.glVertex3f(left, front, bottom);
            gl.glVertex3f(left, back, bottom);
            gl.glVertex3f(left, back, top);
            gl.glNormal3f(0.0f, 1.0f, 0.0f);
            gl.glVertex3f(right, front, top);
            gl.glVertex3f(right, front, bottom);
            gl.glVertex3f(left, front, bottom);
            gl.glVertex3f(left, front, top);
            gl.glNormal3f(1.0f, 0.0f, 0.0f);
            gl.glVertex3f(right, back, top);
            gl.glVertex3f(right, back, bottom);
            gl.glVertex3f(right, front, bottom);
            gl.glVertex3f(right, front, top);
            gl.glNormal3f(0.0f, -1.0f, 0.0f);
            gl.glVertex3f(left, back, top);
            gl.glVertex3f(left, back, bottom);
            gl.glVertex3f(right, back, bottom);
            gl.glVertex3f(right, back, top);
            gl.glEnd();
        }
        if (hollow) {
            gl.glEnable(2884);
            return;
        }
    }

    public void renderCircle(GL2 gl, GLU glu, int offset, Circle circle, boolean rotatable) {
        float zDepth = 0.01f + (float)offset * 1.0E-4f;
        if (!circle.marked()) {
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(circle.displayColor(null).getRGBColorComponents(null)));
        }
        float radius = (float)(circle.bounds().getWidth() * (double)5.0E-4f);
        float[] origin = new float[]{(float)circle.origin().getX() * 0.001f - 0.15f, ((float)300 - (float)circle.origin().getY()) * 0.001f - 0.15f};
        gl.glPushMatrix();
        if (!circle.filled()) {
            glu.gluQuadricDrawStyle(this.quadric, 100013);
        }
        if (rotatable) {
            if (!circle.filled()) {
                glu.gluQuadricDrawStyle(this.quadric, 100012);
                gl.glDisable(2884);
            }
            gl.glTranslatef(origin[0], origin[1], -zDepth);
            glu.gluCylinder(this.quadric, Float$.MODULE$.float2double(radius), Float$.MODULE$.float2double(radius), Float$.MODULE$.float2double((float)2 * zDepth), this.smoothness, 1);
            if (!circle.filled()) {
                gl.glEnable(2884);
                glu.gluQuadricDrawStyle(this.quadric, 100013);
            }
            gl.glTranslatef(0.0f, 0.0f, (float)2 * zDepth);
        } else {
            gl.glTranslatef(origin[0], origin[1], zDepth);
        }
        this.renderCircle(gl, glu, 0.0f, radius, zDepth, rotatable);
        if (!circle.filled()) {
            glu.gluQuadricDrawStyle(this.quadric, 100012);
        }
        gl.glPopMatrix();
        if (!circle.marked()) {
            gl.glPopAttrib();
            return;
        }
    }

    public void renderCircle(GL2 gl, GLU glu, float innerRadius, float outerRadius, float zDepth, boolean rotatable) {
        glu.gluDisk(this.quadric, Float$.MODULE$.float2double(innerRadius), Float$.MODULE$.float2double(outerRadius), this.smoothness, 1);
        if (this.is3D && rotatable) {
            gl.glRotatef(180.0f, 1.0f, 0.0f, 0.0f);
            gl.glTranslatef(0.0f, 0.0f, zDepth * (float)2);
            glu.gluDisk(this.quadric, Float$.MODULE$.float2double(innerRadius), Float$.MODULE$.float2double(outerRadius), this.smoothness, 1);
            return;
        }
    }

    public void renderLine(GL2 gl, int offset, Line line) {
        float zDepth = (float)offset * 1.0E-4f;
        if (!line.marked()) {
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(line.displayColor(null).getRGBColorComponents(null)));
        }
        Point start = line.getStart();
        Point end = line.getEnd();
        float[] coords = new float[]{(float)start.x * 0.001f - 0.15f, (float)(300 - start.y) * 0.001f - 0.15f, (float)end.x * 0.001f - 0.15f, (float)(300 - end.y) * 0.001f - 0.15f};
        gl.glBegin(1);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(coords[0], coords[1], zDepth);
        gl.glVertex3f(coords[2], coords[3], zDepth);
        gl.glEnd();
        if (!line.marked()) {
            gl.glPopAttrib();
            return;
        }
    }
}

