/*
 * Decompiled with CFR 0.152.
 */
package bsearch.app;

import bsearch.util.GeneralUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.nlogo.swing.BrowserLauncher;

public class HelpAboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextPane jTextPaneContent = new JTextPane();
    private JScrollPane jScrollPane1;
    private JButton jButtonOk;
    private JButton jButtonWebsite;

    public HelpAboutDialog(JFrame frame, String title) {
        super((Frame)frame, title);
        String licText;
        String creditsText;
        this.jTextPaneContent.setContentType("text/plain");
        File creditsFile = new File(GeneralUtils.attemptResolvePathFromBSearchRoot("CREDITS.TXT"));
        File licFile = new File(GeneralUtils.attemptResolvePathFromBSearchRoot("LICENSE.TXT"));
        try {
            creditsText = GeneralUtils.stringContentsOfFile(creditsFile);
            licText = GeneralUtils.stringContentsOfFile(licFile);
        }
        catch (FileNotFoundException ex) {
            creditsText = "ERROR: Either CREDITS.TXT or LICENSE.TXT file not found.";
            licText = "";
        }
        this.jTextPaneContent.setText("BehaviorSearch v" + GeneralUtils.getVersionString() + "\n" + creditsText + "\n*****\n\n" + licText);
        this.jTextPaneContent.setCaretPosition(0);
        this.jTextPaneContent.setEditable(false);
        this.jScrollPane1 = new JScrollPane(this.jTextPaneContent);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        JPanel panelSouth = new JPanel();
        this.getContentPane().add((Component)panelSouth, "South");
        this.jButtonWebsite = new JButton("Browse BehaviorSearch web site");
        this.jButtonWebsite.setForeground(Color.blue);
        panelSouth.add(this.jButtonWebsite);
        this.jButtonWebsite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BrowserLauncher.openURI((Component)HelpAboutDialog.this, (URI)BrowserLauncher.makeURI((Component)HelpAboutDialog.this, (String)"http://www.behaviorsearch.org/"));
            }
        });
        this.jButtonOk = new JButton("Close");
        panelSouth.add(this.jButtonOk);
        this.jButtonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HelpAboutDialog.this.setVisible(false);
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                HelpAboutDialog.this.jButtonOk.requestFocusInWindow();
            }
        });
        this.pack();
        if (this.getWidth() > 640) {
            this.setSize(640, Math.min(this.getHeight() * 3 / 2, 440));
        }
        if (this.getHeight() > 440) {
            this.setSize(Math.min(this.getWidth() * 3 / 2, 640), 440);
        }
        this.setDefaultCloseOperation(2);
    }

    public static void showAboutDialog(JFrame parent) {
        HelpAboutDialog hdialog = new HelpAboutDialog(parent, "About BehaviorSearch...");
        hdialog.setLocationRelativeTo(null);
        hdialog.setVisible(true);
    }
}

