/*
 * Decompiled with CFR 0.152.
 */
package bsearch.fx;

import bsearch.algorithms.SearchMethod;
import bsearch.algorithms.SearchMethodLoader;
import bsearch.app.BehaviorSearch;
import bsearch.app.BehaviorSearchException;
import bsearch.app.SearchProtocol;
import bsearch.fx.AcceptOnExitTableCell;
import bsearch.fx.MainGUI;
import bsearch.fx.ProgressController;
import bsearch.fx.RunOptionDialogController;
import bsearch.fx.SearchMethodParamTableRow;
import bsearch.nlogolink.NetLogoLinkException;
import bsearch.nlogolink.Utils;
import bsearch.representations.ChromosomeFactory;
import bsearch.representations.ChromosomeTypeLoader;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import bsearch.util.GeneralUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javax.swing.SwingUtilities;
import org.nlogo.swing.BrowserLauncher;
import org.xml.sax.SAXException;

public class MainController
implements Initializable {
    @FXML
    public AnchorPane anchorPane;
    @FXML
    public TextField browseField;
    @FXML
    public Button runButton;
    @FXML
    public Button browseButton;
    @FXML
    public TextArea MParamSpecsArea;
    @FXML
    public Button MHelpSearchSpaceButton;
    @FXML
    public Button MSuggestParamButton;
    @FXML
    public TextField MModelStepField;
    @FXML
    public TextField MModelSetupField;
    @FXML
    public TextField MModelStopConditionField;
    @FXML
    public TextField MModelStepLimitField;
    @FXML
    public TextField MMeasureField;
    @FXML
    public TextField MMeasureIfField;
    @FXML
    public ChoiceBox<String> SOGoalBox;
    @FXML
    public ChoiceBox<String> SOFitnessCollectingBox;
    @FXML
    public TextField SOFitnessSamplingRepetitionsField;
    @FXML
    public ChoiceBox<String> SOFixedSamplingBox;
    @FXML
    public ChoiceBox<String> SOCombineReplicatesBox;
    @FXML
    public ChoiceBox<String> SOWrtBox;
    @FXML
    public CheckBox SOTakeDerivativeCheckBox;
    @FXML
    public TextField SODeltaField;
    @FXML
    public Label SOWrtLabel;
    @FXML
    public Label SODeltaLabel;
    @FXML
    public CheckBox SOFitnessDerivativeUseAbsCheckBox;
    @FXML
    public Button SOHelpEvaluationButton;
    @FXML
    public ChoiceBox<String> SASearchMethodBox;
    @FXML
    public ChoiceBox<String> SAChromosomeTypeBox;
    @FXML
    public CheckBox SACachingCheckBox;
    @FXML
    public TextField SABestCheckingField;
    @FXML
    public TextField SAEvaluationLimitField;
    @FXML
    public TableView<SearchMethodParamTableRow> SASearchMethodTable;
    @FXML
    public TableColumn<SearchMethodParamTableRow, String> SAParamCol;
    @FXML
    public TableColumn<SearchMethodParamTableRow, String> SAValCol;
    @FXML
    public Button SAHelpSearchSpaceRepresentationButton;
    @FXML
    public Button SAHelpSearchMethodButton;
    private File defaultUserDocumentsFolder = new FileChooser().getInitialDirectory();
    private String defaultProtocolXMLForNewSearch;
    private HashMap<String, SearchMethod> searchMethodChoices = new HashMap();
    private File currentFile;
    private String lastSavedText;
    protected BehaviorSearch.RunOptions runOptions;
    Image icon = new Image(GeneralUtils.getResource("icon_behaviorsearch.png").toURI().toString());

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.SOGoalBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"Minimize Fitness", "Maximize Fitness"}));
        ArrayList<String> fitnessCollecting = new ArrayList<String>();
        for (SearchProtocol.FITNESS_COLLECTING f : SearchProtocol.FITNESS_COLLECTING.values()) {
            fitnessCollecting.add(f.toString());
        }
        this.SOFitnessCollectingBox.setItems(FXCollections.observableArrayList(fitnessCollecting));
        this.SOFixedSamplingBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"Fixed Sampling"}));
        ArrayList<String> combineReplication = new ArrayList<String>();
        for (SearchProtocol.FITNESS_COMBINE_REPLICATIONS f : SearchProtocol.FITNESS_COMBINE_REPLICATIONS.values()) {
            combineReplication.add(f.toString());
        }
        this.SOCombineReplicatesBox.setItems(FXCollections.observableArrayList(combineReplication));
        this.SOWrtBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"---"}));
        try {
            this.SASearchMethodBox.setItems(FXCollections.observableArrayList(SearchMethodLoader.getAllSearchMethodNames()));
        }
        catch (BehaviorSearchException e) {
            MainController.handleError(e.getMessage());
        }
        try {
            for (String name : SearchMethodLoader.getAllSearchMethodNames()) {
                this.searchMethodChoices.put(name, SearchMethodLoader.createFromName(name));
            }
        }
        catch (BehaviorSearchException e1) {
            MainController.handleError(e1.getMessage());
        }
        this.SASearchMethodBox.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> obsValue, String oldSelectedStage, String newSelectedStage) {
                SearchMethod searchMethod = MainController.this.searchMethodChoices.get(newSelectedStage);
                MainController.this.updateSearchMethodParamTable(searchMethod, searchMethod.getSearchParams());
            }
        });
        try {
            this.SAChromosomeTypeBox.setItems(FXCollections.observableArrayList(ChromosomeTypeLoader.getAllChromosomeTypes()));
        }
        catch (BehaviorSearchException e) {
            MainController.handleError(e.getMessage());
        }
        try {
            this.defaultProtocolXMLForNewSearch = GeneralUtils.stringContentsOfFile(GeneralUtils.getResource("defaultNewSearch.xml"));
        }
        catch (FileNotFoundException ex) {
            MainController.handleError("Cannot find defaultNewSearch.xml", null);
            System.exit(1);
        }
        this.actionNew();
    }

    public void helpDialog(String title, String content) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(null);
        WebView webView = new WebView();
        webView.getEngine().loadContent(content);
        webView.setPrefSize(500.0, 300.0);
        alert.getDialogPane().setContent((Node)webView);
        alert.showAndWait();
    }

    public void helpSearchSpaceAction(ActionEvent event) {
        this.helpDialog("Help about search space specification", "<HTML><BODY>Specifying the range of parameters to be searched works much the same as the BehaviorSpace tool in NetLogo:<PRE> [ \"PARAM_NAME\" VALUE1 VALUE2 VALUE3 ... ] </PRE>or <PRE> [ \"PARAM_NAME\" [RANGE_START INCREMENT RANGE_END] ] </PRE><P>One slight difference is that INCREMENT may be \"C\", which means to search the range continously (or at least with fine resolution, if the chromosomal representation doesn't allow for continuous parameters)</P></BODY></HTML>");
    }

    public void helpSearchSpaceRepresentationAction(ActionEvent event) {
        String chromosomeType = (String)this.SAChromosomeTypeBox.getValue();
        try {
            ChromosomeFactory factory = ChromosomeTypeLoader.createFromName(chromosomeType);
            this.helpDialog("Help about " + chromosomeType, factory.getHTMLHelpText() + "<BR><BR>");
        }
        catch (BehaviorSearchException ex) {
            MainController.handleError(ex.toString());
        }
    }

    public void helpEvaluationAction(ActionEvent event) {
        this.helpDialog("Help about fitness evaluation", "<HTML><BODY>An objective function must condense the data collected from multiple model runs into a single number, which is what the search process will either attempt to minimize or maximize.</BODY></HTML>");
    }

    public void helpSearchMethodAction(ActionEvent event) {
        SearchMethod sm = this.searchMethodChoices.get(this.SASearchMethodBox.getValue());
        this.helpDialog("Help about " + sm.getName(), sm.getHTMLHelpText());
    }

    private Window getMainWindow() {
        if (this.anchorPane != null && this.anchorPane.getScene() != null) {
            return this.anchorPane.getScene().getWindow();
        }
        return null;
    }

    public void showTutorialAction(ActionEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrowserLauncher.openPath((Path)Path.of(GeneralUtils.attemptResolvePathFromBSearchRoot("documentation/tutorialFx.html"), new String[0]), (String)"");
            }
        });
    }

    public void showAboutAction(ActionEvent event) {
        String licText;
        String creditsText;
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("About BehaviorSearch...");
        alert.setHeaderText(null);
        alert.setGraphic(null);
        ButtonType browseWebsite = new ButtonType("Browse BehaviorSearch web site");
        ButtonType close = new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{browseWebsite, close});
        TextArea content = new TextArea();
        File creditsFile = new File(GeneralUtils.attemptResolvePathFromBSearchRoot("CREDITS.TXT"));
        File licFile = new File(GeneralUtils.attemptResolvePathFromBSearchRoot("LICENSE.TXT"));
        try {
            creditsText = GeneralUtils.stringContentsOfFile(creditsFile);
            licText = GeneralUtils.stringContentsOfFile(licFile);
        }
        catch (FileNotFoundException ex) {
            creditsText = "ERROR: Either CREDITS.TXT or LICENSE.TXT file not found.";
            licText = "";
        }
        content.setText("BehaviorSearch v" + GeneralUtils.getVersionString() + "\n" + creditsText + "\n*****\n\n" + licText);
        content.setWrapText(true);
        content.setMinHeight(400.0);
        alert.getDialogPane().setContent((Node)content);
        Optional result = alert.showAndWait();
        if (result.get() == browseWebsite) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserLauncher.openURIString((String)"http://www.behaviorsearch.org/");
                }
            });
        }
    }

    public void browseFile(ActionEvent event) {
        File selectedFile;
        FileChooser fileChooser = new FileChooser();
        File parentFolder = new File(this.browseField.getText()).getParentFile();
        if (parentFolder != null && parentFolder.exists()) {
            fileChooser.setInitialDirectory(parentFolder);
        }
        if ((selectedFile = fileChooser.showOpenDialog(this.getMainWindow())) != null) {
            this.browseField.setText(selectedFile.getPath());
        }
    }

    private void updateWindowTitle(String fileName) {
        Window mainWindow = this.getMainWindow();
        if (mainWindow != null) {
            ((Stage)mainWindow).setTitle(fileName + MainGUI.getWindowTitleSuffix());
        }
    }

    public void actionNew() {
        if (!this.checkDiscardOkay()) {
            return;
        }
        this.currentFile = null;
        this.MParamSpecsArea.setText("[\"integerParameter\" [0 1 10]] \n[\"continuousParameter\" [0.0 \"C\" 1.0]] \n [\"choiceParameter\" \"near\" \"far\"] \n");
        try {
            SearchProtocol protocol = SearchProtocol.load(this.defaultProtocolXMLForNewSearch);
            this.loadProtocol(protocol);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error loading default XML protocol to initialize UI!");
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalStateException("Error loading default XML protocol to initialize UI!");
        }
        this.updateWindowTitle("Untitled");
    }

    public void actionOpen() {
        if (!this.checkDiscardOkay()) {
            return;
        }
        FileChooser chooser = new FileChooser();
        if (this.currentFile != null) {
            chooser.setInitialDirectory(this.currentFile.getParentFile());
        }
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("bsearch File", new String[]{"*.bsearch"}), new FileChooser.ExtensionFilter("XML File", new String[]{"*.xml"})});
        File selectedFile = chooser.showOpenDialog(null);
        if (selectedFile != null) {
            this.openFile(selectedFile);
        }
    }

    public void actionOpenExample() {
        if (!this.checkDiscardOkay()) {
            return;
        }
        FileChooser chooser = new FileChooser();
        try {
            chooser.setInitialDirectory(new File(GeneralUtils.attemptResolvePathFromBSearchRoot("examples")));
        }
        catch (Exception e) {
            MainController.handleError("Error: cannot find Example folder", e);
        }
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("bsearch File", new String[]{"*.bsearch"}), new FileChooser.ExtensionFilter("XML File", new String[]{"*.xml"})});
        File selectedFile = chooser.showOpenDialog(null);
        if (selectedFile != null) {
            this.openFile(selectedFile);
        }
    }

    public void actionOpenTest() {
        File selectedFile = new File("C:/Users/AnNguyen/Google Drive/behaviorsearch/behaviorsearch/examples/TestForFX.bsearch");
        this.openFile(selectedFile);
    }

    private void openFile(File fProtocol) {
        try {
            SearchProtocol protocol = SearchProtocol.loadFile(fProtocol.getPath());
            this.currentFile = fProtocol;
            this.loadProtocol(protocol);
            this.updateWindowTitle(this.currentFile.getName());
        }
        catch (IOException e) {
            MainController.handleError("IO Error occurred attempting to load file: " + fProtocol.getPath(), null);
            e.printStackTrace();
        }
        catch (SAXException e) {
            MainController.handleError("XML Parsing error occurred attempting to load file: " + fProtocol.getPath(), null);
            e.printStackTrace();
        }
    }

    public void loadProtocol(SearchProtocol protocol) {
        this.browseField.setText(protocol.modelFile);
        StringBuilder sb = new StringBuilder();
        for (String s : protocol.paramSpecStrings) {
            sb.append(s);
            sb.append("\n");
        }
        this.MParamSpecsArea.setText(sb.toString());
        this.MModelStepField.setText(protocol.modelStepCommands);
        this.MModelSetupField.setText(protocol.modelSetupCommands);
        this.MModelStopConditionField.setText(protocol.modelStopCondition);
        this.MModelStepLimitField.setText(Integer.toString(protocol.modelStepLimit));
        this.MMeasureField.setText(protocol.modelMetricReporter);
        this.MMeasureIfField.setText(protocol.modelMeasureIf);
        this.SOGoalBox.setValue((Object)(protocol.fitnessMinimized ? "Minimize Fitness" : "Maximize Fitness"));
        this.SOFitnessCollectingBox.setValue((Object)protocol.fitnessCollecting.toString());
        this.SOFitnessSamplingRepetitionsField.setText(Integer.toString(protocol.fitnessSamplingReplications));
        this.SOFixedSamplingBox.setValue((Object)(protocol.fitnessSamplingReplications != 0 ? "Fixed Sampling" : "Adaptive Sampling"));
        this.SOCombineReplicatesBox.setValue((Object)protocol.fitnessCombineReplications.toString());
        this.SOTakeDerivativeCheckBox.setSelected(protocol.fitnessDerivativeParameter.length() > 0);
        this.SOFitnessDerivativeUseAbsCheckBox.setSelected(protocol.fitnessDerivativeUseAbs);
        this.takeDerivativeAction(new ActionEvent());
        this.SOWrtBox.setValue((Object)protocol.fitnessDerivativeParameter);
        this.SODeltaField.setText(Double.toString(protocol.fitnessDerivativeDelta));
        this.SASearchMethodBox.setValue((Object)protocol.searchMethodType);
        this.SAChromosomeTypeBox.setValue((Object)protocol.chromosomeType);
        this.updateSearchMethodParamTable(this.searchMethodChoices.get(protocol.searchMethodType), protocol.searchMethodParams);
        this.SACachingCheckBox.setSelected(protocol.caching);
        this.SABestCheckingField.setText(Integer.toString(protocol.bestCheckingNumReplications));
        this.SAEvaluationLimitField.setText(Integer.toString(protocol.evaluationLimit));
        this.lastSavedText = protocol.toXMLString();
        this.runOptions = null;
    }

    private SearchProtocol createProtocolFromFormData() throws UIConstraintException {
        LinkedHashMap<String, String> searchMethodParams = new LinkedHashMap<String, String>();
        ObservableList currentTable = this.SASearchMethodTable.getItems();
        for (SearchMethodParamTableRow row : currentTable) {
            searchMethodParams.put(row.getParam().trim(), row.getValue().trim());
        }
        int modelStepLimit = 0;
        try {
            modelStepLimit = Integer.valueOf(this.MModelStepLimitField.getText());
            if (modelStepLimit < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            throw new UIConstraintException("STEP LIMIT should be a non-negative integer.", "Error: can't create search protocol");
        }
        int fitnessSamplingRepetitions = 0;
        if (((String)this.SOFixedSamplingBox.getValue()).toString().equals("Fixed Sampling")) {
            try {
                fitnessSamplingRepetitions = Integer.valueOf(this.SOFitnessSamplingRepetitionsField.getText());
                if (fitnessSamplingRepetitions < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException ex) {
                throw new UIConstraintException("SAMPLING REPETITIONS should be a positive integer, or 0 if using adaptive sampling.", "Error: can't create protocol");
            }
        }
        boolean caching = this.SACachingCheckBox.isSelected();
        int evaluationLimit = 0;
        try {
            evaluationLimit = Integer.valueOf(this.SAEvaluationLimitField.getText());
            if (evaluationLimit <= 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            throw new UIConstraintException("EVALUATION LIMIT should be a positive integer.", "Error: can't create search protocol");
        }
        int bestCheckingNumReplications = 0;
        try {
            bestCheckingNumReplications = Integer.valueOf(this.SABestCheckingField.getText());
            if (bestCheckingNumReplications < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            throw new UIConstraintException("The number of 'BEST CHECKING' replicates should be a non-negative integer.", "Error: can't create search protocol");
        }
        double fitnessDerivDelta = 0.0;
        if (this.SOTakeDerivativeCheckBox.isSelected()) {
            try {
                fitnessDerivDelta = Double.valueOf(this.SODeltaField.getText());
            }
            catch (NumberFormatException ex) {
                throw new UIConstraintException("The DELTA value (for taking the derivative of the objective fucntion with respect to a parameter) needs to be a number", "Error: can't create search protocol");
            }
        }
        SearchProtocol protocol = new SearchProtocol(this.browseField.getText(), Arrays.asList(this.MParamSpecsArea.getText().split("\n")), this.MModelStepField.getText(), this.MModelSetupField.getText(), this.MModelStopConditionField.getText(), modelStepLimit, this.MMeasureField.getText(), this.MMeasureIfField.getText(), ((String)this.SOGoalBox.getValue()).toString().equals("Minimize Fitness"), fitnessSamplingRepetitions, SearchProtocol.FITNESS_COLLECTING.valueOf(((String)this.SOFitnessCollectingBox.getValue()).toString()), SearchProtocol.FITNESS_COMBINE_REPLICATIONS.valueOf(((String)this.SOCombineReplicatesBox.getValue()).toString()), this.SOTakeDerivativeCheckBox.isSelected() ? ((String)this.SOWrtBox.getValue()).toString() : "", fitnessDerivDelta, this.SOFitnessDerivativeUseAbsCheckBox.isSelected(), ((String)this.SASearchMethodBox.getValue()).toString(), searchMethodParams, ((String)this.SAChromosomeTypeBox.getValue()).toString(), caching, evaluationLimit, bestCheckingNumReplications);
        return protocol;
    }

    public void actionSave() {
        if (this.currentFile == null) {
            this.actionSaveAs();
        } else {
            this.doSave();
        }
    }

    public void actionSaveAs() {
        File tempFile;
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("bsearch File", new String[]{"*.bsearch"})});
        File parentFolder = null;
        if (this.currentFile != null) {
            parentFolder = this.currentFile.getParentFile();
            chooser.setInitialFileName(this.currentFile.getName());
        } else {
            parentFolder = new File(this.browseField.getText()).getParentFile();
            chooser.setInitialFileName("Untitled.bsearch");
        }
        if (parentFolder != null && parentFolder.exists()) {
            chooser.setInitialDirectory(parentFolder);
        }
        if ((tempFile = chooser.showSaveDialog(null)) != null) {
            this.currentFile = tempFile;
            this.doSave();
        }
        if (this.currentFile != null) {
            this.updateWindowTitle(this.currentFile.getName());
        }
    }

    private void doSave() {
        try {
            FileWriter fout = new FileWriter(this.currentFile);
            SearchProtocol protocol = this.createProtocolFromFormData();
            protocol.save(fout);
            fout.close();
            this.lastSavedText = protocol.toXMLString();
        }
        catch (IOException ex) {
            MainController.handleError("IO Error occurred attempting to save file: " + this.currentFile.getPath(), ex);
        }
        catch (UIConstraintException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public boolean protocolChangedSinceLastSave() {
        String xmlStr = "";
        if (this.lastSavedText == null) {
            return false;
        }
        try {
            xmlStr = this.createProtocolFromFormData().toXMLString();
        }
        catch (UIConstraintException ex) {
            return true;
        }
        return !this.lastSavedText.equals(xmlStr);
    }

    boolean checkDiscardOkay() {
        boolean check = true;
        if (this.protocolChangedSinceLastSave()) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Discard changes?");
            alert.setHeaderText("Discard changes you've made to this search experiment?");
            Optional result = alert.showAndWait();
            check = result.get() == ButtonType.OK;
        }
        return check;
    }

    public void takeDerivativeAction(ActionEvent event) {
        if (this.SOTakeDerivativeCheckBox.isSelected()) {
            this.SOWrtLabel.setDisable(false);
            this.SODeltaLabel.setDisable(false);
            this.SOWrtBox.setDisable(false);
            this.SODeltaField.setDisable(false);
            this.SOFitnessDerivativeUseAbsCheckBox.setDisable(false);
            ArrayList<String> wrt = new ArrayList<String>();
            String name = this.currentFile.toString();
            SearchSpace ss = new SearchSpace(Arrays.asList(this.MParamSpecsArea.getText().split("\n")), name.endsWith(".nlogo3d") || name.endsWith(".nlogox3d"));
            for (ParameterSpec spec : ss.getParamSpecs()) {
                wrt.add(spec.getParameterName());
            }
            wrt.add("@MUTATE@");
            this.SOWrtBox.setItems(FXCollections.observableArrayList(wrt));
        } else {
            this.SOWrtLabel.setDisable(true);
            this.SODeltaLabel.setDisable(true);
            this.SOWrtBox.setDisable(true);
            this.SODeltaField.setDisable(true);
            this.SOFitnessDerivativeUseAbsCheckBox.setDisable(true);
        }
    }

    public void suggestParam(ActionEvent event) {
        try {
            this.MParamSpecsArea.setText(Utils.getDefaultConstraintsText(this.browseField.getText()));
        }
        catch (NetLogoLinkException e) {
            MainController.handleError(e.getMessage(), e);
        }
    }

    public void actionRunNow(ActionEvent event) {
        if (this.runOptions == null) {
            this.runOptions = new BehaviorSearch.RunOptions();
            if (this.currentFile != null) {
                String fnameStem = this.currentFile.getPath();
                fnameStem = fnameStem.substring(0, fnameStem.lastIndexOf(46));
                this.runOptions.outputStem = fnameStem = GeneralUtils.attemptResolvePathFromStartupFolder(fnameStem);
            } else {
                this.runOptions.outputStem = new File(this.defaultUserDocumentsFolder, "mySearchOutput").getPath();
            }
        }
        if (this.currentFile != null) {
            this.runOptions.protocolFilename = this.currentFile.getAbsolutePath();
        }
        Stage stage = new Stage();
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("RunOptionDialog.fxml"));
            Parent root = (Parent)loader.load();
            stage.setScene(new Scene(root));
            stage.setTitle("Run Options Dialog");
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.initOwner(this.runButton.getScene().getWindow());
            stage.getIcons().add((Object)this.icon);
            RunOptionDialogController runController = (RunOptionDialogController)loader.getController();
            runController.ini(this.runOptions, this);
            stage.showAndWait();
        }
        catch (IOException e) {
            MainController.handleError("Required file not found: RunOptionDialog.fxml \nThe program will not run properly");
        }
    }

    public static void handleError(final String msg1, final Throwable e) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Exception Dialog");
                alert.setContentText(msg1);
                if (e != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    String exceptionText = sw.toString();
                    Label label = new Label("The exception stacktrace was:");
                    TextArea textArea = new TextArea(exceptionText);
                    textArea.setEditable(false);
                    textArea.setWrapText(true);
                    textArea.setMaxWidth(Double.MAX_VALUE);
                    textArea.setMaxHeight(Double.MAX_VALUE);
                    GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
                    GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
                    GridPane expContent = new GridPane();
                    expContent.setMaxWidth(Double.MAX_VALUE);
                    expContent.add((Node)label, 0, 0);
                    expContent.add((Node)textArea, 0, 1);
                    alert.getDialogPane().setExpandableContent((Node)expContent);
                }
                alert.showAndWait();
            }
        });
    }

    public static void handleError(String msg1) {
        MainController.handleError(msg1, null);
    }

    public void displayProgressDialog() {
        SearchProtocol protocol;
        try {
            protocol = this.createProtocolFromFormData();
        }
        catch (UIConstraintException e) {
            MainController.handleError("Error creating SearchProtocol: " + e.getMessage(), null);
            return;
        }
        Stage stage = new Stage();
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("ProgressDialog.fxml"));
            Parent root = (Parent)loader.load();
            stage.setScene(new Scene(root));
            stage.setTitle("Progress Dialog");
            stage.initModality(Modality.APPLICATION_MODAL);
            stage.initOwner(this.getMainWindow());
            stage.getIcons().add((Object)this.icon);
            ProgressController progressController = (ProgressController)loader.getController();
            progressController.startSearchTask(protocol, this.runOptions);
            stage.show();
        }
        catch (IOException e) {
            MainController.handleError("Required file not found: ProgressDialog.fxml \nThe program will not run properly");
        }
    }

    private void updateSearchMethodParamTable(SearchMethod searchMethod, HashMap<String, String> searchMethodParams) {
        HashMap<String, String> defaultParams = searchMethod.getSearchParams();
        for (String key : defaultParams.keySet()) {
            if (searchMethodParams.containsKey(key)) continue;
            searchMethodParams.put(key, defaultParams.get(key));
        }
        this.SASearchMethodTable.setEditable(true);
        ArrayList<SearchMethodParamTableRow> paramTable = new ArrayList<SearchMethodParamTableRow>();
        for (String s : searchMethodParams.keySet()) {
            paramTable.add(new SearchMethodParamTableRow(s, searchMethodParams.get(s)));
        }
        this.SAValCol.setCellFactory(AcceptOnExitTableCell.forTableColumn());
        this.SAParamCol.setCellValueFactory((Callback)new PropertyValueFactory("param"));
        this.SAValCol.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        this.SASearchMethodTable.setItems(FXCollections.observableArrayList(paramTable));
        this.SAValCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<SearchMethodParamTableRow, String>>(){

            public void handle(TableColumn.CellEditEvent<SearchMethodParamTableRow, String> t) {
                ((SearchMethodParamTableRow)t.getTableView().getItems().get(t.getTablePosition().getRow())).setValue((String)t.getNewValue());
            }
        });
    }

    private class UIConstraintException
    extends Exception {
        private String title;
        private static final long serialVersionUID = 1L;

        public UIConstraintException(String msg, String title) {
            super(msg);
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

