/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.dungeon;

import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ChildNameReserved$;
import org.apache.pekko.actor.ChildRestartStats;
import org.apache.pekko.actor.ChildStats;
import org.apache.pekko.actor.InvalidActorNameException$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$Creation$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$NormalChildrenContainer$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$Recreation$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$TerminatedChildrenContainer$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$TerminatingChildrenContainer$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$Termination$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$UserRequest$;
import org.apache.pekko.util.Collections;
import org.apache.pekko.util.Collections$EmptyImmutableSeq$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface ChildrenContainer {
    public ChildrenContainer add(String var1, ChildRestartStats var2);

    public ChildrenContainer remove(ActorRef var1);

    public Option<ChildStats> getByName(String var1);

    public Option<ChildRestartStats> getByRef(ActorRef var1);

    public Iterable<ActorRef> children();

    public Iterable<ChildRestartStats> stats();

    public ChildrenContainer shallDie(ActorRef var1);

    public ChildrenContainer reserve(String var1);

    public ChildrenContainer unreserve(String var1);

    public static boolean isTerminating$(ChildrenContainer $this) {
        return $this.isTerminating();
    }

    default public boolean isTerminating() {
        return false;
    }

    public static boolean isNormal$(ChildrenContainer $this) {
        return $this.isNormal();
    }

    default public boolean isNormal() {
        return true;
    }

    public static class ChildRestartsIterable
    extends Collections.PartialImmutableValuesIterable<ChildStats, ChildRestartStats> {
        private final Map<?, ChildStats> stats;

        public ChildRestartsIterable(Map<?, ChildStats> stats) {
            this.stats = stats;
        }

        @Override
        public final ChildRestartStats apply(ChildStats c) {
            return (ChildRestartStats)c;
        }

        @Override
        public final boolean isDefinedAt(ChildStats c) {
            return c instanceof ChildRestartStats;
        }

        @Override
        public final Iterator<ChildStats> valuesIterator() {
            return this.stats.valuesIterator();
        }
    }

    public static class ChildrenIterable
    extends Collections.PartialImmutableValuesIterable<ChildStats, ActorRef> {
        private final Map<?, ChildStats> stats;

        public ChildrenIterable(Map<?, ChildStats> stats) {
            this.stats = stats;
        }

        @Override
        public final ActorRef apply(ChildStats c) {
            return ((ChildRestartStats)c).child();
        }

        @Override
        public final boolean isDefinedAt(ChildStats c) {
            return c instanceof ChildRestartStats;
        }

        @Override
        public final Iterator<ChildStats> valuesIterator() {
            return this.stats.valuesIterator();
        }
    }

    public static final class Creation
    implements SuspendReason,
    WaitingForChildren,
    Product,
    Serializable {
        public static Creation apply() {
            return ChildrenContainer$Creation$.MODULE$.apply();
        }

        public static Creation fromProduct(Product product) {
            return ChildrenContainer$Creation$.MODULE$.fromProduct(product);
        }

        public static boolean unapply(Creation creation) {
            return ChildrenContainer$Creation$.MODULE$.unapply(creation);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Creation)) return false;
            Creation creation = (Creation)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Creation;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "Creation";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Creation copy() {
            return new Creation();
        }
    }

    public static interface EmptyChildrenContainer
    extends ChildrenContainer {
        public static void $init$(EmptyChildrenContainer $this) {
            $this.org$apache$pekko$actor$dungeon$ChildrenContainer$EmptyChildrenContainer$_setter_$emptyStats_$eq(TreeMap$.MODULE$.empty((Ordering)Ordering.String$.MODULE$));
        }

        public TreeMap<String, ChildStats> emptyStats();

        public void org$apache$pekko$actor$dungeon$ChildrenContainer$EmptyChildrenContainer$_setter_$emptyStats_$eq(TreeMap var1);

        public static ChildrenContainer add$(EmptyChildrenContainer $this, String name, ChildRestartStats stats) {
            return $this.add(name, stats);
        }

        @Override
        default public ChildrenContainer add(String name, ChildRestartStats stats) {
            return new NormalChildrenContainer((TreeMap<String, ChildStats>)this.emptyStats().updated((Object)name, (Object)stats));
        }

        public static ChildrenContainer remove$(EmptyChildrenContainer $this, ActorRef child) {
            return $this.remove(child);
        }

        @Override
        default public ChildrenContainer remove(ActorRef child) {
            return this;
        }

        public static Option getByName$(EmptyChildrenContainer $this, String name) {
            return $this.getByName(name);
        }

        default public Option<ChildRestartStats> getByName(String name) {
            return None$.MODULE$;
        }

        public static Option getByRef$(EmptyChildrenContainer $this, ActorRef actor) {
            return $this.getByRef(actor);
        }

        @Override
        default public Option<ChildRestartStats> getByRef(ActorRef actor) {
            return None$.MODULE$;
        }

        public static Iterable children$(EmptyChildrenContainer $this) {
            return $this.children();
        }

        @Override
        default public Iterable<ActorRef> children() {
            return Collections$EmptyImmutableSeq$.MODULE$;
        }

        public static Iterable stats$(EmptyChildrenContainer $this) {
            return $this.stats();
        }

        @Override
        default public Iterable<ChildRestartStats> stats() {
            return Collections$EmptyImmutableSeq$.MODULE$;
        }

        public static ChildrenContainer shallDie$(EmptyChildrenContainer $this, ActorRef actor) {
            return $this.shallDie(actor);
        }

        @Override
        default public ChildrenContainer shallDie(ActorRef actor) {
            return this;
        }

        public static ChildrenContainer reserve$(EmptyChildrenContainer $this, String name) {
            return $this.reserve(name);
        }

        @Override
        default public ChildrenContainer reserve(String name) {
            return new NormalChildrenContainer((TreeMap<String, ChildStats>)this.emptyStats().updated((Object)name, (Object)ChildNameReserved$.MODULE$));
        }

        public static ChildrenContainer unreserve$(EmptyChildrenContainer $this, String name) {
            return $this.unreserve(name);
        }

        @Override
        default public ChildrenContainer unreserve(String name) {
            return this;
        }
    }

    public static class NormalChildrenContainer
    implements ChildrenContainer {
        private final TreeMap c;

        public static ChildrenContainer apply(TreeMap<String, ChildStats> treeMap) {
            return ChildrenContainer$NormalChildrenContainer$.MODULE$.apply(treeMap);
        }

        public NormalChildrenContainer(TreeMap<String, ChildStats> c) {
            this.c = c;
        }

        public TreeMap<String, ChildStats> c() {
            return this.c;
        }

        @Override
        public ChildrenContainer add(String name, ChildRestartStats stats) {
            return new NormalChildrenContainer((TreeMap<String, ChildStats>)this.c().updated((Object)name, (Object)stats));
        }

        @Override
        public ChildrenContainer remove(ActorRef child) {
            return ChildrenContainer$NormalChildrenContainer$.MODULE$.apply((TreeMap<String, ChildStats>)((TreeMap)this.c().$minus((Object)child.path().name())));
        }

        @Override
        public Option<ChildStats> getByName(String name) {
            return this.c().get((Object)name);
        }

        @Override
        public Option<ChildRestartStats> getByRef(ActorRef actor) {
            Some some;
            ChildStats childStats;
            Option option = this.c().get((Object)actor.path().name());
            if (option instanceof Some && (childStats = (ChildStats)(some = (Some)option).value()) instanceof ChildRestartStats) {
                ChildRestartStats crs = (ChildRestartStats)childStats;
                Some c = some;
                ActorRef actorRef = crs.child();
                ActorRef actorRef2 = actor;
                if (!(actorRef != null ? !((Object)actorRef).equals(actorRef2) : actorRef2 != null)) {
                    return c;
                }
            }
            return None$.MODULE$;
        }

        @Override
        public Iterable<ActorRef> children() {
            if (this.c().isEmpty()) {
                return Collections$EmptyImmutableSeq$.MODULE$;
            }
            return new ChildrenIterable((Map<?, ChildStats>)this.c());
        }

        @Override
        public Iterable<ChildRestartStats> stats() {
            if (this.c().isEmpty()) {
                return Collections$EmptyImmutableSeq$.MODULE$;
            }
            return new ChildRestartsIterable((Map<?, ChildStats>)this.c());
        }

        @Override
        public ChildrenContainer shallDie(ActorRef actor) {
            return ChildrenContainer$TerminatingChildrenContainer$.MODULE$.apply(this.c(), (Set<ActorRef>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{actor}))), ChildrenContainer$UserRequest$.MODULE$);
        }

        @Override
        public ChildrenContainer reserve(String name) {
            if (this.c().contains((Object)name)) {
                throw InvalidActorNameException$.MODULE$.apply(new StringBuilder(28).append("actor name [").append(name).append("] is not unique!").toString());
            }
            return new NormalChildrenContainer((TreeMap<String, ChildStats>)this.c().updated((Object)name, (Object)ChildNameReserved$.MODULE$));
        }

        @Override
        public ChildrenContainer unreserve(String name) {
            Option option = this.c().get((Object)name);
            if (option instanceof Some && ChildNameReserved$.MODULE$.equals(((Some)option).value())) {
                return ChildrenContainer$NormalChildrenContainer$.MODULE$.apply((TreeMap<String, ChildStats>)((TreeMap)this.c().$minus((Object)name)));
            }
            return this;
        }

        public String toString() {
            if (this.c().size() > 20) {
                return new StringBuilder(9).append(BoxesRunTime.boxToInteger((int)this.c().size()).toString()).append(" children").toString();
            }
            return this.c().mkString("children:\n    ", "\n    ", "");
        }
    }

    public static final class Recreation
    implements SuspendReason,
    WaitingForChildren,
    Product,
    Serializable {
        private final Throwable cause;

        public static Recreation apply(Throwable throwable) {
            return ChildrenContainer$Recreation$.MODULE$.apply(throwable);
        }

        public static Recreation fromProduct(Product product) {
            return ChildrenContainer$Recreation$.MODULE$.fromProduct(product);
        }

        public static Recreation unapply(Recreation recreation) {
            return ChildrenContainer$Recreation$.MODULE$.unapply(recreation);
        }

        public Recreation(Throwable cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Recreation)) return false;
            Recreation recreation = (Recreation)object;
            Throwable throwable = this.cause();
            Throwable throwable2 = recreation.cause();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Recreation;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Recreation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable cause() {
            return this.cause;
        }

        public Recreation copy(Throwable cause) {
            return new Recreation(cause);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public Throwable _1() {
            return this.cause();
        }
    }

    public static interface SuspendReason {
    }

    public static final class TerminatingChildrenContainer
    implements ChildrenContainer,
    Product,
    Serializable {
        private final TreeMap c;
        private final Set toDie;
        private final SuspendReason reason;

        public static TerminatingChildrenContainer apply(TreeMap<String, ChildStats> treeMap, Set<ActorRef> set, SuspendReason suspendReason) {
            return ChildrenContainer$TerminatingChildrenContainer$.MODULE$.apply(treeMap, set, suspendReason);
        }

        public static TerminatingChildrenContainer fromProduct(Product product) {
            return ChildrenContainer$TerminatingChildrenContainer$.MODULE$.fromProduct(product);
        }

        public static TerminatingChildrenContainer unapply(TerminatingChildrenContainer terminatingChildrenContainer) {
            return ChildrenContainer$TerminatingChildrenContainer$.MODULE$.unapply(terminatingChildrenContainer);
        }

        public TerminatingChildrenContainer(TreeMap<String, ChildStats> c, Set<ActorRef> toDie, SuspendReason reason) {
            this.c = c;
            this.toDie = toDie;
            this.reason = reason;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TerminatingChildrenContainer)) return false;
            TerminatingChildrenContainer terminatingChildrenContainer = (TerminatingChildrenContainer)object;
            TreeMap<String, ChildStats> treeMap = this.c();
            TreeMap<String, ChildStats> treeMap2 = terminatingChildrenContainer.c();
            if (treeMap == null) {
                if (treeMap2 != null) {
                    return false;
                }
            } else if (!treeMap.equals(treeMap2)) return false;
            Set<ActorRef> set = this.toDie();
            Set<ActorRef> set2 = terminatingChildrenContainer.toDie();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            SuspendReason suspendReason = this.reason();
            SuspendReason suspendReason2 = terminatingChildrenContainer.reason();
            if (suspendReason == null) {
                if (suspendReason2 == null) return true;
                return false;
            } else {
                if (!suspendReason.equals(suspendReason2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof TerminatingChildrenContainer;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "TerminatingChildrenContainer";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "c";
                }
                case 1: {
                    return "toDie";
                }
                case 2: {
                    return "reason";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TreeMap<String, ChildStats> c() {
            return this.c;
        }

        public Set<ActorRef> toDie() {
            return this.toDie;
        }

        public SuspendReason reason() {
            return this.reason;
        }

        @Override
        public ChildrenContainer add(String name, ChildRestartStats stats) {
            return this.copy((TreeMap<String, ChildStats>)this.c().updated((Object)name, (Object)stats), this.copy$default$2(), this.copy$default$3());
        }

        @Override
        public ChildrenContainer remove(ActorRef child) {
            Set t = (Set)this.toDie().$minus((Object)child);
            if (t.isEmpty()) {
                SuspendReason suspendReason = this.reason();
                if (ChildrenContainer$Termination$.MODULE$.equals(suspendReason)) {
                    return ChildrenContainer$TerminatedChildrenContainer$.MODULE$;
                }
                return ChildrenContainer$NormalChildrenContainer$.MODULE$.apply((TreeMap<String, ChildStats>)((TreeMap)this.c().$minus((Object)child.path().name())));
            }
            return this.copy((TreeMap<String, ChildStats>)((TreeMap)this.c().$minus((Object)child.path().name())), (Set<ActorRef>)t, this.copy$default$3());
        }

        @Override
        public Option<ChildStats> getByName(String name) {
            return this.c().get((Object)name);
        }

        @Override
        public Option<ChildRestartStats> getByRef(ActorRef actor) {
            Some some;
            ChildStats childStats;
            Option option = this.c().get((Object)actor.path().name());
            if (option instanceof Some && (childStats = (ChildStats)(some = (Some)option).value()) instanceof ChildRestartStats) {
                ChildRestartStats crs = (ChildRestartStats)childStats;
                Some c = some;
                ActorRef actorRef = crs.child();
                ActorRef actorRef2 = actor;
                if (!(actorRef != null ? !((Object)actorRef).equals(actorRef2) : actorRef2 != null)) {
                    return c;
                }
            }
            return None$.MODULE$;
        }

        @Override
        public Iterable<ActorRef> children() {
            if (this.c().isEmpty()) {
                return Collections$EmptyImmutableSeq$.MODULE$;
            }
            return new ChildrenIterable((Map<?, ChildStats>)this.c());
        }

        @Override
        public Iterable<ChildRestartStats> stats() {
            if (this.c().isEmpty()) {
                return Collections$EmptyImmutableSeq$.MODULE$;
            }
            return new ChildRestartsIterable((Map<?, ChildStats>)this.c());
        }

        @Override
        public ChildrenContainer shallDie(ActorRef actor) {
            Set set = (Set)this.toDie().$plus((Object)actor);
            TreeMap<String, ChildStats> treeMap = this.copy$default$1();
            SuspendReason suspendReason = this.copy$default$3();
            return this.copy(treeMap, (Set<ActorRef>)set, suspendReason);
        }

        @Override
        public ChildrenContainer reserve(String name) {
            SuspendReason suspendReason = this.reason();
            if (ChildrenContainer$Termination$.MODULE$.equals(suspendReason)) {
                throw new IllegalStateException(new StringBuilder(41).append("cannot reserve actor name '").append(name).append("': terminating").toString());
            }
            if (this.c().contains((Object)name)) {
                throw InvalidActorNameException$.MODULE$.apply(new StringBuilder(28).append("actor name [").append(name).append("] is not unique!").toString());
            }
            return this.copy((TreeMap<String, ChildStats>)this.c().updated((Object)name, (Object)ChildNameReserved$.MODULE$), this.copy$default$2(), this.copy$default$3());
        }

        @Override
        public ChildrenContainer unreserve(String name) {
            Option option = this.c().get((Object)name);
            if (option instanceof Some && ChildNameReserved$.MODULE$.equals(((Some)option).value())) {
                return this.copy((TreeMap<String, ChildStats>)((TreeMap)this.c().$minus((Object)name)), this.copy$default$2(), this.copy$default$3());
            }
            return this;
        }

        @Override
        public boolean isTerminating() {
            SuspendReason suspendReason = this.reason();
            ChildrenContainer$Termination$ childrenContainer$Termination$ = ChildrenContainer$Termination$.MODULE$;
            return !(suspendReason != null ? !suspendReason.equals(childrenContainer$Termination$) : childrenContainer$Termination$ != null);
        }

        @Override
        public boolean isNormal() {
            SuspendReason suspendReason = this.reason();
            ChildrenContainer$UserRequest$ childrenContainer$UserRequest$ = ChildrenContainer$UserRequest$.MODULE$;
            return !(suspendReason != null ? !suspendReason.equals(childrenContainer$UserRequest$) : childrenContainer$UserRequest$ != null);
        }

        public String toString() {
            if (this.c().size() > 20) {
                return new StringBuilder(9).append(BoxesRunTime.boxToInteger((int)this.c().size()).toString()).append(" children").toString();
            }
            return new StringBuilder(0).append(this.c().mkString(new StringBuilder(29).append("children (").append(this.toDie().size()).append(" terminating):\n    ").toString(), "\n    ", "\n")).append(this.toDie()).toString();
        }

        public TerminatingChildrenContainer copy(TreeMap<String, ChildStats> c, Set<ActorRef> toDie, SuspendReason reason) {
            return new TerminatingChildrenContainer(c, toDie, reason);
        }

        public TreeMap<String, ChildStats> copy$default$1() {
            return this.c();
        }

        public Set<ActorRef> copy$default$2() {
            return this.toDie();
        }

        public SuspendReason copy$default$3() {
            return this.reason();
        }

        public TreeMap<String, ChildStats> _1() {
            return this.c();
        }

        public Set<ActorRef> _2() {
            return this.toDie();
        }

        public SuspendReason _3() {
            return this.reason();
        }
    }

    public static interface WaitingForChildren {
    }
}

