/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.dispatch.BoundedMailbox$;
import org.apache.pekko.dispatch.BoundedQueueBasedMessageQueue;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.MailboxType;
import org.apache.pekko.dispatch.ProducesMessageQueue;
import org.apache.pekko.dispatch.ProducesPushTimeoutSemanticsMailbox;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import scala.Option;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BoundedMailbox
implements MailboxType,
ProducesMessageQueue<MessageQueue>,
ProducesPushTimeoutSemanticsMailbox,
Product,
Serializable {
    private final int capacity;
    private final FiniteDuration pushTimeOut;

    public static BoundedMailbox apply(int n, FiniteDuration finiteDuration) {
        return BoundedMailbox$.MODULE$.apply(n, finiteDuration);
    }

    public static BoundedMailbox fromProduct(Product product) {
        return BoundedMailbox$.MODULE$.fromProduct(product);
    }

    public static BoundedMailbox unapply(BoundedMailbox boundedMailbox) {
        return BoundedMailbox$.MODULE$.unapply(boundedMailbox);
    }

    public BoundedMailbox(int capacity, FiniteDuration pushTimeOut) {
        this.capacity = capacity;
        this.pushTimeOut = pushTimeOut;
        if (capacity < 0) {
            throw new IllegalArgumentException("The capacity for BoundedMailbox can not be negative");
        }
        if (pushTimeOut == null) {
            throw new IllegalArgumentException("The push time-out for BoundedMailbox can not be null");
        }
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.capacity());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pushTimeOut()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof BoundedMailbox)) return false;
        BoundedMailbox boundedMailbox = (BoundedMailbox)object;
        if (this.capacity() != boundedMailbox.capacity()) return false;
        FiniteDuration finiteDuration = this.pushTimeOut();
        FiniteDuration finiteDuration2 = boundedMailbox.pushTimeOut();
        if (finiteDuration != null) {
            if (!finiteDuration.equals(finiteDuration2)) return false;
            return true;
        }
        if (finiteDuration2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof BoundedMailbox;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "BoundedMailbox";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToInteger((int)this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "capacity";
        }
        if (1 == n2) {
            return "pushTimeOut";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public int capacity() {
        return this.capacity;
    }

    public FiniteDuration pushTimeOut() {
        return this.pushTimeOut;
    }

    public BoundedMailbox(ActorSystem.Settings settings, Config config) {
        this(config.getInt("mailbox-capacity"), Helpers$ConfigOps$.MODULE$.getNanosDuration$extension(Helpers$.MODULE$.ConfigOps(config), "mailbox-push-timeout-time"));
    }

    @Override
    public org.apache.pekko.dispatch.MessageQueue create(Option<ActorRef> owner, Option<ActorSystem> system) {
        return new MessageQueue(this.capacity(), this.pushTimeOut());
    }

    public BoundedMailbox copy(int capacity, FiniteDuration pushTimeOut) {
        return new BoundedMailbox(capacity, pushTimeOut);
    }

    public int copy$default$1() {
        return this.capacity();
    }

    public FiniteDuration copy$default$2() {
        return this.pushTimeOut();
    }

    public int _1() {
        return this.capacity();
    }

    public FiniteDuration _2() {
        return this.pushTimeOut();
    }

    public static class MessageQueue
    extends LinkedBlockingQueue<Envelope>
    implements BoundedQueueBasedMessageQueue {
        private final FiniteDuration pushTimeOut;

        public MessageQueue(int capacity, FiniteDuration pushTimeOut) {
            this.pushTimeOut = pushTimeOut;
            super(capacity);
        }

        public final FiniteDuration pushTimeOut() {
            return this.pushTimeOut;
        }

        @Override
        public final BlockingQueue<Envelope> queue() {
            return this;
        }
    }
}

