/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.ExecutorServiceConfigurator;
import org.apache.pekko.dispatch.ExecutorServiceFactory;
import org.apache.pekko.dispatch.ExecutorServiceFactoryProvider;
import org.apache.pekko.event.Logging$Debug$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;

public class DefaultExecutorServiceConfigurator
extends ExecutorServiceConfigurator {
    private final ExecutorServiceFactoryProvider provider;

    public DefaultExecutorServiceConfigurator(Config config, DispatcherPrerequisites prerequisites, ExecutorServiceConfigurator fallback) {
        super(config, prerequisites);
        Object object;
        Option<ExecutionContext> option = prerequisites.defaultExecutionContext();
        if (option instanceof Some) {
            ExecutionContext ec = (ExecutionContext)((Some)option).value();
            prerequisites.eventStream().publish(Logging$Debug$.MODULE$.apply("DefaultExecutorServiceConfigurator", this.getClass(), "Using passed in ExecutionContext as default executor for this ActorSystem. If you want to use a different executor, please specify one in pekko.actor.default-dispatcher.default-executor."));
            object = new ExecutorServiceFactory(ec){
                private final ExecutionContext ec$1;
                {
                    this.ec$1 = ec$2;
                }

                public ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
                    return this;
                }

                public ExecutorService createExecutorService() {
                    return this;
                }

                public void shutdown() {
                }

                public boolean isTerminated() {
                    return false;
                }

                public boolean awaitTermination(long timeout, TimeUnit unit) {
                    return false;
                }

                public List shutdownNow() {
                    return Collections.emptyList();
                }

                public void execute(Runnable command) {
                    this.ec$1.execute(command);
                }

                public boolean isShutdown() {
                    return false;
                }
            };
        } else if (None$.MODULE$.equals(option)) {
            object = fallback;
        } else {
            throw new MatchError(option);
        }
        this.provider = object;
    }

    public ExecutorServiceFactoryProvider provider() {
        return this.provider;
    }

    @Override
    public ExecutorServiceFactory createExecutorServiceFactory(String id, ThreadFactory threadFactory) {
        return this.provider().createExecutorServiceFactory(id, threadFactory);
    }
}

