/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.dispatch;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.BalancingDispatcherConfigurator;
import org.apache.pekko.dispatch.CachingConfig;
import org.apache.pekko.dispatch.DispatcherConfigurator;
import org.apache.pekko.dispatch.DispatcherPrerequisites;
import org.apache.pekko.dispatch.Dispatchers$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.dispatch.MessageDispatcherConfigurator;
import org.apache.pekko.dispatch.PinnedDispatcherConfigurator;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

@DoNotInherit
public class Dispatchers {
    private final ActorSystem.Settings settings;
    private final DispatcherPrerequisites prerequisites;
    private final LoggingAdapter logger;
    private final CachingConfig cachingConfig;
    private final Config defaultDispatcherConfig;
    private final ConcurrentHashMap<String, MessageDispatcherConfigurator> dispatcherConfigurators;
    private final MessageDispatcher internalDispatcher;

    public static String DefaultBlockingDispatcherId() {
        return Dispatchers$.MODULE$.DefaultBlockingDispatcherId();
    }

    public static String DefaultDispatcherId() {
        return Dispatchers$.MODULE$.DefaultDispatcherId();
    }

    @InternalApi
    public static String InternalDispatcherId() {
        return Dispatchers$.MODULE$.InternalDispatcherId();
    }

    public static Config getConfig(Config config, String string, int n) {
        return Dispatchers$.MODULE$.getConfig(config, string, n);
    }

    public static int getConfig$default$3() {
        return Dispatchers$.MODULE$.getConfig$default$3();
    }

    @InternalApi
    public Dispatchers(ActorSystem.Settings settings, DispatcherPrerequisites prerequisites, LoggingAdapter logger) {
        this.settings = settings;
        this.prerequisites = prerequisites;
        this.logger = logger;
        this.cachingConfig = new CachingConfig(settings.config());
        this.defaultDispatcherConfig = this.idConfig("pekko.actor.default-dispatcher").withFallback((ConfigMergeable)settings.config().getConfig("pekko.actor.default-dispatcher"));
        this.dispatcherConfigurators = new ConcurrentHashMap();
        this.internalDispatcher = this.lookup("pekko.actor.internal-dispatcher");
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DispatcherPrerequisites prerequisites() {
        return this.prerequisites;
    }

    public CachingConfig cachingConfig() {
        return this.cachingConfig;
    }

    public Config defaultDispatcherConfig() {
        return this.defaultDispatcherConfig;
    }

    public MessageDispatcher defaultGlobalDispatcher() {
        return this.lookup("pekko.actor.default-dispatcher");
    }

    public MessageDispatcher internalDispatcher() {
        return this.internalDispatcher;
    }

    public MessageDispatcher lookup(String id) {
        return this.lookupConfigurator(id, 0).dispatcher();
    }

    public boolean hasDispatcher(String id) {
        return this.dispatcherConfigurators.containsKey(id) || this.cachingConfig().hasPath(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MessageDispatcherConfigurator lookupConfigurator(String id, int depth) {
        MessageDispatcherConfigurator messageDispatcherConfigurator;
        if (depth > Dispatchers$.org$apache$pekko$dispatch$Dispatchers$$$MaxDispatcherAliasDepth) {
            throw new ConfigurationException(new StringBuilder(59).append("Didn't find a concrete dispatcher config after following ").append(Dispatchers$.org$apache$pekko$dispatch$Dispatchers$$$MaxDispatcherAliasDepth).append(", ").append(new StringBuilder(55).append("is there a loop in your config? last looked for id was ").append(id).toString()).toString());
        }
        MessageDispatcherConfigurator messageDispatcherConfigurator2 = this.dispatcherConfigurators.get(id);
        if (messageDispatcherConfigurator2 != null) return messageDispatcherConfigurator2;
        if (!this.cachingConfig().hasPath(id)) throw new ConfigurationException(new StringBuilder(28).append("Dispatcher [").append(id).append("] not configured").toString());
        ConfigValue valueAtPath = this.cachingConfig().getValue(id);
        ConfigValueType configValueType = valueAtPath.valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        ConfigValueType configValueType3 = configValueType;
        if (!(configValueType2 != null ? !configValueType2.equals(configValueType3) : configValueType3 != null)) {
            String actualId = (String)valueAtPath.unwrapped();
            this.logger.debug("Dispatcher id [{}] is an alias, actual dispatcher will be [{}]", id, actualId);
            messageDispatcherConfigurator = this.lookupConfigurator(actualId, depth + 1);
        } else {
            ConfigValueType configValueType4 = ConfigValueType.OBJECT;
            ConfigValueType configValueType5 = configValueType;
            if (!(configValueType4 != null ? !configValueType4.equals(configValueType5) : configValueType5 != null)) {
                messageDispatcherConfigurator = this.configuratorFrom(this.config(id));
            } else {
                ConfigValueType unexpected = configValueType;
                throw new ConfigurationException(new StringBuilder(66).append("Expected either a dispatcher config or an alias at [").append(id).append("] but found [").append(unexpected).append("]").toString());
            }
        }
        MessageDispatcherConfigurator newConfigurator = messageDispatcherConfigurator;
        MessageDispatcherConfigurator messageDispatcherConfigurator3 = this.dispatcherConfigurators.putIfAbsent(id, newConfigurator);
        if (messageDispatcherConfigurator3 != null) return messageDispatcherConfigurator3;
        return newConfigurator;
    }

    public boolean registerConfigurator(String id, MessageDispatcherConfigurator configurator) {
        return this.dispatcherConfigurators.putIfAbsent(id, configurator) == null;
    }

    public Config config(String id) {
        return this.config(id, this.settings().config().getConfig(id));
    }

    public Config config(String id, Config appConfig) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Dispatchers.simpleName$1(id));
        return this.idConfig(id).withFallback((ConfigMergeable)appConfig).withFallback((ConfigMergeable)ConfigFactory.parseMap((java.util.Map)package$JavaConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava())).withFallback((ConfigMergeable)this.defaultDispatcherConfig());
    }

    private Config idConfig(String id) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"id");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id);
        return ConfigFactory.parseMap((java.util.Map)package$JavaConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava());
    }

    public MessageDispatcher from(Config cfg) {
        return this.configuratorFrom(cfg).dispatcher();
    }

    private MessageDispatcherConfigurator configuratorFrom(Config cfg) {
        if (!cfg.hasPath("id")) {
            throw new ConfigurationException(new StringBuilder(44).append("Missing dispatcher 'id' property in config: ").append(Helpers$ConfigOps$.MODULE$.renderWithRedactions$extension(Helpers$.MODULE$.ConfigOps(cfg))).toString());
        }
        String string = cfg.getString("type");
        switch (string == null ? 0 : string.hashCode()) {
            case 780924615: {
                if (!"Dispatcher".equals(string)) break;
                return new DispatcherConfigurator(cfg, this.prerequisites());
            }
            case 785504256: {
                if (!"BalancingDispatcher".equals(string)) break;
                throw new IllegalArgumentException(new StringBuilder(163).append("BalancingDispatcher is deprecated, use a BalancingPool instead. During a migration period you can still use BalancingDispatcher by specifying the full class name: ").append(BalancingDispatcherConfigurator.class.getName()).toString());
            }
            case 1126523071: {
                if (!"PinnedDispatcher".equals(string)) break;
                return new PinnedDispatcherConfigurator(cfg, this.prerequisites());
            }
        }
        String fqn = string;
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(Config.class);
        Class clazz2 = (Class)Predef$.MODULE$.ArrowAssoc(DispatcherPrerequisites.class);
        List args = (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)cfg), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz2, (Object)this.prerequisites()), (List)Nil$.MODULE$));
        return (MessageDispatcherConfigurator)this.prerequisites().dynamicAccess().createInstanceFor(fqn, (Seq<Tuple2<Class<?>, Object>>)args, ClassTag$.MODULE$.apply(MessageDispatcherConfigurator.class)).recover((PartialFunction)new Serializable(fqn, cfg){
            private final String fqn$1;
            private final Config cfg$1;
            {
                this.fqn$1 = fqn$2;
                this.cfg$1 = cfg$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable exception = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable exception = throwable = x;
                throw new ConfigurationException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Cannot instantiate MessageDispatcherConfigurator type [%s], defined in [%s], make sure it has constructor with [com.typesafe.config.Config] and [org.apache.pekko.dispatch.DispatcherPrerequisites] parameters"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.fqn$1, this.cfg$1.getString("id")})), exception);
            }
        }).get();
    }

    private static final String simpleName$1(String id$1) {
        return id$1.substring(id$1.lastIndexOf(46) + 1);
    }
}

