/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Security;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Status$Failure$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Dns;
import org.apache.pekko.io.Dns$Resolve$;
import org.apache.pekko.io.Dns$Resolved$;
import org.apache.pekko.io.SimpleDnsCache;
import org.apache.pekko.io.dns.AAAARecord$;
import org.apache.pekko.io.dns.ARecord$;
import org.apache.pekko.io.dns.CachePolicy;
import org.apache.pekko.io.dns.CachePolicy$Forever$;
import org.apache.pekko.io.dns.CachePolicy$Never$;
import org.apache.pekko.io.dns.CachePolicy$Ttl$;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Ip$;
import org.apache.pekko.io.dns.DnsProtocol$Resolve$;
import org.apache.pekko.io.dns.DnsProtocol$Resolved$;
import org.apache.pekko.io.dns.DnsProtocol$Srv$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$Requiring$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@InternalApi
public class InetAddressDnsResolver
implements Actor,
ActorLogging {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(InetAddressDnsResolver.class.getDeclaredField("defaultNegativeCachePolicy$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InetAddressDnsResolver.class.getDeclaredField("defaultCachePolicy$lzy1"));
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    public final SimpleDnsCache org$apache$pekko$io$InetAddressDnsResolver$$cache;
    private final Config config;
    private CachePolicy.Ttl DefaultPositive;
    private volatile Object defaultCachePolicy$lzy1;
    private volatile Object defaultNegativeCachePolicy$lzy1;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private final long positiveTtl;
    private final long negativeTtl;

    public InetAddressDnsResolver(SimpleDnsCache cache, Config config) {
        this.org$apache$pekko$io$InetAddressDnsResolver$$cache = cache;
        this.config = config;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        String CachePolicyProp = "networkaddress.cache.ttl";
        String CachePolicyPropFallback = "sun.net.inetaddr.ttl";
        String NegativeCachePolicyProp = "networkaddress.cache.negative.ttl";
        String NegativeCachePolicyPropFallback = "sun.net.inetaddr.negative.ttl";
        this.DefaultPositive = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds());
        this.positiveCachePolicy = this.getTtl("positive-ttl", true);
        this.negativeCachePolicy = this.getTtl("negative-ttl", false);
        this.positiveTtl = this.toLongTtl(this.positiveCachePolicy());
        this.negativeTtl = this.toLongTtl(this.negativeCachePolicy());
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    private CachePolicy.CachePolicy defaultCachePolicy() {
        Object object = this.defaultCachePolicy$lzy1;
        if (object instanceof CachePolicy.CachePolicy) {
            return (CachePolicy.CachePolicy)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CachePolicy.CachePolicy)this.defaultCachePolicy$lzyINIT1();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object defaultCachePolicy$lzyINIT1() {
        while (true) {
            Object object;
            if ((object = this.defaultCachePolicy$lzy1) == null) {
                void var2_5;
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                Object var2_2 = null;
                CachePolicy.Ttl ttl = null;
                try {
                    CachePolicy.CachePolicy cachePolicy;
                    Option option = Option$.MODULE$.apply((Object)Security.getProperty("networkaddress.cache.ttl")).filter((Function1 & Serializable)_$1 -> {
                        String string = _$1;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).orElse(InetAddressDnsResolver::defaultCachePolicy$lzyINIT1$$anonfun$2).filter((Function1 & Serializable)_$2 -> {
                        String string = _$2;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).map((Function1 & Serializable)x -> Try$.MODULE$.apply(() -> InetAddressDnsResolver.defaultCachePolicy$lzyINIT1$$anonfun$4$$anonfun$1(x)));
                    if (None$.MODULE$.equals(option)) {
                        cachePolicy = this.DefaultPositive;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError((Object)option);
                        Try try_ = (Try)((Some)option).value();
                        if (try_ instanceof Success) {
                            int n = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
                            cachePolicy = this.parsePolicy(n);
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError((Object)option);
                            this.log().warning("Caching TTL misconfigured. Using default value {}.", this.DefaultPositive);
                            cachePolicy = this.DefaultPositive;
                        }
                    }
                    ttl = cachePolicy;
                    if (ttl == null) {
                        LazyVals.NullValue$ nullValue$ = LazyVals.NullValue$.MODULE$;
                    } else {
                        CachePolicy.Ttl ttl2 = ttl;
                    }
                    this.DefaultPositive = null;
                }
                catch (Throwable throwable) {
                    if (LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, var2_2)) throw throwable;
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultCachePolicy$lzy1;
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, var2_2);
                    waiting.countDown();
                    throw throwable;
                }
                if (LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, (Object)var2_5)) return ttl;
                LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultCachePolicy$lzy1;
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, (Object)var2_5);
                waiting.countDown();
                return ttl;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) return object;
            if (object == LazyVals.Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) return null;
            ((LazyVals.Waiting)object).await();
        }
    }

    private CachePolicy.CachePolicy defaultNegativeCachePolicy() {
        Object object = this.defaultNegativeCachePolicy$lzy1;
        if (object instanceof CachePolicy.CachePolicy) {
            return (CachePolicy.CachePolicy)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CachePolicy.CachePolicy)this.defaultNegativeCachePolicy$lzyINIT1();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object defaultNegativeCachePolicy$lzyINIT1() {
        while (true) {
            Object object;
            if ((object = this.defaultNegativeCachePolicy$lzy1) == null) {
                void var2_5;
                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                Object var2_2 = null;
                CachePolicy$Never$ cachePolicy$Never$ = null;
                try {
                    CachePolicy.CachePolicy cachePolicy;
                    Option option = Option$.MODULE$.apply((Object)Security.getProperty("networkaddress.cache.negative.ttl")).filter((Function1 & Serializable)_$3 -> {
                        String string = _$3;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).orElse(InetAddressDnsResolver::defaultNegativeCachePolicy$lzyINIT1$$anonfun$2).filter((Function1 & Serializable)_$4 -> {
                        String string = _$4;
                        String string2 = "";
                        return string == null ? string2 != null : !string.equals(string2);
                    }).map((Function1 & Serializable)x -> Try$.MODULE$.apply(() -> InetAddressDnsResolver.defaultNegativeCachePolicy$lzyINIT1$$anonfun$4$$anonfun$1(x)));
                    if (None$.MODULE$.equals(option)) {
                        cachePolicy = CachePolicy$Never$.MODULE$;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError((Object)option);
                        Try try_ = (Try)((Some)option).value();
                        if (try_ instanceof Success) {
                            int n = BoxesRunTime.unboxToInt((Object)((Success)try_).value());
                            cachePolicy = this.parsePolicy(n);
                        } else {
                            if (!(try_ instanceof Failure)) throw new MatchError((Object)option);
                            this.log().warning("Negative caching TTL misconfigured. Using default value {}.", CachePolicy$Never$.MODULE$);
                            cachePolicy = CachePolicy$Never$.MODULE$;
                        }
                    }
                    cachePolicy$Never$ = cachePolicy;
                    if (cachePolicy$Never$ == null) {
                        LazyVals.NullValue$ nullValue$ = LazyVals.NullValue$.MODULE$;
                    } else {
                        CachePolicy$Never$ cachePolicy$Never$2 = cachePolicy$Never$;
                    }
                }
                catch (Throwable throwable) {
                    if (LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, var2_2)) throw throwable;
                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultNegativeCachePolicy$lzy1;
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, var2_2);
                    waiting.countDown();
                    throw throwable;
                }
                if (LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, (Object)var2_5)) return cachePolicy$Never$;
                LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultNegativeCachePolicy$lzy1;
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, (Object)var2_5);
                waiting.countDown();
                return cachePolicy$Never$;
            }
            if (!(object instanceof LazyVals.LazyValControlState)) return object;
            if (object == LazyVals.Evaluating$.MODULE$) {
                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                continue;
            }
            if (!(object instanceof LazyVals.Waiting)) return null;
            ((LazyVals.Waiting)object).await();
        }
    }

    private CachePolicy.CachePolicy parsePolicy(int n) {
        CachePolicy.CachePolicy cachePolicy;
        int n2 = n;
        if (0 == n2) {
            cachePolicy = CachePolicy$Never$.MODULE$;
        } else {
            int x = n2;
            if (x < 0) {
                cachePolicy = CachePolicy$Forever$.MODULE$;
            } else {
                int x2 = n2;
                cachePolicy = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationInt(package$.MODULE$.DurationInt(x2)).seconds());
            }
        }
        return cachePolicy;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CachePolicy.CachePolicy getTtl(String path, boolean positive) {
        CachePolicy.CachePolicy cachePolicy;
        String string = this.config.getString(path);
        switch (string == null ? 0 : string.hashCode()) {
            case -677662361: {
                if (!"forever".equals(string)) break;
                cachePolicy = CachePolicy$Forever$.MODULE$;
                return cachePolicy;
            }
            case 104712844: {
                if (!"never".equals(string)) break;
                cachePolicy = CachePolicy$Never$.MODULE$;
                return cachePolicy;
            }
            case 1544803905: {
                if (!"default".equals(string)) break;
                if (positive) {
                    cachePolicy = this.defaultCachePolicy();
                    return cachePolicy;
                }
                cachePolicy = this.defaultNegativeCachePolicy();
                return cachePolicy;
            }
        }
        Long l = (Long)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToLong((long)this.config.getDuration(path, TimeUnit.SECONDS)));
        long finiteTtl = BoxesRunTime.unboxToLong(Helpers$Requiring$.MODULE$.requiring$extension((Object)l, (JFunction1.mcZJ.sp & Serializable)_$5 -> _$5 > 0L, (Function0<Object>)((Function0 & Serializable)() -> InetAddressDnsResolver.$anonfun$2(path))));
        cachePolicy = CachePolicy$Ttl$.MODULE$.fromPositive(new package.DurationLong(package$.MODULE$.DurationLong(finiteTtl)).seconds());
        return cachePolicy;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    public long positiveTtl() {
        return this.positiveTtl;
    }

    public long negativeTtl() {
        return this.negativeTtl;
    }

    private long toLongTtl(CachePolicy.CachePolicy cp) {
        CachePolicy.CachePolicy cachePolicy = cp;
        if (CachePolicy$Forever$.MODULE$.equals(cachePolicy)) {
            return Long.MAX_VALUE;
        }
        if (CachePolicy$Never$.MODULE$.equals(cachePolicy)) {
            return 0L;
        }
        if (cachePolicy instanceof CachePolicy.Ttl) {
            CachePolicy.Ttl ttl = (CachePolicy.Ttl)cachePolicy;
            return ttl.value().toMillis();
        }
        throw new MatchError((Object)cachePolicy);
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ InetAddressDnsResolver $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)object;
                    DnsProtocol.Resolve resolve2 = DnsProtocol$Resolve$.MODULE$.unapply(resolve);
                    String string = resolve2._1();
                    DnsProtocol.RequestType requestType = resolve2._2();
                    if (DnsProtocol$Srv$.MODULE$.equals(requestType)) {
                        return true;
                    }
                    String name = string;
                    if (requestType instanceof DnsProtocol.Ip) {
                        DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType;
                        DnsProtocol.Ip ip2 = DnsProtocol$Ip$.MODULE$.unapply(ip);
                        boolean bl = ip2._1();
                        boolean bl2 = ip2._2();
                        boolean ipv4 = bl;
                        boolean ipv6 = bl2;
                        DnsProtocol.Ip ip3 = ip;
                        DnsProtocol.Resolve r = resolve;
                        return true;
                    }
                }
                if (object instanceof Dns.Resolve) {
                    String string;
                    Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object);
                    String name = string = resolve._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)object;
                    DnsProtocol.Resolve resolve2 = DnsProtocol$Resolve$.MODULE$.unapply(resolve);
                    String string = resolve2._1();
                    DnsProtocol.RequestType requestType = resolve2._2();
                    if (DnsProtocol$Srv$.MODULE$.equals(requestType)) {
                        this.$outer.sender().$bang(Status$Failure$.MODULE$.apply(new IllegalArgumentException("SRV request sent to InetResolver. SRV requests are only supported by async-dns resolver.")), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    String name = string;
                    if (requestType instanceof DnsProtocol.Ip) {
                        DnsProtocol.Resolved resolved;
                        DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType;
                        DnsProtocol.Ip ip2 = DnsProtocol$Ip$.MODULE$.unapply(ip);
                        boolean bl = ip2._1();
                        boolean bl2 = ip2._2();
                        boolean ipv4 = bl;
                        boolean ipv6 = bl2;
                        DnsProtocol.Ip ip3 = ip;
                        DnsProtocol.Resolve r = resolve;
                        Option<DnsProtocol.Resolved> option = this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$cache.cached(r);
                        if (option instanceof Some) {
                            DnsProtocol.Resolved a;
                            resolved = a = (DnsProtocol.Resolved)((Some)option).value();
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.log().debug("Request for [{}] was not yet cached", name);
                            try {
                                Object[] addresses = InetAddress.getAllByName(name);
                                Seq<ResourceRecord> records = this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$addressToRecords(name, (Seq<InetAddress>)Predef$.MODULE$.wrapRefArray(addresses).toList(), ipv4, ipv6);
                                DnsProtocol.Resolved answer = DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)records.toList());
                                CachePolicy.CachePolicy cachePolicy = this.$outer.positiveCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2())), DnsProtocol$Resolved$.MODULE$.apply(name, records), this.$outer.positiveCachePolicy());
                                }
                                resolved = answer;
                            }
                            catch (UnknownHostException unknownHostException) {
                                DnsProtocol.Resolved answer = DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)((Seq)Seq$.MODULE$.empty()));
                                CachePolicy.CachePolicy cachePolicy = this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)ip3), answer, this.$outer.negativeCachePolicy());
                                }
                                resolved = answer;
                            }
                        } else {
                            throw new MatchError(option);
                        }
                        DnsProtocol.Resolved answer = resolved;
                        this.$outer.sender().$bang(answer, this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                }
                if (object instanceof Dns.Resolve) {
                    Dns.Resolved resolved;
                    Dns.Resolve resolve = Dns$Resolve$.MODULE$.unapply((Dns.Resolve)object);
                    String string = resolve._1();
                    String name = string;
                    Option<Dns.Resolved> option = this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$cache.cached(name);
                    if (option instanceof Some) {
                        Dns.Resolved a;
                        resolved = a = (Dns.Resolved)((Some)option).value();
                    } else if (None$.MODULE$.equals(option)) {
                        try {
                            Object[] addresses = InetAddress.getAllByName(name);
                            Dns.Resolved answer = Dns$Resolved$.MODULE$.apply(name, (Iterable<InetAddress>)Predef$.MODULE$.wrapRefArray(addresses));
                            CachePolicy.CachePolicy cachePolicy = this.$outer.positiveCachePolicy();
                            CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                            if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                Seq<ResourceRecord> records = this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$addressToRecords(name, (Seq<InetAddress>)Predef$.MODULE$.wrapRefArray(addresses).toList(), true, true);
                                this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2())), DnsProtocol$Resolved$.MODULE$.apply(name, records), this.$outer.positiveCachePolicy());
                            }
                            resolved = answer;
                        }
                        catch (UnknownHostException unknownHostException) {
                            Dns.Resolved answer = Dns$Resolved$.MODULE$.apply(name, (Seq<Inet4Address>)((Seq)Seq$.MODULE$.empty()), (Seq<Inet6Address>)((Seq)Seq$.MODULE$.empty()));
                            CachePolicy.CachePolicy cachePolicy = this.$outer.negativeCachePolicy();
                            CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                            if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                this.$outer.org$apache$pekko$io$InetAddressDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)Tuple2$.MODULE$.apply((Object)name, (Object)DnsProtocol$Ip$.MODULE$.apply(DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol$Ip$.MODULE$.$lessinit$greater$default$2())), DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)((Seq)Seq$.MODULE$.empty())), this.$outer.negativeCachePolicy());
                            }
                            resolved = answer;
                        }
                    } else {
                        throw new MatchError(option);
                    }
                    Dns.Resolved answer = resolved;
                    this.$outer.sender().$bang(answer, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public Seq<ResourceRecord> org$apache$pekko$io$InetAddressDnsResolver$$addressToRecords(String name, Seq<InetAddress> addresses, boolean ipv4, boolean ipv6) {
        return (Seq)addresses.collect((PartialFunction)new Serializable(ipv4, ipv6, name, this){
            private final boolean ipv4$1;
            private final boolean ipv6$1;
            private final String name$1;
            private final /* synthetic */ InetAddressDnsResolver $outer;
            {
                this.ipv4$1 = ipv4$2;
                this.ipv6$1 = ipv6$2;
                this.name$1 = name$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(InetAddress x) {
                InetAddress inetAddress = x;
                if (inetAddress instanceof Inet4Address) {
                    Inet4Address a = (Inet4Address)inetAddress;
                    if (this.ipv4$1) {
                        return true;
                    }
                }
                if (inetAddress instanceof Inet6Address) {
                    Inet6Address a = (Inet6Address)inetAddress;
                    if (this.ipv6$1) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(InetAddress x, Function1 function1) {
                InetAddress inetAddress = x;
                if (inetAddress instanceof Inet4Address) {
                    Inet4Address a = (Inet4Address)inetAddress;
                    if (this.ipv4$1) {
                        return ARecord$.MODULE$.apply(this.name$1, CachePolicy$Ttl$.MODULE$.toTll(this.$outer.positiveCachePolicy()), a);
                    }
                }
                if (inetAddress instanceof Inet6Address) {
                    Inet6Address a = (Inet6Address)inetAddress;
                    if (this.ipv6$1) {
                        return AAAARecord$.MODULE$.apply(this.name$1, CachePolicy$Ttl$.MODULE$.toTll(this.$outer.positiveCachePolicy()), a);
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    private static final Option defaultCachePolicy$lzyINIT1$$anonfun$2() {
        return Option$.MODULE$.apply((Object)System.getProperty("sun.net.inetaddr.ttl"));
    }

    private static final int defaultCachePolicy$lzyINIT1$$anonfun$4$$anonfun$1(String x$1) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$1));
    }

    private static final Option defaultNegativeCachePolicy$lzyINIT1$$anonfun$2() {
        return Option$.MODULE$.apply((Object)System.getProperty("sun.net.inetaddr.negative.ttl"));
    }

    private static final int defaultNegativeCachePolicy$lzyINIT1$$anonfun$4$$anonfun$1(String x$2) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2));
    }

    private static final Object $anonfun$2(String path$1) {
        return new StringBuilder(72).append("pekko.io.dns.").append(path$1).append(" must be 'default', 'forever', 'never' or positive duration").toString();
    }
}

