/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.ReceiveTimeout$;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.ChannelRegistration;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.SelectionHandler$ChannelReadable$;
import org.apache.pekko.io.SelectionHandler$ChannelWritable$;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.io.Tcp$Abort$;
import org.apache.pekko.io.Tcp$Aborted$;
import org.apache.pekko.io.Tcp$Close$;
import org.apache.pekko.io.Tcp$CommandFailed$;
import org.apache.pekko.io.Tcp$CompoundWrite$;
import org.apache.pekko.io.Tcp$ConfirmedClosed$;
import org.apache.pekko.io.Tcp$Connected$;
import org.apache.pekko.io.Tcp$ErrorClosed$;
import org.apache.pekko.io.Tcp$PeerClosed$;
import org.apache.pekko.io.Tcp$Received$;
import org.apache.pekko.io.Tcp$Register$;
import org.apache.pekko.io.Tcp$ResumeReading$;
import org.apache.pekko.io.Tcp$ResumeWriting$;
import org.apache.pekko.io.Tcp$SuspendReading$;
import org.apache.pekko.io.Tcp$Write$;
import org.apache.pekko.io.Tcp$WriteFile$;
import org.apache.pekko.io.Tcp$WritePath$;
import org.apache.pekko.io.Tcp$WritingResumed$;
import org.apache.pekko.io.TcpConnection$;
import org.apache.pekko.io.TcpConnection$AllRead$;
import org.apache.pekko.io.TcpConnection$CloseInformation$;
import org.apache.pekko.io.TcpConnection$ConnectionInfo$;
import org.apache.pekko.io.TcpConnection$EmptyPendingWrite$;
import org.apache.pekko.io.TcpConnection$EndOfStream$;
import org.apache.pekko.io.TcpConnection$MoreDataWaiting$;
import org.apache.pekko.io.TcpConnection$Unregistered$;
import org.apache.pekko.io.TcpConnection$UpdatePendingWriteAndThen$;
import org.apache.pekko.io.TcpConnection$WriteFileFailed$;
import org.apache.pekko.io.TcpExt;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.SetOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class TcpConnection
implements Actor,
ActorLogging,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final TcpExt tcp;
    private final SocketChannel channel;
    private final boolean pullMode;
    public PendingWrite org$apache$pekko$io$TcpConnection$$pendingWrite;
    private boolean peerClosed;
    public boolean org$apache$pekko$io$TcpConnection$$writingSuspended;
    public boolean org$apache$pekko$io$TcpConnection$$readingSuspended;
    public Option<ActorRef> org$apache$pekko$io$TcpConnection$$interestedInResume;
    private Option<CloseInformation> closedMessage;
    private ActorRef watchedActor;
    private Option<ChannelRegistration> registration;

    public static IOException DroppingWriteBecauseQueueIsFullException() {
        return TcpConnection$.MODULE$.DroppingWriteBecauseQueueIsFullException();
    }

    public static IOException DroppingWriteBecauseWritingIsSuspendedException() {
        return TcpConnection$.MODULE$.DroppingWriteBecauseWritingIsSuspendedException();
    }

    public static Function0<BoxedUnit> doNothing() {
        return TcpConnection$.MODULE$.doNothing();
    }

    public TcpConnection(TcpExt tcp, SocketChannel channel, boolean pullMode) {
        this.tcp = tcp;
        this.channel = channel;
        this.pullMode = pullMode;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.org$apache$pekko$io$TcpConnection$$pendingWrite = TcpConnection$EmptyPendingWrite$.MODULE$;
        this.peerClosed = false;
        this.org$apache$pekko$io$TcpConnection$$writingSuspended = false;
        this.org$apache$pekko$io$TcpConnection$$readingSuspended = pullMode;
        this.org$apache$pekko$io$TcpConnection$$interestedInResume = None$.MODULE$;
        this.closedMessage = None$.MODULE$;
        this.watchedActor = this.context().system().deadLetters();
        this.registration = None$.MODULE$;
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public TcpExt tcp() {
        return this.tcp;
    }

    public SocketChannel channel() {
        return this.channel;
    }

    public boolean pullMode() {
        return this.pullMode;
    }

    public void setRegistration(ChannelRegistration registration) {
        this.registration = Some$.MODULE$.apply((Object)registration);
    }

    public void signDeathPact(ActorRef actor) {
        this.unsignDeathPact();
        this.watchedActor = actor;
        this.context().watch(this.watchedActor);
    }

    public void unsignDeathPact() {
        if (this.watchedActor != this.context().system().deadLetters()) {
            this.context().unwatch(this.watchedActor);
            return;
        }
    }

    public boolean writePending() {
        return this.org$apache$pekko$io$TcpConnection$$pendingWrite != TcpConnection$EmptyPendingWrite$.MODULE$;
    }

    public PartialFunction<Object, BoxedUnit> waitingForRegistration(ChannelRegistration registration, ActorRef commander) {
        return new Serializable(commander, registration, this){
            private final ActorRef commander$1;
            private final ChannelRegistration registration$1;
            private final /* synthetic */ TcpConnection $outer;
            {
                this.commander$1 = commander$3;
                this.registration$1 = registration$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Tcp.Register) {
                    Tcp.Register register = Tcp$Register$.MODULE$.unapply((Tcp.Register)object);
                    ActorRef actorRef = register._1();
                    boolean bl = register._2();
                    boolean bl2 = register._3();
                    ActorRef handler = actorRef;
                    boolean keepOpenOnPeerClosed = bl;
                    boolean useResumeWriting = bl2;
                    return true;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Tcp.CloseCommand) {
                    Tcp.CloseCommand cmd = (Tcp.CloseCommand)object;
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Tcp.Register) {
                    Tcp.Register register = Tcp$Register$.MODULE$.unapply((Tcp.Register)object);
                    ActorRef actorRef = register._1();
                    boolean bl = register._2();
                    boolean bl2 = register._3();
                    ActorRef handler = actorRef;
                    boolean keepOpenOnPeerClosed = bl;
                    boolean useResumeWriting = bl2;
                    ActorRef actorRef2 = handler;
                    ActorRef actorRef3 = this.commander$1;
                    if (actorRef2 == null ? actorRef3 != null : !((Object)actorRef2).equals(actorRef3)) {
                        this.$outer.signDeathPact(handler);
                    }
                    if (this.$outer.tcp().Settings().TraceLogging()) {
                        this.$outer.log().debug("[{}] registered as connection handler", handler);
                    }
                    ConnectionInfo info = TcpConnection$ConnectionInfo$.MODULE$.apply(this.registration$1, handler, keepOpenOnPeerClosed, useResumeWriting);
                    this.$outer.context().setReceiveTimeout((Duration)Duration$.MODULE$.Undefined());
                    this.$outer.context().become(this.$outer.connected(info));
                    if (!this.$outer.pullMode() || !this.$outer.org$apache$pekko$io$TcpConnection$$readingSuspended) {
                        this.$outer.resumeReading(info, (Option<ActorRef>)None$.MODULE$);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$io$TcpConnection$$readingSuspended = false;
                    return BoxedUnit.UNIT;
                }
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$io$TcpConnection$$readingSuspended = true;
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Tcp.CloseCommand) {
                    Tcp.CloseCommand cmd = (Tcp.CloseCommand)object;
                    ConnectionInfo info = TcpConnection$ConnectionInfo$.MODULE$.apply(this.registration$1, this.commander$1, false, false);
                    this.$outer.handleClose(info, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender()), cmd.event());
                    return BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(object)) {
                    this.$outer.log().debug("Configured registration timeout of [{}] expired, stopping", this.$outer.tcp().Settings().RegisterTimeout());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> connected(ConnectionInfo info) {
        return this.handleWriteMessages(info).orElse((PartialFunction)new Serializable(info, this){
            private final ConnectionInfo info$1;
            private final /* synthetic */ TcpConnection $outer;
            {
                this.info$1 = info$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Tcp.CloseCommand) {
                    Tcp.CloseCommand cmd = (Tcp.CloseCommand)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    this.$outer.suspendReading(this.info$1);
                    return BoxedUnit.UNIT;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    this.$outer.resumeReading(this.info$1, (Option<ActorRef>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    this.$outer.doRead(this.info$1, (Option<ActorRef>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Tcp.CloseCommand) {
                    Tcp.CloseCommand cmd = (Tcp.CloseCommand)object;
                    this.$outer.handleClose(this.info$1, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender()), cmd.event());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        });
    }

    public PartialFunction<Object, BoxedUnit> peerSentEOF(ConnectionInfo info) {
        return this.handleWriteMessages(info).orElse((PartialFunction)new Serializable(info, this){
            private final ConnectionInfo info$2;
            private final /* synthetic */ TcpConnection $outer;
            {
                this.info$2 = info$8;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Tcp.CloseCommand) {
                    Tcp.CloseCommand cmd = (Tcp.CloseCommand)object;
                    return true;
                }
                return Tcp$ResumeReading$.MODULE$.equals(object) || SelectionHandler$ChannelReadable$.MODULE$.equals(object);
                {
                }
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Tcp.CloseCommand) {
                    Tcp.CloseCommand cmd = (Tcp.CloseCommand)object;
                    this.$outer.handleClose(this.info$2, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender()), cmd.event());
                    return BoxedUnit.UNIT;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object) || SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        });
    }

    public PartialFunction<Object, BoxedUnit> closingWithPendingWrite(ConnectionInfo info, Option<ActorRef> closeCommander, Tcp.ConnectionClosed closedEvent) {
        return new Serializable(info, closeCommander, closedEvent, this){
            private final ConnectionInfo info$3;
            private final Option closeCommander$1;
            private final Tcp.ConnectionClosed closedEvent$1;
            private final /* synthetic */ TcpConnection $outer;
            {
                this.info$3 = info$9;
                this.closeCommander$1 = closeCommander$3;
                this.closedEvent$1 = closedEvent$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    return true;
                }
                if (SelectionHandler$ChannelWritable$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof UpdatePendingWriteAndThen) {
                    UpdatePendingWriteAndThen updatePendingWriteAndThen = TcpConnection$UpdatePendingWriteAndThen$.MODULE$.unapply((UpdatePendingWriteAndThen)object);
                    PendingWrite pendingWrite = updatePendingWriteAndThen._1();
                    Function0<BoxedUnit> function0 = updatePendingWriteAndThen._2();
                    PendingWrite remaining = pendingWrite;
                    Function0<BoxedUnit> work = function0;
                    return true;
                }
                if (object instanceof WriteFileFailed) {
                    IOException iOException;
                    WriteFileFailed writeFileFailed = TcpConnection$WriteFileFailed$.MODULE$.unapply((WriteFileFailed)object);
                    IOException e = iOException = writeFileFailed._1();
                    return true;
                }
                return Tcp$Abort$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    this.$outer.suspendReading(this.info$3);
                    return BoxedUnit.UNIT;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    this.$outer.resumeReading(this.info$3, (Option<ActorRef>)this.closeCommander$1);
                    return BoxedUnit.UNIT;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    this.$outer.doRead(this.info$3, (Option<ActorRef>)this.closeCommander$1);
                    return BoxedUnit.UNIT;
                }
                if (SelectionHandler$ChannelWritable$.MODULE$.equals(object)) {
                    this.$outer.doWrite(this.info$3);
                    if (!this.$outer.writePending()) {
                        this.$outer.handleClose(this.info$3, (Option<ActorRef>)this.closeCommander$1, this.closedEvent$1);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof UpdatePendingWriteAndThen) {
                    UpdatePendingWriteAndThen updatePendingWriteAndThen = TcpConnection$UpdatePendingWriteAndThen$.MODULE$.unapply((UpdatePendingWriteAndThen)object);
                    PendingWrite pendingWrite = updatePendingWriteAndThen._1();
                    Function0<BoxedUnit> function0 = updatePendingWriteAndThen._2();
                    PendingWrite remaining = pendingWrite;
                    Function0<BoxedUnit> work = function0;
                    this.$outer.org$apache$pekko$io$TcpConnection$$pendingWrite = remaining;
                    work.apply$mcV$sp();
                    if (this.$outer.writePending()) {
                        this.info$3.registration().enableInterest(4);
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.handleClose(this.info$3, (Option<ActorRef>)this.closeCommander$1, this.closedEvent$1);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof WriteFileFailed) {
                    IOException iOException;
                    WriteFileFailed writeFileFailed = TcpConnection$WriteFileFailed$.MODULE$.unapply((WriteFileFailed)object);
                    IOException e = iOException = writeFileFailed._1();
                    this.$outer.handleError(this.info$3.handler(), e);
                    return BoxedUnit.UNIT;
                }
                if (Tcp$Abort$.MODULE$.equals(object)) {
                    this.$outer.handleClose(this.info$3, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender()), Tcp$Aborted$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> closing(ConnectionInfo info, Option<ActorRef> closeCommander) {
        return new Serializable(info, closeCommander, this){
            private final ConnectionInfo info$4;
            private final Option closeCommander$2;
            private final /* synthetic */ TcpConnection $outer;
            {
                this.info$4 = info$10;
                this.closeCommander$2 = closeCommander$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    return true;
                }
                if (Tcp$Close$.MODULE$.equals(object)) {
                    return true;
                }
                return Tcp$Abort$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (Tcp$SuspendReading$.MODULE$.equals(object)) {
                    this.$outer.suspendReading(this.info$4);
                    return BoxedUnit.UNIT;
                }
                if (Tcp$ResumeReading$.MODULE$.equals(object)) {
                    this.$outer.resumeReading(this.info$4, (Option<ActorRef>)this.closeCommander$2);
                    return BoxedUnit.UNIT;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    this.$outer.doRead(this.info$4, (Option<ActorRef>)this.closeCommander$2);
                    return BoxedUnit.UNIT;
                }
                if (Tcp$Close$.MODULE$.equals(object)) {
                    this.$outer.doCloseConnection(this.info$4.handler(), (Option<ActorRef>)this.closeCommander$2, Tcp$Close$.MODULE$.event());
                    return BoxedUnit.UNIT;
                }
                if (Tcp$Abort$.MODULE$.equals(object)) {
                    this.$outer.handleClose(this.info$4, (Option<ActorRef>)Some$.MODULE$.apply((Object)this.$outer.sender()), Tcp$Aborted$.MODULE$);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> handleWriteMessages(ConnectionInfo info) {
        return new Serializable(info, this){
            private final ConnectionInfo info$5;
            private final /* synthetic */ TcpConnection $outer;
            {
                this.info$5 = info$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (SelectionHandler$ChannelWritable$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Tcp.WriteCommand) {
                    Tcp.WriteCommand write = (Tcp.WriteCommand)object;
                    return true;
                }
                if (Tcp$ResumeWriting$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof UpdatePendingWriteAndThen) {
                    UpdatePendingWriteAndThen updatePendingWriteAndThen = TcpConnection$UpdatePendingWriteAndThen$.MODULE$.unapply((UpdatePendingWriteAndThen)object);
                    PendingWrite pendingWrite = updatePendingWriteAndThen._1();
                    Function0<BoxedUnit> function0 = updatePendingWriteAndThen._2();
                    PendingWrite remaining = pendingWrite;
                    Function0<BoxedUnit> work = function0;
                    return true;
                }
                if (object instanceof WriteFileFailed) {
                    IOException iOException;
                    WriteFileFailed writeFileFailed = TcpConnection$WriteFileFailed$.MODULE$.unapply((WriteFileFailed)object);
                    IOException e = iOException = writeFileFailed._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (SelectionHandler$ChannelWritable$.MODULE$.equals(object)) {
                    if (this.$outer.writePending()) {
                        this.$outer.doWrite(this.info$5);
                        if (!this.$outer.writePending() && this.$outer.org$apache$pekko$io$TcpConnection$$interestedInResume.nonEmpty()) {
                            ((ActorRef)this.$outer.org$apache$pekko$io$TcpConnection$$interestedInResume.get()).$bang(Tcp$WritingResumed$.MODULE$, this.$outer.self());
                            this.$outer.org$apache$pekko$io$TcpConnection$$interestedInResume = None$.MODULE$;
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Tcp.WriteCommand) {
                    Tcp.WriteCommand write = (Tcp.WriteCommand)object;
                    if (this.$outer.org$apache$pekko$io$TcpConnection$$writingSuspended) {
                        if (this.$outer.tcp().Settings().TraceLogging()) {
                            this.$outer.log().debug("Dropping write because writing is suspended");
                        }
                        this.$outer.sender().$bang(Tcp$CommandFailed$.MODULE$.apply(write).withCause(TcpConnection$.MODULE$.DroppingWriteBecauseWritingIsSuspendedException()), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    if (this.$outer.writePending()) {
                        if (this.$outer.tcp().Settings().TraceLogging()) {
                            this.$outer.log().debug("Dropping write because queue is full");
                        }
                        this.$outer.sender().$bang(Tcp$CommandFailed$.MODULE$.apply(write).withCause(TcpConnection$.MODULE$.DroppingWriteBecauseQueueIsFullException()), this.$outer.self());
                        if (this.info$5.useResumeWriting()) {
                            this.$outer.org$apache$pekko$io$TcpConnection$$writingSuspended = true;
                            return BoxedUnit.UNIT;
                        }
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.org$apache$pekko$io$TcpConnection$$pendingWrite = this.$outer.PendingWrite(this.$outer.sender(), write);
                    if (this.$outer.writePending()) {
                        this.$outer.doWrite(this.info$5);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (Tcp$ResumeWriting$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$io$TcpConnection$$writingSuspended = false;
                    if (this.$outer.writePending()) {
                        if (this.$outer.org$apache$pekko$io$TcpConnection$$interestedInResume.isEmpty()) {
                            this.$outer.org$apache$pekko$io$TcpConnection$$interestedInResume = Some$.MODULE$.apply((Object)this.$outer.sender());
                            return BoxedUnit.UNIT;
                        }
                        this.$outer.sender().$bang(Tcp$CommandFailed$.MODULE$.apply(Tcp$ResumeWriting$.MODULE$), this.$outer.self());
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.sender().$bang(Tcp$WritingResumed$.MODULE$, this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof UpdatePendingWriteAndThen) {
                    UpdatePendingWriteAndThen updatePendingWriteAndThen = TcpConnection$UpdatePendingWriteAndThen$.MODULE$.unapply((UpdatePendingWriteAndThen)object);
                    PendingWrite pendingWrite = updatePendingWriteAndThen._1();
                    Function0<BoxedUnit> function0 = updatePendingWriteAndThen._2();
                    PendingWrite remaining = pendingWrite;
                    Function0<BoxedUnit> work = function0;
                    this.$outer.org$apache$pekko$io$TcpConnection$$pendingWrite = remaining;
                    work.apply$mcV$sp();
                    if (this.$outer.writePending()) {
                        this.info$5.registration().enableInterest(4);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof WriteFileFailed) {
                    IOException iOException;
                    WriteFileFailed writeFileFailed = TcpConnection$WriteFileFailed$.MODULE$.unapply((WriteFileFailed)object);
                    IOException e = iOException = writeFileFailed._1();
                    this.$outer.handleError(this.info$5.handler(), e);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> unregistering() {
        return new Serializable(this){
            private final /* synthetic */ TcpConnection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (TcpConnection$Unregistered$.MODULE$.equals(object)) {
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                block0: {
                    Object object = x;
                    if (!TcpConnection$Unregistered$.MODULE$.equals(object)) break block0;
                    this.$outer.context().stop(this.$outer.self());
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public void completeConnect(ChannelRegistration registration, ActorRef commander, Iterable<Inet.SocketOption> options) {
        this.registration = Some$.MODULE$.apply((Object)registration);
        try {
            this.channel().socket().setTcpNoDelay(true);
        }
        catch (SocketException e) {
            this.log().debug("Could not enable TcpNoDelay: {}", e.getMessage());
        }
        options.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.afterConnect(this.channel().socket()));
        commander.$bang(Tcp$Connected$.MODULE$.apply((InetSocketAddress)this.channel().socket().getRemoteSocketAddress(), (InetSocketAddress)this.channel().socket().getLocalSocketAddress()), this.self());
        this.context().setReceiveTimeout(this.tcp().Settings().RegisterTimeout());
        if (this.tcp().Settings().WindowsConnectionAbortWorkaroundEnabled()) {
            registration.enableInterest(8);
        }
        this.context().become(this.waitingForRegistration(registration, commander));
    }

    public void suspendReading(ConnectionInfo info) {
        this.org$apache$pekko$io$TcpConnection$$readingSuspended = true;
        info.registration().disableInterest(1);
    }

    public void resumeReading(ConnectionInfo info, Option<ActorRef> closeCommander) {
        this.org$apache$pekko$io$TcpConnection$$readingSuspended = false;
        this.doRead(info, closeCommander);
    }

    public void doRead(ConnectionInfo info, Option<ActorRef> closeCommander) {
        if (!this.org$apache$pekko$io$TcpConnection$$readingSuspended) {
            block14: {
                ByteBuffer buffer = this.tcp().bufferPool().acquire();
                try {
                    try {
                        ReadResult readResult = this.innerRead$1(info, buffer, this.tcp().Settings().ReceivedMessageSizeLimit());
                        if (TcpConnection$AllRead$.MODULE$.equals(readResult)) {
                            break block14;
                        }
                        if (TcpConnection$MoreDataWaiting$.MODULE$.equals(readResult)) {
                            if (!this.pullMode()) {
                                this.self().$bang(SelectionHandler$ChannelReadable$.MODULE$, this.self());
                            }
                            break block14;
                        }
                        if (TcpConnection$EndOfStream$.MODULE$.equals(readResult)) {
                            if (this.channel().socket().isOutputShutdown()) {
                                if (this.tcp().Settings().TraceLogging()) {
                                    this.log().debug("Read returned end-of-stream, our side already closed");
                                }
                                this.doCloseConnection(info.handler(), closeCommander, Tcp$ConfirmedClosed$.MODULE$);
                            } else {
                                if (this.tcp().Settings().TraceLogging()) {
                                    this.log().debug("Read returned end-of-stream, our side not yet closed");
                                }
                                this.handleClose(info, closeCommander, Tcp$PeerClosed$.MODULE$);
                            }
                            break block14;
                        }
                        throw new MatchError((Object)readResult);
                    }
                    catch (IOException e) {
                        this.handleError(info.handler(), e);
                    }
                }
                finally {
                    this.tcp().bufferPool().release(buffer);
                }
            }
            return;
        }
    }

    public void doWrite(ConnectionInfo info) {
        this.org$apache$pekko$io$TcpConnection$$pendingWrite = this.org$apache$pekko$io$TcpConnection$$pendingWrite.doWrite(info);
    }

    public Tcp.ConnectionClosed closeReason() {
        return this.channel().socket().isOutputShutdown() ? Tcp$ConfirmedClosed$.MODULE$ : Tcp$PeerClosed$.MODULE$;
    }

    public void handleClose(ConnectionInfo info, Option<ActorRef> closeCommander, Tcp.ConnectionClosed closedEvent) {
        Tcp.ConnectionClosed connectionClosed = closedEvent;
        if (Tcp$Aborted$.MODULE$.equals(connectionClosed)) {
            if (this.tcp().Settings().TraceLogging()) {
                this.log().debug("Got Abort command. RESETing connection.");
            }
            this.doCloseConnection(info.handler(), closeCommander, closedEvent);
            return;
        }
        if (Tcp$PeerClosed$.MODULE$.equals(connectionClosed) && info.keepOpenOnPeerClosed()) {
            info.handler().$bang(Tcp$PeerClosed$.MODULE$, this.self());
            this.peerClosed = true;
            this.context().become(this.peerSentEOF(info));
            return;
        }
        if (this.writePending()) {
            this.unsignDeathPact();
            if (this.tcp().Settings().TraceLogging()) {
                this.log().debug("Got Close command but write is still pending.");
            }
            this.context().become(this.closingWithPendingWrite(info, closeCommander, closedEvent));
            return;
        }
        if (Tcp$ConfirmedClosed$.MODULE$.equals(connectionClosed)) {
            if (this.tcp().Settings().TraceLogging()) {
                this.log().debug("Got ConfirmedClose command, sending FIN.");
            }
            if (this.peerClosed || !this.safeShutdownOutput()) {
                this.doCloseConnection(info.handler(), closeCommander, closedEvent);
                return;
            }
            this.context().become(this.closing(info, closeCommander));
            return;
        }
        if (this.tcp().Settings().TraceLogging()) {
            this.log().debug("Got Close command, closing connection.");
        }
        this.doCloseConnection(info.handler(), closeCommander, closedEvent);
    }

    public void doCloseConnection(ActorRef handler, Option<ActorRef> closeCommander, Tcp.ConnectionClosed closedEvent) {
        this.stopWith(TcpConnection$CloseInformation$.MODULE$.apply((Set<ActorRef>)((Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{handler}))).$plus$plus(closeCommander)), closedEvent), this.stopWith$default$2());
    }

    public void handleError(ActorRef handler, IOException exception) {
        this.log().debug("Closing connection due to IO error {}", exception);
        this.stopWith(TcpConnection$CloseInformation$.MODULE$.apply((Set<ActorRef>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{handler}))), Tcp$ErrorClosed$.MODULE$.apply(this.extractMsg(exception))), this.stopWith$default$2());
    }

    public boolean safeShutdownOutput() {
        boolean bl;
        try {
            this.channel().socket().shutdownOutput();
            bl = true;
        }
        catch (SocketException socketException) {
            bl = false;
        }
        return bl;
    }

    private String extractMsg(Throwable t) {
        String string;
        while (true) {
            if (t == null) {
                return "unknown";
            }
            string = t.getMessage();
            if (string != null && !"".equals(string)) break;
            t = t.getCause();
        }
        String msg = string;
        return msg;
    }

    public void prepareAbort() {
        try {
            this.channel().socket().setSoLinger(true, 0);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                if (this.tcp().Settings().TraceLogging()) {
                    this.log().debug("setSoLinger(true, 0) failed with [{}]", e);
                }
            }
            throw throwable;
        }
    }

    public void stopWith(CloseInformation closeInfo, boolean shouldAbort) {
        Option<ChannelRegistration> option;
        this.closedMessage = Some$.MODULE$.apply((Object)closeInfo);
        this.unsignDeathPact();
        Tcp.Event event = closeInfo.closedEvent();
        Tcp$Aborted$ tcp$Aborted$ = Tcp$Aborted$.MODULE$;
        if (!(event == null ? tcp$Aborted$ != null : !event.equals(tcp$Aborted$)) || shouldAbort) {
            this.prepareAbort();
        }
        if (None$.MODULE$.equals(option = this.registration)) {
            this.context().stop(this.self());
            return;
        }
        if (option instanceof Some) {
            ChannelRegistration reg = (ChannelRegistration)((Some)option).value();
            this.context().become(this.unregistering());
            reg.cancelAndClose((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.self().$bang(TcpConnection$Unregistered$.MODULE$, this.self()));
            return;
        }
        throw new MatchError(option);
    }

    public boolean stopWith$default$2() {
        return false;
    }

    @Override
    public void postStop() {
        if (this.writePending()) {
            this.org$apache$pekko$io$TcpConnection$$pendingWrite.release();
        }
        Set interestedInClose = (Set)(this.writePending() ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ActorRef[]{this.org$apache$pekko$io$TcpConnection$$pendingWrite.commander()})) : Predef$.MODULE$.Set().empty()).$plus$plus((IterableOnce)this.closedMessage.toList().flatMap((Function1 & Serializable)_$2 -> _$2.notificationsTo()).toSet());
        if (this.channel().isOpen()) {
            this.prepareAbort();
        }
        if (!this.channel().isOpen() || this.isCommandFailed$1() || this.registration.isEmpty()) {
            this.notifyInterested$1(interestedInClose);
            return;
        }
        this.registration.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.cancelAndClose((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.notifyInterested$1(interestedInClose)));
    }

    @Override
    public void postRestart(Throwable reason) {
        throw new IllegalStateException("Restarting not supported for connection actors.");
    }

    public PendingWrite PendingWrite(ActorRef commander, Tcp.WriteCommand write) {
        return this.create$1(commander, write, Tcp$Write$.MODULE$.empty());
    }

    public PendingBufferWrite PendingBufferWrite(ActorRef commander, ByteString data, Tcp.Event ack, Tcp.WriteCommand tail) {
        PendingBufferWrite pendingBufferWrite;
        ByteBuffer buffer = this.tcp().bufferPool().acquire();
        try {
            int copied = data.copyToBuffer(buffer);
            buffer.flip();
            pendingBufferWrite = new PendingBufferWrite(this, commander, data.drop(copied), ack, buffer, tail);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.tcp().bufferPool().release(buffer);
                throw e;
            }
            throw throwable;
        }
        return pendingBufferWrite;
    }

    public PendingWriteFile PendingWriteFile(ActorRef commander, Path filePath, long offset, long count, Tcp.Event ack, Tcp.WriteCommand tail) {
        return new PendingWriteFile(this, commander, FileChannel.open(filePath, new OpenOption[0]), offset, count, ack, tail);
    }

    private final ReadResult innerRead$1(ConnectionInfo info$6, ByteBuffer buffer, int remainingLimit) {
        while (remainingLimit > 0) {
            int n;
            buffer.clear();
            int maxBufferSpace = package$.MODULE$.min(this.tcp().Settings().DirectBufferSize(), remainingLimit);
            buffer.limit(maxBufferSpace);
            int readBytes = this.channel().read(buffer);
            buffer.flip();
            if (this.tcp().Settings().TraceLogging()) {
                this.log().debug("Read [{}] bytes.", BoxesRunTime.boxToInteger((int)readBytes));
            }
            if (readBytes > 0) {
                info$6.handler().$bang(Tcp$Received$.MODULE$.apply(ByteString$.MODULE$.apply(buffer)), this.self());
            }
            if (maxBufferSpace == (n = readBytes)) {
                if (this.pullMode()) {
                    return TcpConnection$MoreDataWaiting$.MODULE$;
                }
                remainingLimit -= maxBufferSpace;
                continue;
            }
            int x = n;
            if (x >= 0) {
                if (!this.pullMode() || x == 0) {
                    info$6.registration().enableInterest(1);
                }
                return TcpConnection$AllRead$.MODULE$;
            }
            if (-1 == n) {
                return TcpConnection$EndOfStream$.MODULE$;
            }
            throw new IllegalStateException(new StringBuilder(37).append("Unexpected value returned from read: ").append(readBytes).toString());
        }
        return TcpConnection$MoreDataWaiting$.MODULE$;
    }

    private final boolean isCommandFailed$1() {
        return this.closedMessage.exists((Function1 & Serializable)_$3 -> _$3.closedEvent() instanceof Tcp.CommandFailed);
    }

    private final void notifyInterested$1(Set interestedInClose$1) {
        this.closedMessage.foreach((Function1)(JProcedure1 & Serializable)msg -> interestedInClose$1.foreach((Function1)(JProcedure1 & Serializable)ref -> ref.$bang(msg.closedEvent(), this.self())));
    }

    private final PendingWrite create$1(ActorRef commander$2, Tcp.WriteCommand head, Tcp.WriteCommand tail) {
        Tcp.WriteCommand writeCommand;
        while (true) {
            Tcp.Event event;
            writeCommand = head;
            Tcp.Write write = Tcp$Write$.MODULE$.empty();
            Tcp.WriteCommand writeCommand2 = writeCommand;
            if (!(write != null ? !((Object)write).equals(writeCommand2) : writeCommand2 != null)) {
                if (tail == Tcp$Write$.MODULE$.empty()) {
                    return TcpConnection$EmptyPendingWrite$.MODULE$;
                }
                Tcp.WriteCommand writeCommand3 = tail;
                Tcp.Write write2 = Tcp$Write$.MODULE$.empty();
                head = writeCommand3;
                tail = write2;
                continue;
            }
            if (writeCommand instanceof Tcp.Write) {
                Tcp.Write write3 = Tcp$Write$.MODULE$.unapply((Tcp.Write)writeCommand);
                ByteString byteString = write3._1();
                Tcp.Event event2 = write3._2();
                ByteString data = byteString;
                Tcp.Event ack = event2;
                if (data.nonEmpty()) {
                    return this.PendingBufferWrite(commander$2, data, ack, tail);
                }
            }
            if (writeCommand instanceof Tcp.WriteFile) {
                Tcp.WriteFile writeFile = Tcp$WriteFile$.MODULE$.unapply((Tcp.WriteFile)writeCommand);
                String string = writeFile._1();
                long l = writeFile._2();
                long l2 = writeFile._3();
                Tcp.Event event3 = writeFile._4();
                String path = string;
                long offset = l;
                long count = l2;
                Tcp.Event ack = event3;
                return this.PendingWriteFile(commander$2, Paths.get(path, new String[0]), offset, count, ack, tail);
            }
            if (writeCommand instanceof Tcp.WritePath) {
                Tcp.WritePath writePath = Tcp$WritePath$.MODULE$.unapply((Tcp.WritePath)writeCommand);
                Path path = writePath._1();
                long l = writePath._2();
                long l3 = writePath._3();
                Tcp.Event event4 = writePath._4();
                Path path2 = path;
                long offset = l;
                long count = l3;
                Tcp.Event ack = event4;
                return this.PendingWriteFile(commander$2, path2, offset, count, ack, tail);
            }
            if (writeCommand instanceof Tcp.CompoundWrite) {
                Tcp.CompoundWrite compoundWrite = Tcp$CompoundWrite$.MODULE$.unapply((Tcp.CompoundWrite)writeCommand);
                Tcp.SimpleWriteCommand simpleWriteCommand = compoundWrite._1();
                Tcp.WriteCommand writeCommand4 = compoundWrite._2();
                Tcp.SimpleWriteCommand h = simpleWriteCommand;
                Tcp.WriteCommand t = writeCommand4;
                Tcp.SimpleWriteCommand simpleWriteCommand2 = h;
                Tcp.WriteCommand writeCommand5 = t;
                head = simpleWriteCommand2;
                tail = writeCommand5;
                continue;
            }
            if (!(writeCommand instanceof Tcp.Write)) break;
            Tcp.Write write4 = (Tcp.Write)writeCommand;
            Tcp.Write write5 = Tcp$Write$.MODULE$.unapply(write4);
            ByteString byteString = write5._1();
            Tcp.Event ack = event = write5._2();
            Tcp.Write x = write4;
            if (x.wantsAck()) {
                commander$2.$bang(ack, this.self());
            }
            Tcp.WriteCommand writeCommand6 = tail;
            Tcp.Write write6 = Tcp$Write$.MODULE$.empty();
            head = writeCommand6;
            tail = write6;
        }
        throw new MatchError((Object)writeCommand);
    }

    public static final class CloseInformation
    implements Product,
    Serializable {
        private final Set notificationsTo;
        private final Tcp.Event closedEvent;

        public static CloseInformation apply(Set<ActorRef> set, Tcp.Event event) {
            return TcpConnection$CloseInformation$.MODULE$.apply(set, event);
        }

        public static CloseInformation fromProduct(Product product) {
            return TcpConnection$CloseInformation$.MODULE$.fromProduct(product);
        }

        public static CloseInformation unapply(CloseInformation closeInformation) {
            return TcpConnection$CloseInformation$.MODULE$.unapply(closeInformation);
        }

        public CloseInformation(Set<ActorRef> notificationsTo, Tcp.Event closedEvent) {
            this.notificationsTo = notificationsTo;
            this.closedEvent = closedEvent;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CloseInformation)) return false;
            CloseInformation closeInformation = (CloseInformation)object;
            Set<ActorRef> set = this.notificationsTo();
            Set<ActorRef> set2 = closeInformation.notificationsTo();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Tcp.Event event = this.closedEvent();
            Tcp.Event event2 = closeInformation.closedEvent();
            if (event == null) {
                if (event2 == null) return true;
                return false;
            } else {
                if (!event.equals(event2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CloseInformation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CloseInformation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "notificationsTo";
            }
            if (1 == n2) {
                return "closedEvent";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<ActorRef> notificationsTo() {
            return this.notificationsTo;
        }

        public Tcp.Event closedEvent() {
            return this.closedEvent;
        }

        public CloseInformation copy(Set<ActorRef> notificationsTo, Tcp.Event closedEvent) {
            return new CloseInformation(notificationsTo, closedEvent);
        }

        public Set<ActorRef> copy$default$1() {
            return this.notificationsTo();
        }

        public Tcp.Event copy$default$2() {
            return this.closedEvent();
        }

        public Set<ActorRef> _1() {
            return this.notificationsTo();
        }

        public Tcp.Event _2() {
            return this.closedEvent();
        }
    }

    public static final class ConnectionInfo
    implements Product,
    Serializable {
        private final ChannelRegistration registration;
        private final ActorRef handler;
        private final boolean keepOpenOnPeerClosed;
        private final boolean useResumeWriting;

        public static ConnectionInfo apply(ChannelRegistration channelRegistration, ActorRef actorRef, boolean bl, boolean bl2) {
            return TcpConnection$ConnectionInfo$.MODULE$.apply(channelRegistration, actorRef, bl, bl2);
        }

        public static ConnectionInfo fromProduct(Product product) {
            return TcpConnection$ConnectionInfo$.MODULE$.fromProduct(product);
        }

        public static ConnectionInfo unapply(ConnectionInfo connectionInfo) {
            return TcpConnection$ConnectionInfo$.MODULE$.unapply(connectionInfo);
        }

        public ConnectionInfo(ChannelRegistration registration, ActorRef handler, boolean keepOpenOnPeerClosed, boolean useResumeWriting) {
            this.registration = registration;
            this.handler = handler;
            this.keepOpenOnPeerClosed = keepOpenOnPeerClosed;
            this.useResumeWriting = useResumeWriting;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.registration()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.handler()));
            n = Statics.mix((int)n, (int)(this.keepOpenOnPeerClosed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.useResumeWriting() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConnectionInfo)) return false;
            ConnectionInfo connectionInfo = (ConnectionInfo)object;
            if (this.keepOpenOnPeerClosed() != connectionInfo.keepOpenOnPeerClosed()) return false;
            if (this.useResumeWriting() != connectionInfo.useResumeWriting()) return false;
            ChannelRegistration channelRegistration = this.registration();
            ChannelRegistration channelRegistration2 = connectionInfo.registration();
            if (channelRegistration == null) {
                if (channelRegistration2 != null) {
                    return false;
                }
            } else if (!channelRegistration.equals(channelRegistration2)) return false;
            ActorRef actorRef = this.handler();
            ActorRef actorRef2 = connectionInfo.handler();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!((Object)actorRef).equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConnectionInfo;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ConnectionInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "registration";
                }
                case 1: {
                    return "handler";
                }
                case 2: {
                    return "keepOpenOnPeerClosed";
                }
                case 3: {
                    return "useResumeWriting";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ChannelRegistration registration() {
            return this.registration;
        }

        public ActorRef handler() {
            return this.handler;
        }

        public boolean keepOpenOnPeerClosed() {
            return this.keepOpenOnPeerClosed;
        }

        public boolean useResumeWriting() {
            return this.useResumeWriting;
        }

        public ConnectionInfo copy(ChannelRegistration registration, ActorRef handler, boolean keepOpenOnPeerClosed, boolean useResumeWriting) {
            return new ConnectionInfo(registration, handler, keepOpenOnPeerClosed, useResumeWriting);
        }

        public ChannelRegistration copy$default$1() {
            return this.registration();
        }

        public ActorRef copy$default$2() {
            return this.handler();
        }

        public boolean copy$default$3() {
            return this.keepOpenOnPeerClosed();
        }

        public boolean copy$default$4() {
            return this.useResumeWriting();
        }

        public ChannelRegistration _1() {
            return this.registration();
        }

        public ActorRef _2() {
            return this.handler();
        }

        public boolean _3() {
            return this.keepOpenOnPeerClosed();
        }

        public boolean _4() {
            return this.useResumeWriting();
        }
    }

    public class PendingBufferWrite
    extends PendingWrite {
        private final ActorRef commander;
        private final ByteString remainingData;
        private final Object ack;
        private final ByteBuffer buffer;
        private final Tcp.WriteCommand tail;
        private final /* synthetic */ TcpConnection $outer;

        public PendingBufferWrite(TcpConnection $outer, ActorRef commander, ByteString remainingData, Object ack, ByteBuffer buffer, Tcp.WriteCommand tail) {
            this.commander = commander;
            this.remainingData = remainingData;
            this.ack = ack;
            this.buffer = buffer;
            this.tail = tail;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public ActorRef commander() {
            return this.commander;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public PendingWrite doWrite(ConnectionInfo info) {
            PendingBufferWrite pendingBufferWrite;
            try {
                void var2_2;
                PendingWrite next = this.writeToChannel$1(this.remainingData);
                if (next != TcpConnection$EmptyPendingWrite$.MODULE$) {
                    info.registration().enableInterest(4);
                }
                pendingBufferWrite = var2_2;
            }
            catch (IOException e) {
                this.$outer.handleError(info.handler(), e);
                pendingBufferWrite = this;
            }
            return pendingBufferWrite;
        }

        @Override
        public void release() {
            this.$outer.tcp().bufferPool().release(this.buffer);
        }

        public final /* synthetic */ TcpConnection org$apache$pekko$io$TcpConnection$PendingBufferWrite$$$outer() {
            return this.$outer;
        }

        private final PendingWrite writeToChannel$1(ByteString data) {
            while (true) {
                int writtenBytes = this.$outer.channel().write(this.buffer);
                if (this.$outer.tcp().Settings().TraceLogging()) {
                    this.$outer.log().debug("Wrote [{}] bytes to channel", BoxesRunTime.boxToInteger((int)writtenBytes));
                }
                if (this.buffer.hasRemaining()) {
                    if (data == this.remainingData) {
                        return this;
                    }
                    return new PendingBufferWrite(this.$outer, this.commander(), data, this.ack, this.buffer, this.tail);
                }
                if (!data.nonEmpty()) break;
                this.buffer.clear();
                int copied = data.copyToBuffer(this.buffer);
                this.buffer.flip();
                data = data.drop(copied);
            }
            if (!(this.ack instanceof Tcp.NoAck)) {
                this.commander().$bang(this.ack, this.$outer.self());
            }
            this.release();
            return this.$outer.PendingWrite(this.commander(), this.tail);
        }
    }

    public static abstract class PendingWrite {
        public abstract ActorRef commander();

        public abstract PendingWrite doWrite(ConnectionInfo var1);

        public abstract void release();
    }

    public class PendingWriteFile
    extends PendingWrite
    implements Runnable {
        private final ActorRef commander;
        private final FileChannel fileChannel;
        private final long offset;
        private final long remaining;
        private final Tcp.Event ack;
        private final Tcp.WriteCommand tail;
        private final /* synthetic */ TcpConnection $outer;

        public PendingWriteFile(TcpConnection $outer, ActorRef commander, FileChannel fileChannel, long offset, long remaining, Tcp.Event ack, Tcp.WriteCommand tail) {
            this.commander = commander;
            this.fileChannel = fileChannel;
            this.offset = offset;
            this.remaining = remaining;
            this.ack = ack;
            this.tail = tail;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public ActorRef commander() {
            return this.commander;
        }

        @Override
        public PendingWrite doWrite(ConnectionInfo info) {
            this.$outer.tcp().fileIoDispatcher().execute(this);
            return this;
        }

        @Override
        public void release() {
            this.fileChannel.close();
        }

        @Override
        public void run() {
            block3: {
                try {
                    long toWrite = package$.MODULE$.min(this.remaining, Int$.MODULE$.int2long(this.$outer.tcp().Settings().TransferToLimit()));
                    long written = this.fileChannel.transferTo(this.offset, toWrite, this.$outer.channel());
                    if (written < this.remaining) {
                        PendingWriteFile updated = new PendingWriteFile(this.$outer, this.commander(), this.fileChannel, this.offset + written, this.remaining - written, this.ack, this.tail);
                        this.$outer.self().$bang(TcpConnection$UpdatePendingWriteAndThen$.MODULE$.apply(updated, TcpConnection$.MODULE$.doNothing()), this.$outer.self());
                        break block3;
                    }
                    this.release();
                    Function0<BoxedUnit> andThen = !(this.ack instanceof Tcp.NoAck) ? () -> this.commander().$bang(this.ack, this.$outer.self()) : TcpConnection$.MODULE$.doNothing();
                    this.$outer.self().$bang(TcpConnection$UpdatePendingWriteAndThen$.MODULE$.apply(this.$outer.PendingWrite(this.commander(), this.tail), andThen), this.$outer.self());
                }
                catch (IOException e) {
                    this.$outer.self().$bang(TcpConnection$WriteFileFailed$.MODULE$.apply(e), this.$outer.self());
                }
            }
        }

        public final /* synthetic */ TcpConnection org$apache$pekko$io$TcpConnection$PendingWriteFile$$$outer() {
            return this.$outer;
        }
    }

    public static interface ReadResult {
    }

    public static final class UpdatePendingWriteAndThen
    implements NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final PendingWrite remainingWrite;
        private final Function0 work;

        public static UpdatePendingWriteAndThen apply(PendingWrite pendingWrite, Function0<BoxedUnit> function0) {
            return TcpConnection$UpdatePendingWriteAndThen$.MODULE$.apply(pendingWrite, function0);
        }

        public static UpdatePendingWriteAndThen fromProduct(Product product) {
            return TcpConnection$UpdatePendingWriteAndThen$.MODULE$.fromProduct(product);
        }

        public static UpdatePendingWriteAndThen unapply(UpdatePendingWriteAndThen updatePendingWriteAndThen) {
            return TcpConnection$UpdatePendingWriteAndThen$.MODULE$.unapply(updatePendingWriteAndThen);
        }

        public UpdatePendingWriteAndThen(PendingWrite remainingWrite, Function0<BoxedUnit> work) {
            this.remainingWrite = remainingWrite;
            this.work = work;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UpdatePendingWriteAndThen)) return false;
            UpdatePendingWriteAndThen updatePendingWriteAndThen = (UpdatePendingWriteAndThen)object;
            PendingWrite pendingWrite = this.remainingWrite();
            PendingWrite pendingWrite2 = updatePendingWriteAndThen.remainingWrite();
            if (pendingWrite == null) {
                if (pendingWrite2 != null) {
                    return false;
                }
            } else if (!pendingWrite.equals(pendingWrite2)) return false;
            Function0<BoxedUnit> function0 = this.work();
            Function0<BoxedUnit> function02 = updatePendingWriteAndThen.work();
            if (function0 == null) {
                if (function02 == null) return true;
                return false;
            } else {
                if (!function0.equals(function02)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UpdatePendingWriteAndThen;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UpdatePendingWriteAndThen";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "remainingWrite";
            }
            if (1 == n2) {
                return "work";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public PendingWrite remainingWrite() {
            return this.remainingWrite;
        }

        public Function0<BoxedUnit> work() {
            return this.work;
        }

        public UpdatePendingWriteAndThen copy(PendingWrite remainingWrite, Function0<BoxedUnit> work) {
            return new UpdatePendingWriteAndThen(remainingWrite, work);
        }

        public PendingWrite copy$default$1() {
            return this.remainingWrite();
        }

        public Function0<BoxedUnit> copy$default$2() {
            return this.work();
        }

        public PendingWrite _1() {
            return this.remainingWrite();
        }

        public Function0<BoxedUnit> _2() {
            return this.work();
        }
    }

    public static final class WriteFileFailed
    implements Product,
    Serializable {
        private final IOException e;

        public static WriteFileFailed apply(IOException iOException) {
            return TcpConnection$WriteFileFailed$.MODULE$.apply(iOException);
        }

        public static WriteFileFailed fromProduct(Product product) {
            return TcpConnection$WriteFileFailed$.MODULE$.fromProduct(product);
        }

        public static WriteFileFailed unapply(WriteFileFailed writeFileFailed) {
            return TcpConnection$WriteFileFailed$.MODULE$.unapply(writeFileFailed);
        }

        public WriteFileFailed(IOException e) {
            this.e = e;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WriteFileFailed)) return false;
            WriteFileFailed writeFileFailed = (WriteFileFailed)object;
            IOException iOException = this.e();
            IOException iOException2 = writeFileFailed.e();
            if (iOException != null) {
                if (!iOException.equals(iOException2)) return false;
                return true;
            }
            if (iOException2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WriteFileFailed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "WriteFileFailed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "e";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public IOException e() {
            return this.e;
        }

        public WriteFileFailed copy(IOException e) {
            return new WriteFileFailed(e);
        }

        public IOException copy$default$1() {
            return this.e();
        }

        public IOException _1() {
            return this.e();
        }
    }
}

