/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.dispatch.RequiresMessageQueue;
import org.apache.pekko.dispatch.UnboundedMessageQueueSemantics;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.ChannelRegistration;
import org.apache.pekko.io.ChannelRegistry;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.Inet$DatagramChannelCreator$;
import org.apache.pekko.io.SelectionHandler$ChannelReadable$;
import org.apache.pekko.io.Udp;
import org.apache.pekko.io.Udp$Bound$;
import org.apache.pekko.io.Udp$CommandFailed$;
import org.apache.pekko.io.Udp$Received$;
import org.apache.pekko.io.Udp$ResumeReading$;
import org.apache.pekko.io.Udp$SuspendReading$;
import org.apache.pekko.io.Udp$Unbind$;
import org.apache.pekko.io.Udp$Unbound$;
import org.apache.pekko.io.UdpExt;
import org.apache.pekko.io.WithUdpSend;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public class UdpListener
implements Actor,
ActorLogging,
WithUdpSend,
RequiresMessageQueue<UnboundedMessageQueueSemantics> {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private Udp.Send org$apache$pekko$io$WithUdpSend$$pendingSend;
    private ActorRef org$apache$pekko$io$WithUdpSend$$pendingCommander;
    private boolean org$apache$pekko$io$WithUdpSend$$retriedSend;
    private Udp.UdpSettings settings;
    private final UdpExt udp;
    public final ActorRef org$apache$pekko$io$UdpListener$$bindCommander;
    public final Udp.Bind org$apache$pekko$io$UdpListener$$bind;
    private final DatagramChannel channel;
    private final Object localAddress;

    public UdpListener(UdpExt udp, ChannelRegistry channelRegistry, ActorRef bindCommander, Udp.Bind bind) {
        Object object;
        this.udp = udp;
        this.org$apache$pekko$io$UdpListener$$bindCommander = bindCommander;
        this.org$apache$pekko$io$UdpListener$$bind = bind;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        WithUdpSend.$init$(this);
        this.context().watch(bind.handler());
        this.channel = ((Inet.DatagramChannelCreator)bind.options().collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Inet.SocketOption x) {
                Inet.SocketOption socketOption = x;
                if (socketOption instanceof Inet.DatagramChannelCreator) {
                    Inet.DatagramChannelCreator creator = (Inet.DatagramChannelCreator)socketOption;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Inet.SocketOption x, Function1 function1) {
                Inet.SocketOption socketOption = x;
                if (socketOption instanceof Inet.DatagramChannelCreator) {
                    Inet.DatagramChannelCreator creator = (Inet.DatagramChannelCreator)socketOption;
                    return creator;
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(UdpListener::$init$$$anonfun$1)).create();
        this.channel().configureBlocking(false);
        UdpListener udpListener = this;
        try {
            DatagramSocket socket = this.channel().socket();
            bind.options().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.beforeDatagramBind(socket));
            socket.bind(bind.localAddress());
            SocketAddress socketAddress = socket.getLocalSocketAddress();
            if (!(socketAddress instanceof InetSocketAddress)) {
                SocketAddress x = socketAddress;
                throw new IllegalArgumentException(new StringBuilder(33).append("bound to unknown SocketAddress [").append(x).append("]").toString());
            }
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            InetSocketAddress ret = isa;
            channelRegistry.register(this.channel(), 1, this.self());
            this.log().debug("Successfully bound to [{}]", ret);
            bind.options().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Inet.SocketOption socketOption = x$1;
                if (socketOption instanceof Inet.SocketOptionV2) {
                    Inet.SocketOptionV2 o = (Inet.SocketOptionV2)socketOption;
                    o.afterBind(this.channel().socket());
                    return;
                }
            });
            object = ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Option option;
            Throwable throwable3 = throwable;
            if (throwable3 == null || (option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                throw throwable;
            }
            Throwable e = throwable2 = (Throwable)option.get();
            bindCommander.$bang(Udp$CommandFailed$.MODULE$.apply(bind), this.self());
            this.log().error(e, "Failed to bind UDP channel to endpoint [{}]", (Object)bind.localAddress());
            this.context().stop(this.self());
            object = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = object;
        UdpListener udpListener2 = udpListener;
        udpListener = null;
        BoxedUnit boxedUnit2 = boxedUnit;
        boxedUnit = null;
        udpListener2.localAddress = boxedUnit2;
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public Udp.Send org$apache$pekko$io$WithUdpSend$$pendingSend() {
        return this.org$apache$pekko$io$WithUdpSend$$pendingSend;
    }

    @Override
    public ActorRef org$apache$pekko$io$WithUdpSend$$pendingCommander() {
        return this.org$apache$pekko$io$WithUdpSend$$pendingCommander;
    }

    @Override
    public boolean org$apache$pekko$io$WithUdpSend$$retriedSend() {
        return this.org$apache$pekko$io$WithUdpSend$$retriedSend;
    }

    @Override
    public Udp.UdpSettings settings() {
        return this.settings;
    }

    @Override
    public void org$apache$pekko$io$WithUdpSend$$pendingSend_$eq(Udp.Send x$1) {
        this.org$apache$pekko$io$WithUdpSend$$pendingSend = x$1;
    }

    @Override
    public void org$apache$pekko$io$WithUdpSend$$pendingCommander_$eq(ActorRef x$1) {
        this.org$apache$pekko$io$WithUdpSend$$pendingCommander = x$1;
    }

    @Override
    public void org$apache$pekko$io$WithUdpSend$$retriedSend_$eq(boolean x$1) {
        this.org$apache$pekko$io$WithUdpSend$$retriedSend = x$1;
    }

    @Override
    public void org$apache$pekko$io$WithUdpSend$_setter_$settings_$eq(Udp.UdpSettings x$0) {
        this.settings = x$0;
    }

    @Override
    public UdpExt udp() {
        return this.udp;
    }

    public ActorRef selector() {
        return this.context().parent();
    }

    @Override
    public DatagramChannel channel() {
        return this.channel;
    }

    public Object localAddress() {
        return this.localAddress;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ UdpListener $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ChannelRegistration) {
                    ChannelRegistration registration = (ChannelRegistration)object;
                    this.$outer.org$apache$pekko$io$UdpListener$$bindCommander.$bang(Udp$Bound$.MODULE$.apply((InetSocketAddress)this.$outer.channel().socket().getLocalSocketAddress()), this.$outer.self());
                    this.$outer.context().become((PartialFunction<Object, BoxedUnit>)this.$outer.readHandlers(registration).orElse(this.$outer.sendHandlers(registration)), true);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> readHandlers(ChannelRegistration registration) {
        return new Serializable(registration, this){
            private final ChannelRegistration registration$1;
            private final /* synthetic */ UdpListener $outer;
            {
                this.registration$1 = registration$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (Udp$SuspendReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (Udp$ResumeReading$.MODULE$.equals(object)) {
                    return true;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    return true;
                }
                return Udp$Unbind$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (Udp$SuspendReading$.MODULE$.equals(object)) {
                    this.registration$1.disableInterest(1);
                    return BoxedUnit.UNIT;
                }
                if (Udp$ResumeReading$.MODULE$.equals(object)) {
                    this.registration$1.enableInterest(1);
                    return BoxedUnit.UNIT;
                }
                if (SelectionHandler$ChannelReadable$.MODULE$.equals(object)) {
                    this.$outer.doReceive(this.registration$1, this.$outer.org$apache$pekko$io$UdpListener$$bind.handler());
                    return BoxedUnit.UNIT;
                }
                if (Udp$Unbind$.MODULE$.equals(object)) {
                    this.$outer.log().debug("Unbinding endpoint [{}]", this.$outer.org$apache$pekko$io$UdpListener$$bind.localAddress());
                    this.registration$1.cancelAndClose((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.$outer.self().$bang(Udp$Unbound$.MODULE$, this.$outer.self()));
                    this.$outer.context().become(this.$outer.unregistering(this.$outer.sender()));
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> unregistering(ActorRef requester) {
        return new Serializable(requester, this){
            private final ActorRef requester$1;
            private final /* synthetic */ UdpListener $outer;
            {
                this.requester$1 = requester$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return Udp$Unbound$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (Udp$Unbound$.MODULE$.equals(object)) {
                    this.$outer.log().debug("Unbound endpoint [{}], stopping listener", this.$outer.org$apache$pekko$io$UdpListener$$bind.localAddress());
                    this.requester$1.$bang(Udp$Unbound$.MODULE$, this.$outer.self());
                    this.$outer.context().stop(this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void doReceive(ChannelRegistration registration, ActorRef handler) {
        ByteBuffer buffer = this.udp().bufferPool().acquire();
        try {
            this.innerReceive$1(handler, this.udp().settings().BatchReceiveLimit(), buffer);
        }
        finally {
            this.udp().bufferPool().release(buffer);
            registration.enableInterest(1);
        }
    }

    @Override
    public void postStop() {
        if (this.channel().isOpen()) {
            this.log().debug("Closing DatagramChannel after being stopped");
            try {
                this.channel().close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.log().debug("Error closing DatagramChannel: {}", e);
                }
                throw throwable;
            }
            return;
        }
    }

    private static final Inet.DatagramChannelCreator $init$$$anonfun$1() {
        return Inet$DatagramChannelCreator$.MODULE$.apply();
    }

    private final void innerReceive$1(ActorRef handler$1, int readsLeft, ByteBuffer buffer) {
        SocketAddress socketAddress;
        block2: {
            while (true) {
                buffer.clear();
                buffer.limit(this.udp().settings().DirectBufferSize());
                socketAddress = this.channel().receive(buffer);
                if (!(socketAddress instanceof InetSocketAddress)) break block2;
                InetSocketAddress sender = (InetSocketAddress)socketAddress;
                buffer.flip();
                handler$1.$bang(Udp$Received$.MODULE$.apply(ByteString$.MODULE$.apply(buffer), sender), this.self());
                if (readsLeft <= 0) break;
                --readsLeft;
            }
            return;
        }
        if (socketAddress == null) {
            return;
        }
        SocketAddress unexpected = socketAddress;
        throw new RuntimeException(new StringBuilder(30).append("Unexpected address in buffer: ").append(unexpected).toString());
    }
}

