/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.BaseSerializer$;
import org.apache.pekko.serialization.ByteBufferSerializer;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Option;

@InternalApi
public final class ByteStringSerializer
implements Serializer,
ByteBufferSerializer {
    private final ExtendedActorSystem system;
    private final int identifier;

    public ByteStringSerializer(ExtendedActorSystem system) {
        this.system = system;
        this.identifier = BaseSerializer$.MODULE$.identifierFromConfig("primitive-bytestring", system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void toBinary(Object o, ByteBuffer buf) {
        ByteString bs = (ByteString)o;
        if (bs.copyToBuffer(buf) < bs.length()) {
            throw new BufferOverflowException();
        }
    }

    @Override
    public Object fromBinary(ByteBuffer buf, String manifest) {
        return ByteString$.MODULE$.fromByteBuffer(buf);
    }

    @Override
    public byte[] toBinary(Object o) {
        ByteString bs = (ByteString)o;
        byte[] result = new byte[bs.length()];
        bs.copyToArray(result, 0, bs.length());
        return result;
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return ByteString$.MODULE$.apply(bytes);
    }
}

