/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.FrequencySketch$;
import org.apache.pekko.util.FrequencySketch$Bits$;
import org.apache.pekko.util.FrequencySketch$Hasher$;
import org.apache.pekko.util.FrequencySketchUtil$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.hashing.MurmurHash3$;

@InternalApi
public final class FrequencySketch<A> {
    private final int depth;
    private final int resetSize;
    private final Hasher<A> hasher;
    private final int counterWidth;
    private final int slots;
    private final int rowWidth;
    private final int columnMask;
    private final int slotShift;
    private final int slotMask;
    private final int counterShift;
    private final long counterMask;
    private final long oddMask;
    private final long resetMask;
    private final long[][] matrix;
    private final int[] rowSizes;
    private int updatedSize;

    public static <A> FrequencySketch<A> apply(int n, int n2, double d, int n3, int n4, Hasher<A> hasher) {
        return FrequencySketch$.MODULE$.apply(n, n2, d, n3, n4, hasher);
    }

    public static <A> int apply$default$2() {
        return FrequencySketch$.MODULE$.apply$default$2();
    }

    public static <A> double apply$default$3() {
        return FrequencySketch$.MODULE$.apply$default$3();
    }

    public static <A> int apply$default$4() {
        return FrequencySketch$.MODULE$.apply$default$4();
    }

    public static <A> int apply$default$5() {
        return FrequencySketch$.MODULE$.apply$default$5();
    }

    public FrequencySketch(int depth, int width, int counterBits, int resetSize, Hasher<A> hasher) {
        this.depth = depth;
        this.resetSize = resetSize;
        this.hasher = hasher;
        Predef$.MODULE$.require(FrequencySketch$Bits$.MODULE$.isPowerOfTwo(width), FrequencySketch::$init$$$anonfun$1);
        Predef$.MODULE$.require(((Function1)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 8, 16, 32, 64}))).apply$mcZI$sp(counterBits), FrequencySketch::$init$$$anonfun$2);
        int SlotBits = 64;
        this.counterWidth = counterBits;
        this.slots = 64 / this.counterWidth;
        this.rowWidth = package$.MODULE$.max(1, width / this.slots);
        this.columnMask = width - 1;
        this.slotShift = FrequencySketch$Bits$.MODULE$.powerOfTwoExponent(this.slots);
        this.slotMask = this.slots - 1;
        this.counterShift = FrequencySketch$Bits$.MODULE$.powerOfTwoExponent(this.counterWidth);
        this.counterMask = counterBits == 64 ? Long.MAX_VALUE : (1L << this.counterWidth) - 1L;
        this.oddMask = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.slots).foldLeft((Object)BoxesRunTime.boxToLong((long)1L), (Function2)(JFunction2.mcJJI.sp & Serializable)(mask, count) -> mask | 1L << count * this.counterWidth));
        long counterResetMask = this.counterMask >> 1;
        this.resetMask = BoxesRunTime.unboxToLong((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.slots).foldLeft((Object)BoxesRunTime.boxToLong((long)counterResetMask), (Function2)(JFunction2.mcJJI.sp & Serializable)(mask, count) -> mask | counterResetMask << count * this.counterWidth));
        this.matrix = (long[][])Array$.MODULE$.fill(depth, this::$init$$$anonfun$5, ClassTag$.MODULE$.apply(Long.TYPE).wrap());
        this.rowSizes = new int[depth];
        this.updatedSize = 0;
    }

    public int size() {
        return this.updatedSize;
    }

    public int frequency(A value) {
        int hash1 = this.hasher.hash(value);
        int hash2 = this.rehash(hash1);
        int minCount = Integer.MAX_VALUE;
        for (int row = 0; row < this.depth; ++row) {
            int hash = hash1 + row * hash2;
            minCount = Math.min(minCount, this.getCounter(row, hash));
        }
        return minCount;
    }

    public void increment(A value) {
        int hash1 = this.hasher.hash(value);
        int hash2 = this.rehash(hash1);
        boolean updated = false;
        for (int row = 0; row < this.depth; ++row) {
            int hash = hash1 + row * hash2;
            updated |= this.incrementCounter(row, hash);
        }
        if (updated) {
            ++this.updatedSize;
            if (this.updatedSize == this.resetSize) {
                this.reset();
                return;
            }
            return;
        }
    }

    private int rehash(int hash) {
        return MurmurHash3$.MODULE$.finalizeHash(MurmurHash3$.MODULE$.mixLast(hash, hash), 2);
    }

    private int getCounter(int row, int hash) {
        int column = (hash & this.columnMask) >>> this.slotShift;
        int slot = (hash & this.slotMask) << this.counterShift;
        return (int)(this.matrix[row][column] >>> slot & this.counterMask);
    }

    private boolean incrementCounter(int row, int hash) {
        int column = (hash & this.columnMask) >>> this.slotShift;
        int slot = (hash & this.slotMask) << this.counterShift;
        long mask = this.counterMask << slot;
        if ((this.matrix[row][column] & mask) != mask) {
            long[] lArray = this.matrix[row];
            lArray[column] = lArray[column] + (1L << slot);
            this.rowSizes[row] = this.rowSizes[row] + 1;
            return true;
        }
        return false;
    }

    private void reset() {
        for (int row = 0; row < this.depth; ++row) {
            int odd = 0;
            for (int column = 0; column < this.rowWidth; ++column) {
                odd += Long.bitCount(this.matrix[row][column] & this.oddMask);
                this.matrix[row][column] = this.matrix[row][column] >>> 1 & this.resetMask;
            }
            this.rowSizes[row] = this.rowSizes[row] - odd >>> 1;
        }
        this.updatedSize = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(this.rowSizes).max((Ordering)Ordering.Int$.MODULE$));
    }

    public String toDebugString() {
        return FrequencySketchUtil$.MODULE$.debugString(this.matrix, this.rowWidth, this.slots, this.counterWidth, this.counterMask);
    }

    private static final Object $init$$$anonfun$1() {
        return "width must be a power of two";
    }

    private static final Object $init$$$anonfun$2() {
        return "counterBits must be 2, 4, 8, 16, 32, or 64 bits";
    }

    private final long[] $init$$$anonfun$5() {
        return new long[this.rowWidth];
    }

    public static interface Hasher<A> {
        public static int DefaultSeed() {
            return FrequencySketch$Hasher$.MODULE$.DefaultSeed();
        }

        public static StringHasher StringHasher() {
            return FrequencySketch$Hasher$.MODULE$.StringHasher();
        }

        public int hash(A var1);

        public static final class StringHasher
        implements Hasher<String> {
            private final int seed;

            public StringHasher(int seed) {
                this.seed = seed;
            }

            @Override
            public int hash(String value) {
                return MurmurHash3$.MODULE$.stringHash(value, this.seed);
            }
        }
    }
}

