/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ls;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.CompilerException;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.ls.ChildModel;
import org.nlogo.ls.LevelSpace;
import org.nlogo.nvm.HaltException;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class CreateModels<T extends ChildModel>
implements Command {
    private final LevelSpace ls;
    private final Function2<AbstractWorkspace, String, ChildModel> createModel;

    public CreateModels(LevelSpace ls, Function2<AbstractWorkspace, String, ChildModel> createModel) {
        this.ls = ls;
        this.createModel = createModel;
    }

    public Syntax getSyntax() {
        return Syntax$.MODULE$.commandSyntax((List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.NumberType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)Syntax$.MODULE$.StringType()), (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)(Syntax$.MODULE$.CommandType() | Syntax$.MODULE$.RepeatableType())), (List)Nil$.MODULE$))), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), Syntax$.MODULE$.commandSyntax$default$3(), Syntax$.MODULE$.commandSyntax$default$4(), Syntax$.MODULE$.commandSyntax$default$5(), Syntax$.MODULE$.commandSyntax$default$6(), Syntax$.MODULE$.commandSyntax$default$7());
    }

    public void perform(Argument[] args, Context ctx) {
        AbstractWorkspace parentWS = (AbstractWorkspace)ctx.workspace();
        String modelPath = ctx.attachCurrentDirectory(args[1].getString());
        try {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), args[0].getIntValue()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
                int n = x$1;
                ChildModel model = (ChildModel)this.createModel.apply((Object)parentWS, (Object)modelPath);
                if (args.length > 2) {
                    args[2].getCommand().perform(ctx, new Object[]{BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(model.modelID()))});
                    return;
                }
            });
            this.ls.updateModelMenu();
        }
        catch (MalformedURLException e) {
            throw new ExtensionException((Exception)e);
        }
        catch (CompilerException e) {
            throw new ExtensionException(modelPath + " has an error in its code: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ExtensionException("NetLogo couldn't read the file \"" + modelPath + "\". Are you sure it exists and that NetLogo has permission to read it?", (Exception)e);
        }
        catch (InterruptedException interruptedException) {
            throw new HaltException(false);
        }
    }
}

