/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.ls.gui;

import java.awt.Component;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ModelType;
import org.nlogo.api.Version;
import org.nlogo.api.Version$;
import org.nlogo.app.App$;
import org.nlogo.app.TabManager;
import org.nlogo.app.codetab.CodeTab;
import org.nlogo.app.common.TabsInterface;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N$;
import org.nlogo.core.LiteralParser;
import org.nlogo.core.Model;
import org.nlogo.core.Model$;
import org.nlogo.fileformat.FailedConversionResult;
import org.nlogo.fileformat.FileFormat$;
import org.nlogo.fileformat.NLogoAnyLoader;
import org.nlogo.ls.gui.ModelManager;
import org.nlogo.swing.OptionPane;
import org.nlogo.window.Events;
import org.nlogo.workspace.AbstractWorkspace;
import org.nlogo.workspace.AbstractWorkspaceScala;
import org.nlogo.workspace.ModelTracker;
import org.nlogo.workspace.ModelsLibrary$;
import org.nlogo.workspace.OpenModel;
import org.nlogo.workspace.OpenModelFromURI$;
import org.nlogo.workspace.SaveModel;
import org.nlogo.workspace.SaveModel$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Try;

public class ModelCodeTab
extends CodeTab
implements Events.ModelSavedEvent$.Handler {
    private final TabManager tabManager;
    private final ModelManager modelManager;
    private final String tabName;
    private final String filePath;
    private String modelSource;
    private Option<Model> currentModel;
    private boolean isDirty;
    private final String originalModelSource;

    public ModelCodeTab(AbstractWorkspaceScala workspace, TabManager tabManager, ModelManager modelManager) {
        BoxedUnit boxedUnit;
        this.tabManager = tabManager;
        this.modelManager = modelManager;
        super((AbstractWorkspace)workspace, (TabsInterface)tabManager);
        this.tabName = workspace.getModelFileName();
        this.filePath = workspace.getModelPath();
        this.modelSource = "";
        this.currentModel = Option$.MODULE$.empty();
        NLogoAnyLoader loader = FileFormat$.MODULE$.standardAnyLoader(false, (LiteralParser)workspace.compiler().utilities(), FileFormat$.MODULE$.standardAnyLoader$default$3());
        OpenModel.Controller controller = new OpenModel.Controller(){

            public void errorOpeningURI(URI uri, Exception exception) {
                throw new ExtensionException("Levelspace encountered an error while opening: " + Paths.get(uri).toString() + ". " + exception.toString());
            }

            public void invalidModel(URI uri) {
                throw new ExtensionException("Levelspace couldn't open: " + Paths.get(uri).toString());
            }

            public void invalidModelVersion(URI uri, String version) {
                throw new ExtensionException("Levelspace couldn't open invalid NetLogo model: " + Paths.get(uri).toString());
            }

            public Option errorAutoconvertingModel(FailedConversionResult failure) {
                return None$.MODULE$;
            }

            public boolean shouldOpenModelOfDifferingArity(int arity, String version) {
                return false;
            }

            public boolean shouldOpenModelOfLegacyVersion(String version) {
                return true;
            }

            public boolean shouldOpenModelOfUnknownVersion(String version) {
                return true;
            }
        };
        OpenModelFromURI$.MODULE$.apply(Paths.get(this.filePath(), new String[0]).toUri(), controller, (AbstractModelLoader)loader, FileFormat$.MODULE$.defaultConverter(), (Version)Version$.MODULE$).foreach((Function1)(JProcedure1 & Serializable)model -> {
            this.currentModel_$eq((Option<Model>)Some$.MODULE$.apply(model));
            this.innerSource_$eq(model.code());
        });
        Object object = Predef$.MODULE$.refArrayOps((Object[])ModelsLibrary$.MODULE$.getModelPaths());
        if (ArrayOps$.MODULE$.contains$extension(object, (Object)this.filePath())) {
            ((JTextComponent)this.text()).setEditable(false);
            JOptionPane.showMessageDialog((Component)App$.MODULE$.app().frame(), "<html><p style='width: 400px;'>Because this is a models library model, you will not be able to make any changes to the code. If you wish to make changes, copy the file to a different location, update your parent model with the new location, and reopen the model.</p></html>", "Warning", 2);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
        this.isDirty = false;
        this.originalModelSource = this.modelSource();
    }

    public AbstractWorkspaceScala org$nlogo$ls$gui$ModelCodeTab$$workspace$accessor() {
        return (AbstractWorkspaceScala)super.workspace();
    }

    public String tabName() {
        return this.tabName;
    }

    public String filePath() {
        return this.filePath;
    }

    public String modelSource() {
        return this.modelSource;
    }

    public void modelSource_$eq(String x$1) {
        this.modelSource = x$1;
    }

    public Option<Model> currentModel() {
        return this.currentModel;
    }

    public void currentModel_$eq(Option<Model> x$1) {
        this.currentModel = x$1;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void isDirty_$eq(boolean x$1) {
        this.isDirty = x$1;
    }

    public void close() {
        try {
            if (this.dirty() && this.userWantsToSaveFile()) {
                this.save();
            }
            this.tabManager.removeTab((Component)((Object)this));
            this.modelManager.removeTab(this);
        }
        catch (UserCancelException userCancelException) {}
    }

    private boolean userWantsToSaveFile() {
        Object[] options = new String[]{I18N$.MODULE$.gui().get("common.buttons.save"), "Discard", I18N$.MODULE$.gui().get("common.buttons.cancel")};
        String message = "Do you want to save the changes you made to " + this.filePath() + "?";
        Object object = Predef$.MODULE$.refArrayOps(options);
        int n = new OptionPane((Component)((Object)this), I18N$.MODULE$.gui().get("common.messages.warning"), message, (Seq)ArrayOps$.MODULE$.toSeq$extension(object)).getSelectedIndex();
        if (0 == n) {
            return true;
        }
        if (1 == n) {
            return false;
        }
        throw new UserCancelException();
    }

    public String originalModelSource() {
        return this.originalModelSource;
    }

    public void handle(Events.ModelSavedEvent modelSavedEvent) {
        this.save();
    }

    public void save() {
        NLogoAnyLoader loader = FileFormat$.MODULE$.standardAnyLoader(false, (LiteralParser)this.org$nlogo$ls$gui$ModelCodeTab$$workspace$accessor().compiler().utilities(), FileFormat$.MODULE$.standardAnyLoader$default$3());
        SaveModel.Controller controller = new SaveModel.Controller(this){
            private final /* synthetic */ ModelCodeTab $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Option chooseFilePath(ModelType modelType) {
                return Some$.MODULE$.apply((Object)Paths.get(this.$outer.org$nlogo$ls$gui$ModelCodeTab$$workspace$accessor().getModelPath(), new String[0]).toUri());
            }

            public boolean shouldSaveModelOfDifferingVersion(String version) {
                return false;
            }

            public void warnInvalidFileFormat(String format) {
                throw new ExtensionException("Internal LevelSpace error: invalid file format: " + format);
            }
        };
        this.currentModel_$eq((Option<Model>)this.currentModel().map((Function1 & Serializable)_$1 -> _$1.copy(this.innerSource(), _$1.copy$default$2(), _$1.copy$default$3(), _$1.copy$default$4(), _$1.copy$default$5(), _$1.copy$default$6(), _$1.copy$default$7(), _$1.copy$default$8(), _$1.copy$default$9())).orElse(this::save$$anonfun$2));
        this.currentModel().foreach((Function1)(JProcedure1 & Serializable)model -> SaveModel$.MODULE$.apply(model, (AbstractModelLoader)loader, controller, (ModelTracker)this.org$nlogo$ls$gui$ModelCodeTab$$workspace$accessor(), (Version)Version$.MODULE$).foreach((Function1)(JProcedure1 & Serializable)_$2 -> ((Try)_$2.apply()).foreach((Function1)(JProcedure1 & Serializable)_$3 -> {
            this.changedSourceWarning();
            this.dirty_$eq(false);
        })));
    }

    public void changedSourceWarning() {
        String string = this.modelSource();
        String string2 = this.originalModelSource();
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.errorLabel().setVisible(true);
            this.errorLabel().setText("Warning: Changes made to this code will not affect models until they are reloaded");
            return;
        }
        this.errorLabel().setVisible(false);
    }

    private final Option save$$anonfun$2() {
        return Some$.MODULE$.apply((Object)Model$.MODULE$.apply(this.innerSource(), Model$.MODULE$.$lessinit$greater$default$2(), Model$.MODULE$.$lessinit$greater$default$3(), Model$.MODULE$.$lessinit$greater$default$4(), Model$.MODULE$.$lessinit$greater$default$5(), Model$.MODULE$.$lessinit$greater$default$6(), Model$.MODULE$.$lessinit$greater$default$7(), Model$.MODULE$.$lessinit$greater$default$8(), Model$.MODULE$.$lessinit$greater$default$9()));
    }
}

