/*
 * Decompiled with CFR 0.152.
 */
package org.json4s.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.json4s.JArray$;
import org.json4s.JBool$;
import org.json4s.JDecimal$;
import org.json4s.JDouble$;
import org.json4s.JInt$;
import org.json4s.JLong$;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject$;
import org.json4s.JString$;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import scala.collection.mutable.ListBuffer;
import scala.package$;

public class JValueDeserializer
extends JsonDeserializer<Object> {
    private final Class<?> klass;

    public JValueDeserializer(Class<?> klass) {
        this.klass = klass;
    }

    /*
     * WARNING - void declaration
     */
    public Object deserialize(JsonParser jp, DeserializationContext ctxt) {
        void var3_3;
        Object value = JValueDeserializer._deserialize$1(jp, ctxt);
        if (!this.klass.isAssignableFrom(value.getClass())) {
            ctxt.handleUnexpectedToken(this.klass, jp);
        }
        return var3_3;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getNullValue() {
        return JNull$.MODULE$;
    }

    public Object getEmptyValue() {
        return JNothing$.MODULE$;
    }

    private static final Object _deserialize$1(JsonParser jp, DeserializationContext ctxt) {
        Object object;
        block11: while (true) {
            if (jp.getCurrentToken() == null) {
                jp.nextToken();
            }
            int n = jp.getCurrentToken().id();
            switch (n) {
                case 11: {
                    object = JNull$.MODULE$;
                    break block11;
                }
                case 7: {
                    if (ctxt.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                        object = JInt$.MODULE$.apply(package$.MODULE$.BigInt().apply(jp.getText()));
                        break block11;
                    }
                    object = JLong$.MODULE$.apply(jp.getLongValue());
                    break block11;
                }
                case 8: {
                    if (ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        object = JDecimal$.MODULE$.apply(package$.MODULE$.BigDecimal().apply(jp.getDecimalValue()));
                        break block11;
                    }
                    object = JDouble$.MODULE$.apply(jp.getDoubleValue());
                    break block11;
                }
                case 6: {
                    object = JString$.MODULE$.apply(jp.getText());
                    break block11;
                }
                case 9: {
                    object = JBool$.MODULE$.True();
                    break block11;
                }
                case 10: {
                    object = JBool$.MODULE$.False();
                    break block11;
                }
                case 3: {
                    ListBuffer values = new ListBuffer();
                    jp.nextToken();
                    while (true) {
                        JsonToken jsonToken = jp.getCurrentToken();
                        JsonToken jsonToken2 = JsonToken.END_ARRAY;
                        if (!(jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2))) break;
                        values.$plus$eq((Object)((JValue)JValueDeserializer._deserialize$1(jp, ctxt)));
                        jp.nextToken();
                    }
                    object = JArray$.MODULE$.apply(values.toList());
                    break block11;
                }
                case 1: {
                    jp.nextToken();
                    continue block11;
                }
                case 2: 
                case 5: {
                    ListBuffer fields = new ListBuffer();
                    while (jp.getCurrentToken().id() != 2) {
                        String name = jp.getCurrentName();
                        jp.nextToken();
                        fields.$plus$eq((Object)JsonAST$.MODULE$.JField().apply(name, (JValue)JValueDeserializer._deserialize$1(jp, ctxt)));
                        jp.nextToken();
                    }
                    object = JObject$.MODULE$.apply(fields.toList());
                    break block11;
                }
                default: {
                    object = ctxt.handleUnexpectedToken(JValue.class, jp);
                    break block11;
                }
            }
            break;
        }
        return object;
    }
}

