/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import org.jcodec.codecs.wav.WavHeader;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.boxes.channel.Label;
import org.jcodec.movtool.streaming.AudioCodecMeta;
import org.jcodec.movtool.streaming.CodecMeta;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.ByteChannelPool;

public class WavTrack
implements VirtualTrack {
    public static final int FRAMES_PER_PKT = 1024;
    private ByteChannelPool pool;
    private WavHeader header;
    private AudioCodecMeta se;
    private int pktDataLen;
    private double pktDuration;
    private long offset;
    private double pts;
    private int frameNo;
    private long size;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WavTrack(ByteChannelPool pool, Label ... labels) throws IOException {
        this.pool = pool;
        SeekableByteChannel ch = null;
        try {
            ch = pool.getChannel();
            this.header = WavHeader.read(ch);
            this.size = this.header.dataSize <= 0L ? ch.size() : this.header.dataSize;
        }
        finally {
            ch.close();
        }
        this.se = new AudioCodecMeta("sowt", ByteBuffer.allocate(0), new AudioFormat(this.header.fmt.sampleRate, this.header.fmt.bitsPerSample >> 3, this.header.fmt.numChannels, true, false), true, labels);
        this.pktDataLen = 1024 * this.header.fmt.numChannels * (this.header.fmt.bitsPerSample >> 3);
        this.pktDuration = 1024.0 / (double)this.header.fmt.sampleRate;
        this.offset = this.header.dataOffset;
        this.pts = 0.0;
        this.frameNo = 0;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        if (this.offset >= this.size) {
            return null;
        }
        WavPacket pkt = new WavPacket(this.frameNo, this.pts, this.offset, (int)Math.min(this.size - this.offset, (long)this.pktDataLen));
        this.offset += (long)this.pktDataLen;
        this.frameNo += 1024;
        this.pts = (double)this.frameNo / (double)this.header.fmt.sampleRate;
        return pkt;
    }

    @Override
    public CodecMeta getCodecMeta() {
        return this.se;
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return this.header.fmt.sampleRate;
    }

    @Override
    public void close() throws IOException {
        this.pool.close();
    }

    public class WavPacket
    implements VirtualPacket {
        private int frameNo;
        private double pts;
        private long offset;
        private int dataLen;

        public WavPacket(int frameNo, double pts, long offset, int dataLen) {
            this.frameNo = frameNo;
            this.pts = pts;
            this.offset = offset;
            this.dataLen = dataLen;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer getData() throws IOException {
            Channel ch = null;
            try {
                ch = WavTrack.this.pool.getChannel();
                ch.position(this.offset);
                ByteBuffer buffer = ByteBuffer.allocate(this.dataLen);
                NIOUtils.read((ReadableByteChannel)ch, buffer);
                buffer.flip();
                ByteBuffer byteBuffer = buffer;
                return byteBuffer;
            }
            finally {
                ch.close();
            }
        }

        @Override
        public int getDataLen() throws IOException {
            return this.dataLen;
        }

        @Override
        public double getPts() {
            return this.pts;
        }

        @Override
        public double getDuration() {
            return WavTrack.this.pktDuration;
        }

        @Override
        public boolean isKeyframe() {
            return true;
        }

        @Override
        public int getFrameNo() {
            return this.frameNo;
        }
    }
}

