/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.languagelibrary.config;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Insets;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.languagelibrary.config.ConfigProperty;
import org.nlogo.languagelibrary.config.Constraints$;
import org.nlogo.swing.Button;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextField$;
import org.nlogo.theme.InterfaceColors$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class FileProperty
implements ConfigProperty {
    private final String key;
    private final String fileName;
    private JDialog parent;
    private final JLabel messageLabel;
    private final JLabel pathLabel;
    private final TextField pathTextField;
    private final Button browseButton;

    public FileProperty(String key, String fileName, String initialValue, String message) {
        this.key = key;
        this.fileName = fileName;
        this.parent = null;
        this.messageLabel = new JLabel(message);
        this.pathLabel = new JLabel(fileName + " Path");
        this.pathTextField = new TextField(20, initialValue, TextField$.MODULE$.$lessinit$greater$default$3());
        this.browseButton = new Button("Browse...", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option<String> userSelected = this.askForPath(this.pathLabel.getText(), this.pathTextField.getText());
            userSelected.foreach((Function1)(JProcedure1 & Serializable)x$0 -> this.pathTextField.setText(x$0));
        });
    }

    @Override
    public String key() {
        return this.key;
    }

    public String fileName() {
        return this.fileName;
    }

    @Override
    public String value() {
        return this.pathTextField.getText();
    }

    @Override
    public void addToPanel(JDialog parent, JPanel panel) {
        this.parent = parent;
        Integer n = Predef$.MODULE$.int2Integer(0);
        Integer n2 = Predef$.MODULE$.int2Integer(3);
        Integer n3 = Constraints$.MODULE$.apply$default$2();
        Integer n4 = Constraints$.MODULE$.apply$default$4();
        double d = Constraints$.MODULE$.apply$default$5();
        double d2 = Constraints$.MODULE$.apply$default$6();
        Integer n5 = Constraints$.MODULE$.apply$default$7();
        Integer n6 = Constraints$.MODULE$.apply$default$8();
        Insets insets = Constraints$.MODULE$.apply$default$9();
        Integer n7 = Constraints$.MODULE$.apply$default$10();
        Integer n8 = Constraints$.MODULE$.apply$default$11();
        panel.add((Component)this.messageLabel, Constraints$.MODULE$.apply(n, n3, n2, n4, d, d2, n5, n6, insets, n7, n8));
        panel.add((Component)this.pathLabel, Constraints$.MODULE$.apply(Predef$.MODULE$.int2Integer(0), Constraints$.MODULE$.apply$default$2(), Constraints$.MODULE$.apply$default$3(), Constraints$.MODULE$.apply$default$4(), Constraints$.MODULE$.apply$default$5(), Constraints$.MODULE$.apply$default$6(), Constraints$.MODULE$.apply$default$7(), Constraints$.MODULE$.apply$default$8(), Constraints$.MODULE$.apply$default$9(), Constraints$.MODULE$.apply$default$10(), Constraints$.MODULE$.apply$default$11()));
        Integer n9 = Predef$.MODULE$.int2Integer(1);
        Integer n10 = Predef$.MODULE$.int2Integer(2);
        Integer n11 = Constraints$.MODULE$.apply$default$2();
        Integer n12 = Constraints$.MODULE$.apply$default$3();
        Integer n13 = Constraints$.MODULE$.apply$default$4();
        double d3 = Constraints$.MODULE$.apply$default$6();
        Integer n14 = Constraints$.MODULE$.apply$default$7();
        Insets insets2 = Constraints$.MODULE$.apply$default$9();
        Integer n15 = Constraints$.MODULE$.apply$default$10();
        Integer n16 = Constraints$.MODULE$.apply$default$11();
        panel.add((Component)this.pathTextField, Constraints$.MODULE$.apply(n9, n11, n12, n13, 1.0, d3, n14, n10, insets2, n15, n16));
        panel.add((Component)this.browseButton, Constraints$.MODULE$.apply(Predef$.MODULE$.int2Integer(2), Constraints$.MODULE$.apply$default$2(), Constraints$.MODULE$.apply$default$3(), Constraints$.MODULE$.apply$default$4(), Constraints$.MODULE$.apply$default$5(), Constraints$.MODULE$.apply$default$6(), Constraints$.MODULE$.apply$default$7(), Constraints$.MODULE$.apply$default$8(), Constraints$.MODULE$.apply$default$9(), Constraints$.MODULE$.apply$default$10(), Constraints$.MODULE$.apply$default$11()));
    }

    private Option<String> askForPath(String name, String current) {
        FileDialog dialog = new FileDialog((Dialog)this.parent, "Configure " + name, 0);
        dialog.setDirectory(new File(current).getParent());
        dialog.setFile(new File(current).getName());
        dialog.setVisible(true);
        String file = dialog.getFile();
        if (file != null) {
            String path = Paths.get(dialog.getDirectory(), file).toString();
            return Some$.MODULE$.apply((Object)path);
        }
        return None$.MODULE$;
    }

    public void syncTheme() {
        this.messageLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.pathLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.pathTextField.syncTheme();
        this.browseButton.syncTheme();
    }
}

