/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.asciigrid;

import java.awt.Dimension;
import java.awt.image.DataBuffer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.locationtech.jts.geom.Envelope;
import org.myworldgis.io.asciigrid.AsciiGridConstants;

public final class AsciiGridFileWriter
implements AsciiGridConstants {
    private PrintWriter _out;
    private int _columnCount;
    private String _nanString;

    public AsciiGridFileWriter(Writer out) throws IOException {
        this._out = new PrintWriter(out);
    }

    public void writeGridInfo(Dimension size, Envelope envelope, double nanValue) {
        this._columnCount = size.width;
        this._out.print("NCOLS");
        this._out.print(" ");
        this._out.print(Integer.toString(this._columnCount));
        this._out.println();
        this._out.print("NROWS");
        this._out.print(" ");
        this._out.print(Integer.toString(size.height));
        this._out.println();
        this._out.print("XLLCORNER");
        this._out.print(" ");
        this._out.print(DIMENSION_FORMAT.format(envelope.getMinX()));
        this._out.println();
        this._out.print("YLLCORNER");
        this._out.print(" ");
        this._out.print(DIMENSION_FORMAT.format(envelope.getMinY()));
        this._out.println();
        double cellWidth = envelope.getWidth() / (double)size.width;
        double cellHeight = envelope.getHeight() / (double)size.height;
        this._out.print("CELLSIZE");
        this._out.print(" ");
        this._out.print(DIMENSION_FORMAT.format(StrictMath.min(cellWidth, cellHeight)));
        this._out.println();
        this._nanString = Double.isNaN(nanValue) ? "NaN" : VALUE_FORMAT.format(nanValue);
        this._out.print("NODATA_VALUE");
        this._out.print(" ");
        this._out.print(this._nanString);
        this._out.println();
    }

    public void writeGridData(DataBuffer data) throws IOException {
        int i = 0;
        int column = 0;
        while (i < data.getSize()) {
            double value;
            if (column == this._columnCount) {
                this._out.println();
                column = 0;
            }
            if (Double.isNaN(value = data.getElemDouble(i))) {
                this._out.print(this._nanString);
            } else {
                this._out.print(VALUE_FORMAT.format(value));
            }
            this._out.print(" ");
            ++i;
            ++column;
        }
    }

    public void close() {
        this._out.close();
        this._out = null;
    }
}

