/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.geojson;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.myworldgis.io.geojson.GeoJsonConstants;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;

public class GeoJsonWriter
implements GeoJsonConstants {
    private RandomAccessFile file;
    private VectorDataset dataset;
    private JSONObject root;
    private JSONArray features;

    public GeoJsonWriter(RandomAccessFile file, VectorDataset dataset) throws IOException {
        this.file = file;
        this.dataset = dataset;
        this.root = new JSONObject();
        this.features = new JSONArray();
        this.setupJsonObject();
        this.processVectorFeatures();
        this.writeToFile();
    }

    private void setupJsonObject() {
        this.root.put((Object)"type", (Object)"FeatureCollection");
    }

    private void processVectorFeatures() throws IOException {
        VectorDataset.Property[] propSchema = this.dataset.getProperties();
        for (VectorFeature f : this.dataset.getFeatures()) {
            JSONObject thisFeatureJson = new JSONObject();
            thisFeatureJson.put((Object)"type", (Object)"Feature");
            thisFeatureJson.put((Object)"geometry", (Object)this.createGeometryObject(f.getGeometry()));
            thisFeatureJson.put((Object)"properties", (Object)this.createPropertiesObject(f, propSchema));
            this.features.add((Object)thisFeatureJson);
        }
    }

    private JSONObject createPropertiesObject(VectorFeature f, VectorDataset.Property[] propSchema) {
        JSONObject props = new JSONObject();
        for (VectorDataset.Property prop : propSchema) {
            String propName = prop.getName();
            props.put((Object)propName, f.getProperty(propName));
        }
        return props;
    }

    private void writeToFile() throws IOException {
        this.root.put((Object)"features", (Object)this.features);
        this.file.setLength(0L);
        this.file.writeBytes(this.root.toJSONString());
    }

    private JSONObject createGeometryObject(Geometry geom) {
        if (geom instanceof Point) {
            return this.createGeometryObject((Point)geom);
        }
        if (geom instanceof MultiPoint) {
            return this.createGeometryObject((MultiPoint)geom);
        }
        if (geom instanceof LineString) {
            return this.createGeometryObject((LineString)geom);
        }
        if (geom instanceof MultiLineString) {
            return this.createGeometryObject((MultiLineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.createGeometryObject((Polygon)geom);
        }
        if (geom instanceof MultiPolygon) {
            return this.createGeometryObject((MultiPolygon)geom);
        }
        return new JSONObject();
    }

    private JSONObject createGeometryObject(Point point) {
        JSONObject out = new JSONObject();
        out.put((Object)"type", (Object)"Point");
        out.put((Object)"coordinates", (Object)GeoJsonWriter.pointToJSONArray(point));
        return out;
    }

    private JSONObject createGeometryObject(MultiPoint multiPoint) {
        JSONObject out = new JSONObject();
        out.put((Object)"type", (Object)"MultiPoint");
        JSONArray coordsArray = new JSONArray();
        int numPoints = multiPoint.getNumGeometries();
        for (int i = 0; i < numPoints; ++i) {
            Point thisPoint = (Point)multiPoint.getGeometryN(i);
            coordsArray.add((Object)GeoJsonWriter.pointToJSONArray(thisPoint));
        }
        out.put((Object)"coordinates", (Object)coordsArray);
        return out;
    }

    private JSONObject createGeometryObject(LineString lineString) {
        JSONObject out = new JSONObject();
        out.put((Object)"type", (Object)"LineString");
        out.put((Object)"coordinates", (Object)GeoJsonWriter.lineStringToJSONArray(lineString));
        return out;
    }

    private JSONObject createGeometryObject(Polygon polygon) {
        JSONObject out = new JSONObject();
        out.put((Object)"type", (Object)"Polygon");
        out.put((Object)"coordinates", (Object)GeoJsonWriter.polygonToJSONArray(polygon));
        return out;
    }

    private JSONObject createGeometryObject(MultiPolygon multiPolygon) {
        JSONObject out = new JSONObject();
        out.put((Object)"type", (Object)"MultiPolygon");
        JSONArray coordsArray = new JSONArray();
        int numPolygons = multiPolygon.getNumGeometries();
        for (int i = 0; i < numPolygons; ++i) {
            Polygon thisPolygon = (Polygon)multiPolygon.getGeometryN(i);
            coordsArray.add((Object)GeoJsonWriter.polygonToJSONArray(thisPolygon));
        }
        out.put((Object)"coordinates", (Object)coordsArray);
        return out;
    }

    private JSONObject createGeometryObject(MultiLineString multiLineString) {
        JSONObject out = new JSONObject();
        out.put((Object)"type", (Object)"MultiLineString");
        JSONArray coordsArray = new JSONArray();
        int numLineStrings = multiLineString.getNumGeometries();
        for (int i = 0; i < numLineStrings; ++i) {
            LineString thisLineString = (LineString)multiLineString.getGeometryN(i);
            coordsArray.add((Object)GeoJsonWriter.lineStringToJSONArray(thisLineString));
        }
        out.put((Object)"coordinates", (Object)coordsArray);
        return out;
    }

    private static JSONArray coordToJSONArray(Coordinate coord) {
        JSONArray arr = new JSONArray();
        arr.add((Object)coord.x);
        arr.add((Object)coord.y);
        return arr;
    }

    private static JSONArray pointToJSONArray(Point p) {
        return GeoJsonWriter.coordToJSONArray(p.getCoordinate());
    }

    public static JSONArray lineStringToJSONArray(LineString lineString) {
        JSONArray arr = new JSONArray();
        int numPoints = lineString.getNumPoints();
        for (int i = 0; i < numPoints; ++i) {
            arr.add((Object)GeoJsonWriter.coordToJSONArray(lineString.getCoordinateN(i)));
        }
        return arr;
    }

    public static JSONArray polygonToJSONArray(Polygon poly) {
        JSONArray arr = new JSONArray();
        arr.add((Object)GeoJsonWriter.lineStringToJSONArray((LineString)poly.getExteriorRing()));
        int numInteriorRings = poly.getNumInteriorRing();
        for (int i = 0; i < numInteriorRings; ++i) {
            arr.add((Object)GeoJsonWriter.lineStringToJSONArray((LineString)poly.getInteriorRingN(i)));
        }
        return arr;
    }
}

