/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.myworldgis.io.shapefile.DBaseConstants;
import org.myworldgis.io.shapefile.DBaseFieldDescriptor;
import org.myworldgis.util.Buffer;

public final class DBaseBuffer
extends Buffer
implements DBaseConstants {
    private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final NumberFormat YEAR_FORMAT = new DecimalFormat("0000", SYMBOLS);
    private static final NumberFormat MONTH_DAY_FORMAT = new DecimalFormat("00", SYMBOLS);
    public static final NumberFormat FLOAT_FORMAT = new DecimalFormat("0.###########E000", SYMBOLS);
    public static final NumberFormat DECIMAL_FORMAT = new DecimalFormat("###################0.##################", SYMBOLS);
    private static final NumberFormat DECIMAL_PRINT_FORMAT = (NumberFormat)DECIMAL_FORMAT.clone();
    public static final double MAX_DECIMAL_VALUE = 9.99999999999E19;

    static String formatDatum(Object datum) {
        if (datum instanceof Integer || datum instanceof Long) {
            return DECIMAL_FORMAT.format(((Number)datum).longValue());
        }
        if (datum instanceof Float || datum instanceof Double) {
            return DECIMAL_FORMAT.format(((Number)datum).doubleValue());
        }
        return datum.toString();
    }

    public DBaseBuffer() {
        super(254, Buffer.ByteOrder.LITTLE_ENDIAN);
    }

    public Date getDate(int offset) throws IOException {
        String dateStr = this.getCString(offset, 8);
        if (dateStr.length() < 8) {
            return null;
        }
        int year = 1900;
        int month = 1;
        int day = 1;
        try {
            year = Integer.parseInt(dateStr.substring(0, 4));
            month = Integer.parseInt(dateStr.substring(4, 6));
            day = Integer.parseInt(dateStr.substring(6, 8));
        }
        catch (NumberFormatException e) {
            IOException ioe = new IOException("invalid date value");
            ioe.initCause(e);
            throw ioe;
        }
        return new Date(year, month, day);
    }

    public int putDate(int offset, Date date) {
        StringBuffer output = new StringBuffer();
        output.append(YEAR_FORMAT.format(date.getYear()));
        output.append(MONTH_DAY_FORMAT.format(date.getMonth()));
        output.append(MONTH_DAY_FORMAT.format(date.getDay()));
        this.putCString(offset, 8, output.toString());
        return 8;
    }

    public int putHeaderDate(int offset, Date date) {
        this.putByte(offset, (byte)(date.getYear() - 1900));
        this.putByte(offset + 1, (byte)date.getMonth());
        this.putByte(offset + 2, (byte)date.getDay());
        return 6;
    }

    public DBaseFieldDescriptor getFieldDescriptor(int offset) {
        return new DBaseFieldDescriptor(this.getChar(offset + 11), this.getCString(offset + 0, 11), this.getUnsignedByte(offset + 16), this.getUnsignedByte(offset + 17));
    }

    public int putFieldDescriptor(int offset, DBaseFieldDescriptor field) {
        this.putCString(offset + 0, 11, field.getName());
        this.putChar(offset + 11, field.getType());
        this.putUnsignedByte(offset + 16, (short)field.getLength());
        this.putUnsignedByte(offset + 17, (short)field.getDecimalCount());
        return 32;
    }

    public Object[] getRecord(int initialOffset, DBaseFieldDescriptor[] fields) throws IOException {
        Object[] result = new Object[fields.length];
        int offset = initialOffset + 1;
        for (int i = 0; i < fields.length; ++i) {
            result[i] = this.getFieldContents(offset, fields[i]);
            offset += fields[i].getLength();
        }
        return result;
    }

    public int putRecord(int initialOffset, DBaseFieldDescriptor[] fieldDescriptors, Object[] record) {
        int offset = initialOffset;
        offset += this.putChar(offset, ' ');
        for (int i = 0; i < fieldDescriptors.length; ++i) {
            offset += this.putFieldContents(offset, fieldDescriptors[i], record[i]);
        }
        return offset - initialOffset;
    }

    private Object getFieldContents(int offset, DBaseFieldDescriptor field) throws IOException {
        switch (field.getType()) {
            case 'C': {
                return this.getJustifiedString(offset, field.getLength());
            }
            case 'D': {
                Date date = this.getDate(offset);
                if (date != null) {
                    return YEAR_FORMAT.format(date.getYear()) + "-" + MONTH_DAY_FORMAT.format(date.getMonth()) + "-" + MONTH_DAY_FORMAT.format(date.getDay());
                }
                return "";
            }
            case 'N': {
                String nStr = this.getJustifiedString(offset, field.getLength());
                if (nStr.equals("")) {
                    return null;
                }
                try {
                    return DECIMAL_FORMAT.parse(nStr).doubleValue();
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case 'F': {
                String fStr = this.getJustifiedString(offset, field.getLength());
                if (fStr.equals("")) {
                    return null;
                }
                try {
                    return FLOAT_FORMAT.parse(fStr.replace('e', 'E').replaceAll("\\+", "")).doubleValue();
                }
                catch (ParseException e) {
                    return null;
                }
            }
            case 'L': {
                char c = this.getChar(offset);
                if ("yYtT".indexOf(c) != -1) {
                    return Boolean.TRUE;
                }
                if ("nNfF".indexOf(c) != -1) {
                    return Boolean.FALSE;
                }
                return null;
            }
            case 'M': {
                return null;
            }
        }
        return null;
    }

    private int putFieldContents(int offset, DBaseFieldDescriptor field, Object datum) {
        if (datum == null) {
            this.putJustifiedString(offset, field.getLength(), "", 2);
        } else {
            switch (field.getType()) {
                case 'C': {
                    this.putJustifiedString(offset, field.getLength(), DBaseBuffer.formatDatum(datum), 2);
                    break;
                }
                case 'D': {
                    this.putDate(offset, (Date)datum);
                    break;
                }
                case 'N': {
                    DECIMAL_PRINT_FORMAT.setMaximumFractionDigits(field.getDecimalCount());
                    DECIMAL_PRINT_FORMAT.setMinimumFractionDigits(field.getDecimalCount());
                    this.putJustifiedString(offset, field.getLength(), DECIMAL_PRINT_FORMAT.format((Number)datum), 4);
                    break;
                }
                case 'F': {
                    this.putJustifiedString(offset, field.getLength(), FLOAT_FORMAT.format((Number)datum), 4);
                    break;
                }
                case 'L': {
                    this.putChar(offset, datum.equals(Boolean.TRUE) ? (char)'T' : 'F');
                    break;
                }
                case 'M': {
                    throw new IllegalArgumentException("memo field not supported");
                }
                default: {
                    throw new IllegalArgumentException("invalid field type '" + field.getType() + "'");
                }
            }
        }
        return field.getLength();
    }
}

