/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.io.shapefile;

import java.io.IOException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.myworldgis.io.PointZWrapper;
import org.myworldgis.io.shapefile.ESRIShapeConstants;
import org.myworldgis.util.Buffer;
import org.myworldgis.util.JTSUtils;
import org.ngs.ngunits.UnitConverter;

public final class ESRIShapeBuffer
extends Buffer
implements ESRIShapeConstants {
    private UnitConverter _converter;
    private GeometryFactory _factory;

    public ESRIShapeBuffer(int size, UnitConverter converter, GeometryFactory factory) {
        super(size, Buffer.ByteOrder.LITTLE_ENDIAN);
        this._converter = converter;
        this._factory = factory;
    }

    public GeometryFactory getGeometryFactory() {
        return this._factory;
    }

    public void setGeometryFactory(GeometryFactory newFactory) {
        this._factory = newFactory;
    }

    public UnitConverter getUnitConverter() {
        return this._converter;
    }

    public void setUnitConverter(UnitConverter newConverter) {
        this._converter = newConverter;
    }

    public Envelope getBoundingBox(int offset) {
        double min_lon = this._converter.convert(this.getDouble(offset));
        double min_lat = this._converter.convert(this.getDouble(offset += 8));
        double max_lon = this._converter.convert(this.getDouble(offset += 8));
        double max_lat = this._converter.convert(this.getDouble(offset += 8));
        return new Envelope(min_lon, max_lon, min_lat, max_lat);
    }

    public int putBoundingBox(int offset, Envelope box) {
        int bytesWritten = 0;
        bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(box.getMinX()));
        bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(box.getMinY()));
        bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(box.getMaxX()));
        bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(box.getMaxY()));
        return bytesWritten;
    }

    public Geometry getESRIRecord(int offset) throws IOException {
        this.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        offset += 4;
        this.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
        int shapeType = this.getInt(offset += 4);
        offset += 4;
        switch (shapeType) {
            case 1: {
                return this.getESRIPointRecord(offset);
            }
            case 11: {
                return this.getESRIPointZRecord(offset);
            }
            case 5: {
                return this.getESRIPolygonRecord(offset);
            }
            case 15: {
                return this.getESRIPolygonZRecord(offset);
            }
            case 3: {
                return this.getESRIPolyLineRecord(offset);
            }
            case 13: {
                return this.getESRIPolyLineZRecord(offset);
            }
            case 8: {
                return this.getESRIMultiPointRecord(offset);
            }
            case 18: {
                return this.getESRIMultiPointZRecord(offset);
            }
        }
        throw new IOException("unsupported shape type");
    }

    public Point getESRIPointRecord(int offset) {
        double x = this._converter.convert(this.getDouble(offset));
        double y = this._converter.convert(this.getDouble(offset += 8));
        offset += 8;
        return this._factory.createPoint(new Coordinate(x, y));
    }

    public PointZWrapper getESRIPointZRecord(int offset) {
        double x = this._converter.convert(this.getDouble(offset));
        double y = this._converter.convert(this.getDouble(offset += 8));
        double z = this._converter.convert(this.getDouble(offset += 8));
        offset += 16;
        return new PointZWrapper(this._factory.createPoint(new Coordinate(x, y)), z);
    }

    public MultiPoint getESRIMultiPointRecord(int offset) {
        int nPoints = this.getInt(offset += 32);
        offset += 4;
        Coordinate[] coords = new Coordinate[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            double x = this._converter.convert(this.getDouble(offset));
            double y = this._converter.convert(this.getDouble(offset += 8));
            offset += 8;
            coords[i] = new Coordinate(x, y);
        }
        return this._factory.createMultiPointFromCoords(coords);
    }

    public MultiPoint getESRIMultiPointZRecord(int offset) {
        int nPoints = this.getInt(offset += 32);
        offset += 4;
        Coordinate[] coords = new Coordinate[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            double x = this._converter.convert(this.getDouble(offset));
            double y = this._converter.convert(this.getDouble(offset += 8));
            offset += 8;
            coords[i] = new Coordinate(x, y);
        }
        offset += 16;
        offset += 8 * nPoints;
        offset += 16;
        offset += 8 * nPoints;
        return this._factory.createMultiPointFromCoords(coords);
    }

    public MultiLineString getESRIPolyLineRecord(int offset) {
        int nParts = this.getInt(offset += 32);
        int nPoints = this.getInt(offset += 4);
        offset += 4;
        if (nParts == 0 || nPoints < 2) {
            return this._factory.createMultiLineString(null);
        }
        int[] offsets = new int[nParts];
        for (int i = 0; i < nParts; ++i) {
            offsets[i] = this.getInt(offset);
            offset += 4;
        }
        LineString[] parts = new LineString[nParts];
        int startIndex = offsets[0];
        for (int i = 0; i < nParts; ++i) {
            int endIndex = i == nParts - 1 ? nPoints : offsets[i + 1];
            Coordinate[] coords = new Coordinate[endIndex - startIndex];
            int coordIndex = 0;
            for (int currentIndex = startIndex; currentIndex < endIndex; ++currentIndex) {
                double x = this._converter.convert(this.getDouble(offset));
                double y = this._converter.convert(this.getDouble(offset += 8));
                offset += 8;
                coords[coordIndex++] = new Coordinate(x, y);
            }
            parts[i] = this._factory.createLineString(coords);
            startIndex = endIndex;
        }
        return this._factory.createMultiLineString(parts);
    }

    public MultiLineString getESRIPolyLineZRecord(int offset) {
        int nParts = this.getInt(offset += 32);
        int nPoints = this.getInt(offset += 4);
        offset += 4;
        if (nParts == 0 || nPoints < 2) {
            return this._factory.createMultiLineString(null);
        }
        int[] offsets = new int[nParts];
        for (int i = 0; i < nParts; ++i) {
            offsets[i] = this.getInt(offset);
            offset += 4;
        }
        LineString[] parts = new LineString[nParts];
        int startIndex = offsets[0];
        for (int i = 0; i < nParts; ++i) {
            int endIndex = i == nParts - 1 ? nPoints : offsets[i + 1];
            Coordinate[] coords = new Coordinate[endIndex - startIndex];
            int coordIndex = 0;
            for (int currentIndex = startIndex; currentIndex < endIndex; ++currentIndex) {
                double x = this._converter.convert(this.getDouble(offset));
                double y = this._converter.convert(this.getDouble(offset += 8));
                offset += 8;
                coords[coordIndex++] = new Coordinate(x, y);
            }
            parts[i] = this._factory.createLineString(coords);
            startIndex = endIndex;
        }
        offset += 16;
        offset += 8 * nPoints;
        offset += 16;
        offset += 8 * nPoints;
        return this._factory.createMultiLineString(parts);
    }

    public MultiPolygon getESRIPolygonRecord(int offset) {
        int nParts = this.getInt(offset += 32);
        int nPoints = this.getInt(offset += 4);
        offset += 4;
        if (nParts == 0 || nPoints < 3) {
            return this._factory.createMultiPolygon(null);
        }
        int[] offsets = new int[nParts];
        for (int i = 0; i < nParts; ++i) {
            offsets[i] = this.getInt(offset);
            offset += 4;
        }
        LinearRing[] parts = new LinearRing[nParts];
        int startIndex = offsets[0];
        for (int i = 0; i < nParts; ++i) {
            int endIndex = i == nParts - 1 ? nPoints : offsets[i + 1];
            Coordinate[] coords = new Coordinate[endIndex - startIndex];
            int coordIndex = 0;
            for (int currentIndex = startIndex; currentIndex < endIndex; ++currentIndex) {
                double x = this._converter.convert(this.getDouble(offset));
                double y = this._converter.convert(this.getDouble(offset += 8));
                offset += 8;
                coords[coordIndex++] = new Coordinate(x, y);
            }
            parts[i] = this._factory.createLinearRing(coords);
            startIndex = endIndex;
        }
        return JTSUtils.buildPolygonGeometry(parts, this._factory, true);
    }

    public MultiPolygon getESRIPolygonZRecord(int offset) {
        int nParts = this.getInt(offset += 32);
        int nPoints = this.getInt(offset += 4);
        offset += 4;
        if (nParts == 0 || nPoints < 3) {
            return this._factory.createMultiPolygon(null);
        }
        int[] offsets = new int[nParts];
        for (int i = 0; i < nParts; ++i) {
            offsets[i] = this.getInt(offset);
            offset += 4;
        }
        LinearRing[] parts = new LinearRing[nParts];
        int startIndex = offsets[0];
        for (int i = 0; i < nParts; ++i) {
            int endIndex = i == nParts - 1 ? nPoints : offsets[i + 1];
            Coordinate[] coords = new Coordinate[endIndex - startIndex];
            int coordIndex = 0;
            for (int currentIndex = startIndex; currentIndex < endIndex; ++currentIndex) {
                double x = this._converter.convert(this.getDouble(offset));
                double y = this._converter.convert(this.getDouble(offset += 8));
                offset += 8;
                coords[coordIndex++] = new Coordinate(x, y);
            }
            parts[i] = this._factory.createLinearRing(coords);
            startIndex = endIndex;
        }
        offset += 16;
        offset += 8 * nPoints;
        offset += 16;
        offset += 8 * nPoints;
        return JTSUtils.buildPolygonGeometry(parts, this._factory, true);
    }

    public int putESRIRecord(int offset, Geometry shape, int shapeType, int index) {
        switch (shapeType) {
            case 1: {
                return this.putESRIPointRecord(offset, (Point)shape, index + 1);
            }
            case 3: {
                return this.putESRIPolyLineRecord(offset, (MultiLineString)shape, index + 1);
            }
            case 5: {
                return this.putESRIPolygonRecord(offset, (MultiPolygon)shape, index + 1);
            }
            case 8: {
                return this.putESRIMultiPointRecord(offset, (MultiPoint)shape, index + 1);
            }
        }
        throw new IllegalArgumentException("features of type '" + shape.getClass().getName() + "' can't be written to a ShapeFile");
    }

    public int putESRIPointRecord(int offset, Point shape, int index) {
        int bytesWritten = 0;
        this.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, index);
        bytesWritten += this.putInt(offset + bytesWritten, 10);
        this.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, 1);
        bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(shape.getX()));
        bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(shape.getY()));
        return bytesWritten;
    }

    public int putESRIMultiPointRecord(int offset, MultiPoint shape, int index) {
        int bytesWritten = 0;
        this.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, index);
        int recordLength = 20 + shape.getNumGeometries() * 8;
        this.ensureCapacity(recordLength * 2 + 8);
        bytesWritten += this.putInt(offset + bytesWritten, recordLength);
        this.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, 8);
        bytesWritten += this.putBoundingBox(offset + bytesWritten, shape.getEnvelopeInternal());
        bytesWritten += this.putInt(offset + bytesWritten, shape.getNumGeometries());
        for (int i = 0; i < shape.getNumGeometries(); ++i) {
            Point pt = (Point)shape.getGeometryN(i);
            bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(pt.getX()));
            bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(pt.getY()));
        }
        return bytesWritten;
    }

    public int putESRIPolyLineRecord(int offset, MultiLineString shape, int index) {
        int i;
        int bytesWritten = 0;
        this.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, index);
        int segmentCount = shape.getNumGeometries();
        int pointCount = shape.getNumPoints();
        int recordLength = 22 + segmentCount * 2 + pointCount * 8;
        this.ensureCapacity(recordLength * 2 + 8);
        bytesWritten += this.putInt(offset + bytesWritten, recordLength);
        this.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, 3);
        bytesWritten += this.putBoundingBox(offset + bytesWritten, shape.getEnvelopeInternal());
        bytesWritten += this.putInt(offset + bytesWritten, segmentCount);
        bytesWritten += this.putInt(offset + bytesWritten, pointCount);
        int segmentOffset = 0;
        for (i = 0; i < segmentCount; ++i) {
            bytesWritten += this.putInt(offset + bytesWritten, segmentOffset);
            segmentOffset += shape.getGeometryN(i).getNumPoints();
        }
        for (i = 0; i < segmentCount; ++i) {
            LineString ls = (LineString)shape.getGeometryN(i);
            for (int j = 0; j < ls.getNumPoints(); ++j) {
                Point pt = ls.getPointN(j);
                bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(pt.getX()));
                bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(pt.getY()));
            }
        }
        return bytesWritten;
    }

    public int putESRIPolygonRecord(int offset, MultiPolygon shape, int index) {
        int i;
        int bytesWritten = 0;
        this.setByteOrder(Buffer.ByteOrder.BIG_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, index);
        GeometryCollection processedShape = JTSUtils.explodeMultiPolygon(shape);
        int ringCount = processedShape.getNumGeometries();
        int pointCount = processedShape.getNumPoints();
        int recordLength = 22 + ringCount * 2 + pointCount * 8;
        this.ensureCapacity(recordLength * 2 + 8);
        bytesWritten += this.putInt(offset + bytesWritten, recordLength);
        this.setByteOrder(Buffer.ByteOrder.LITTLE_ENDIAN);
        bytesWritten += this.putInt(offset + bytesWritten, 5);
        bytesWritten += this.putBoundingBox(offset + bytesWritten, shape.getEnvelopeInternal());
        bytesWritten += this.putInt(offset + bytesWritten, ringCount);
        bytesWritten += this.putInt(offset + bytesWritten, pointCount);
        int ringOffset = 0;
        for (i = 0; i < ringCount; ++i) {
            bytesWritten += this.putInt(offset + bytesWritten, ringOffset);
            ringOffset += processedShape.getGeometryN(i).getNumPoints();
        }
        for (i = 0; i < ringCount; ++i) {
            LinearRing lr = (LinearRing)processedShape.getGeometryN(i);
            for (int j = 0; j < lr.getNumPoints(); ++j) {
                Point pt = lr.getPointN(j);
                bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(pt.getX()));
                bytesWritten += this.putDouble(offset + bytesWritten, this._converter.convert(pt.getY()));
            }
        }
        return bytesWritten;
    }
}

