/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.myworldgis.util.RangeColorModel;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.Dump;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.World;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public abstract class Painting
extends GISExtension.Command {
    static AffineTransform getTransform(World world, double drawingWidth, double drawingHeight) throws ExtensionException {
        double worldCenterX = (double)world.minPxcor() + (double)world.worldWidth() * 0.5;
        double worldCenterY = (double)world.minPycor() + (double)world.worldHeight() * 0.5;
        double sx = drawingWidth / (double)world.worldWidth();
        double sy = drawingHeight / (double)world.worldHeight();
        double tx = StrictMath.ceil(drawingWidth * 0.5) + sx * 0.5;
        double ty = StrictMath.ceil(drawingHeight * 0.5) - sy * 0.5;
        AffineTransform result = AffineTransform.getTranslateInstance(tx, ty);
        result.scale(sx, -sy);
        result.translate(-worldCenterX, -worldCenterY);
        result.concatenate(GISExtension.getState().getTransformation().getGISToNetLogoTransform());
        return result;
    }

    static Shape toShape(Geometry geom, float pointRadius) {
        GeneralPath result;
        block8: {
            block7: {
                result = new GeneralPath(1);
                if (!(geom instanceof Point)) break block7;
                Coordinate c = ((Point)geom).getCoordinate();
                if (c == null) break block8;
                result.append(new Ellipse2D.Double(c.x - (double)pointRadius, c.y - (double)pointRadius, pointRadius * 2.0f, pointRadius * 2.0f), false);
                break block8;
            }
            if (geom instanceof LineString) {
                result.append(new LineStringPathIterator((LineString)geom), false);
            } else if (geom instanceof Polygon) {
                Polygon poly = (Polygon)geom;
                result.append(new LineStringPathIterator((LineString)poly.getExteriorRing()), false);
                for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                    result.append(new LineStringPathIterator((LineString)poly.getInteriorRingN(i)), false);
                }
            } else if (geom instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)geom;
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    result.append(Painting.toShape(gc.getGeometryN(i), pointRadius), false);
                }
            }
        }
        return result;
    }

    private static final class LineStringPathIterator
    implements PathIterator {
        private LineString _line;
        private int _position;

        public LineStringPathIterator(LineString ls) {
            this._line = ls;
            this._position = 0;
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this._position >= this._line.getNumPoints();
        }

        @Override
        public void next() {
            ++this._position;
        }

        @Override
        public int currentSegment(float[] coords) {
            Coordinate c = this._line.getCoordinateN(this._position);
            coords[0] = (float)c.x;
            coords[1] = (float)c.y;
            return this._position == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            Coordinate c = this._line.getCoordinateN(this._position);
            coords[0] = c.x;
            coords[1] = c.y;
            return this._position == 0 ? 0 : 1;
        }
    }

    public static final class PaintRaster
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "OTLP";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg = args[0].get();
            if (!(arg instanceof RasterDataset)) {
                throw new ExtensionException("not a RasterDataset: " + Dump.logoObject((Object)arg));
            }
            int transparency = args[1].getIntValue();
            if (transparency < 0 || transparency > 255) {
                throw new ExtensionException("transparency must be between 0 and 255");
            }
            BufferedImage drawing = context.getDrawing();
            Graphics2D g = (Graphics2D)drawing.getGraphics();
            g.setColor(GISExtension.getState().getColor());
            g.setTransform(Painting.getTransform(context.getAgent().world(), drawing.getWidth(), drawing.getHeight()));
            try {
                RasterDataset dataset = (RasterDataset)arg;
                BufferedImage bimg = new BufferedImage(new RangeColorModel(dataset.getRaster()), dataset.getRaster(), false, null);
                BufferedImage img = new BufferedImage(bimg.getWidth(), bimg.getHeight(), 2);
                Graphics2D gImg = img.createGraphics();
                try {
                    gImg.drawImage((Image)bimg, 0, 0, null);
                }
                finally {
                    gImg.dispose();
                }
                if (transparency > 0) {
                    int alpha = 255 - transparency;
                    int width = img.getWidth();
                    int height = img.getHeight();
                    BufferedImage tImg = new BufferedImage(width, height, 2);
                    gImg = tImg.createGraphics();
                    try {
                        gImg.drawRenderedImage(img, new AffineTransform());
                    }
                    finally {
                        gImg.dispose();
                    }
                    WritableRaster alphaRaster = tImg.getAlphaRaster();
                    int[] pixel = new int[]{alpha};
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            alphaRaster.setPixel(x, y, pixel);
                        }
                    }
                    img = tImg;
                }
                GridDimensions dimensions = dataset.getDimensions();
                AffineTransform xform = new AffineTransform(dimensions.getCellWidth(), 0.0, 0.0, -dimensions.getCellHeight(), dimensions.getLeft(), dimensions.getTop());
                g.drawRenderedImage(img, xform);
            }
            finally {
                g.dispose();
            }
        }
    }

    public static final class FillVector
    extends VectorCommand {
        @Override
        protected void paint(Geometry geom, Graphics2D g, double thickness) {
            AffineTransform t = g.getTransform();
            double unitsPerPixel = 1.0 / StrictMath.max(t.getScaleX(), t.getScaleY());
            float segmentRadius = (float)(unitsPerPixel * thickness);
            g.setStroke(new BasicStroke(segmentRadius, 0, 2));
            g.fill(Painting.toShape(geom, segmentRadius));
        }
    }

    public static final class DrawVector
    extends VectorCommand {
        @Override
        protected void paint(Geometry geom, Graphics2D g, double thickness) {
            AffineTransform t = g.getTransform();
            double unitsPerPixel = 1.0 / StrictMath.max(t.getScaleX(), t.getScaleY());
            float segmentRadius = (float)(unitsPerPixel * thickness);
            g.setStroke(new BasicStroke(segmentRadius, 0, 2));
            g.draw(Painting.toShape(geom, segmentRadius));
        }
    }

    private static abstract class VectorCommand
    extends GISExtension.Command {
        private VectorCommand() {
        }

        public String getAgentClassString() {
            return "OTLP";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.NumberType()});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            block6: {
                Object arg = args[0].get();
                double thickness = args[1].getDoubleValue();
                BufferedImage drawing = context.getDrawing();
                Graphics2D g = (Graphics2D)drawing.getGraphics();
                try {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(GISExtension.getState().getColor());
                    g.setTransform(Painting.getTransform(context.getAgent().world(), drawing.getWidth(), drawing.getHeight()));
                    if (arg instanceof VectorDataset) {
                        Iterator<VectorFeature> i = ((VectorDataset)arg).getFeatures().iterator();
                        while (i.hasNext()) {
                            this.paint(i.next().getGeometry(), g, thickness);
                        }
                        break block6;
                    }
                    if (arg instanceof VectorFeature) {
                        this.paint(((VectorFeature)arg).getGeometry(), g, thickness);
                        break block6;
                    }
                    throw new ExtensionException("not a VectorDataset or VectorFeature: " + arg);
                }
                finally {
                    g.dispose();
                }
            }
        }

        protected abstract void paint(Geometry var1, Graphics2D var2, double var3);
    }

    public static final class SetColor
    extends GISExtension.Command {
        public String getAgentClassString() {
            return "OTLP";
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType() | Syntax.ListType()});
        }

        @Override
        public void performInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            GISExtension.getState().setNetLogoColor(args[0].get());
        }
    }

    public static final class GetColor
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[0], (int)(Syntax.NumberType() | Syntax.ListType()));
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            return GISExtension.getState().getNetLogoColor();
        }
    }
}

