/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import java.text.ParseException;
import org.locationtech.jts.geom.Coordinate;
import org.myworldgis.projection.Cylindrical;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.myworldgis.util.GeometryUtils;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public final class Mercator
extends Cylindrical {
    public static final String WKT_NAME = "Mercator_1SP";
    public static final String CENTER_LON_PROPERTY = "central_meridian";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_origin";
    public static final String SCALE_FACTOR_PROPERTY = "scale_factor";
    private double _k0;
    private double _e;
    private double[] _subLat;
    private double _spq;

    public Mercator(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        this(ellipsoid, center, units, falseEasting, falseNorthing, 1.0);
    }

    public Mercator(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double scaleFactor) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this._k0 = scaleFactor;
        this._subLat = new double[4];
        this.computeParameters();
    }

    public Mercator(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._k0 = parameters.getDimensionlessParameter(SCALE_FACTOR_PROPERTY);
        this._subLat = new double[4];
        this.computeParameters();
    }

    public double getCenterScaleFactor() {
        return this._k0;
    }

    public void setCenterScaleFactor(double newScale) {
        if (newScale != this._k0) {
            this._k0 = newScale;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Mercator proj = (Mercator)obj;
            return StrictMath.abs(proj._k0 - this._k0) < 1.567855942887398E-7;
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)super.hashCode() * Math.round(this._k0 / 1.567855942887398E-7) % Integer.MAX_VALUE);
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        storage.x = this._k0 * this._a * GeometryUtils.wrap_longitude(lon - this._lambda0) * this._spq;
        double sinPhi = StrictMath.sin(lat);
        storage.y = sinPhi == 1.0 ? (lat > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : this._k0 * (this._a / 2.0 * StrictMath.log((1.0 + sinPhi) / (1.0 - sinPhi) * StrictMath.pow((1.0 - this._e * sinPhi) / (1.0 + this._e * sinPhi), this._e))) * this._spq;
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        storage.x = x / this._spq / (this._k0 * this._a) + this._lambda0;
        double t = StrictMath.pow(Math.E, -(y / this._spq / (this._k0 * this._a)));
        double chi = 1.5707963267948966 - 2.0 * StrictMath.atan(t);
        storage.y = chi + this._subLat[0] * StrictMath.sin(2.0 * chi) + this._subLat[1] * StrictMath.sin(4.0 * chi) + this._subLat[2] * StrictMath.sin(6.0 * chi) + this._subLat[3] * StrictMath.sin(8.0 * chi);
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._e = StrictMath.sqrt(this._e2);
        this._subLat[0] = this._e2 / 2.0 + 5.0 * this._e2 * this._e2 / 24.0 + this._e2 * this._e2 * this._e2 / 12.0 + 13.0 * this._e2 * this._e2 * this._e2 * this._e2 * 360.0;
        this._subLat[1] = 7.0 * this._e2 * this._e2 / 48.0 + 29.0 * this._e2 * this._e2 * this._e2 / 240.0 + 811.0 * this._e2 * this._e2 * this._e2 * this._e2 / 11520.0;
        this._subLat[2] = 7.0 * this._e2 * this._e2 * this._e2 / 120.0 + 81.0 * this._e2 * this._e2 * this._e2 * this._e2 / 1120.0;
        this._subLat[3] = 4279.0 * this._e2 * this._e2 * this._e2 * this._e2 / 161280.0;
        if (this._phi0 == 0.0) {
            this._spq = 1.0;
        } else {
            double sinPhi0 = StrictMath.sin(this._phi0);
            this._spq = StrictMath.cos(this._phi0) / StrictMath.sqrt(1.0 - this._e2 * sinPhi0 * sinPhi0);
        }
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        result.addDimensionlessParameter(SCALE_FACTOR_PROPERTY, this._k0);
        return result;
    }

    @Override
    public Object clone() {
        Mercator clone = (Mercator)super.clone();
        clone._subLat = (double[])this._subLat.clone();
        return clone;
    }
}

