/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final String RESERVED_URI_CHARS = ";/?:@&=+$,%#";
    private static final String UNRESERVED_URI_CHARS = "-_.!~*'()";

    public static boolean startsWithIgnoreCase(String str1, String str2) {
        if (str1.length() >= str2.length()) {
            return str1.regionMatches(true, 0, str2, 0, str2.length());
        }
        return false;
    }

    public static boolean endsWithIgnoreCase(String str1, String str2) {
        if (str1.length() >= str2.length()) {
            return str1.regionMatches(true, str1.length() - str2.length(), str2, 0, str2.length());
        }
        return false;
    }

    public static String stripNonAlphanumeric(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) continue;
            StringBuffer newString = new StringBuffer(string.length());
            for (int j = 0; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (!Character.isLetterOrDigit(c)) continue;
                newString.append(c);
            }
            return newString.toString();
        }
        return string;
    }

    public static boolean hasFileExtension(String fileName, String extension) {
        return fileName.length() >= extension.length() + 1 && fileName.charAt(fileName.length() - extension.length() - 1) == '.' && fileName.regionMatches(true, fileName.length() - extension.length(), extension, 0, extension.length());
    }

    public static String getFileExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0 && fileName.length() > dotIndex + 1) {
            return fileName.substring(dotIndex + 1);
        }
        return null;
    }

    public static String stripFileExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0 && fileName.length() > dotIndex + 1) {
            return fileName.substring(0, dotIndex);
        }
        return fileName;
    }

    public static String changeFileExtension(String fileName, String extension) {
        if (StringUtils.hasFileExtension(fileName, extension)) {
            return fileName;
        }
        return StringUtils.stripFileExtension(fileName) + "." + extension;
    }

    public static void writeDelimited(String string, char delimiter, Writer out) throws IOException {
        if (delimiter == '\"') {
            throw new IllegalArgumentException("cannot use double-quote char as delimiter");
        }
        if (string.indexOf(delimiter) >= 0) {
            out.write(34);
            if (string.indexOf(34) >= 0) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\"') {
                        out.write("\"\"");
                        continue;
                    }
                    out.write(c);
                }
            } else {
                out.write(string);
            }
            out.write(34);
        } else {
            out.write(string);
        }
    }

    public static String readDelimited(Reader in, char delimiter) throws IOException {
        if (delimiter == '\"') {
            throw new IllegalArgumentException("cannot use double-quote char as delimiter");
        }
        PushbackReader pIn = new PushbackReader(in);
        boolean escaped = false;
        StringBuilder builder = new StringBuilder();
        while (true) {
            int i;
            if ((i = pIn.read()) < 0) {
                if (builder.length() > 0) {
                    return builder.toString();
                }
                return null;
            }
            char c = (char)i;
            if (c == delimiter && !escaped) {
                return builder.toString();
            }
            if (c == '\"') {
                char next = (char)pIn.read();
                if (next == '\"') {
                    builder.append(c);
                    continue;
                }
                escaped = !escaped;
                pIn.unread(next);
                continue;
            }
            builder.append(c);
        }
    }

    public static String encodeURL(String in) {
        StringBuilder resultBuffer = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (Character.isLetterOrDigit(c) || RESERVED_URI_CHARS.indexOf(c) >= 0 || UNRESERVED_URI_CHARS.indexOf(c) >= 0) {
                resultBuffer.append(c);
                continue;
            }
            if (c == '%' && i < in.length() - 2 && StringUtils.isHexDigit(in.charAt(i + 1)) && StringUtils.isHexDigit(in.charAt(i + 2))) {
                resultBuffer.append(c);
                continue;
            }
            resultBuffer.append("%" + Integer.toHexString(c));
        }
        return resultBuffer.toString();
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= '\u00c0' && c <= '\u00c5' || c >= '\u00df' && c <= '\u00e4';
    }

    public static final class WildcardMatcher {
        private final Pattern _regEx;

        public WildcardMatcher(String pattern) {
            String[] splits = pattern.split("\\*", -1);
            CharSequence[] subpatterns = new String[splits.length];
            for (int i = 0; i < splits.length; ++i) {
                subpatterns[i] = "".equals(splits[i]) ? ".*" : Pattern.quote(splits[i]);
            }
            String newPattern = String.join((CharSequence)"", subpatterns);
            this._regEx = Pattern.compile(newPattern);
        }

        public boolean matches(String str) {
            Matcher m = this._regEx.matcher(str);
            return m.matches();
        }
    }
}

