/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.netlogo.VectorFeature;
import org.nlogo.agent.Agent;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentSet;
import org.nlogo.api.Color;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.LogoList;
import org.nlogo.core.Syntax;
import org.nlogo.nvm.Context;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.jdk.javaapi.CollectionConverters;

public class VectorFeaturesToTurtlesUtil {
    private static final Map<String, Double> COLOR_NAMES_TO_COLOR_NUMBERS;

    public static Syntax makeTurtleCreationCommandSyntax(Object[] syntaxTokens) {
        List list = CollectionConverters.asScala(Arrays.asList(syntaxTokens)).toList();
        return Syntax.commandSyntax((List)list, (Option)Option.empty(), (Option)Option.empty(), (String)"O---", (Option)Some.apply((Object)"-T--"), (boolean)false, (boolean)true);
    }

    public static void UpdatePropertyNameToTurtleVarMappingsWithManualAdditions(Map<String, Integer> propertyNameToTurtleVarIndexMappings, LogoList manualList, java.util.List<String> variableNamesList) throws ExtensionException {
        String improperSyntaxExceptionMessage = "The variable mapping must be of the form: [[\"property-name\" \"turtle-variable-name\"] [\"property-name\" \"turtle-variable-name\"] (etc.)]";
        for (Object pairing : manualList.javaIterable()) {
            if (!(pairing instanceof LogoList)) {
                throw new ExtensionException("The variable mapping must be of the form: [[\"property-name\" \"turtle-variable-name\"] [\"property-name\" \"turtle-variable-name\"] (etc.)]");
            }
            LogoList pairingList = (LogoList)pairing;
            if (pairingList.length() != 2) {
                throw new ExtensionException("The variable mapping must be of the form: [[\"property-name\" \"turtle-variable-name\"] [\"property-name\" \"turtle-variable-name\"] (etc.)]");
            }
            Object firstObj = pairingList.first();
            Object secondObj = pairingList.butFirst().first();
            if (!(firstObj instanceof String) || !(secondObj instanceof String)) {
                throw new ExtensionException("The variable mapping must be of the form: [[\"property-name\" \"turtle-variable-name\"] [\"property-name\" \"turtle-variable-name\"] (etc.)]");
            }
            String propertyName = ((String)firstObj).toUpperCase();
            String variableName = ((String)secondObj).toUpperCase();
            int index = variableNamesList.indexOf(variableName);
            if (index != -1) {
                propertyNameToTurtleVarIndexMappings.put(propertyName, index);
                continue;
            }
            throw new ExtensionException("There is no variable " + variableName + " defined. use turtles-own or <breeds>-own to define one.");
        }
    }

    public static Turtle CreateTurtleAtGISCoordinate(TreeAgentSet agentSet, Coordinate coordinate, World world, Context nvmContext) throws ExtensionException, AgentException {
        Turtle turtle = world.createTurtle((org.nlogo.agent.AgentSet)agentSet, nvmContext.job.random.nextInt(14), 0);
        Coordinate nlogoPosition = GISExtension.getState().gisToNetLogo(coordinate, null);
        if (nlogoPosition == null) {
            return null;
        }
        if (!world.wrappingAllowedInX() && nlogoPosition.x == world.maxPxcorBoxed() + 0.5) {
            nlogoPosition.x = Math.nextDown(nlogoPosition.x);
        }
        if (!world.wrappingAllowedInY() && nlogoPosition.y == world.maxPycorBoxed() + 0.5) {
            nlogoPosition.y = Math.nextDown(nlogoPosition.y);
        }
        turtle.setTurtleOrLinkVariable("XCOR", (Object)nlogoPosition.x);
        turtle.setTurtleOrLinkVariable("YCOR", (Object)nlogoPosition.y);
        agentSet.add((Agent)turtle);
        return turtle;
    }

    public static java.util.List<String> getVariableNamesListForBreed(World world, AgentSet agentSet) {
        int i;
        int allTurtlesVarCount = world.getVariablesArraySize((org.nlogo.api.Turtle)null, (AgentSet)world.turtles());
        int breedVarCount = world.getVariablesArraySize((org.nlogo.api.Turtle)null, agentSet);
        String[] variableNames = new String[breedVarCount];
        for (i = 0; i < allTurtlesVarCount; ++i) {
            variableNames[i] = world.turtlesOwnNameAt(i).toUpperCase();
        }
        for (i = allTurtlesVarCount; i < breedVarCount; ++i) {
            variableNames[i] = world.breedsOwnNameAt(agentSet, i).toUpperCase();
        }
        return Arrays.asList(variableNames);
    }

    public static Map<String, Integer> getAutomaticPropertyNameToTurtleVarIndexMappings(java.util.List<String> variableNamesList, VectorDataset.Property[] properties) {
        return VectorFeaturesToTurtlesUtil.getAutomaticPropertyNameToTurtleVarIndexMappings(variableNamesList, Arrays.stream(properties).map(VectorDataset.Property::getName).collect(Collectors.toList()));
    }

    public static Map<String, Integer> getAutomaticPropertyNameToTurtleVarIndexMappings(java.util.List<String> variableNamesList, java.util.List<String> propertyNamesList) {
        HashMap<String, Integer> propertyNameToTurtleVarIndex = new HashMap<String, Integer>();
        for (String propertyName : propertyNamesList) {
            int index = variableNamesList.indexOf(propertyName.toUpperCase().replace(' ', '-'));
            if (index == -1) continue;
            propertyNameToTurtleVarIndex.put(propertyName.toUpperCase(), index);
        }
        return propertyNameToTurtleVarIndex;
    }

    public static void setTurtleVariablesToVectorFeatureProperties(Turtle turtle, VectorFeature feature, Map<String, Integer> propertyNameToTurtleVarIndex) throws AgentException, ExtensionException {
        for (Map.Entry<String, Integer> entry : propertyNameToTurtleVarIndex.entrySet()) {
            World world = turtle.world();
            Integer variableIndex = entry.getValue();
            String variableName = entry.getKey();
            Object valueToSetTo = feature.getProperty(variableName);
            if (valueToSetTo == null || variableIndex.intValue() == world.turtlesOwnIndexOf("BREED") || variableIndex.intValue() == world.turtlesOwnIndexOf("XCOR") || variableIndex.intValue() == world.turtlesOwnIndexOf("YCOR")) continue;
            if ((variableIndex.intValue() == world.turtlesOwnIndexOf("COLOR") || variableIndex.intValue() == world.turtlesOwnIndexOf("LABEL-COLOR")) && valueToSetTo instanceof String) {
                String colorName = (String)valueToSetTo;
                if (COLOR_NAMES_TO_COLOR_NUMBERS.containsKey(colorName)) {
                    valueToSetTo = COLOR_NAMES_TO_COLOR_NUMBERS.get(colorName);
                } else {
                    throw new ExtensionException(colorName + " is not a supported color name. Only the default hues or netlogo color number representations are supported. see https://ccl.northwestern.edu/netlogo/docs/programming.html#colors for a list of default colors and a table of color number representations.");
                }
            }
            if (variableIndex.intValue() == world.turtlesOwnIndexOf("HIDDEN?") && valueToSetTo instanceof String) {
                String stringValue = (String)valueToSetTo;
                if (stringValue.equalsIgnoreCase("true") || Double.parseDouble(stringValue) == 1.0) {
                    valueToSetTo = true;
                } else if (stringValue.equalsIgnoreCase("false") || Double.parseDouble(stringValue) == 0.0) {
                    valueToSetTo = false;
                } else {
                    throw new ExtensionException(stringValue + " is not a supported boolean value. Only true/false or 0/1 are accepted");
                }
            }
            if (variableIndex.intValue() == world.turtlesOwnIndexOf("HIDDEN?") && valueToSetTo instanceof Number) {
                Double doubleValue = (Double)valueToSetTo;
                if (doubleValue == 1.0) {
                    valueToSetTo = true;
                } else if (doubleValue == 0.0) {
                    valueToSetTo = false;
                } else {
                    throw new ExtensionException(doubleValue.toString() + " is not a supported boolean value. Only true/false or 0/1 are accepted");
                }
            }
            turtle.setTurtleVariable(variableIndex.intValue(), valueToSetTo);
        }
    }

    static {
        HashMap<String, Double> tmpMap = new HashMap<String, Double>();
        for (int i = 0; i < Color.ColorNames().length; ++i) {
            tmpMap.put(Color.ColorNames()[i], Color.getColorNumberByIndex((int)i));
        }
        COLOR_NAMES_TO_COLOR_NUMBERS = Collections.unmodifiableMap(tmpMap);
    }
}

