/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import java.io.Serializable;
import scala.Function1;
import scala.collection.mutable.StringBuilder;
import scala.runtime.function.JProcedure1;

public class JavaxNetDebugBuilder {
    private final SSLDebugConfig c;

    public JavaxNetDebugBuilder(SSLDebugConfig c) {
        this.c = c;
    }

    public String build() {
        if (this.c.all()) {
            return "all";
        }
        return this.buildSSL(this.c);
    }

    public String buildSSL(SSLDebugConfig sslDebugConfig) {
        StringBuilder b = new StringBuilder();
        sslDebugConfig.record().map((Function1)(JProcedure1 & Serializable)r -> {
            b.append(" record");
            if (r.packet()) {
                b.append(" packet");
            }
            if (r.plaintext()) {
                b.append(" plaintext");
            }
        });
        sslDebugConfig.handshake().map((Function1)(JProcedure1 & Serializable)h -> {
            b.append(" handshake");
            if (h.data()) {
                b.append(" data");
            }
            if (h.verbose()) {
                b.append(" verbose");
            }
        });
        if (sslDebugConfig.keygen()) {
            b.append(" keygen");
        }
        if (sslDebugConfig.session()) {
            b.append(" session");
        }
        if (sslDebugConfig.defaultctx()) {
            b.append(" defaultctx");
        }
        if (sslDebugConfig.sslctx()) {
            b.append(" sslctx");
        }
        if (sslDebugConfig.sessioncache()) {
            b.append(" sessioncache");
        }
        if (sslDebugConfig.keymanager()) {
            b.append(" keymanager");
        }
        if (sslDebugConfig.trustmanager()) {
            b.append(" trustmanager");
        }
        if (sslDebugConfig.pluggability()) {
            b.append(" pluggability");
        }
        if (!b.isEmpty() || sslDebugConfig.ssl()) {
            b.append(" ssl");
        }
        return b.toString();
    }
}

