/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl.tracing;

import com.typesafe.sslconfig.ssl.SSLDebugConfig;
import com.typesafe.sslconfig.ssl.tracing.TraceLogger;
import com.typesafe.sslconfig.ssl.tracing.TracingSSLEngine;
import com.typesafe.sslconfig.ssl.tracing.TracingSSLServerSocketFactory;
import com.typesafe.sslconfig.ssl.tracing.TracingSSLSocketFactory;
import com.typesafe.sslconfig.util.LoggerFactory;
import java.io.Serializable;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class TracingSSLContextSpi
extends SSLContextSpi
implements TraceLogger {
    private final Function0<SSLContext> ctx;
    private final SSLDebugConfig debug;
    private final LoggerFactory loggerFactory;

    public TracingSSLContextSpi(Function0 ctx, SSLDebugConfig debug, LoggerFactory loggerFactory) {
        this.ctx = ctx;
        this.debug = debug;
        this.loggerFactory = loggerFactory;
    }

    @Override
    public boolean isLogEnabled(String methodName, Map<String, Object> parameters) {
        return this.debug.all() || this.debug.sslctx();
    }

    @Override
    public void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) {
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"keyManagers");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)keyManagers);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"trustManagers");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)trustManagers);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"secureRandom");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)secureRandom);
        this.tracer("init", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0)(JFunction0.mcV.sp & Serializable)() -> ((SSLContext)this.ctx.apply()).init(keyManagers, trustManagers, secureRandom), this.loggerFactory);
    }

    @Override
    public SSLSocketFactory engineGetSocketFactory() {
        return (SSLSocketFactory)this.tracer("getSocketFactory", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> new TracingSSLSocketFactory(((SSLContext)this.ctx.apply()).getSocketFactory(), this.debug, this.loggerFactory), this.loggerFactory);
    }

    @Override
    public SSLServerSocketFactory engineGetServerSocketFactory() {
        return (SSLServerSocketFactory)this.tracer("getServerSocketFactory", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> new TracingSSLServerSocketFactory(this::engineGetServerSocketFactory$$anonfun$2$$anonfun$1, this.debug, this.loggerFactory), this.loggerFactory);
    }

    @Override
    public SSLEngine engineCreateSSLEngine() {
        return (SSLEngine)this.tracer("createSSLEngine", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> {
            SSLEngine engine = ((SSLContext)this.ctx.apply()).createSSLEngine();
            return new TracingSSLEngine(() -> TracingSSLContextSpi.engineCreateSSLEngine$$anonfun$3$$anonfun$1(engine), this.debug, this.loggerFactory);
        }, this.loggerFactory);
    }

    @Override
    public SSLEngine engineCreateSSLEngine(String host, int port) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"host");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)host);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"port");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToInteger((int)port));
        return (SSLEngine)this.tracer("createSSLEngine", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (Function0 & Serializable)() -> {
            SSLEngine engine = ((SSLContext)this.ctx.apply()).createSSLEngine(host, port);
            return new TracingSSLEngine(() -> TracingSSLContextSpi.engineCreateSSLEngine$$anonfun$4$$anonfun$1(engine), this.debug, this.loggerFactory);
        }, this.loggerFactory);
    }

    @Override
    public SSLSessionContext engineGetServerSessionContext() {
        return (SSLSessionContext)this.tracer("getServerSessionContext", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLContext)this.ctx.apply()).getServerSessionContext(), this.loggerFactory);
    }

    @Override
    public SSLSessionContext engineGetClientSessionContext() {
        return (SSLSessionContext)this.tracer("getClientSessionContext", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function0 & Serializable)() -> ((SSLContext)this.ctx.apply()).getClientSessionContext(), this.loggerFactory);
    }

    private final SSLServerSocketFactory engineGetServerSocketFactory$$anonfun$2$$anonfun$1() {
        return ((SSLContext)this.ctx.apply()).getServerSocketFactory();
    }

    private static final SSLEngine engineCreateSSLEngine$$anonfun$3$$anonfun$1(SSLEngine engine$1) {
        return engine$1;
    }

    private static final SSLEngine engineCreateSSLEngine$$anonfun$4$$anonfun$1(SSLEngine engine$2) {
        return engine$2;
    }
}

