/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib.html;

import java.util.Iterator;
import java.util.WeakHashMap;
import org.jhotdraw.contrib.html.DisposableResourceHolder;
import org.jhotdraw.contrib.html.DisposableResourceManager;
import org.jhotdraw.contrib.html.ResourceDisposabilityStrategy;
import org.jhotdraw.contrib.html.ResourceManagerNotSetException;

public class StandardDisposableResourceManager
implements DisposableResourceManager {
    private WeakHashMap resources = new WeakHashMap();
    private ResourceDisposabilityStrategy strategy;

    public StandardDisposableResourceManager(ResourceDisposabilityStrategy resourceDisposabilityStrategy) {
        this.setStrategy(resourceDisposabilityStrategy);
        this.getStrategy().setManager(this);
    }

    public synchronized void registerResource(DisposableResourceHolder disposableResourceHolder) {
        this.resources.put(disposableResourceHolder, disposableResourceHolder);
    }

    public synchronized void unregisterResource(DisposableResourceHolder disposableResourceHolder) {
        this.resources.remove(disposableResourceHolder);
    }

    public Iterator getResources() {
        return this.resources.values().iterator();
    }

    public synchronized boolean managesResource(DisposableResourceHolder disposableResourceHolder) {
        return this.resources.containsValue(disposableResourceHolder);
    }

    public ResourceDisposabilityStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(ResourceDisposabilityStrategy resourceDisposabilityStrategy) {
        this.strategy = resourceDisposabilityStrategy;
    }

    public void startDisposing() throws ResourceManagerNotSetException {
        this.getStrategy().startDisposing();
    }

    public void stopDisposing(long l) {
        this.getStrategy().stopDisposing(l);
    }
}

