/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.languagelibrary;

import java.io.Serializable;
import org.json4s.AsJsonInput$;
import org.json4s.JArray;
import org.json4s.JBool;
import org.json4s.JDecimal;
import org.json4s.JDouble;
import org.json4s.JInt;
import org.json4s.JLong;
import org.json4s.JNothing$;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JObject$;
import org.json4s.JSet;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import org.json4s.JsonDSL$;
import org.json4s.JsonListAssoc$;
import org.json4s.jackson.JsonMethods$;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.Dump$;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Nobody$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class Convert {
    private final String extensionLongName;

    public Convert(String extensionLongName) {
        this.extensionLongName = extensionLongName;
    }

    public String extensionLongName() {
        return this.extensionLongName;
    }

    public JValue toJson(Object x2) {
        Object object = x2;
        if (object instanceof JValue) {
            JValue j = (JValue)object;
            return j;
        }
        if (object instanceof String) {
            String s = (String)object;
            return JsonAST$.MODULE$.JString().apply(s);
        }
        if (object instanceof LogoList) {
            LogoList l = (LogoList)object;
            return JsonDSL$.MODULE$.seq2jvalue((Iterable)l.map((Function1 & Serializable)x -> this.toJson(x)), Predef$.MODULE$.$conforms());
        }
        if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            if (Predef$.MODULE$.Boolean2boolean(b)) {
                return JsonAST$.MODULE$.JBool().True();
            }
            return JsonAST$.MODULE$.JBool().False();
        }
        if (Nobody$.MODULE$.equals(object)) {
            return JsonAST$.MODULE$.JNothing();
        }
        if (object instanceof Agent) {
            Agent agent2 = (Agent)object;
            return this.agentToJson(agent2, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))));
        }
        if (object instanceof AgentSet) {
            AgentSet set = (AgentSet)object;
            return JsonDSL$.MODULE$.seq2jvalue((Iterable)set.toLogoList().map((Function1 & Serializable)agent -> this.agentToJson((Agent)agent, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]))))), Predef$.MODULE$.$conforms());
        }
        Object iter = object;
        if (iter instanceof Iterable) {
            return JsonDSL$.MODULE$.seq2jvalue((Iterable)((Iterable)iter).map((Function1 & Serializable)x -> this.toJson(x)), Predef$.MODULE$.$conforms());
        }
        Object o = object;
        return JsonMethods$.MODULE$.parse((Object)Dump$.MODULE$.logoObject(o, true, false), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
    }

    public JValue agentToJson(Agent agent, Set<String> variableNamesFilter) {
        Set filter = (Set)variableNamesFilter.map((Function1 & Serializable)vn -> vn.toLowerCase());
        ObjectRef obj = ObjectRef.create((Object)JObject$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
        Object object = Predef$.MODULE$.refArrayOps(agent.variables());
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String name = agent.variableName(i);
            if (filter.isEmpty() || filter.contains((Object)name.toLowerCase())) {
                JValue jValue;
                Object object = agent.getVariable(i);
                if (object instanceof AgentSet) {
                    AgentSet set = (AgentSet)object;
                    jValue = this.toJson(set.printName());
                } else if (object instanceof Agent) {
                    Agent agent = (Agent)object;
                    jValue = this.toJson(agent.toString());
                } else if (object != null) {
                    Object other = object;
                    jValue = this.toJson(other);
                } else {
                    throw new MatchError(object);
                }
                JValue value = jValue;
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                obj$1.elem = JsonListAssoc$.MODULE$.$tilde$extension(JsonDSL$.MODULE$.jobject2assoc((JObject)obj$1.elem), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value));
                return;
            }
        });
        return (JObject)obj.elem;
    }

    public Object toNetLogo(JValue x2) {
        JValue jValue = x2;
        JNothing$ jNothing$ = JsonAST$.MODULE$.JNothing();
        JValue jValue2 = jValue;
        if (!(jNothing$ != null ? !jNothing$.equals(jValue2) : jValue2 != null)) {
            return Nobody$.MODULE$;
        }
        JNull$ jNull$ = JsonAST$.MODULE$.JNull();
        JValue jValue3 = jValue;
        if (!(jNull$ != null ? !jNull$.equals(jValue3) : jValue3 != null)) {
            return Nobody$.MODULE$;
        }
        if (jValue instanceof JString) {
            String string;
            JString jString = JsonAST$.MODULE$.JString().unapply((JString)jValue);
            String s = string = jString._1();
            return s;
        }
        if (jValue instanceof JDouble) {
            double d;
            JDouble jDouble = JsonAST$.MODULE$.JDouble().unapply((JDouble)jValue);
            double num = d = jDouble._1();
            return Predef$.MODULE$.double2Double(this.ensureValidNum(num));
        }
        if (jValue instanceof JDecimal) {
            BigDecimal bigDecimal;
            JDecimal jDecimal = JsonAST$.MODULE$.JDecimal().unapply((JDecimal)jValue);
            BigDecimal num = bigDecimal = jDecimal._1();
            return Predef$.MODULE$.double2Double(this.ensureValidNum(num.toDouble()));
        }
        if (jValue instanceof JLong) {
            long l;
            JLong jLong = JsonAST$.MODULE$.JLong().unapply((JLong)jValue);
            long num = l = jLong._1();
            return Predef$.MODULE$.double2Double(this.ensureValidNum(num));
        }
        if (jValue instanceof JInt) {
            BigInt bigInt;
            JInt jInt = JsonAST$.MODULE$.JInt().unapply((JInt)jValue);
            BigInt num = bigInt = jInt._1();
            return Predef$.MODULE$.double2Double(this.ensureValidNum(num.toDouble()));
        }
        if (jValue instanceof JBool) {
            boolean bl;
            JBool jBool = JsonAST$.MODULE$.JBool().unapply((JBool)jValue);
            boolean value = bl = jBool._1();
            return Predef$.MODULE$.boolean2Boolean(value);
        }
        if (jValue instanceof JObject) {
            List list;
            JObject jObject = JsonAST$.MODULE$.JObject().unapply((JObject)jValue);
            List obj = list = jObject._1();
            return LogoList$.MODULE$.fromVector(obj.map((Function1 & Serializable)f -> LogoList$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{f._1(), this.toNetLogo((JValue)f._2())}))).toVector());
        }
        if (jValue instanceof JArray) {
            List list;
            JArray jArray = JsonAST$.MODULE$.JArray().unapply((JArray)jValue);
            List arr = list = jArray._1();
            return LogoList$.MODULE$.fromVector(arr.map((Function1 & Serializable)x -> this.toNetLogo((JValue)x)).toVector());
        }
        if (jValue instanceof JSet) {
            Set set;
            JSet jSet = JsonAST$.MODULE$.JSet().unapply((JSet)jValue);
            Set set2 = set = jSet._1();
            return LogoList$.MODULE$.fromVector(((IterableOnceOps)set2.map((Function1 & Serializable)x -> this.toNetLogo((JValue)x))).toVector());
        }
        throw new MatchError((Object)jValue);
    }

    private double ensureValidNum(double d) {
        double d2 = d;
        double x = d2;
        if (Predef$.MODULE$.double2Double(x).isInfinite()) {
            throw new ExtensionException(this.extensionLongName() + " reported a number too large for NetLogo.");
        }
        double x2 = d2;
        if (Predef$.MODULE$.double2Double(x2).isNaN()) {
            throw new ExtensionException(this.extensionLongName() + " reported a non-numeric value from a mathematical operation.");
        }
        double x3 = d2;
        return x3;
    }
}

