/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.languagelibrary;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json4s.AsJsonInput$;
import org.json4s.JInt;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import org.json4s.JsonAssoc$;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.Workspace;
import org.nlogo.languagelibrary.Convert;
import org.nlogo.languagelibrary.LineReader;
import org.nlogo.languagelibrary.Logger$;
import org.nlogo.languagelibrary.StreamGobbler;
import org.nlogo.languagelibrary.Subprocess$;
import org.nlogo.languagelibrary.Subprocess$Haltable$;
import org.nlogo.languagelibrary.Subprocess$HandleFailures$;
import org.nlogo.languagelibrary.Subprocess$InTypes$;
import org.nlogo.languagelibrary.Subprocess$OutTypes$;
import org.nlogo.languagelibrary.TargetLanguageErrorException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public class Subprocess {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Subprocess.class.getDeclaredField("HandleFailures$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Subprocess.class.getDeclaredField("Haltable$lzy1"));
    public final Process org$nlogo$languagelibrary$Subprocess$$proc;
    private final Socket socket;
    private final String extensionName;
    private final String extensionLongName;
    private final Option<JsonMethods> customMapper;
    private final AtomicBoolean shuttingDown;
    private final AtomicBoolean isRunningLegitJob;
    private final Convert convert;
    private final LineReader inReader;
    private final BufferedOutputStream out;
    private final StreamGobbler outGobbler;
    private final StreamGobbler errGobbler;
    private final ExecutorService executor;
    private volatile Object Haltable$lzy1;
    private volatile Object HandleFailures$lzy1;

    public static int convertibleTypesSyntax() {
        return Subprocess$.MODULE$.convertibleTypesSyntax();
    }

    public static Seq<File> path() {
        return Subprocess$.MODULE$.path();
    }

    public static Subprocess start(Workspace workspace, Seq<String> seq, Seq<String> seq2, String string, String string2, Option<Object> option, Option<JsonMethods> option2) {
        return Subprocess$.MODULE$.start(workspace, seq, seq2, string, string2, option, option2);
    }

    public static Option<Object> start$default$6() {
        return Subprocess$.MODULE$.start$default$6();
    }

    public static Option<JsonMethods> start$default$7() {
        return Subprocess$.MODULE$.start$default$7();
    }

    public Subprocess(Workspace ws, Process proc, Socket socket, String extensionName, String extensionLongName, Option<JsonMethods> customMapper) {
        this.org$nlogo$languagelibrary$Subprocess$$proc = proc;
        this.socket = socket;
        this.extensionName = extensionName;
        this.extensionLongName = extensionLongName;
        this.customMapper = customMapper;
        this.shuttingDown = new AtomicBoolean(false);
        this.isRunningLegitJob = new AtomicBoolean(false);
        this.convert = new Convert(extensionLongName);
        this.inReader = new LineReader(new InputStreamReader(socket.getInputStream()));
        this.out = new BufferedOutputStream(socket.getOutputStream());
        this.outGobbler = new StreamGobbler(ws, proc.getInputStream());
        this.errGobbler = new StreamGobbler(ws, proc.getErrorStream());
        this.outGobbler().start();
        this.errGobbler().start();
        this.executor = Executors.newSingleThreadExecutor();
        Runtime.getRuntime().addShutdownHook(new Thread(this){
            private final /* synthetic */ Subprocess $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                if (this.$outer.org$nlogo$languagelibrary$Subprocess$$proc.isAlive()) {
                    this.$outer.close();
                    return;
                }
            }
        });
    }

    public Convert convert() {
        return this.convert;
    }

    public LineReader inReader() {
        return this.inReader;
    }

    public BufferedOutputStream out() {
        return this.out;
    }

    public StreamGobbler outGobbler() {
        return this.outGobbler;
    }

    public StreamGobbler errGobbler() {
        return this.errGobbler;
    }

    public Object exec(String stmt) {
        Logger$.MODULE$.current().logMany("Subprocess.exec()", (Function0<Seq<String>>)((Function0 & Serializable)() -> Subprocess.exec$$anonfun$1(stmt)));
        return ((Try)((LinkedBlockingQueue)this.HandleFailures().apply(() -> this.exec$$anonfun$2(stmt))).take()).get();
    }

    public Object eval(String expr) {
        Logger$.MODULE$.current().logMany("Subprocess.eval()", (Function0<Seq<String>>)((Function0 & Serializable)() -> Subprocess.eval$$anonfun$1(expr)));
        return ((Try)((LinkedBlockingQueue)this.HandleFailures().apply(() -> this.eval$$anonfun$2(expr))).take()).get();
    }

    public String evalStringified(String expr) {
        Logger$.MODULE$.current().logMany("Subprocess.evalStringified()", (Function0<Seq<String>>)((Function0 & Serializable)() -> Subprocess.evalStringified$$anonfun$1(expr)));
        return ((Try)((LinkedBlockingQueue)this.HandleFailures().apply(() -> this.evalStringified$$anonfun$2(expr))).take()).get().toString();
    }

    public void assign(String varName, Object value) {
        Logger$.MODULE$.current().logMany("Subprocess.assign()", (Function0<Seq<String>>)((Function0 & Serializable)() -> Subprocess.assign$$anonfun$1(varName, value)));
        ((Try)((LinkedBlockingQueue)this.HandleFailures().apply(() -> this.assign$$anonfun$2(varName, value))).take()).get();
    }

    public Object genericJson(int msg_type, JValue value) {
        Logger$.MODULE$.current().logMany("Subprocess.genericJson()", (Function0<Seq<String>>)((Function0 & Serializable)() -> Subprocess.genericJson$$anonfun$1(msg_type, value)));
        return this.generic(msg_type, value);
    }

    public Object generic(int msg_type, Object value) {
        Logger$.MODULE$.current().logMany("Subprocess.generic()", (Function0<Seq<String>>)((Function0 & Serializable)() -> Subprocess.generic$$anonfun$1(msg_type, value)));
        return ((Try)((LinkedBlockingQueue)this.HandleFailures().apply(() -> this.generic$$anonfun$2(msg_type, value))).take()).get();
    }

    public void close() {
        Logger$.MODULE$.current().logOne("Subprocess.close()");
        this.quit();
        this.shuttingDown.set(true);
        this.executor.shutdownNow();
        Exceptions$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class}), (Function0 & Serializable)() -> {
            this.close$$anonfun$1();
            return BoxedUnit.UNIT;
        });
        Exceptions$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class}), (Function0 & Serializable)() -> {
            this.close$$anonfun$2();
            return BoxedUnit.UNIT;
        });
        Exceptions$.MODULE$.ignoring((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{IOException.class}), (Function0 & Serializable)() -> {
            this.close$$anonfun$3();
            return BoxedUnit.UNIT;
        });
        this.org$nlogo$languagelibrary$Subprocess$$proc.destroyForcibly();
        this.org$nlogo$languagelibrary$Subprocess$$proc.waitFor(3L, TimeUnit.SECONDS);
        if (this.org$nlogo$languagelibrary$Subprocess$$proc.isAlive()) {
            throw new ExtensionException(this.extensionLongName + " process failed to shutdown. Please shut it down via your process manager");
        }
    }

    private void quit() {
        Logger$.MODULE$.current().logOne("Subprocess.quit()");
        ((Try)((LinkedBlockingQueue)this.HandleFailures().apply(this::quit$$anonfun$1)).take()).get();
    }

    public void org$nlogo$languagelibrary$Subprocess$$invalidateJobs() {
        this.isRunningLegitJob.set(false);
    }

    private final Subprocess$Haltable$ Haltable() {
        Object object = this.Haltable$lzy1;
        if (object instanceof Subprocess$Haltable$) {
            return (Subprocess$Haltable$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Subprocess$Haltable$)this.Haltable$lzyINIT1();
    }

    private Object Haltable$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Haltable$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Subprocess$Haltable$ subprocess$Haltable$ = null;
                    try {
                        subprocess$Haltable$ = new Subprocess$Haltable$(this);
                        object2 = subprocess$Haltable$ == null ? LazyVals.NullValue$.MODULE$ : subprocess$Haltable$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Haltable$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return subprocess$Haltable$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final Subprocess$HandleFailures$ HandleFailures() {
        Object object = this.HandleFailures$lzy1;
        if (object instanceof Subprocess$HandleFailures$) {
            return (Subprocess$HandleFailures$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Subprocess$HandleFailures$)this.HandleFailures$lzyINIT1();
    }

    private Object HandleFailures$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.HandleFailures$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Subprocess$HandleFailures$ subprocess$HandleFailures$ = null;
                    try {
                        subprocess$HandleFailures$ = new Subprocess$HandleFailures$(this);
                        object2 = subprocess$HandleFailures$ == null ? LazyVals.NullValue$.MODULE$ : subprocess$HandleFailures$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.HandleFailures$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return subprocess$HandleFailures$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private <R> LinkedBlockingQueue<Try<R>> async(Function0<Try<R>> body) {
        LinkedBlockingQueue result = new LinkedBlockingQueue(1);
        this.executor.execute(() -> {
            block10: {
                try {
                    try {
                        this.isRunningLegitJob.set(true);
                        result.put((Try)body.apply());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof IOException) {
                            if (this.shuttingDown.get()) {
                            } else {
                                IOException e = (IOException)throwable2;
                                this.close();
                                result.put((Try)Failure$.MODULE$.apply((Throwable)new ExtensionException("Disconnected from " + this.extensionLongName + " unexpectedly. Try running " + this.extensionName + ":setup again.", (Exception)e)));
                            }
                            break block10;
                        }
                        if (throwable2 instanceof InterruptedException) {
                            Thread.interrupted();
                            break block10;
                        }
                        if (throwable2 instanceof Exception) {
                            Exception e = (Exception)throwable2;
                            result.put((Try)Failure$.MODULE$.apply((Throwable)e));
                            break block10;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.isRunningLegitJob.set(false);
                }
            }
        });
        return result;
    }

    private Try<Object> receive(Function0<BoxedUnit> send) {
        Success success;
        int msg_type;
        BigInt bigInt;
        Logger$.MODULE$.current().logOne("Subprocess.receive()");
        send.apply$mcV$sp();
        String line = this.inReader().readLine();
        if (line == null) {
            return Failure$.MODULE$.apply((Throwable)new ExtensionException("Unable to read child process output. Try running the command again"));
        }
        JValue parsed = (JValue)this.customMapper.map((Function1 & Serializable)_$9 -> _$9.parse((Object)line, _$9.parse$default$2(), _$9.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())).getOrElse(() -> Subprocess.$anonfun$2(line));
        JValue jValue = MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(parsed), "type");
        if (!(jValue instanceof JInt)) {
            return Failure$.MODULE$.apply((Throwable)new ExtensionException("Unknown message type received from the external langauge: " + MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(parsed), "type")));
        }
        JInt jInt = JsonAST$.MODULE$.JInt().unapply((JInt)jValue);
        BigInt num = bigInt = jInt._1();
        int n = msg_type = num.toInt();
        if (Subprocess$InTypes$.MODULE$.hearbeatResponseMsg() == n) {
            success = Success$.MODULE$.apply((Object)"beat");
        } else if (Subprocess$InTypes$.MODULE$.successMsg() == n) {
            Object body = this.convert().toNetLogo(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(parsed), "body"));
            success = Success$.MODULE$.apply(body);
        } else if (Subprocess$InTypes$.MODULE$.errorMsg() == n) {
            String message = ((JString)MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(parsed), "body")), "message")).s();
            String longMessage = ((JString)MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.$bslash$extension(package$.MODULE$.jvalue2monadic(parsed), "body")), "longMessage")).s();
            success = Failure$.MODULE$.apply((Throwable)new ExtensionException(message, (Exception)new TargetLanguageErrorException(message, longMessage)));
        } else {
            success = Failure$.MODULE$.apply((Throwable)new ExtensionException("Unknown message type received from the external langauge: " + msg_type));
        }
        Success result = success;
        return result;
    }

    private Try<Object> heartbeat(Duration timeout) {
        if (!this.isRunningLegitJob.get()) {
            LinkedBlockingQueue hb = this.async(this::$anonfun$3);
            return (Try)Option$.MODULE$.apply(hb.poll(timeout.toMillis(), TimeUnit.MILLISECONDS)).getOrElse(this::heartbeat$$anonfun$1);
        }
        return Success$.MODULE$.apply((Object)"beat");
    }

    private Duration heartbeat$default$1() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds();
    }

    private void sendMessage(JObject msg) {
        Logger$.MODULE$.current().logMany("Subprocess.sendMessage()", (Function0<Seq<String>>)((Function0 & Serializable)() -> Subprocess.sendMessage$$anonfun$1(msg)));
        this.out().write(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)msg, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())).getBytes("UTF-8"));
        Logger$.MODULE$.current().logMany("Subprocess.sendMessage()", (Function0<Seq<String>>)((Function0 & Serializable)Subprocess::sendMessage$$anonfun$2));
        this.out().write(10);
        Logger$.MODULE$.current().logMany("Subprocess.sendMessage()", (Function0<Seq<String>>)((Function0 & Serializable)Subprocess::sendMessage$$anonfun$3));
        this.out().flush();
        Logger$.MODULE$.current().logMany("Subprocess.sendMessage()", (Function0<Seq<String>>)((Function0 & Serializable)Subprocess::sendMessage$$anonfun$4));
    }

    private void sendStmt(String stmt) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        Tuple2 tuple2 = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)Subprocess$OutTypes$.MODULE$.stmtMsg())), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"body");
        JObject msg = JsonAssoc$.MODULE$.$tilde$extension(tuple2, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)stmt), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x));
        this.sendMessage(msg);
    }

    private void sendExpr(String expr) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        Tuple2 tuple2 = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)Subprocess$OutTypes$.MODULE$.exprMsg())), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"body");
        JObject msg = JsonAssoc$.MODULE$.$tilde$extension(tuple2, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)expr), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x));
        this.sendMessage(msg);
    }

    private void sendExprStringified(String expr) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        Tuple2 tuple2 = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)Subprocess$OutTypes$.MODULE$.exprStringifiedMsg())), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"body");
        JObject msg = JsonAssoc$.MODULE$.$tilde$extension(tuple2, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)expr), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x));
        this.sendMessage(msg);
    }

    private void sendAssn(String varName, Object value) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"varName");
        Tuple2 tuple2 = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)varName), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
        JObject name_value_pair = JsonAssoc$.MODULE$.$tilde$extension(tuple2, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.convert().toJson(value)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x), Predef$.MODULE$.$conforms());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        Tuple2 tuple22 = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToInteger((int)Subprocess$OutTypes$.MODULE$.assnMsg())), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"body");
        JObject msg = JsonAssoc$.MODULE$.$tilde$extension(tuple22, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)name_value_pair), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), Predef$.MODULE$.$conforms());
        this.sendMessage(msg);
    }

    private void sendQuit() {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        Tuple2 msg = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)Subprocess$OutTypes$.MODULE$.quitMsg()));
        this.sendMessage(JsonDSL$.MODULE$.pair2jvalue(msg, (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
    }

    private void sendGeneric(int i, Object value) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        Tuple2 tuple2 = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)i)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"body");
        JObject msg = JsonAssoc$.MODULE$.$tilde$extension(tuple2, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.convert().toJson(value)), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)), Predef$.MODULE$.$conforms());
        this.sendMessage(msg);
    }

    private void sendHeartbeat() {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        Tuple2 msg = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)Subprocess$OutTypes$.MODULE$.heartbeatRequestMsg()));
        this.sendMessage(JsonDSL$.MODULE$.pair2jvalue(msg, (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x))));
    }

    private static final Seq exec$$anonfun$1(String stmt$1) {
        return (Seq)((SeqOps)new .colon.colon((Object)"stmt", (List)new .colon.colon((Object)stmt$1, (List)Nil$.MODULE$)));
    }

    private final void exec$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String stmt$6) {
        this.sendStmt(stmt$6);
    }

    private final Try exec$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(String stmt$5) {
        return this.receive((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.exec$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(stmt$5);
            return BoxedUnit.UNIT;
        });
    }

    private final Try exec$$anonfun$2$$anonfun$1(String stmt$3) {
        return this.heartbeat(this.heartbeat$default$1()).map((Function1 & Serializable)_$3 -> this.async(() -> this.exec$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(stmt$3)));
    }

    private final Try exec$$anonfun$2(String stmt$2) {
        return (Try)this.Haltable().apply(() -> this.exec$$anonfun$2$$anonfun$1(stmt$2));
    }

    private static final Seq eval$$anonfun$1(String expr$1) {
        return (Seq)((SeqOps)new .colon.colon((Object)"expr", (List)new .colon.colon((Object)expr$1, (List)Nil$.MODULE$)));
    }

    private final void eval$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String expr$6) {
        this.sendExpr(expr$6);
    }

    private final Try eval$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(String expr$5) {
        return this.receive((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.eval$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(expr$5);
            return BoxedUnit.UNIT;
        });
    }

    private final Try eval$$anonfun$2$$anonfun$1(String expr$3) {
        return this.heartbeat(this.heartbeat$default$1()).map((Function1 & Serializable)_$4 -> this.async(() -> this.eval$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(expr$3)));
    }

    private final Try eval$$anonfun$2(String expr$2) {
        return (Try)this.Haltable().apply(() -> this.eval$$anonfun$2$$anonfun$1(expr$2));
    }

    private static final Seq evalStringified$$anonfun$1(String expr$7) {
        return (Seq)((SeqOps)new .colon.colon((Object)"expr", (List)new .colon.colon((Object)expr$7, (List)Nil$.MODULE$)));
    }

    private final void evalStringified$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String expr$12) {
        this.sendExprStringified(expr$12);
    }

    private final Try evalStringified$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(String expr$11) {
        return this.receive((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.evalStringified$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(expr$11);
            return BoxedUnit.UNIT;
        });
    }

    private final Try evalStringified$$anonfun$2$$anonfun$1(String expr$9) {
        return this.heartbeat(this.heartbeat$default$1()).map((Function1 & Serializable)_$5 -> this.async(() -> this.evalStringified$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(expr$9)));
    }

    private final Try evalStringified$$anonfun$2(String expr$8) {
        return (Try)this.Haltable().apply(() -> this.evalStringified$$anonfun$2$$anonfun$1(expr$8));
    }

    private static final Seq assign$$anonfun$1(String varName$1, Object value$1) {
        return (Seq)((SeqOps)new .colon.colon((Object)"varName", (List)new .colon.colon((Object)varName$1, (List)new .colon.colon((Object)", value", (List)new .colon.colon((Object)value$1.toString(), (List)Nil$.MODULE$)))));
    }

    private final void assign$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String varName$6, Object value$6) {
        this.sendAssn(varName$6, value$6);
    }

    private final Try assign$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(String varName$5, Object value$5) {
        return this.receive((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.assign$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(varName$5, value$5);
            return BoxedUnit.UNIT;
        });
    }

    private final Try assign$$anonfun$2$$anonfun$1(String varName$3, Object value$3) {
        return this.heartbeat(this.heartbeat$default$1()).map((Function1 & Serializable)_$6 -> this.async(() -> this.assign$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(varName$3, value$3)));
    }

    private final Try assign$$anonfun$2(String varName$2, Object value$2) {
        return (Try)this.Haltable().apply(() -> this.assign$$anonfun$2$$anonfun$1(varName$2, value$2));
    }

    private static final Seq genericJson$$anonfun$1(int msg_type$1, JValue value$7) {
        return (Seq)((SeqOps)new .colon.colon((Object)"msg_type", (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)msg_type$1).toString(), (List)new .colon.colon((Object)", value", (List)new .colon.colon((Object)value$7.toString(), (List)Nil$.MODULE$)))));
    }

    private static final Seq generic$$anonfun$1(int msg_type$2, Object value$8) {
        return (Seq)((SeqOps)new .colon.colon((Object)"msg_type", (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)msg_type$2).toString(), (List)new .colon.colon((Object)", value", (List)new .colon.colon((Object)value$8.toString(), (List)Nil$.MODULE$)))));
    }

    private final void generic$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(int msg_type$7, Object value$13) {
        this.sendGeneric(msg_type$7, value$13);
    }

    private final Try generic$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(int msg_type$6, Object value$12) {
        return this.receive((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.generic$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(msg_type$6, value$12);
            return BoxedUnit.UNIT;
        });
    }

    private final Try generic$$anonfun$2$$anonfun$1(int msg_type$4, Object value$10) {
        return this.heartbeat(this.heartbeat$default$1()).map((Function1 & Serializable)_$7 -> this.async(() -> this.generic$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(msg_type$4, value$10)));
    }

    private final Try generic$$anonfun$2(int msg_type$3, Object value$9) {
        return (Try)this.Haltable().apply(() -> this.generic$$anonfun$2$$anonfun$1(msg_type$3, value$9));
    }

    private final void close$$anonfun$1() {
        this.inReader().close();
    }

    private final void close$$anonfun$2() {
        this.out().close();
    }

    private final void close$$anonfun$3() {
        this.socket.close();
    }

    private final void quit$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        this.sendQuit();
    }

    private final Try quit$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.receive((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.quit$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private final Try quit$$anonfun$1$$anonfun$1() {
        return this.heartbeat(this.heartbeat$default$1()).map((Function1 & Serializable)_$8 -> this.async(this::quit$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1));
    }

    private final Try quit$$anonfun$1() {
        return (Try)this.Haltable().apply(this::quit$$anonfun$1$$anonfun$1);
    }

    private static final JValue $anonfun$2(String line$2) {
        return JsonMethods$.MODULE$.parse((Object)line$2, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
    }

    private final void $anonfun$3$$anonfun$1() {
        this.sendHeartbeat();
    }

    private final Try $anonfun$3() {
        return this.receive((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.$anonfun$3$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private final Try heartbeat$$anonfun$1() {
        return Failure$.MODULE$.apply((Throwable)new ExtensionException(this.extensionLongName + " is not responding. You can wait to see if it finishes what it's doing or restart it using " + this.extensionName + ":setup"));
    }

    private static final Seq sendMessage$$anonfun$1(JObject msg$1) {
        return (Seq)((SeqOps)new .colon.colon((Object)"msg", (List)new .colon.colon((Object)msg$1.toString(), (List)Nil$.MODULE$)));
    }

    private static final Seq sendMessage$$anonfun$2() {
        return (Seq)((SeqOps)new .colon.colon((Object)"message written", (List)Nil$.MODULE$));
    }

    private static final Seq sendMessage$$anonfun$3() {
        return (Seq)((SeqOps)new .colon.colon((Object)"line breaks written", (List)Nil$.MODULE$));
    }

    private static final Seq sendMessage$$anonfun$4() {
        return (Seq)((SeqOps)new .colon.colon((Object)"flushed", (List)Nil$.MODULE$));
    }
}

