/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sttp.model.Header;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.Uri;
import sttp.model.headers.AcceptEncoding;
import sttp.model.headers.CacheDirective;
import sttp.model.headers.ContentRange;
import sttp.model.headers.Cookie;
import sttp.model.headers.CookieWithMeta;
import sttp.model.headers.ETag;
import sttp.model.headers.ETag$;
import sttp.model.headers.Origin;
import sttp.model.headers.Range;
import sttp.model.headers.WWWAuthenticateChallenge;
import sttp.model.internal.Rfc2616$;
import sttp.model.internal.Rfc9110$;
import sttp.model.internal.Validate$;

public final class Header$
implements Serializable {
    private volatile Object GMT$lzy1;
    private volatile Object Rfc850DatetimeFormat$lzy1;
    private static final Set Rfc850WeekDays;
    private static final String[] Rfc1123WeekDays;
    private static final String[] Rfc1123Months;
    public static final Header$ MODULE$;

    private Header$() {
    }

    static {
        MODULE$ = new Header$();
        Rfc850WeekDays = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mon", "tue", "wed", "thu", "fri", "sat", "sun"}));
        Rfc1123WeekDays = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        Rfc1123Months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Header$.class);
    }

    public Option<Tuple2<String, String>> unapply(Header h) {
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)h.name(), (Object)h.value()));
    }

    public Header unsafeApply(String name, String value) {
        return Validate$.MODULE$.RichEither(this.safeApply(name, value)).getOrThrow();
    }

    public Either<String, Header> safeApply(String name, String value) {
        return Validate$.MODULE$.all((Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Rfc2616$.MODULE$.validateToken("Header name", name), Rfc9110$.MODULE$.validateFieldValue(value)}), () -> Header$.safeApply$$anonfun$1(name, value));
    }

    public Header apply(String name, String value) {
        return new Header(name, value);
    }

    public Header accept(MediaType mediaType, Seq<MediaType> additionalMediaTypes) {
        return this.accept(String.valueOf(additionalMediaTypes.toList().$colon$colon((Object)mediaType).map((Function1 & Serializable)_$1 -> _$1.noCharset()).mkString(", ")));
    }

    public Header accept(String mediaRanges) {
        return this.apply(HeaderNames$.MODULE$.Accept(), mediaRanges);
    }

    public Header acceptCharset(String charsetRanges) {
        return this.apply(HeaderNames$.MODULE$.AcceptCharset(), charsetRanges);
    }

    public Header acceptEncoding(String encodingRanges) {
        return this.apply(HeaderNames$.MODULE$.AcceptEncoding(), encodingRanges);
    }

    public Header accessControlAllowCredentials(boolean allow) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowCredentials(), BoxesRunTime.boxToBoolean((boolean)allow).toString());
    }

    public Header accessControlAllowHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlAllowMethods(Seq<Method> methods) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowMethods(), ((IterableOnceOps)methods.map((Function1 & Serializable)_$2 -> _$2 == null ? null : ((Method)_$2).method())).mkString(", "));
    }

    public Header accessControlAllowOrigin(String originRange) {
        return this.apply(HeaderNames$.MODULE$.AccessControlAllowOrigin(), originRange);
    }

    public Header accessControlExposeHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlExposeHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlMaxAge(long deltaSeconds) {
        return this.apply(HeaderNames$.MODULE$.AccessControlMaxAge(), BoxesRunTime.boxToLong((long)deltaSeconds).toString());
    }

    public Header accessControlRequestHeaders(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.AccessControlRequestHeaders(), headerNames.mkString(", "));
    }

    public Header accessControlRequestMethod(String method) {
        return this.apply(HeaderNames$.MODULE$.AccessControlRequestMethod(), Method$.MODULE$.toString$extension(method));
    }

    public Header authorization(String authType, String credentials) {
        return this.apply(HeaderNames$.MODULE$.Authorization(), new StringBuilder(1).append(authType).append(" ").append(credentials).toString());
    }

    public Header acceptEncoding(AcceptEncoding acceptEncoding) {
        return this.apply(HeaderNames$.MODULE$.AcceptEncoding(), acceptEncoding.toString());
    }

    public Header cacheControl(CacheDirective first, Seq<CacheDirective> other) {
        return this.cacheControl((Iterable<CacheDirective>)((Iterable)other.$plus$colon((Object)first)));
    }

    public Header cacheControl(Iterable<CacheDirective> directives) {
        return this.apply(HeaderNames$.MODULE$.CacheControl(), ((IterableOnceOps)directives.map((Function1 & Serializable)_$3 -> _$3.toString())).mkString(", "));
    }

    public Header contentLength(long length) {
        return this.apply(HeaderNames$.MODULE$.ContentLength(), BoxesRunTime.boxToLong((long)length).toString());
    }

    public Header contentEncoding(String encoding) {
        return this.apply(HeaderNames$.MODULE$.ContentEncoding(), encoding);
    }

    public Header contentType(MediaType mediaType) {
        return this.apply(HeaderNames$.MODULE$.ContentType(), mediaType.toString());
    }

    public Header contentRange(ContentRange contentRange) {
        return this.apply(HeaderNames$.MODULE$.ContentRange(), contentRange.toString());
    }

    public Header cookie(Cookie firstCookie, Seq<Cookie> otherCookies) {
        return this.apply(HeaderNames$.MODULE$.Cookie(), ((IterableOnceOps)((IterableOps)otherCookies.$plus$colon((Object)firstCookie)).map((Function1 & Serializable)_$4 -> _$4.toString())).mkString("; "));
    }

    public Header etag(String tag) {
        return this.etag(ETag$.MODULE$.apply(tag, ETag$.MODULE$.$lessinit$greater$default$2()));
    }

    public Header etag(ETag tag) {
        return this.apply(HeaderNames$.MODULE$.Etag(), tag.toString());
    }

    public Header expires(Instant i) {
        return this.apply(HeaderNames$.MODULE$.Expires(), this.toHttpDateString(i));
    }

    public Header ifNoneMatch(List<ETag> tags) {
        return this.apply(HeaderNames$.MODULE$.IfNoneMatch(), ETag$.MODULE$.toString(tags));
    }

    public Header ifModifiedSince(Instant i) {
        return this.apply(HeaderNames$.MODULE$.IfModifiedSince(), this.toHttpDateString(i));
    }

    public Header ifUnmodifiedSince(Instant i) {
        return this.apply(HeaderNames$.MODULE$.IfUnmodifiedSince(), this.toHttpDateString(i));
    }

    public Header lastModified(Instant i) {
        return this.apply(HeaderNames$.MODULE$.LastModified(), this.toHttpDateString(i));
    }

    public Header location(String uri) {
        return this.apply(HeaderNames$.MODULE$.Location(), uri);
    }

    public Header location(Uri uri) {
        return this.apply(HeaderNames$.MODULE$.Location(), uri.toString());
    }

    public Header origin(Origin origin) {
        return this.apply(HeaderNames$.MODULE$.Origin(), origin.toString());
    }

    public Header proxyAuthorization(String authType, String credentials) {
        return this.apply(HeaderNames$.MODULE$.ProxyAuthorization(), new StringBuilder(1).append(authType).append(" ").append(credentials).toString());
    }

    public Header range(Range range) {
        return this.apply(HeaderNames$.MODULE$.Range(), range.toString());
    }

    public Header setCookie(CookieWithMeta cookie) {
        return this.apply(HeaderNames$.MODULE$.SetCookie(), cookie.toString());
    }

    public Header userAgent(String userAgent) {
        return this.apply(HeaderNames$.MODULE$.UserAgent(), userAgent);
    }

    public Header wwwAuthenticate(WWWAuthenticateChallenge challenge) {
        return this.apply(HeaderNames$.MODULE$.WwwAuthenticate(), challenge.toString());
    }

    public List<Header> wwwAuthenticate(WWWAuthenticateChallenge firstChallenge, Seq<WWWAuthenticateChallenge> otherChallenges) {
        return otherChallenges.toList().$colon$colon((Object)firstChallenge).map((Function1 & Serializable)c -> MODULE$.apply(HeaderNames$.MODULE$.WwwAuthenticate(), c.toString()));
    }

    public Header vary(Seq<String> headerNames) {
        return this.apply(HeaderNames$.MODULE$.Vary(), headerNames.mkString(", "));
    }

    public Header xForwardedFor(String firstAddress, Seq<String> otherAddresses) {
        return this.apply(HeaderNames$.MODULE$.XForwardedFor(), ((IterableOnceOps)otherAddresses.$plus$colon((Object)firstAddress)).mkString(", "));
    }

    private ZoneId GMT() {
        Object object = this.GMT$lzy1;
        if (object instanceof ZoneId) {
            return (ZoneId)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ZoneId)this.GMT$lzyINIT1();
    }

    private Object GMT$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.GMT$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ZoneId zoneId = null;
                    try {
                        zoneId = ZoneId.of("GMT");
                        object2 = zoneId == null ? LazyVals.NullValue$.MODULE$ : zoneId;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.GMT$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return zoneId;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private DateTimeFormatter Rfc850DatetimeFormat() {
        Object object = this.Rfc850DatetimeFormat$lzy1;
        if (object instanceof DateTimeFormatter) {
            return (DateTimeFormatter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (DateTimeFormatter)this.Rfc850DatetimeFormat$lzyINIT1();
    }

    private Object Rfc850DatetimeFormat$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Rfc850DatetimeFormat$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DateTimeFormatter dateTimeFormatter = null;
                    try {
                        dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("dd-MMM-").appendValueReduced((TemporalField)ChronoField.YEAR, 2, 4, 1970).appendPattern(" HH:mm:ss zzz").toFormatter(Locale.US);
                        object2 = dateTimeFormatter == null ? LazyVals.NullValue$.MODULE$ : dateTimeFormatter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Rfc850DatetimeFormat$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return dateTimeFormatter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Header.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Set<String> Rfc850WeekDays() {
        return Rfc850WeekDays;
    }

    private Instant parseRfc850DateTime(String v) {
        String[] expiresParts = v.split(", ");
        if (expiresParts.length != 2) {
            throw new Exception("There must be exactly one \", \"");
        }
        if (!this.Rfc850WeekDays().contains((Object)expiresParts[0].trim().toLowerCase(Locale.ENGLISH))) {
            throw new Exception("String must start with weekday name");
        }
        return Instant.from(this.Rfc850DatetimeFormat().parse(expiresParts[1]));
    }

    public Either<String, Instant> parseHttpDate(String v) {
        Try try_ = Try$.MODULE$.apply(() -> Header$.parseHttpDate$$anonfun$1(v));
        if (try_ instanceof Success) {
            Instant r = (Instant)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)r);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            Try try_2 = Try$.MODULE$.apply(() -> Header$.parseHttpDate$$anonfun$2(v));
            if (try_2 instanceof Success) {
                Instant r = (Instant)((Success)try_2).value();
                return package$.MODULE$.Right().apply((Object)r);
            }
            if (try_2 instanceof Failure) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(22).append("Invalid http date: ").append(v).append(" (").append(e.getMessage()).append(")").toString());
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError((Object)try_);
    }

    public Instant unsafeParseHttpDate(String s) {
        return Validate$.MODULE$.RichEither(this.parseHttpDate(s)).getOrThrow();
    }

    public String toHttpDateString(Instant instantTime) {
        ZonedDateTime dateTime = instantTime.atZone(this.GMT());
        String dayOfWeek = Rfc1123WeekDays[dateTime.getDayOfWeek().getValue() - 1];
        String month = Rfc1123Months[dateTime.getMonth().getValue() - 1];
        int dayOfMonth = dateTime.getDayOfMonth();
        int year = dateTime.getYear();
        int hour = dateTime.getHour();
        int minute = dateTime.getMinute();
        int second = dateTime.getSecond();
        return StringOps$.MODULE$.format$extension("%s, %02d %s %04d %02d:%02d:%02d GMT", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dayOfWeek, BoxesRunTime.boxToInteger((int)dayOfMonth), month, BoxesRunTime.boxToInteger((int)year), BoxesRunTime.boxToInteger((int)hour), BoxesRunTime.boxToInteger((int)minute), BoxesRunTime.boxToInteger((int)second)}));
    }

    private static final Header safeApply$$anonfun$1(String name$1, String value$1) {
        return MODULE$.apply(name$1, value$1);
    }

    private static final Instant parseHttpDate$$anonfun$1(String v$1) {
        return Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(v$1));
    }

    private static final Instant parseHttpDate$$anonfun$2(String v$2) {
        return MODULE$.parseRfc850DateTime(v$2);
    }
}

