/*
 * Decompiled with CFR 0.152.
 */
package sttp.model;

import java.io.Serializable;
import java.net.URI;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import sttp.model.Uri;
import sttp.model.Uri$AbsolutePath$;
import sttp.model.Uri$Authority$;
import sttp.model.Uri$EmptyPath$;
import sttp.model.Uri$FragmentEncoding$;
import sttp.model.Uri$FragmentSegment$;
import sttp.model.Uri$HostEncoding$;
import sttp.model.Uri$HostSegment$;
import sttp.model.Uri$PathSegment$;
import sttp.model.Uri$PathSegmentEncoding$;
import sttp.model.Uri$PathSegments$;
import sttp.model.Uri$QuerySegment$;
import sttp.model.Uri$QuerySegment$KeyValue$;
import sttp.model.Uri$QuerySegment$Value$;
import sttp.model.Uri$QuerySegmentEncoding$;
import sttp.model.Uri$RelativePath$;
import sttp.model.Uri$Segment$;
import sttp.model.Uri$UserInfo$;
import sttp.model.UriInterpolator;
import sttp.model.internal.Rfc3986$;
import sttp.model.internal.Validate$;

public final class Uri$
implements UriInterpolator,
Mirror.Product,
Serializable {
    private static final Regex AllowedSchemeCharacters;
    public static final Uri$Authority$ Authority;
    public static final Uri$Segment$ Segment;
    public static final Uri$HostSegment$ HostSegment;
    public static final Uri$PathSegments$ PathSegments;
    public static final Uri$EmptyPath$ EmptyPath;
    public static final Uri$AbsolutePath$ AbsolutePath;
    public static final Uri$RelativePath$ RelativePath;
    public static final Uri$PathSegment$ PathSegment;
    public static final Uri$FragmentSegment$ FragmentSegment;
    public static final Uri$QuerySegment$ QuerySegment;
    public static final Uri$HostEncoding$ HostEncoding;
    public static final Uri$PathSegmentEncoding$ PathSegmentEncoding;
    public static final Uri$QuerySegmentEncoding$ QuerySegmentEncoding;
    public static final Uri$FragmentEncoding$ FragmentEncoding;
    public static final Uri$UserInfo$ UserInfo;
    public static final Uri$ MODULE$;

    private Uri$() {
    }

    static {
        MODULE$ = new Uri$();
        AllowedSchemeCharacters = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[a-zA-Z][a-zA-Z0-9+-.]*"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Uri$.class);
    }

    public Uri apply(Option<String> scheme, Option<Uri.Authority> authority, Uri.PathSegments pathSegments, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return new Uri(scheme, authority, pathSegments, querySegments, fragmentSegment);
    }

    public Uri unapply(Uri x$1) {
        return x$1;
    }

    public Option<String> sttp$model$Uri$$$validateHost(Option<String> host) {
        return host.flatMap((Function1 & Serializable)h -> {
            if (h.isEmpty()) {
                return Some$.MODULE$.apply((Object)"Host cannot be empty");
            }
            return None$.MODULE$;
        });
    }

    private Option<String> validateScheme(Option<String> scheme) {
        return scheme.flatMap((Function1 & Serializable)s -> {
            if (AllowedSchemeCharacters.unapplySeq((CharSequence)s).isEmpty()) {
                return Some$.MODULE$.apply((Object)"Scheme can only contain alphanumeric characters, +, - and .");
            }
            return None$.MODULE$;
        });
    }

    public Either<String, Uri> safeApply(String host) {
        return this.safeApply("http", (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String host, int port) {
        return this.safeApply("http", (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String host, int port, Seq<String> path) {
        return this.safeApply("http", (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$19 -> Uri$PathSegment$.MODULE$.apply((String)_$19))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.Authority>)None$.MODULE$, (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$20 -> Uri$PathSegment$.MODULE$.apply((String)_$20))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host) {
        return this.safeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, int port) {
        return this.safeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, int port, Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$21 -> Uri$PathSegment$.MODULE$.apply((String)_$21))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, Seq<String> path) {
        return this.safeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$22 -> Uri$PathSegment$.MODULE$.apply((String)_$22))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Either<String, Uri> safeApply(String scheme, String host, Seq<String> path, Option<String> fragment) {
        return this.safeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$23 -> Uri$PathSegment$.MODULE$.apply((String)_$23))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$24 -> Uri$FragmentSegment$.MODULE$.apply((String)_$24)));
    }

    public Either<String, Uri> safeApply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.safeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(userInfo, Uri$HostSegment$.MODULE$.apply(host), port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$25 -> Uri$PathSegment$.MODULE$.apply((String)_$25))), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$26 -> Uri$FragmentSegment$.MODULE$.apply((String)_$26)));
    }

    public Either<String, Uri> safeApply(String scheme, Option<Uri.Authority> authority, Seq<Uri.Segment> pathSegments, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return Validate$.MODULE$.all((Seq<Option<String>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.validateScheme((Option<String>)Some$.MODULE$.apply((Object)scheme)), this.sttp$model$Uri$$$validateHost((Option<String>)authority.map((Function1 & Serializable)_$27 -> _$27.hostSegment().v()))}), () -> Uri$.safeApply$$anonfun$10(scheme, authority, pathSegments, querySegments, fragmentSegment));
    }

    public Uri unsafeApply(String host) {
        return this.unsafeApply("http", (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String host, int port) {
        return this.unsafeApply("http", (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String host, int port, Seq<String> path) {
        return this.unsafeApply("http", (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$28 -> Uri$PathSegment$.MODULE$.apply((String)_$28))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)None$.MODULE$, (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$29 -> Uri$PathSegment$.MODULE$.apply((String)_$29))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, int port) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)package$.MODULE$.Vector().empty(), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, int port, Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$30 -> Uri$PathSegment$.MODULE$.apply((String)_$30))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, Seq<String> path) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$31 -> Uri$PathSegment$.MODULE$.apply((String)_$31))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri unsafeApply(String scheme, String host, Seq<String> path, Option<String> fragment) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$32 -> Uri$PathSegment$.MODULE$.apply((String)_$32))), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$33 -> Uri$FragmentSegment$.MODULE$.apply((String)_$33)));
    }

    public Uri unsafeApply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.unsafeApply(scheme, (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(userInfo, Uri$HostSegment$.MODULE$.apply(host), port)), (Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$34 -> Uri$PathSegment$.MODULE$.apply((String)_$34))), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$35 -> Uri$FragmentSegment$.MODULE$.apply((String)_$35)));
    }

    public Uri unsafeApply(String scheme, Option<Uri.Authority> authority, Seq<Uri.Segment> pathSegments, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragmentSegment) {
        return Validate$.MODULE$.RichEither(this.safeApply(scheme, authority, pathSegments, querySegments, fragmentSegment)).getOrThrow();
    }

    public Uri apply(String host) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)"http"), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String host, int port) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)"http"), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String host, int port, Seq<String> path) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)"http"), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, Seq<String> path) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), (Option<Uri.Authority>)None$.MODULE$, Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, int port) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$EmptyPath$.MODULE$, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, int port, Seq<String> path) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host, port)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, Seq<String> path) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)None$.MODULE$);
    }

    public Uri apply(String scheme, String host, Seq<String> path, Option<String> fragment) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(host)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$36 -> Uri$FragmentSegment$.MODULE$.apply((String)_$36)));
    }

    public Uri apply(String scheme, Option<Uri.UserInfo> userInfo, String host, Option<Object> port, Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), (Option<Uri.Authority>)Some$.MODULE$.apply((Object)Uri$Authority$.MODULE$.apply(userInfo, Uri$HostSegment$.MODULE$.apply(host), port)), Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$37 -> Uri$FragmentSegment$.MODULE$.apply((String)_$37)));
    }

    public Uri apply(String scheme, Option<Uri.Authority> authority, Seq<Uri.Segment> path, Seq<Uri.QuerySegment> querySegments, Option<Uri.Segment> fragment) {
        return this.apply((Option<String>)Some$.MODULE$.apply((Object)scheme), authority, Uri$PathSegments$.MODULE$.absoluteOrEmpty(path), querySegments, fragment);
    }

    public Uri relative(Seq<String> path) {
        return this.relative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<String>)None$.MODULE$);
    }

    public Uri relative(Seq<String> path, Option<String> fragment) {
        return this.relative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), fragment);
    }

    public Uri relative(Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.apply((Option<String>)None$.MODULE$, (Option<Uri.Authority>)None$.MODULE$, Uri$PathSegments$.MODULE$.absoluteOrEmptyS(path), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$38 -> Uri$FragmentSegment$.MODULE$.apply((String)_$38)));
    }

    public Uri pathRelative(Seq<String> path) {
        return this.pathRelative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), (Option<String>)None$.MODULE$);
    }

    public Uri pathRelative(Seq<String> path, Option<String> fragment) {
        return this.pathRelative(path, (Seq<Uri.QuerySegment>)package$.MODULE$.Vector().empty(), fragment);
    }

    public Uri pathRelative(Seq<String> path, Seq<Uri.QuerySegment> querySegments, Option<String> fragment) {
        return this.apply((Option<String>)None$.MODULE$, (Option<Uri.Authority>)None$.MODULE$, Uri$RelativePath$.MODULE$.apply((Seq<Uri.Segment>)((Seq)path.map((Function1 & Serializable)_$39 -> Uri$PathSegment$.MODULE$.apply((String)_$39)))), querySegments, (Option<Uri.Segment>)fragment.map((Function1 & Serializable)_$40 -> Uri$FragmentSegment$.MODULE$.apply((String)_$40)));
    }

    public Uri apply(URI javaUri) {
        return this.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{javaUri.toString()}));
    }

    public Either<String, Uri> parse(String uri) {
        Try try_ = Try$.MODULE$.apply(() -> Uri$.parse$$anonfun$1(uri));
        if (try_ instanceof Success) {
            Uri u = (Uri)((Success)try_).value();
            return package$.MODULE$.Right().apply((Object)u);
        }
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof Exception) {
                Exception e = (Exception)throwable;
                return package$.MODULE$.Left().apply((Object)e.getMessage());
            }
            if (throwable != null) {
                Throwable t = throwable;
                throw t;
            }
        }
        throw new MatchError((Object)try_);
    }

    public Uri unsafeParse(String uri) {
        return this.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{uri}));
    }

    public Uri fromProduct(Product x$0) {
        return new Uri((Option<String>)((Option)x$0.productElement(0)), (Option<Uri.Authority>)((Option)x$0.productElement(1)), (Uri.PathSegments)x$0.productElement(2), (Seq<Uri.QuerySegment>)((Seq)x$0.productElement(3)), (Option<Uri.Segment>)((Option)x$0.productElement(4)));
    }

    private static final Uri safeApply$$anonfun$10(String scheme$19, Option authority$19, Seq pathSegments$19, Seq querySegments$19, Option fragmentSegment$19) {
        return MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)scheme$19), (Option<Uri.Authority>)authority$19, Uri$PathSegments$.MODULE$.absoluteOrEmpty((Seq<Uri.Segment>)pathSegments$19), (Seq<Uri.QuerySegment>)querySegments$19, (Option<Uri.Segment>)fragmentSegment$19);
    }

    private static final Uri parse$$anonfun$1(String uri$1) {
        return MODULE$.UriContext(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).uri((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{uri$1}));
    }

    public static final String sttp$model$Uri$Authority$$_$encodeUserInfo$1$$anonfun$1() {
        return "";
    }

    public static final /* synthetic */ String sttp$model$Uri$Authority$$_$encodeUserInfo$1$$anonfun$2(String _$41) {
        return new StringBuilder(1).append(":").append(Rfc3986$.MODULE$.encode(Rfc3986$.MODULE$.UserInfo(), Rfc3986$.MODULE$.encode$default$2(), Rfc3986$.MODULE$.encode$default$3(), _$41)).toString();
    }

    public static final String sttp$model$Uri$Authority$$_$_$$anonfun$22() {
        return "";
    }

    public static final String sttp$model$Uri$Authority$$_$_$$anonfun$24() {
        return "";
    }

    private static final /* synthetic */ String $anonfun$25(int _$43) {
        return new StringBuilder(1).append(":").append(_$43).toString();
    }

    public static /* bridge */ /* synthetic */ String sttp$model$Uri$Authority$$_$_$$anonfun$adapted$1(Object _$43) {
        return Uri$.$anonfun$25(BoxesRunTime.unboxToInt((Object)_$43));
    }

    public static final Uri.Authority sttp$model$Uri$Authority$$$_$safeApply$$anonfun$11(String host$1) {
        return Uri$Authority$.MODULE$.apply((Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host$1), (Option<Object>)None$.MODULE$);
    }

    public static final Uri.Authority sttp$model$Uri$Authority$$$_$safeApply$$anonfun$12(String host$2, int port$2) {
        return Uri$Authority$.MODULE$.apply((Option<Uri.UserInfo>)None$.MODULE$, Uri$HostSegment$.MODULE$.apply(host$2), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port$2)));
    }

    public static final /* synthetic */ Uri.Segment sttp$model$Uri$PathSegments$$_$add$$anonfun$1(String _$44) {
        return Uri$PathSegment$.MODULE$.apply(_$44);
    }

    public static final /* synthetic */ boolean sttp$model$Uri$PathSegments$$_$_$$anonfun$26(Uri.Segment _$45) {
        return _$45.v().isEmpty();
    }

    public static final /* synthetic */ Uri.Segment sttp$model$Uri$PathSegments$$_$withS$$anonfun$1(String _$46) {
        return Uri$PathSegment$.MODULE$.apply(_$46);
    }

    public static final /* synthetic */ Uri.Segment sttp$model$Uri$PathSegments$$$_$absoluteOrEmptyS$$anonfun$1(String _$47) {
        return Uri$PathSegment$.MODULE$.apply(_$47);
    }

    public static final /* synthetic */ String sttp$model$Uri$AbsolutePath$$_$toString$$anonfun$1(Uri.Segment _$48) {
        return _$48.encoded();
    }

    public static final /* synthetic */ String sttp$model$Uri$RelativePath$$_$toString$$anonfun$2(Uri.Segment _$49) {
        return _$49.encoded();
    }

    public static final /* synthetic */ IterableOnce sttp$model$Uri$QuerySegment$$$_$fromQueryParams$$anonfun$1(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            SeqOps seqOps;
            String k = (String)tuple2._1();
            Seq vs = (Seq)tuple2._2();
            Seq seq = vs;
            if (seq != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = Seq$.MODULE$.unapplySeq((SeqOps)seq), 0) == 0) {
                return (Seq)new .colon.colon((Object)Uri$QuerySegment$Value$.MODULE$.apply(k, Uri$QuerySegment$Value$.MODULE$.$lessinit$greater$default$2()), (List)Nil$.MODULE$);
            }
            Seq s = seq;
            return (Seq)s.map((Function1 & Serializable)v -> Uri$QuerySegment$KeyValue$.MODULE$.apply(k, (String)v, Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$3(), Uri$QuerySegment$KeyValue$.MODULE$.$lessinit$greater$default$4()));
        }
        throw new MatchError((Object)tuple2);
    }
}

