/*
 * Decompiled with CFR 0.152.
 */
package sttp.model.headers;

import java.io.Serializable;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sttp.model.ContentRangeUnits$;
import sttp.model.headers.ContentRange;
import sttp.model.headers.ContentRange$;
import sttp.model.headers.Range$;

public class Range
implements Product,
Serializable {
    private final Option start;
    private final Option end;
    private final String unit;
    private final long contentLength;

    public static Range apply(Option<Object> option, Option<Object> option2, String string) {
        return Range$.MODULE$.apply(option, option2, string);
    }

    public static Range fromProduct(Product product) {
        return Range$.MODULE$.fromProduct(product);
    }

    public static Either<String, List<Range>> parse(String string) {
        return Range$.MODULE$.parse(string);
    }

    public static Either<String, List<Range>> safeApply(Option<Object> option, Option<Object> option2, String string) {
        return Range$.MODULE$.safeApply(option, option2, string);
    }

    public static Range unapply(Range range) {
        return Range$.MODULE$.unapply(range);
    }

    public static List<Range> unsafeApply(Option<Object> option, Option<Object> option2, String string) {
        return Range$.MODULE$.unsafeApply(option, option2, string);
    }

    public static List<Range> unsafeParse(String string) {
        return Range$.MODULE$.unsafeParse(string);
    }

    public Range(Option<Object> start, Option<Object> end, String unit) {
        this.start = start;
        this.end = end;
        this.unit = unit;
        this.contentLength = end.isDefined() && start.isDefined() ? BoxesRunTime.unboxToLong((Object)end.get()) - BoxesRunTime.unboxToLong((Object)start.get()) + 1L : 0L;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Range)) return false;
        Range range = (Range)object;
        Option<Object> option = this.start();
        Option<Object> option2 = range.start();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.end();
        Option<Object> option4 = range.end();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        String string = this.unit();
        String string2 = range.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!range.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Range;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Range";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "start";
            }
            case 1: {
                return "end";
            }
            case 2: {
                return "unit";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<Object> start() {
        return this.start;
    }

    public Option<Object> end() {
        return this.end;
    }

    public String unit() {
        return this.unit;
    }

    public String toString() {
        Object object;
        Object object2;
        StringBuilder sb = new StringBuilder();
        sb.append(this.unit()).append("=");
        Option<Object> option = this.start();
        if (option instanceof Some) {
            Some x = (Some)option;
            object2 = sb.append(BoxesRunTime.unboxToLong((Object)x.value()));
        } else {
            object2 = BoxedUnit.UNIT;
        }
        sb.append('-');
        Option<Object> option2 = this.end();
        if (option2 instanceof Some) {
            Some x = (Some)option2;
            object = sb.append(BoxesRunTime.unboxToLong((Object)x.value()));
        } else {
            object = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    public ContentRange toContentRange(long fileSize, String unit) {
        return ContentRange$.MODULE$.apply(unit, (Option<Tuple2<Object, Object>>)(this.start().isDefined() && this.end().isDefined() ? Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(this.start().get(), this.end().get())) : None$.MODULE$), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)fileSize)));
    }

    public String toContentRange$default$2() {
        return ContentRangeUnits$.MODULE$.Bytes();
    }

    public long contentLength() {
        return this.contentLength;
    }

    public boolean isValid(long contentSize) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.start(), this.end());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                long l;
                long _start = l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (option2 instanceof Some) {
                    long _end = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                    return _start <= _end && _end < contentSize;
                }
                long _start2 = l;
                if (None$.MODULE$.equals(option2)) {
                    return _start2 < contentSize;
                }
            }
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                long _end = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                return _end < contentSize;
            }
        }
        return false;
    }

    public Range copy(Option<Object> start, Option<Object> end, String unit) {
        return new Range(start, end, unit);
    }

    public Option<Object> copy$default$1() {
        return this.start();
    }

    public Option<Object> copy$default$2() {
        return this.end();
    }

    public String copy$default$3() {
        return this.unit();
    }

    public Option<Object> _1() {
        return this.start();
    }

    public Option<Object> _2() {
        return this.end();
    }

    public String _3() {
        return this.unit();
    }
}

