/*
 * Decompiled with CFR 0.152.
 */
package sttp.model.internal;

import java.io.Serializable;
import java.util.ArrayList;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sttp.model.internal.ArrayView$;

public class ArrayView<T> {
    private final Object arr;
    private final int from;
    private final int till;

    public static <T> ArrayView<T> apply(Vector<T> vector, ClassTag<T> classTag) {
        return ArrayView$.MODULE$.apply(vector, classTag);
    }

    public static <T> ArrayView<T> empty(ClassTag<T> classTag) {
        return ArrayView$.MODULE$.empty(classTag);
    }

    public ArrayView(Object arr, int from, int till) {
        this.arr = arr;
        this.from = from;
        this.till = till;
    }

    public boolean isEmpty() {
        return this.till <= this.from;
    }

    public boolean nonEmpty() {
        return this.from < this.till;
    }

    public T get(int i) {
        return (T)ScalaRunTime$.MODULE$.array_apply(this.arr, this.from + i);
    }

    public int size() {
        return this.till - this.from;
    }

    public Option<T> headOption() {
        if (this.nonEmpty()) {
            return Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, this.from));
        }
        return None$.MODULE$;
    }

    public boolean startsWith(T t) {
        return this.nonEmpty() && BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(this.arr, this.from), t);
    }

    public Option<T> lastOption() {
        if (this.nonEmpty()) {
            return Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, this.till - 1));
        }
        return None$.MODULE$;
    }

    public void foreach(Function1<T, BoxedUnit> func) {
        for (int i = this.from; i < this.till; ++i) {
            func.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, i));
        }
    }

    public <U> ArrayView<U> map(Function1<T, U> func, ClassTag<U> evidence$1) {
        Object object;
        Object newArray = Arrays$.MODULE$.newGenericArray(this.size(), evidence$1);
        for (int i = 0; i < ArrayOps$.MODULE$.size$extension(object = Predef$.MODULE$.genericArrayOps(newArray)); ++i) {
            ScalaRunTime$.MODULE$.array_update(newArray, i, func.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, i + this.from)));
        }
        Object object2 = Predef$.MODULE$.genericArrayOps(newArray);
        return new ArrayView<T>(newArray, 0, ArrayOps$.MODULE$.size$extension(object2));
    }

    public ArrayView<T> flatMapLike(Function1<T, List<T>> func, ClassTag<T> ev) {
        ArrayBuilder b = ArrayBuilder$.MODULE$.make(ev);
        b.sizeHint(2 * this.size());
        this.foreach((Function1<T, BoxedUnit>)(JProcedure1 & Serializable)t -> ((List)func.apply(t)).foreach((Function1 & Serializable)_$1 -> (ArrayBuilder)b.$plus$eq(_$1)));
        Object result = b.result();
        return new ArrayView<T>(result, 0, ScalaRunTime$.MODULE$.array_length(result));
    }

    public int count(Function1<T, Object> pred) {
        IntRef result = IntRef.create((int)0);
        this.foreach((Function1<T, BoxedUnit>)(JProcedure1 & Serializable)t -> {
            if (BoxesRunTime.unboxToBoolean((Object)pred.apply(t))) {
                ++result$1.elem;
                return;
            }
        });
        return result.elem;
    }

    public String mkString(Function1<T, String> transform) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = this.from; i < this.till; ++i) {
            sb.append((String)transform.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, i)));
        }
        return sb.toString();
    }

    public Option<String> mkStringOpt(Function1<T, Option<String>> transform) {
        StringBuilder sb = new StringBuilder(128);
        BooleanRef empty = BooleanRef.create((boolean)true);
        for (int i = this.from; i < this.till; ++i) {
            ((Option)transform.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, i))).foreach((Function1)(JProcedure1 & Serializable)str -> {
                sb.append((String)str);
                empty$1.elem = false;
            });
        }
        if (empty.elem) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)sb.toString());
    }

    public int indexOf(T t) {
        int i;
        for (i = this.from; i < this.till && !BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(this.arr, i), t); ++i) {
        }
        if (i == this.till) {
            return -1;
        }
        return i - this.from;
    }

    public int indexWhere(Function1<T, Object> pred) {
        int i;
        for (i = this.from; i < this.till && !BoxesRunTime.unboxToBoolean((Object)pred.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, i))); ++i) {
        }
        if (i == this.till) {
            return -1;
        }
        return i - this.from;
    }

    public ArrayView<T> take(int i) {
        return new ArrayView<T>(this.arr, this.from, this.from + i);
    }

    public ArrayView<T> drop(int i) {
        return new ArrayView<T>(this.arr, this.from + i, this.till);
    }

    public ArrayView<T> dropWhile(Function1<T, Object> pred) {
        int i;
        int len = ScalaRunTime$.MODULE$.array_length(this.arr);
        for (i = this.from; i < len && BoxesRunTime.unboxToBoolean((Object)pred.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, i))); ++i) {
        }
        return new ArrayView<T>(this.arr, i, this.till);
    }

    public Tuple2<ArrayView<T>, ArrayView<T>> span(Function1<T, Object> pred) {
        int i;
        for (i = this.from; i < this.till && BoxesRunTime.unboxToBoolean((Object)pred.apply(ScalaRunTime$.MODULE$.array_apply(this.arr, i))); ++i) {
        }
        return Tuple2$.MODULE$.apply(new ArrayView<T>(this.arr, this.from, i), new ArrayView<T>(this.arr, i + 1, this.till));
    }

    public ArrayView<T> shiftLeft() {
        return new ArrayView<T>(this.arr, this.from - 1, this.till);
    }

    public ArrayView<T> $plus$colon(T t, ClassTag<T> ev) {
        int currentSize = this.size();
        Object newArr = Arrays$.MODULE$.newGenericArray(currentSize + 1, ev);
        ScalaRunTime$.MODULE$.array_update(newArr, 0, t);
        Array$.MODULE$.copy(this.arr, this.from, newArr, 1, currentSize);
        return new ArrayView<T>(newArr, 0, currentSize + 1);
    }

    public Vector<T> toVector() {
        VectorBuilder b = new VectorBuilder();
        b.sizeHint(this.size());
        this.foreach((Function1<T, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> b.$plus$eq(_$2));
        return b.result();
    }

    public String toString() {
        ArrayList list = new ArrayList(this.size());
        this.foreach((Function1<T, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> list.add(_$3));
        return list.toString();
    }
}

