/*
 * Decompiled with CFR 0.152.
 */
package sttp.model.internal;

import java.io.Serializable;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar;
import scala.runtime.ScalaRunTime$;
import sttp.model.internal.Rfc3986Compatibility$;

public final class Rfc3986$
implements Serializable {
    private static final Set AlphaNum;
    private static final Set Unreserved;
    private static final Set SubDelims;
    private static final Set PChar;
    private static final Set Scheme;
    private static final Set UserInfo;
    private static final Set Host;
    private static final Set PathSegment;
    private static final Set Query;
    private static final Set Fragment;
    private static final Set QueryWithBrackets;
    public static final Rfc3986$ MODULE$;

    private Rfc3986$() {
    }

    static {
        MODULE$ = new Rfc3986$();
        AlphaNum = ((IterableOnceOps)((IterableOps)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')))).$plus$plus((IterableOnce)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')))).toSet();
        Unreserved = (Set)MODULE$.AlphaNum().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'-', '.', '_', '~'})));
        SubDelims = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='}));
        PChar = (Set)MODULE$.Unreserved().$plus$plus(MODULE$.SubDelims()).$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{':', '@'})));
        Scheme = (Set)MODULE$.AlphaNum().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'+', '-', '.'})));
        UserInfo = (Set)MODULE$.Unreserved().$plus$plus(MODULE$.SubDelims());
        Host = (Set)MODULE$.Unreserved().$plus$plus(MODULE$.SubDelims());
        PathSegment = MODULE$.PChar();
        Query = (Set)MODULE$.PChar().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'/', '?'})));
        Fragment = MODULE$.Query();
        QueryWithBrackets = (Set)MODULE$.Query().$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{'[', ']'})));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Rfc3986$.class);
    }

    public Set<Object> AlphaNum() {
        return AlphaNum;
    }

    public Set<Object> Unreserved() {
        return Unreserved;
    }

    public Set<Object> SubDelims() {
        return SubDelims;
    }

    public Set<Object> PChar() {
        return PChar;
    }

    public Set<Object> Scheme() {
        return Scheme;
    }

    public Set<Object> UserInfo() {
        return UserInfo;
    }

    public Set<Object> Host() {
        return Host;
    }

    public Set<Object> PathSegment() {
        return PathSegment;
    }

    public Set<Object> Query() {
        return Query;
    }

    public Set<Object> Fragment() {
        return Fragment;
    }

    public Set<Object> QueryWithBrackets() {
        return QueryWithBrackets;
    }

    public String encode(Set<Object> allowedCharacters, boolean spaceAsPlus, boolean encodePlus, String s) {
        return this.encode(s, "UTF-8", allowedCharacters, spaceAsPlus, encodePlus);
    }

    public boolean encode$default$2() {
        return false;
    }

    public boolean encode$default$3() {
        return false;
    }

    public String encode(String s, String enc, Set<Object> allowedCharacters) {
        return this.encode(s, enc, allowedCharacters, false, false);
    }

    private String encode(String s, String enc, Set<Object> allowedCharacters, boolean spaceAsPlus, boolean encodePlus) {
        StringBuilder sb = new StringBuilder();
        byte[] bytes = s.getBytes(enc);
        for (int i = 0; i < bytes.length; ++i) {
            StringBuilder stringBuilder;
            byte b = bytes[i];
            char c = (char)(b & 0xFF);
            if (c == '+' && encodePlus) {
                stringBuilder = sb.append("%2B");
                continue;
            }
            if (allowedCharacters.apply((Object)BoxesRunTime.boxToCharacter((char)c))) {
                stringBuilder = sb.append(c);
                continue;
            }
            if (c == ' ' && spaceAsPlus) {
                stringBuilder = sb.append('+');
                continue;
            }
            sb.append("%");
            stringBuilder = sb.append(Rfc3986Compatibility$.MODULE$.formatByte(b));
        }
        return sb.toString();
    }

    public String decode(boolean plusAsSpace, String s, String enc) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        char c = '\u0000';
        byte[] bytes = null;
        while (i < numChars) {
            c = s.charAt(i);
            char c2 = c;
            if ('+' == c2 && plusAsSpace) {
                sb.append(' ');
                ++i;
                needToChange = true;
                continue;
            }
            if ('%' == c2) {
                try {
                    if (bytes == null) {
                        bytes = new byte[(numChars - i) / 3];
                    }
                    int pos = 0;
                    while (i + 2 < numChars && c == '%') {
                        int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                        if (v < 0) {
                            throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                        }
                        bytes[pos] = (byte)v;
                        ++pos;
                        if ((i += 3) >= numChars) continue;
                        c = s.charAt(i);
                    }
                    if (i < numChars && c == '%') {
                        throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                    }
                    sb.append(new String(bytes, 0, pos, enc));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(59).append("URLDecoder: Illegal hex characters in escape (%) pattern - ").append(e.getMessage()).toString());
                }
                needToChange = true;
                continue;
            }
            sb.append(c);
            ++i;
        }
        if (needToChange) {
            return sb.toString();
        }
        return s;
    }

    public boolean decode$default$1() {
        return false;
    }

    public String decode$default$3(boolean plusAsSpace) {
        return "utf-8";
    }
}

