/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.time.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.TickCounter;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ$;
import org.nlogo.core.ExtensionObject;
import org.nlogo.extensions.time.AddType;
import org.nlogo.extensions.time.DateType;
import org.nlogo.extensions.time.Default$;
import org.nlogo.extensions.time.Month$;
import org.nlogo.extensions.time.PeriodType;
import org.nlogo.extensions.time.Repeat$;
import org.nlogo.extensions.time.RepeatShuffled$;
import org.nlogo.extensions.time.Shuffle$;
import org.nlogo.extensions.time.TimeUtils$;
import org.nlogo.extensions.time.Year$;
import org.nlogo.extensions.time.datatypes.LogoEvent;
import org.nlogo.extensions.time.datatypes.LogoEventComparator$;
import org.nlogo.extensions.time.datatypes.LogoTime;
import org.nlogo.nvm.AnonymousCommand;
import org.nlogo.nvm.ExtensionContext;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public class LogoSchedule
implements ExtensionObject {
    private TreeSet<LogoEvent> scheduleTree = new TreeSet(LogoEventComparator$.MODULE$);
    private TickCounter tickCounter = null;
    private LogoTime timeAnchor = null;
    private PeriodType tickType = null;
    private Double tickValue = null;

    public TreeSet<LogoEvent> scheduleTree() {
        return this.scheduleTree;
    }

    public void scheduleTree_$eq(TreeSet<LogoEvent> x$1) {
        this.scheduleTree = x$1;
    }

    public TickCounter tickCounter() {
        return this.tickCounter;
    }

    public void tickCounter_$eq(TickCounter x$1) {
        this.tickCounter = x$1;
    }

    public LogoTime timeAnchor() {
        return this.timeAnchor;
    }

    public void timeAnchor_$eq(LogoTime x$1) {
        this.timeAnchor = x$1;
    }

    public PeriodType tickType() {
        return this.tickType;
    }

    public void tickType_$eq(PeriodType x$1) {
        this.tickType = x$1;
    }

    public Double tickValue() {
        return this.tickValue;
    }

    public void tickValue_$eq(Double x$1) {
        this.tickValue = x$1;
    }

    public boolean equals(Object obj) {
        LogoSchedule logoSchedule = this;
        Object object = obj;
        return !(logoSchedule != null ? !((Object)logoSchedule).equals(object) : object != null);
    }

    public Boolean isAnchored() {
        return Predef$.MODULE$.boolean2Boolean(this.timeAnchor() != null);
    }

    public void anchorSchedule(LogoTime time, Double tickValue, PeriodType tickType) {
        try {
            this.timeAnchor_$eq(new LogoTime(time));
            this.tickType_$eq(tickType);
            this.tickValue_$eq(tickValue);
        }
        catch (ExtensionException e) {
            e.printStackTrace();
        }
    }

    public Double timeToTick(LogoTime time) throws ExtensionException {
        DateType dateType = this.timeAnchor().dateType();
        DateType dateType2 = time.dateType();
        if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
            throw new ExtensionException("Cannot schedule event to occur at a LogoTime of type " + time.dateType().toString() + " because the schedule is anchored to a LogoTime of type " + this.timeAnchor().dateType().toString() + ".  Types must be consistent.");
        }
        return Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(this.timeAnchor().getDifferenceBetween(this.tickType(), time)) / Predef$.MODULE$.Double2double(this.tickValue()));
    }

    /*
     * Unable to fully structure code
     */
    public void addEvent(Argument[] args, Context context, AddType addType) throws ExtensionException {
        block39: {
            block38: {
                var5_4 = addType;
                if (Default$.MODULE$.equals(var5_4)) {
                    if (args.length < 3) {
                        throw new ExtensionException("time:add must have 3 arguments: schedule agent task tick/time");
                    }
                    v0 = "add";
                } else if (Shuffle$.MODULE$.equals(var5_4)) {
                    if (args.length < 3) {
                        throw new ExtensionException("time:add-shuffled must have 3 arguments: schedule agent task tick/time");
                    }
                    v0 = "add-shuffled";
                } else if (Repeat$.MODULE$.equals(var5_4)) {
                    if (args.length < 4) {
                        throw new ExtensionException("time:repeat must have 4 or 5 arguments:\n            schedule agent task tick/time number (period-type)");
                    }
                    v0 = "repeat";
                } else if (RepeatShuffled$.MODULE$.equals(var5_4)) {
                    if (args.length < 4) {
                        throw new ExtensionException("time:repeat-shuffled must have 4 or 5 arguments: schedule agent task tick/time number (period-type)");
                    }
                    v0 = "repeat-shuffled";
                } else {
                    throw new MatchError((Object)var5_4);
                }
                primName = v0;
                if (args[0].get() instanceof Agent || args[0].get() instanceof AgentSet) ** GOTO lbl-1000
                if (!(args[0].get() instanceof String)) ** GOTO lbl-1000
                v1 = args[0].get().toString().toLowerCase();
                var7_6 = "observer";
                if (v1 == null ? var7_6 != null : v1.equals(var7_6) == false) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = isInvalidEventArgument = false;
                }
                if (isInvalidEventArgument) {
                    throw new ExtensionException("time: " + primName + " expected an agent, agentset, or the string 'observer' as the first argument");
                }
                if (!(args[1].get() instanceof AnonymousCommand)) {
                    throw new ExtensionException("time: " + primName + " expecting a command task as the second argument");
                }
                if (((AnonymousCommand)args[1].get()).formals().length > 0) {
                    throw new ExtensionException("time: " + primName + " expecting as the second argument a command task that takes no arguments of\n       its own, but found a task which expects its own arguments, this kind of task is unsupported by\n       the time extension.");
                }
                v3 = clazz = (var9_8 = args[2].get().getClass());
                var11_10 = Double.class;
                if (!(v3 != null ? v3.equals(var11_10) == false : var11_10 != null)) {
                    v4 = Predef$.MODULE$.double2Double(args[2].getDoubleValue());
                } else {
                    v5 = clazz = var9_8;
                    var13_12 = LogoTime.class;
                    if (!(v5 != null ? v5.equals(var13_12) == false : var13_12 != null)) {
                        if (!Predef$.MODULE$.Boolean2boolean(this.isAnchored())) {
                            throw new ExtensionException("A LogoEvent can only be scheduled to occur at a LogoTime\n            if the discrete event schedule has been anchored to a LogoTime, see time:anchor-schedule");
                        }
                        v4 = this.timeToTick(TimeUtils$.MODULE$.getTimeFromArgument(args, Predef$.MODULE$.int2Integer(2)));
                    } else {
                        throw new ExtensionException("time: " + primName + " expecting a number or logotime as the third argument");
                    }
                }
                eventTick = v4;
                if (Predef$.MODULE$.Double2double(eventTick) < ((ExtensionContext)context).workspace().world().ticks()) {
                    throw new ExtensionException("Attempted to schedule an event for tick " + eventTick + " which is\n        before the present 'moment' of " + ((ExtensionContext)context).workspace().world().ticks());
                }
                repeatIntervalPeriodType = null;
                repeatInterval = null;
                v6 = addType;
                var16_16 = Repeat$.MODULE$;
                if (!(v6 == null ? var16_16 != null : v6.equals(var16_16) == false)) break block38;
                v7 = addType;
                var17_17 = RepeatShuffled$.MODULE$;
                if (v7 != null ? v7.equals(var17_17) == false : var17_17 != null) break block39;
            }
            v8 = args[3].get().getClass();
            var18_18 = Double.class;
            if (v8 == null ? var18_18 != null : v8.equals(var18_18) == false) {
                throw new ExtensionException("time repeat expecting a number as the fourth argument");
            }
            repeatInterval = Predef$.MODULE$.double2Double(args[3].getDoubleValue());
            if (Predef$.MODULE$.Double2double(repeatInterval) <= (double)false) {
                throw new ExtensionException("time repeat the repeat interval must be a positive number");
            }
            if (args.length == 5) {
                if (!Predef$.MODULE$.Boolean2boolean(this.isAnchored())) {
                    throw new ExtensionException("A LogoEvent can only be scheduled to repeat using a period type if the discrete\n              event schedule has been anchored to a LogoTime, see time:anchor-schedule");
                }
                v9 = repeatIntervalPeriodType = TimeUtils$.MODULE$.stringToPeriodType(TimeUtils$.MODULE$.getStringFromArgument(args, Predef$.MODULE$.int2Integer(4)));
                var19_19 = Month$.MODULE$;
                if (v9 == null ? var19_19 != null : v9.equals(var19_19) == false) {
                    v10 = repeatIntervalPeriodType;
                    var20_20 = Year$.MODULE$;
                    if (v10 == null ? var20_20 != null : v10.equals(var20_20) == false) {
                        repeatInterval = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(this.timeAnchor().getDifferenceBetween(this.tickType(), this.timeAnchor().plus(repeatIntervalPeriodType, repeatInterval))) / Predef$.MODULE$.Double2double(this.tickValue()));
                        repeatIntervalPeriodType = null;
                    }
                }
            }
        }
        v11 = addType;
        var22_21 = Shuffle$.MODULE$;
        if (!(v11 == null ? var22_21 != null : v11.equals(var22_21) == false)) ** GOTO lbl-1000
        v12 = addType;
        var23_22 = RepeatShuffled$.MODULE$;
        if (!(v12 != null ? v12.equals(var23_22) == false : var23_22 != null)) lbl-1000:
        // 2 sources

        {
            v13 = true;
        } else {
            v13 = false;
        }
        shuffleAgentSet = v13;
        var25_24 = args[0].get();
        if (var25_24 instanceof Agent) {
            agent = (Agent)var25_24;
            theAgent = (Agent)args[0].getAgent();
            v14 = new ArrayAgentSet((AgentKind)AgentKindJ$.MODULE$.Turtle(), theAgent.toString(), new Agent[]{theAgent});
        } else if (var25_24 instanceof AgentSet) {
            agentset = (AgentSet)var25_24;
            v14 = (AgentSet)args[0].getAgentSet();
        } else {
            v14 = null;
        }
        agentSet = v14;
        event = new LogoEvent((AgentSet)agentSet, (AnonymousCommand)args[1].getCommand(), eventTick, repeatInterval, repeatIntervalPeriodType, Predef$.MODULE$.boolean2Boolean(shuffleAgentSet));
        this.scheduleTree().add(event);
    }

    public TickCounter getTickCounter() {
        TickCounter tickCounter = this.tickCounter();
        if (tickCounter == null) {
            throw new ExtensionException("Tick counter has not been initialized in time extension.");
        }
        TickCounter tc = tickCounter;
        return tc;
    }

    public TickCounter getTickCounter(ExtensionContext context) {
        TickCounter tickCounter = this.tickCounter();
        if (tickCounter == null) {
            this.tickCounter_$eq(context.workspace().world().tickCounter());
            return this.tickCounter();
        }
        TickCounter tc = tickCounter;
        return tc;
    }

    public void updateTickCounter(ExtensionContext context) {
        context.workspace().requestDisplayUpdate(false);
    }

    public void performScheduledTasks(Argument[] args, Context context) {
        this.performScheduledTasks(args, context, Predef$.MODULE$.double2Double(Double.MAX_VALUE));
    }

    public void performScheduledTasks(Argument[] args, Context context, LogoTime untilTime) {
        if (!Predef$.MODULE$.Boolean2boolean(this.isAnchored())) {
            throw new ExtensionException("time:go-until can only accept a LogoTime as a stopping time if the schedule is anchored\n         using time:anchor-schedule");
        }
        Double untilTick = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(this.timeAnchor().getDifferenceBetween(this.tickType(), untilTime)) / Predef$.MODULE$.Double2double(this.tickValue()));
        this.performScheduledTasks(args, context, untilTick);
    }

    public void performScheduledTasks(Argument[] args, Context context, Double untilTick) {
        ExtensionContext extcontext = (ExtensionContext)context;
        Object[] emptyArgs = new Object[1];
        ObjectRef event = ObjectRef.create(this.scheduleTree().isEmpty() ? null : this.scheduleTree().first());
        while ((LogoEvent)event.elem != null && Predef$.MODULE$.Double2double(((LogoEvent)event.elem).tick()) <= Predef$.MODULE$.Double2double(untilTick)) {
            Object object;
            this.getTickCounter(extcontext).tick(Predef$.MODULE$.Double2double(((LogoEvent)event.elem).tick()) - this.getTickCounter(extcontext).ticks());
            AgentSet agentSet = ((LogoEvent)event.elem).agents();
            if (agentSet == null) {
                org.nlogo.nvm.Context nvmContext = new org.nlogo.nvm.Context(extcontext.nvmContext().job, (Agent)extcontext.getAgent().world().observer(), extcontext.nvmContext().ip, extcontext.nvmContext().activation, extcontext.workspace());
                ((LogoEvent)event.elem).task().perform(nvmContext, emptyArgs);
                object = BoxedUnit.UNIT;
            } else {
                AgentIterator iter = Predef$.MODULE$.Boolean2boolean(((LogoEvent)event.elem).shuffleAgentSet()) ? ((LogoEvent)event.elem).agents().shufflerator(extcontext.nvmContext().job.random) : ((LogoEvent)event.elem).agents().iterator();
                ArrayList<Agent> copy = new ArrayList<Agent>();
                while (iter.hasNext()) {
                    copy.add(iter.next());
                }
                object = CollectionConverters$.MODULE$.ListHasAsScala(copy).asScala().dropWhile((Function1 & Serializable)agent -> {
                    if (agent == null || agent.id() == -1L) {
                        return false;
                    }
                    org.nlogo.nvm.Context nvmContext = new org.nlogo.nvm.Context(extcontext$1.nvmContext().job, agent, extcontext$1.nvmContext().ip, extcontext$1.nvmContext().activation, extcontext.workspace());
                    if (extcontext$1.nvmContext().stopping) {
                        return false;
                    }
                    ((LogoEvent)event$1.elem).task().perform(nvmContext, emptyArgs);
                    return !nvmContext.stopping;
                });
            }
            this.scheduleTree().remove((LogoEvent)event.elem);
            ((LogoEvent)event.elem).reschedule(this);
            event.elem = this.scheduleTree().isEmpty() ? null : this.scheduleTree().first();
        }
        if (untilTick != null && Predef$.MODULE$.Double2double(untilTick) < Double.MAX_VALUE && Predef$.MODULE$.Double2double(untilTick) > this.getTickCounter(extcontext).ticks()) {
            this.getTickCounter(extcontext).tick(Predef$.MODULE$.Double2double(untilTick) - this.getTickCounter(extcontext).ticks());
        }
        this.updateTickCounter(extcontext);
    }

    public LogoTime getCurrentTime() {
        if (!Predef$.MODULE$.Boolean2boolean(this.isAnchored())) {
            return null;
        }
        return this.timeAnchor().plus(this.tickType(), Predef$.MODULE$.double2Double(this.getTickCounter().ticks() / Predef$.MODULE$.Double2double(this.tickValue())));
    }

    public String dump(boolean readable, boolean exporting, boolean reference) {
        StringBuilder buf = new StringBuilder();
        if (exporting) {
            buf.append("LogoSchedule");
            if (!reference) {
                buf.append(":");
            }
        }
        if (!reference || !exporting) {
            buf.append(" [ ");
            Iterator<LogoEvent> iter = this.scheduleTree().iterator();
            while (iter.hasNext()) {
                buf.append(iter.next().dump(true, true, true) + " ");
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public String getExtensionName() {
        return "time";
    }

    public String getNLTypeName() {
        return "schedule";
    }

    public boolean recursivelyEqual(Object arg0) {
        return this.equals(arg0);
    }

    public void clear() {
        this.scheduleTree().clear();
    }
}

