/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.time.datatypes;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import org.nlogo.agent.World;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.ExtensionObject;
import org.nlogo.extensions.time.Date$;
import org.nlogo.extensions.time.DateTime$;
import org.nlogo.extensions.time.DateType;
import org.nlogo.extensions.time.Day$;
import org.nlogo.extensions.time.DayDate$;
import org.nlogo.extensions.time.DayOfWeek$;
import org.nlogo.extensions.time.DayOfYear$;
import org.nlogo.extensions.time.Hour$;
import org.nlogo.extensions.time.Milli$;
import org.nlogo.extensions.time.Minute$;
import org.nlogo.extensions.time.Month$;
import org.nlogo.extensions.time.PeriodType;
import org.nlogo.extensions.time.Second$;
import org.nlogo.extensions.time.TimeUtils$;
import org.nlogo.extensions.time.Week$;
import org.nlogo.extensions.time.Year$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public class LogoTime
implements ExtensionObject {
    private DateType dateType;
    private LocalDateTime datetime;
    private LocalDate date;
    private MonthDay monthDay;
    private DateTimeFormatter customFmt;
    private DateTimeFormatter defaultFmt;
    private Boolean isAnchored;
    private Double tickValue;
    private PeriodType tickType;
    private LocalDateTime anchorDatetime;
    private LocalDate anchorDate;
    private MonthDay anchorMonthDay;
    private World world;

    public LogoTime() {
        this.dateType = DateTime$.MODULE$;
        this.datetime = null;
        this.date = null;
        this.monthDay = null;
        this.customFmt = null;
        this.defaultFmt = new DateTimeFormatterBuilder().parseStrict().appendPattern("uuuu-MM-dd HH:mm:ss.").parseLenient().appendPattern("SSS").toFormatter();
        this.isAnchored = Predef$.MODULE$.boolean2Boolean(false);
        this.tickValue = Predef$.MODULE$.double2Double(0.0);
        this.tickType = null;
        this.anchorDatetime = null;
        this.anchorDate = null;
        this.anchorMonthDay = null;
        this.world = null;
    }

    public DateType dateType() {
        return this.dateType;
    }

    public void dateType_$eq(DateType x$1) {
        this.dateType = x$1;
    }

    public LocalDateTime datetime() {
        return this.datetime;
    }

    public void datetime_$eq(LocalDateTime x$1) {
        this.datetime = x$1;
    }

    public LocalDate date() {
        return this.date;
    }

    public void date_$eq(LocalDate x$1) {
        this.date = x$1;
    }

    public MonthDay monthDay() {
        return this.monthDay;
    }

    public void monthDay_$eq(MonthDay x$1) {
        this.monthDay = x$1;
    }

    private DateTimeFormatter customFmt() {
        return this.customFmt;
    }

    private void customFmt_$eq(DateTimeFormatter x$0) {
        this.customFmt = x$0;
    }

    private DateTimeFormatter defaultFmt() {
        return this.defaultFmt;
    }

    private void defaultFmt_$eq(DateTimeFormatter x$0) {
        this.defaultFmt = x$0;
    }

    public LogoTime(LocalDateTime dt) throws ExtensionException {
        this();
        this.datetime_$eq(dt);
    }

    /*
     * Unable to fully structure code
     */
    public LogoTime(String dateStringArg, Option<String> customFormat) throws ExtensionException {
        block20: {
            this();
            dateString = dateStringArg.replace('T', ' ').replace('Y', 'y');
            var4_4 = customFormat;
            if (None$.MODULE$.equals(var4_4)) {
                dateString = this.parseDateString(dateString).replace('T', ' ');
            } else if (var4_4 instanceof Some) {
                customForm = (String)((Some)var4_4).value();
                this.dateType_$eq(customForm.indexOf(72) >= 0 || customForm.indexOf(104) >= 0 || customForm.indexOf(83) >= 0 || customForm.indexOf(115) >= 0 || customForm.indexOf(75) >= 0 || customForm.indexOf(107) >= 0 || customForm.indexOf(109) >= 0 ? DateTime$.MODULE$ : (DateType)(customForm.indexOf(89) >= 0 || customForm.indexOf(121) >= 0 ? Date$.MODULE$ : DayDate$.MODULE$));
            } else {
                throw new MatchError(var4_4);
            }
            var6_6 = this.dateType();
            if (DateTime$.MODULE$.equals(var6_6)) {
                v0 = new DateTimeFormatterBuilder().parseStrict().appendPattern("uuuu-MM-dd HH:mm:ss.").parseLenient().appendPattern("SSS").toFormatter().withResolverStyle(ResolverStyle.STRICT);
            } else if (Date$.MODULE$.equals(var6_6)) {
                v0 = DateTimeFormatter.ofPattern("uuuu-MM-dd").withResolverStyle(ResolverStyle.STRICT);
            } else if (DayDate$.MODULE$.equals(var6_6)) {
                v0 = DateTimeFormatter.ofPattern("MM-dd").withResolverStyle(ResolverStyle.STRICT);
            } else {
                throw new MatchError((Object)var6_6);
            }
            this.defaultFmt_$eq(v0);
            try {
                block21: {
                    block22: {
                        var7_7 = customFormat;
                        if (!None$.MODULE$.equals(var7_7)) break block21;
                        dateString = dateString.replace(' ', 'T').replace('/', '-');
                        var8_8 = this.dateType();
                        if (!DateTime$.MODULE$.equals(var8_8)) break block22;
                        if (dateString.length() == 0) ** GOTO lbl-1000
                        v1 = dateString;
                        var9_9 = "now";
                        if (!(v1 != null ? v1.equals(var9_9) == false : var9_9 != null)) lbl-1000:
                        // 2 sources

                        {
                            v2 = LocalDateTime.now();
                        } else {
                            v2 = LocalDateTime.parse(dateString);
                        }
                        this.datetime_$eq(v2);
                        break block20;
                    }
                    if (Date$.MODULE$.equals(var8_8)) {
                        this.date_$eq(LocalDate.parse(dateString));
                        break block20;
                    }
                    if (DayDate$.MODULE$.equals(var8_8)) {
                        this.monthDay_$eq(MonthDay.parse(dateString, this.defaultFmt()));
                        break block20;
                    }
                    throw new MatchError((Object)var8_8);
                }
                if (var7_7 instanceof Some) {
                    customForm = (String)((Some)var7_7).value();
                    this.customFmt_$eq(customForm.endsWith("S") != false && StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(customForm), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$adapted$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)()) < 4 ? new DateTimeFormatterBuilder().parseStrict().appendPattern(StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString(customForm), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$adapted$2(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Boolean;)()).replace('Y', 'y').replace('y', 'u')).parseStrict().appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, false).toFormatter().withResolverStyle(ResolverStyle.STRICT) : new DateTimeFormatterBuilder().parseStrict().appendPattern(customForm.replace('Y', 'y').replace('y', 'u')).toFormatter().withResolverStyle(ResolverStyle.STRICT));
                    var11_11 = this.dateType();
                    if (DateTime$.MODULE$.equals(var11_11)) {
                        this.datetime_$eq(LocalDateTime.parse(dateString, this.customFmt()));
                        break block20;
                    }
                    if (Date$.MODULE$.equals(var11_11)) {
                        this.date_$eq(LocalDate.parse(dateString, this.customFmt()));
                        break block20;
                    }
                    if (DayDate$.MODULE$.equals(var11_11)) {
                        this.monthDay_$eq(MonthDay.parse(dateString, this.customFmt()));
                        break block20;
                    }
                    throw new MatchError((Object)var11_11);
                }
                throw new MatchError(var7_7);
            }
            catch (DateTimeParseException e) {
                throw new ExtensionException("Extension could not parse input: " + dateString + " and " + customFormat);
            }
        }
    }

    public LogoTime(String dateString) {
        this(dateString, (Option<String>)None$.MODULE$);
    }

    public LogoTime(String dateString, DateTimeFormatter dateFormat, DateType datetype) {
        this();
        this.dateType_$eq(datetype);
        this.customFmt_$eq(dateFormat);
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            this.datetime_$eq(LocalDateTime.parse(dateString, dateFormat));
        } else if (Date$.MODULE$.equals(dateType)) {
            this.date_$eq(LocalDate.parse(dateString, dateFormat));
        } else if (DayDate$.MODULE$.equals(dateType)) {
            this.monthDay_$eq(MonthDay.parse(dateString, dateFormat));
        } else {
            throw new MatchError((Object)dateType);
        }
    }

    public LogoTime(LogoTime time) {
        this(time.show(time.customFmt() == null ? time.defaultFmt() : time.customFmt()), time.customFmt() == null ? time.defaultFmt() : time.customFmt(), time.dateType());
    }

    public LogoTime(LocalDate dt) {
        this();
        this.date_$eq(dt);
        this.defaultFmt_$eq(DateTimeFormatter.ofPattern("uuuu-MM-dd").withResolverStyle(ResolverStyle.STRICT));
        this.dateType_$eq(Date$.MODULE$);
    }

    public LogoTime(MonthDay dt) {
        this();
        this.monthDay_$eq(dt);
        this.defaultFmt_$eq(DateTimeFormatter.ofPattern("MM-dd").withResolverStyle(ResolverStyle.STRICT));
        this.dateType_$eq(DayDate$.MODULE$);
    }

    public int compareTo(LogoTime that) {
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            return this.datetime().compareTo(that.datetime());
        }
        if (Date$.MODULE$.equals(dateType)) {
            return this.date().compareTo(that.date());
        }
        if (DayDate$.MODULE$.equals(dateType)) {
            return this.monthDay().compareTo(that.monthDay());
        }
        throw new MatchError((Object)dateType);
    }

    public Boolean isCloserToAThanB(LogoTime timeA, LogoTime timeB) {
        LocalDateTime refDateTime = LocalDateTime.now(ZoneOffset.UTC);
        Long millisToA = null;
        Long millisToB = null;
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            millisToA = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeA.datetime().with(refDateTime), this.datetime().with(refDateTime)).toMillis()));
            millisToB = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeB.datetime().with(refDateTime), this.datetime().with(refDateTime)).toMillis()));
        } else if (Date$.MODULE$.equals(dateType)) {
            millisToA = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeA.date().with(refDateTime), this.date().with(refDateTime)).toMillis()));
            millisToB = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeB.date().with(refDateTime), this.date().with(refDateTime)).toMillis()));
        } else if (DayDate$.MODULE$.equals(dateType)) {
            millisToA = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeA.monthDay().atYear(2000).with(refDateTime), this.monthDay().atYear(2000).with(refDateTime)).toMillis()));
            millisToB = Predef$.MODULE$.long2Long(Math.abs(Duration.between(timeB.monthDay().atYear(2000).with(refDateTime), this.monthDay().atYear(2000).with(refDateTime)).toMillis()));
        } else {
            throw new MatchError((Object)dateType);
        }
        return Predef$.MODULE$.boolean2Boolean(Predef$.MODULE$.Long2long(millisToA) < Predef$.MODULE$.Long2long(millisToB));
    }

    public String parseDateString(String dateStringT) throws ExtensionException {
        Object object;
        char delimiter = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(dateStringT), '-') ? (char)'-' : '/';
        String dateString = dateStringT.replace('/', '-').replace(' ', 'T');
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])dateString.split("T"));
        String[] timefragments = (String[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$3 -> _$3.trim(), ClassTag$.MODULE$.apply(String.class));
        String string = dateString;
        if ("".equals(string)) {
            object = "";
        } else if ("now".equals(string)) {
            object = "now";
        } else {
            String str = string;
            if (timefragments.length == 2 && StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(dateString), '-')) {
                this.dateType_$eq(DateTime$.MODULE$);
                object = this.parseDate(timefragments[0]) + "T" + this.parseTime(timefragments[1]);
            } else {
                String str2 = string;
                if (timefragments.length == 1 && !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(str2), ':') && StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(str2), '-')) {
                    if (str2.length() < 6) {
                        this.dateType_$eq(DayDate$.MODULE$);
                    } else {
                        this.dateType_$eq(Date$.MODULE$);
                    }
                    object = this.parseDate(timefragments[0]);
                } else {
                    String str3 = string;
                    throw new ExtensionException("Invalid string fragment: " + str3);
                }
            }
        }
        return ((String)object).replace('-', delimiter);
    }

    public String formatToLength(String dateString, int desiredLength) {
        if (dateString.length() >= desiredLength) {
            return dateString;
        }
        return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), desiredLength - dateString.length()) + dateString;
    }

    public String parseDate(String dateTimeStr) throws ExtensionException {
        String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(dateTimeStr), '-');
        if (stringArray != null) {
            String string;
            Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0 && "".equals(string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0))) {
                return "";
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 3) == 0) {
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String string4 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
                String date1 = string2;
                String date2 = string3;
                String date3 = string4;
                if (dateTimeStr.length() < 11 || date1.length() != 3 || date2.length() != 3 || date1.length() != 3) {
                    return this.formatToLength(date1, 2) + "-" + this.formatToLength(date2, 2) + "-" + this.formatToLength(date3, 2);
                }
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                String string5 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string6 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String date1 = string5;
                String date2 = string6;
                if (dateTimeStr.length() < 6) {
                    return this.formatToLength(date1, 2) + "-" + this.formatToLength(date2, 2);
                }
            }
        }
        throw new ExtensionException("Illegal Date String(DateTime Error)");
    }

    public String parseTime(String dateTimeStr) throws ExtensionException {
        String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(dateTimeStr), ':');
        if (stringArray != null) {
            Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 3) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2);
                String hour = string;
                String minute = string2;
                String second = string3;
                if ((hour + ":" + minute + ":").length() < 7) {
                    return this.formatToLength(hour, 2) + ":" + this.formatToLength(minute, 2) + ":" + this.formatSeconds$1().apply((Object)second);
                }
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                String string4 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                String hour = string;
                String minute = string4;
                if (dateTimeStr.length() < 6) {
                    return this.formatToLength(hour, 2) + ":" + this.formatToLength(minute, 2) + ":00.000";
                }
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0) {
                String string;
                String hour = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                if (dateTimeStr.length() < 3) {
                    return this.formatToLength(hour, 2) + ":00:00.000";
                }
            }
        }
        String[] tstr = stringArray;
        throw new ExtensionException("Invalid Time String: " + tstr);
    }

    public void setAnchor(Double tickCount, PeriodType tickType, World world) {
        PeriodType periodType = tickType;
        DayOfWeek$ dayOfWeek$ = DayOfWeek$.MODULE$;
        if (!(periodType != null ? !periodType.equals(dayOfWeek$) : dayOfWeek$ != null)) {
            throw new ExtensionException(tickType.toString() + " type is not a supported tick type");
        }
        this.isAnchored = Predef$.MODULE$.boolean2Boolean(true);
        this.tickValue = tickCount;
        this.tickType = tickType;
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            this.anchorDatetime = LocalDateTime.from(this.datetime());
        } else if (Date$.MODULE$.equals(dateType)) {
            this.anchorDate = LocalDate.from(this.date());
        } else if (DayDate$.MODULE$.equals(dateType)) {
            this.anchorMonthDay = MonthDay.from(this.monthDay());
        } else {
            throw new MatchError((Object)dateType);
        }
        this.world = world;
    }

    public String dump(boolean arg1, boolean arg2, boolean arg3) {
        return this.toString();
    }

    public String toString() {
        try {
            this.updateFromTick();
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            DateTimeFormatter fmt = this.customFmt() == null ? this.defaultFmt() : this.customFmt();
            return this.datetime().format(fmt);
        }
        if (Date$.MODULE$.equals(dateType)) {
            DateTimeFormatter fmt = this.customFmt() == null ? this.defaultFmt() : this.customFmt();
            return this.date().format(fmt);
        }
        if (DayDate$.MODULE$.equals(dateType)) {
            DateTimeFormatter fmt = this.customFmt() == null ? this.defaultFmt() : this.customFmt();
            return this.monthDay().format(fmt);
        }
        throw new MatchError((Object)dateType);
    }

    public void updateFromTick() {
        if (!Predef$.MODULE$.Boolean2boolean(this.isAnchored)) {
            return;
        }
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            this.datetime_$eq(this.plus(this.anchorDatetime, this.tickType, Predef$.MODULE$.double2Double(this.world.ticks() * Predef$.MODULE$.Double2double(this.tickValue))).datetime());
            return;
        }
        if (Date$.MODULE$.equals(dateType)) {
            this.date_$eq(this.plus(this.anchorDate, this.tickType, Predef$.MODULE$.double2Double(this.world.ticks() * Predef$.MODULE$.Double2double(this.tickValue))).date());
            return;
        }
        if (DayDate$.MODULE$.equals(dateType)) {
            this.monthDay_$eq(this.plus(this.anchorMonthDay, this.tickType, Predef$.MODULE$.double2Double(this.world.ticks() * Predef$.MODULE$.Double2double(this.tickValue))).monthDay());
            return;
        }
        throw new MatchError((Object)dateType);
    }

    public String getExtensionName() {
        return "time";
    }

    public String getNLTypeName() {
        return "logotime";
    }

    public boolean recursivelyEqual(Object arg0) {
        return this.equals(arg0);
    }

    public String show(DateTimeFormatter fmt) {
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            return this.datetime().format(fmt);
        }
        if (Date$.MODULE$.equals(dateType)) {
            return this.date().atStartOfDay().format(fmt);
        }
        if (DayDate$.MODULE$.equals(dateType)) {
            return this.monthDay().atYear(2000).atStartOfDay().format(fmt);
        }
        throw new MatchError((Object)dateType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Double get(PeriodType periodType) {
        int n;
        PeriodType periodType2 = periodType;
        if (Milli$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getNano() / 1000000;
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().atStartOfDay().getNano() / 1000000;
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).atStartOfDay().getNano() / 1000000;
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (Second$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getSecond();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().atStartOfDay().getSecond();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).atStartOfDay().getSecond();
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (Minute$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getMinute();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().atStartOfDay().getMinute();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).atStartOfDay().getMinute();
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (Hour$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getHour();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().atStartOfDay().getHour();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).atStartOfDay().getHour();
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (Day$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getDayOfMonth();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().getDayOfMonth();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).getDayOfMonth();
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (DayOfYear$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getDayOfYear();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().getDayOfYear();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).getDayOfYear();
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (DayOfWeek$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getDayOfWeek().getValue();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().getDayOfWeek().getValue();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).getDayOfWeek().getValue();
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (Week$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().get(WeekFields.SUNDAY_START.weekOfYear());
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().get(WeekFields.SUNDAY_START.weekOfYear());
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).get(WeekFields.SUNDAY_START.weekOfYear());
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else if (Month$.MODULE$.equals(periodType2)) {
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getMonthValue();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().getMonthValue();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).getMonthValue();
            }
            return Predef$.MODULE$.double2Double((double)n);
        } else {
            if (!Year$.MODULE$.equals(periodType2)) throw new MatchError((Object)periodType2);
            DateType dateType = this.dateType();
            if (DateTime$.MODULE$.equals(dateType)) {
                n = this.datetime().getYear();
                return Predef$.MODULE$.double2Double((double)n);
            } else if (Date$.MODULE$.equals(dateType)) {
                n = this.date().atStartOfDay().getYear();
                return Predef$.MODULE$.double2Double((double)n);
            } else {
                if (!DayDate$.MODULE$.equals(dateType)) throw new MatchError((Object)dateType);
                n = this.monthDay().atYear(2000).getYear();
            }
        }
        return Predef$.MODULE$.double2Double((double)n);
    }

    public LogoTime plus(PeriodType pType, Double durVal) {
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            return this.plus(this.datetime(), pType, durVal);
        }
        if (Date$.MODULE$.equals(dateType)) {
            return this.plus(this.date(), pType, durVal);
        }
        if (DayDate$.MODULE$.equals(dateType)) {
            return this.plus(this.monthDay(), pType, durVal);
        }
        throw new MatchError((Object)dateType);
    }

    public LogoTime plus(Object refTime, PeriodType pType, Double durValArg) {
        None$ per = None$.MODULE$;
        Double durVal = durValArg;
        PeriodType periodType = pType;
        if (Week$.MODULE$.equals(periodType)) {
            durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)604800000);
        } else if (Day$.MODULE$.equals(periodType) || DayOfYear$.MODULE$.equals(periodType)) {
            durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)86400000);
        } else if (Hour$.MODULE$.equals(periodType)) {
            durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)3600000);
        } else if (Minute$.MODULE$.equals(periodType)) {
            durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)60000);
        } else if (Second$.MODULE$.equals(periodType)) {
            durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)1000);
        } else if (!Milli$.MODULE$.equals(periodType)) {
            if (Month$.MODULE$.equals(periodType)) {
                per = Some$.MODULE$.apply((Object)Period.of(0, Predef$.MODULE$.Integer2int(TimeUtils$.MODULE$.roundDouble(durVal)), 0));
            } else if (Year$.MODULE$.equals(periodType)) {
                per = Some$.MODULE$.apply((Object)Period.of(Predef$.MODULE$.Integer2int(TimeUtils$.MODULE$.roundDouble(durVal)), 0, 0));
            } else {
                throw new ExtensionException(pType + " type is not supported by the time:plus primitive");
            }
        }
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            None$ none$ = per;
            if (None$.MODULE$.equals(none$)) {
                return new LogoTime(((LocalDateTime)refTime).plus(Duration.of(Predef$.MODULE$.Long2long(TimeUtils$.MODULE$.dToL(durVal)), ChronoUnit.MILLIS)));
            }
            if (none$ instanceof Some) {
                Period period = (Period)((Some)none$).value();
                return new LogoTime(((LocalDateTime)refTime).plus(period));
            }
            throw new MatchError((Object)none$);
        }
        if (Date$.MODULE$.equals(dateType)) {
            None$ none$ = per;
            if (None$.MODULE$.equals(none$)) {
                LocalDate logotime = ((LocalDate)refTime).atStartOfDay().plus(Duration.of(Predef$.MODULE$.Long2long(TimeUtils$.MODULE$.dToL(durVal)), ChronoUnit.MILLIS)).toLocalDate();
                return new LogoTime(logotime);
            }
            if (none$ instanceof Some) {
                Period period = (Period)((Some)none$).value();
                return new LogoTime(((LocalDate)refTime).plus(period));
            }
            throw new MatchError((Object)none$);
        }
        if (DayDate$.MODULE$.equals(dateType)) {
            None$ none$ = per;
            if (None$.MODULE$.equals(none$)) {
                return new LogoTime(MonthDay.from(((MonthDay)refTime).atYear(2000).atStartOfDay().plus(Duration.of(Predef$.MODULE$.Long2long(TimeUtils$.MODULE$.dToL(durVal)), ChronoUnit.MILLIS))));
            }
            if (none$ instanceof Some) {
                Period period = (Period)((Some)none$).value();
                return new LogoTime(MonthDay.from(((MonthDay)refTime).atYear(2000).atStartOfDay().plus(period)));
            }
            throw new MatchError((Object)none$);
        }
        throw new MatchError((Object)dateType);
    }

    public boolean isBefore(LogoTime timeB) {
        DateType dateType = this.dateType();
        DateType dateType2 = timeB.dateType();
        if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
            throw new ExtensionException("time comparisons only work if the LogoTime's are the same variety, but you called with a " + this.dateType().toString() + " and a " + timeB.dateType().toString());
        }
        DateType dateType3 = this.dateType();
        if (DateTime$.MODULE$.equals(dateType3)) {
            return this.datetime().isBefore(timeB.datetime());
        }
        if (Date$.MODULE$.equals(dateType3)) {
            return this.date().isBefore(timeB.date());
        }
        if (DayDate$.MODULE$.equals(dateType3)) {
            return this.monthDay().isBefore(timeB.monthDay());
        }
        throw new MatchError((Object)dateType3);
    }

    public boolean isEqual(LogoTime timeB) {
        DateType dateType = this.dateType();
        DateType dateType2 = timeB.dateType();
        if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
            throw new ExtensionException("time comparisons only work if the LogoTime's are the same variety, but you called with a " + this.dateType().toString() + " and a " + timeB.dateType().toString());
        }
        DateType dateType3 = this.dateType();
        if (DateTime$.MODULE$.equals(dateType3)) {
            return this.datetime().isEqual(timeB.datetime());
        }
        if (Date$.MODULE$.equals(dateType3)) {
            return this.date().isEqual(timeB.date());
        }
        if (DayDate$.MODULE$.equals(dateType3)) {
            return this.monthDay().equals(timeB.monthDay());
        }
        throw new MatchError((Object)dateType3);
    }

    public boolean isBetween(LogoTime timeAArg, LogoTime timeBArg) {
        LogoTime timeB;
        LogoTime timeA;
        block9: {
            block8: {
                timeA = timeAArg;
                timeB = timeBArg;
                if (!timeA.isBefore(timeB)) {
                    LogoTime tempA = timeA;
                    timeA = timeB;
                    timeB = tempA;
                }
                DateType dateType = this.dateType();
                DateType dateType2 = timeA.dateType();
                if (dateType != null ? !dateType.equals(dateType2) : dateType2 != null) break block8;
                DateType dateType3 = this.dateType();
                DateType dateType4 = timeB.dateType();
                if (!(dateType3 == null ? dateType4 != null : !dateType3.equals(dateType4))) break block9;
            }
            throw new ExtensionException("time comparisons only work if the LogoTime's are the same variety, but you called with a " + this.dateType().toString() + ", a " + timeA.dateType().toString() + ", and a " + timeB.dateType().toString());
        }
        DateType dateType = this.dateType();
        if (DateTime$.MODULE$.equals(dateType)) {
            return this.datetime().isAfter(timeA.datetime()) && this.datetime().isBefore(timeB.datetime()) || this.datetime().isEqual(timeA.datetime()) || this.datetime().isEqual(timeB.datetime());
        }
        if (Date$.MODULE$.equals(dateType)) {
            return this.date().isAfter(timeA.date()) && this.date().isBefore(timeB.date()) || this.date().isEqual(timeA.date()) || this.date().isEqual(timeB.date());
        }
        if (DayDate$.MODULE$.equals(dateType)) {
            if (timeA.monthDay().equals(timeAArg.monthDay())) {
                return this.monthDay().isAfter(timeA.monthDay()) && this.monthDay().isBefore(timeB.monthDay()) || this.monthDay().equals(timeA.monthDay()) || this.monthDay().equals(timeB.monthDay());
            }
            return this.monthDay().isBefore(timeBArg.monthDay()) || this.monthDay().equals(timeA.monthDay()) || this.monthDay().equals(timeB.monthDay());
        }
        throw new MatchError((Object)dateType);
    }

    public Double getDifferenceBetween(PeriodType pType, LogoTime endTime) {
        DateType dateType = this.dateType();
        DateType dateType2 = endTime.dateType();
        if (dateType == null ? dateType2 != null : !dateType.equals(dateType2)) {
            throw new ExtensionException("time comparisons only work if the LogoTimes are the same variety, but you called with a " + this.dateType().toString() + " and a " + endTime.dateType().toString());
        }
        Double durVal = Predef$.MODULE$.double2Double(1.0);
        PeriodType periodType = pType;
        if (Year$.MODULE$.equals(periodType)) {
            DateType dateType3 = this.dateType();
            if (DateTime$.MODULE$.equals(dateType3)) {
                return TimeUtils$.MODULE$.intToDouble(Period.between(this.datetime().toLocalDate(), endTime.datetime().toLocalDate()).getYears());
            }
            if (Date$.MODULE$.equals(dateType3)) {
                return TimeUtils$.MODULE$.intToDouble(Period.between(this.date(), endTime.date()).getYears());
            }
            if (DayDate$.MODULE$.equals(dateType3)) {
                throw new ExtensionException(pType + " type is not supported by the time:difference-between primitive with LogoTimes of type DAY");
            }
            throw new MatchError((Object)dateType3);
        }
        if (Month$.MODULE$.equals(periodType)) {
            DateType dateType4 = this.dateType();
            if (DateTime$.MODULE$.equals(dateType4)) {
                return TimeUtils$.MODULE$.intToDouble(Period.between(this.datetime().toLocalDate(), endTime.datetime().toLocalDate()).getMonths());
            }
            if (Date$.MODULE$.equals(dateType4)) {
                return TimeUtils$.MODULE$.intToDouble(Period.between(this.date(), endTime.date()).getMonths());
            }
            if (DayDate$.MODULE$.equals(dateType4)) {
                return TimeUtils$.MODULE$.intToDouble(Period.between(this.monthDay().atYear(2000), endTime.monthDay().atYear(2000)).getMonths());
            }
            throw new MatchError((Object)dateType4);
        }
        if (Week$.MODULE$.equals(periodType) || Day$.MODULE$.equals(periodType) || DayOfYear$.MODULE$.equals(periodType) || Hour$.MODULE$.equals(periodType) || Minute$.MODULE$.equals(periodType) || Second$.MODULE$.equals(periodType) || Milli$.MODULE$.equals(periodType)) {
            PeriodType periodType2 = pType;
            if (Week$.MODULE$.equals(periodType2)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 6.048E8);
            } else if (Day$.MODULE$.equals(periodType2) || DayOfYear$.MODULE$.equals(periodType2)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 8.64E7);
            } else if (Hour$.MODULE$.equals(periodType2)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 3600000.0);
            } else if (Minute$.MODULE$.equals(periodType2)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * 60000.0);
            } else if (Second$.MODULE$.equals(periodType2)) {
                durVal = Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(durVal) * (double)1000);
            } else if (!Milli$.MODULE$.equals(periodType2)) {
                throw new ExtensionException(pType + " testing type is not supported by the time:difference-between primitive");
            }
            DateType dateType5 = this.dateType();
            if (DateTime$.MODULE$.equals(dateType5)) {
                return Predef$.MODULE$.double2Double((double)Duration.between(this.datetime(), endTime.datetime()).toMillis() / Predef$.MODULE$.Double2double(durVal));
            }
            if (Date$.MODULE$.equals(dateType5)) {
                return Predef$.MODULE$.double2Double((double)Duration.between(this.date().atStartOfDay(), endTime.date().atStartOfDay()).toMillis() / Predef$.MODULE$.Double2double(durVal));
            }
            if (DayDate$.MODULE$.equals(dateType5)) {
                return Predef$.MODULE$.double2Double((double)Duration.between(this.monthDay().atYear(2000).atStartOfDay(), endTime.monthDay().atYear(2000).atStartOfDay()).toMillis() / Predef$.MODULE$.Double2double(durVal));
            }
            throw new MatchError((Object)dateType5);
        }
        throw new ExtensionException(pType + " coding type is not supported by the time:difference-between primitive");
    }

    private static final /* synthetic */ boolean $init$$$anonfun$1(char _$1) {
        return _$1 == 'S';
    }

    private static /* bridge */ /* synthetic */ boolean $init$$$anonfun$adapted$1(Object _$1) {
        return LogoTime.$init$$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1));
    }

    private static final /* synthetic */ boolean $init$$$anonfun$2(char _$2) {
        return _$2 == 'S';
    }

    private static /* bridge */ /* synthetic */ boolean $init$$$anonfun$adapted$2(Object _$2) {
        return LogoTime.$init$$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$2));
    }

    private final Function1 formatSeconds$1() {
        return (Function1 & Serializable)secondAndMillis -> {
            String[] stringArray = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(secondAndMillis), '.');
            if (stringArray != null) {
                String string;
                String sec;
                Object object = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                    String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                    String string3 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                    String sec2 = string2;
                    String milli = string3;
                    if (sec2.length() <= 2 && milli.length() <= 3) {
                        return this.formatToLength(sec2, 2) + "." + (milli + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 3 - milli.length()));
                    }
                    String sec3 = string2;
                    String milli2 = string3;
                    if (sec3.length() <= 2 && milli2.length() > 3) {
                        return this.formatToLength(sec3, 2) + "." + StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(milli2), 3);
                    }
                }
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 1) == 0 && (sec = (string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0))).length() <= 2) {
                    return this.formatToLength(sec, 2) + ".000";
                }
            }
            throw new ExtensionException("Illegal Second String");
        };
    }
}

