/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw;

import java.io.Serializable;
import org.nlogo.agent.Agent;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentSet;
import org.nlogo.api.ExtensionException;
import org.nlogo.extensions.nw.GraphContext$TurtleOrdering$;
import org.nlogo.extensions.nw.MonitoredAgentSet;
import org.nlogo.extensions.nw.MonitoredLinkArrayAgentSet;
import org.nlogo.extensions.nw.MonitoredLinkTreeAgentSet;
import org.nlogo.extensions.nw.MonitoredTreeAgentSet;
import org.nlogo.extensions.nw.MonitoredTurtleArrayAgentSet;
import org.nlogo.extensions.nw.MonitoredTurtleTreeAgentSet;
import org.nlogo.extensions.nw.NetworkExtensionUtil$;
import org.nlogo.extensions.nw.algorithms.BreadthFirstSearch$;
import org.nlogo.extensions.nw.algorithms.CentralityMeasurer;
import org.nlogo.extensions.nw.algorithms.PathFinder;
import org.nlogo.extensions.nw.jgrapht.Graph;
import org.nlogo.extensions.nw.jgrapht.UndirectedGraph;
import org.nlogo.extensions.nw.jung.DirectedGraph;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.EvidenceIterableFactory;
import scala.collection.EvidenceIterableFactory$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.SortedMapFactory;
import scala.collection.SortedMapFactory$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Seq;
import scala.collection.mutable.Seq$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class GraphContext
implements org.nlogo.extensions.nw.Graph<Turtle, Link>,
CentralityMeasurer {
    public static final long OFFSET$8 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("eigenvectorCentrality$lzy1"));
    public static final long OFFSET$7 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("totalArcWeight$lzy1"));
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("arcCount$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("components$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("linkCount$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("turtleCount$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("asUndirectedJGraphTGraph$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("asDirectedJGraphTGraph$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(GraphContext.class.getDeclaredField("TurtleOrdering$lzy1"));
    private volatile Object arcCount$lzy1;
    private volatile Object totalArcWeight$lzy1;
    private volatile Object eigenvectorCentrality$lzy1;
    private final World world;
    private final org.nlogo.agent.AgentSet turtleSet;
    private final org.nlogo.agent.AgentSet linkSet;
    private final World implicitWorld;
    private final MonitoredAgentSet<Turtle> turtleMonitor;
    private final MonitoredAgentSet<Link> linkMonitor;
    private volatile Object TurtleOrdering$lzy1;
    private final SortedSet<Turtle> nodes;
    private final Iterable<Link> links;
    private final Map<Turtle, Seq<Link>> undirLinks;
    private final Map<Turtle, Seq<Link>> inLinks;
    private final Map<Turtle, Seq<Link>> outLinks;
    private Option<DirectedGraph> directedJungGraph;
    private Option<org.nlogo.extensions.nw.jung.UndirectedGraph> undirectedJungGraph;
    private volatile Object asDirectedJGraphTGraph$lzy1;
    private volatile Object asUndirectedJGraphTGraph$lzy1;
    private final boolean isDirected;
    private volatile Object turtleCount$lzy1;
    private volatile Object linkCount$lzy1;
    private final PathFinder<Turtle, Link> pathFinder;
    private volatile Object components$lzy1;

    public GraphContext(World world, org.nlogo.agent.AgentSet turtleSet, org.nlogo.agent.AgentSet linkSet) {
        MonitoredAgentSet<Link> monitoredAgentSet;
        MonitoredAgentSet<Turtle> monitoredAgentSet2;
        this.world = world;
        this.turtleSet = turtleSet;
        this.linkSet = linkSet;
        org.nlogo.extensions.nw.Graph.$init$(this);
        CentralityMeasurer.$init$(this);
        this.implicitWorld = world;
        org.nlogo.agent.AgentSet agentSet = turtleSet;
        if (agentSet instanceof TreeAgentSet) {
            TreeAgentSet tas = (TreeAgentSet)agentSet;
            monitoredAgentSet2 = new MonitoredTurtleTreeAgentSet(tas, world);
        } else if (agentSet instanceof ArrayAgentSet) {
            ArrayAgentSet aas = (ArrayAgentSet)agentSet;
            monitoredAgentSet2 = new MonitoredTurtleArrayAgentSet(aas);
        } else {
            throw new IllegalStateException();
        }
        this.turtleMonitor = monitoredAgentSet2;
        org.nlogo.agent.AgentSet agentSet2 = linkSet;
        if (agentSet2 instanceof TreeAgentSet) {
            TreeAgentSet tas = (TreeAgentSet)agentSet2;
            monitoredAgentSet = new MonitoredLinkTreeAgentSet(tas, world);
        } else if (agentSet2 instanceof ArrayAgentSet) {
            ArrayAgentSet aas = (ArrayAgentSet)agentSet2;
            monitoredAgentSet = new MonitoredLinkArrayAgentSet(aas);
        } else {
            throw new IllegalStateException();
        }
        this.linkMonitor = monitoredAgentSet;
        this.nodes = (SortedSet)NetworkExtensionUtil$.MODULE$.AgentSetToRichAgentSet((AgentSet)turtleSet, this.implicitWorld()).asIterable().to(EvidenceIterableFactory$.MODULE$.toFactory((EvidenceIterableFactory)SortedSet$.MODULE$, (Object)this.TurtleOrdering()));
        this.links = (Iterable)NetworkExtensionUtil$.MODULE$.AgentSetToRichAgentSet((AgentSet)linkSet, this.implicitWorld()).asIterable().filter((Function1 & Serializable)l -> this.nodes().contains((Object)l.end1()) && this.nodes().contains((Object)l.end2()));
        scala.collection.mutable.Map in = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map out = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map undir = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.links().foreach((Function1 & Serializable)link -> {
            if (link.isDirectedLink()) {
                ((Growable)out.getOrElseUpdate((Object)link.end1(), GraphContext::$init$$$anonfun$2$$anonfun$1)).$plus$eq(link);
                return (ArrayBuffer)((Growable)in.getOrElseUpdate((Object)link.end2(), GraphContext::$init$$$anonfun$2$$anonfun$2)).$plus$eq(link);
            }
            ((Growable)undir.getOrElseUpdate((Object)link.end1(), GraphContext::$init$$$anonfun$2$$anonfun$3)).$plus$eq(link);
            return (ArrayBuffer)((Growable)undir.getOrElseUpdate((Object)link.end2(), GraphContext::$init$$$anonfun$2$$anonfun$4)).$plus$eq(link);
        });
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)undir.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).withDefaultValue((Object)Seq$.MODULE$.empty()), (Object)in.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).withDefaultValue((Object)Seq$.MODULE$.empty()), (Object)out.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).withDefaultValue((Object)Seq$.MODULE$.empty()));
        this.undirLinks = (Map)tuple3._1();
        this.inLinks = (Map)tuple3._2();
        this.outLinks = (Map)tuple3._3();
        this.directedJungGraph = None$.MODULE$;
        this.undirectedJungGraph = None$.MODULE$;
        this.isDirected = this.outLinks().nonEmpty();
        this.pathFinder = new PathFinder<Turtle, Link>(this, world, (Function1 & Serializable)variable -> this.weightFunction((String)variable));
    }

    @Override
    public int arcCount() {
        Object object = this.arcCount$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.arcCount$lzyINIT1());
    }

    private Object arcCount$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.arcCount$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)org.nlogo.extensions.nw.Graph.arcCount$(this));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.arcCount$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public double totalArcWeight() {
        Object object = this.totalArcWeight$lzy1;
        if (object instanceof Double) {
            return BoxesRunTime.unboxToDouble((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToDouble(null);
        }
        return BoxesRunTime.unboxToDouble((Object)this.totalArcWeight$lzyINIT1());
    }

    private Object totalArcWeight$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.totalArcWeight$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Double d = null;
                    try {
                        d = BoxesRunTime.boxToDouble((double)org.nlogo.extensions.nw.Graph.totalArcWeight$(this));
                        object2 = d == null ? LazyVals.NullValue$.MODULE$ : d;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.totalArcWeight$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return d;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$7, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Map eigenvectorCentrality() {
        Object object = this.eigenvectorCentrality$lzy1;
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Map)this.eigenvectorCentrality$lzyINIT1();
    }

    private Object eigenvectorCentrality$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.eigenvectorCentrality$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Map map = null;
                    try {
                        map = CentralityMeasurer.eigenvectorCentrality$(this);
                        object2 = map == null ? LazyVals.NullValue$.MODULE$ : map;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.eigenvectorCentrality$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return map;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$8, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public World world() {
        return this.world;
    }

    public org.nlogo.agent.AgentSet turtleSet() {
        return this.turtleSet;
    }

    public org.nlogo.agent.AgentSet linkSet() {
        return this.linkSet;
    }

    public World implicitWorld() {
        return this.implicitWorld;
    }

    public MonitoredAgentSet<Turtle> turtleMonitor() {
        return this.turtleMonitor;
    }

    public MonitoredAgentSet<Link> linkMonitor() {
        return this.linkMonitor;
    }

    public final GraphContext$TurtleOrdering$ TurtleOrdering() {
        Object object = this.TurtleOrdering$lzy1;
        if (object instanceof GraphContext$TurtleOrdering$) {
            return (GraphContext$TurtleOrdering$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (GraphContext$TurtleOrdering$)this.TurtleOrdering$lzyINIT1();
    }

    private Object TurtleOrdering$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.TurtleOrdering$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    GraphContext$TurtleOrdering$ graphContext$TurtleOrdering$ = null;
                    try {
                        graphContext$TurtleOrdering$ = new GraphContext$TurtleOrdering$();
                        object2 = graphContext$TurtleOrdering$ == null ? LazyVals.NullValue$.MODULE$ : graphContext$TurtleOrdering$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.TurtleOrdering$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return graphContext$TurtleOrdering$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public SortedSet<Turtle> nodes() {
        return this.nodes;
    }

    @Override
    public Iterable<Link> links() {
        return this.links;
    }

    public Map<Turtle, Seq<Link>> undirLinks() {
        return this.undirLinks;
    }

    public Map<Turtle, Seq<Link>> inLinks() {
        return this.inLinks;
    }

    public Map<Turtle, Seq<Link>> outLinks() {
        return this.outLinks;
    }

    public GraphContext verify(World w) {
        World world = w;
        World world2 = this.world();
        if (world == null ? world2 != null : !world.equals(world2)) {
            return new GraphContext(w, (org.nlogo.agent.AgentSet)w.turtles(), (org.nlogo.agent.AgentSet)w.links());
        }
        if (this.turtleMonitor().hasChanged() || this.linkMonitor().hasChanged()) {
            return new GraphContext(w, this.turtleSet() instanceof TreeAgentSet ? (org.nlogo.agent.AgentSet)Option$.MODULE$.apply((Object)w.getBreed(this.turtleSet().printName())).getOrElse(() -> GraphContext.verify$$anonfun$1(w)) : this.turtleSet(), this.linkSet() instanceof TreeAgentSet ? (org.nlogo.agent.AgentSet)Option$.MODULE$.apply((Object)w.getLinkBreed(this.linkSet().printName())).getOrElse(() -> GraphContext.verify$$anonfun$2(w)) : this.linkSet());
        }
        return this;
    }

    public org.nlogo.extensions.nw.jung.Graph asJungGraph() {
        if (this.isDirected()) {
            return this.asDirectedJungGraph();
        }
        return this.asUndirectedJungGraph();
    }

    public DirectedGraph asDirectedJungGraph() {
        return (DirectedGraph)this.directedJungGraph.getOrElse(this::asDirectedJungGraph$$anonfun$1);
    }

    public org.nlogo.extensions.nw.jung.UndirectedGraph asUndirectedJungGraph() {
        return (org.nlogo.extensions.nw.jung.UndirectedGraph)this.undirectedJungGraph.getOrElse(this::asUndirectedJungGraph$$anonfun$1);
    }

    public Graph asJGraphTGraph() {
        if (this.isDirected()) {
            return this.asDirectedJGraphTGraph();
        }
        return this.asUndirectedJGraphTGraph();
    }

    public org.nlogo.extensions.nw.jgrapht.DirectedGraph asDirectedJGraphTGraph() {
        Object object = this.asDirectedJGraphTGraph$lzy1;
        if (object instanceof org.nlogo.extensions.nw.jgrapht.DirectedGraph) {
            return (org.nlogo.extensions.nw.jgrapht.DirectedGraph)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (org.nlogo.extensions.nw.jgrapht.DirectedGraph)this.asDirectedJGraphTGraph$lzyINIT1();
    }

    private Object asDirectedJGraphTGraph$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.asDirectedJGraphTGraph$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    org.nlogo.extensions.nw.jgrapht.DirectedGraph directedGraph = null;
                    try {
                        directedGraph = new org.nlogo.extensions.nw.jgrapht.DirectedGraph(this);
                        object2 = directedGraph == null ? LazyVals.NullValue$.MODULE$ : directedGraph;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.asDirectedJGraphTGraph$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return directedGraph;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public UndirectedGraph asUndirectedJGraphTGraph() {
        Object object = this.asUndirectedJGraphTGraph$lzy1;
        if (object instanceof UndirectedGraph) {
            return (UndirectedGraph)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (UndirectedGraph)this.asUndirectedJGraphTGraph$lzyINIT1();
    }

    private Object asUndirectedJGraphTGraph$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.asUndirectedJGraphTGraph$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    UndirectedGraph undirectedGraph = null;
                    try {
                        undirectedGraph = new UndirectedGraph(this);
                        object2 = undirectedGraph == null ? LazyVals.NullValue$.MODULE$ : undirectedGraph;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.asUndirectedJGraphTGraph$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return undirectedGraph;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Function1<Link, Object> weightFunction(String variable) {
        return (Function1 & Serializable)link -> {
            double d;
            try {
                int n = link.world().program().linksOwn().indexOf((Object)variable);
                if (-1 == n) {
                    d = BoxesRunTime.unboxToDouble((Object)link.getLinkBreedVariable(variable));
                } else {
                    int i = n;
                    d = BoxesRunTime.unboxToDouble((Object)link.getLinkVariable(i));
                }
            }
            catch (ClassCastException e) {
                throw new ExtensionException("Weights must be numbers.", (Exception)e);
            }
            catch (Exception e) {
                throw new ExtensionException(e);
            }
            return d;
        };
    }

    public boolean isDirected() {
        return this.isDirected;
    }

    public int turtleCount() {
        Object object = this.turtleCount$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.turtleCount$lzyINIT1());
    }

    private Object turtleCount$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.turtleCount$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)this.nodes().size());
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.turtleCount$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int linkCount() {
        Object object = this.linkCount$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.linkCount$lzyINIT1());
    }

    private Object linkCount$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.linkCount$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)this.links().size());
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.linkCount$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Tuple2<Turtle, Turtle> ends(Link link) {
        return Tuple2$.MODULE$.apply((Object)link.end1(), (Object)link.end2());
    }

    @Override
    public Turtle otherEnd(Turtle node, Link link) {
        Turtle turtle = link.end1();
        Turtle turtle2 = node;
        if (!(turtle != null ? !turtle.equals(turtle2) : turtle2 != null)) {
            return link.end2();
        }
        return link.end1();
    }

    @Override
    public scala.collection.immutable.Seq<Link> inEdges(Turtle turtle) {
        return ((IterableOnceOps)((IterableOps)this.inLinks().apply((Object)turtle)).$plus$plus((IterableOnce)this.undirLinks().apply((Object)turtle))).toSeq();
    }

    @Override
    public scala.collection.immutable.Seq<Link> outEdges(Turtle turtle) {
        return ((IterableOnceOps)((IterableOps)this.outLinks().apply((Object)turtle)).$plus$plus((IterableOnce)this.undirLinks().apply((Object)turtle))).toSeq();
    }

    @Override
    public scala.collection.immutable.Seq<Link> allEdges(Turtle turtle) {
        return ((IterableOnceOps)((IterableOps)((IterableOps)this.inLinks().apply((Object)turtle)).$plus$plus((IterableOnce)this.outLinks().apply((Object)turtle))).$plus$plus((IterableOnce)this.undirLinks().apply((Object)turtle))).toSeq();
    }

    public String toString() {
        return this.turtleSet().toLogoList().toString() + "\n" + this.linkSet().toLogoList();
    }

    public PathFinder<Turtle, Link> pathFinder() {
        return this.pathFinder;
    }

    public Iterable<SortedSet<Turtle>> components() {
        Object object = this.components$lzy1;
        if (object instanceof Iterable) {
            return (Iterable)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Iterable)this.components$lzyINIT1();
    }

    private Object components$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.components$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Iterable iterable = null;
                    try {
                        scala.collection.mutable.Map foundBy = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                        iterable = ((MapOps)this.nodes().groupBy((Function1 & Serializable)t -> (Turtle)foundBy.getOrElseUpdate(t, () -> this.components$lzyINIT1$$anonfun$1$$anonfun$1(t, foundBy))).to(SortedMapFactory$.MODULE$.toFactory((SortedMapFactory)SortedMap$.MODULE$, (Ordering)this.TurtleOrdering()))).values();
                        object2 = iterable == null ? LazyVals.NullValue$.MODULE$ : iterable;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.components$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.components$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return iterable;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public scala.collection.immutable.Seq<MonitoredTreeAgentSet<? extends Agent>> monitoredTreeAgentSets() {
        return (scala.collection.immutable.Seq)((SeqOps)new .colon.colon(this.turtleMonitor(), (List)new .colon.colon(this.linkMonitor(), (List)Nil$.MODULE$))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(MonitoredAgentSet x) {
                MonitoredAgentSet monitoredAgentSet = x;
                if (monitoredAgentSet instanceof MonitoredTreeAgentSet) {
                    MonitoredTreeAgentSet mtas = (MonitoredTreeAgentSet)monitoredAgentSet;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(MonitoredAgentSet x, Function1 function1) {
                MonitoredAgentSet monitoredAgentSet = x;
                if (monitoredAgentSet instanceof MonitoredTreeAgentSet) {
                    MonitoredTreeAgentSet mtas = (MonitoredTreeAgentSet)monitoredAgentSet;
                    return mtas;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public void unsubscribe() {
        this.monitoredTreeAgentSets().foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.unsubscribe());
    }

    private static final ArrayBuffer $init$$$anonfun$2$$anonfun$1() {
        return ArrayBuffer$.MODULE$.empty();
    }

    private static final ArrayBuffer $init$$$anonfun$2$$anonfun$2() {
        return ArrayBuffer$.MODULE$.empty();
    }

    private static final ArrayBuffer $init$$$anonfun$2$$anonfun$3() {
        return ArrayBuffer$.MODULE$.empty();
    }

    private static final ArrayBuffer $init$$$anonfun$2$$anonfun$4() {
        return ArrayBuffer$.MODULE$.empty();
    }

    private static final TreeAgentSet verify$$anonfun$1(World w$1) {
        return w$1.turtles();
    }

    private static final org.nlogo.agent.AgentSet verify$$anonfun$2(World w$2) {
        return w$2.links();
    }

    private final DirectedGraph asDirectedJungGraph$$anonfun$1() {
        DirectedGraph g = new DirectedGraph(this);
        this.directedJungGraph = Some$.MODULE$.apply((Object)g);
        return g;
    }

    private final org.nlogo.extensions.nw.jung.UndirectedGraph asUndirectedJungGraph$$anonfun$1() {
        org.nlogo.extensions.nw.jung.UndirectedGraph g = new org.nlogo.extensions.nw.jung.UndirectedGraph(this);
        this.undirectedJungGraph = Some$.MODULE$.apply((Object)g);
        return g;
    }

    private final Turtle components$lzyINIT1$$anonfun$1$$anonfun$1(Turtle t$1, scala.collection.mutable.Map foundBy$2) {
        BreadthFirstSearch$.MODULE$.apply(this, t$1, true, true).map((Function1 & Serializable)_$1 -> (Turtle)_$1.head()).foreach((Function1)(JProcedure1 & Serializable)found -> foundBy$2.update(found, (Object)t$1));
        return t$1;
    }
}

