/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw.algorithms;

import java.io.Serializable;
import org.nlogo.agent.World;
import org.nlogo.extensions.nw.Graph;
import org.nlogo.extensions.nw.util.Cache;
import org.nlogo.extensions.nw.util.CacheManager;
import org.nlogo.extensions.nw.util.CacheManager$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Random;

public class PathFinder<V, E> {
    private final Graph<V, E> graph;
    private final Function1<String, Function1<E, Object>> weightFunction;
    private final CacheManager<Tuple2<V, V>, Object> distanceCaches;
    private final CacheManager<Tuple2<V, V>, ArrayBuffer<V>> predecessorCaches;
    private final CacheManager<Tuple2<V, V>, ArrayBuffer<V>> successorCaches;
    private final CacheManager<V, Iterator<V>> singleSourceTraversalCaches;
    private final CacheManager<V, Iterator<V>> singleDestTraversalCaches;
    private Option<V> lastSource;
    private Option<V> lastDest;

    public PathFinder(Graph<V, E> graph, World world, Function1<String, Function1<E, Object>> weightFunction) {
        this.graph = graph;
        this.weightFunction = weightFunction;
        this.distanceCaches = CacheManager$.MODULE$.apply(world);
        this.predecessorCaches = CacheManager$.MODULE$.apply(world, (Function1 & Serializable)_$1 -> (Function1 & Serializable)p -> ArrayBuffer$.MODULE$.empty());
        this.successorCaches = CacheManager$.MODULE$.apply(world, (Function1 & Serializable)_$2 -> (Function1 & Serializable)p -> ArrayBuffer$.MODULE$.empty());
        this.singleSourceTraversalCaches = CacheManager$.MODULE$.apply(world, (Function1 & Serializable)x$1 -> {
            String string;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return (Function1 & Serializable)source -> this.cachingBFS(source, false, this.predecessorCaches.apply((Option<String>)None$.MODULE$));
            }
            if (option instanceof Some && (string = (String)((Some)option).value()) != null) {
                String varName = string;
                return (Function1 & Serializable)source -> this.cachingDijkstra(source, (Function1)weightFunction.apply((Object)varName), false, this.predecessorCaches.apply((Option<String>)Some$.MODULE$.apply((Object)varName)), this.distanceCaches.apply((Option<String>)Some$.MODULE$.apply((Object)varName)));
            }
            throw new MatchError((Object)option);
        });
        this.singleDestTraversalCaches = CacheManager$.MODULE$.apply(world, (Function1 & Serializable)x$1 -> {
            String string;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return (Function1 & Serializable)source -> this.cachingBFS(source, true, this.successorCaches.apply((Option<String>)None$.MODULE$));
            }
            if (option instanceof Some && (string = (String)((Some)option).value()) != null) {
                String varName = string;
                return (Function1 & Serializable)source -> this.cachingDijkstra(source, (Function1)weightFunction.apply((Object)varName), true, this.successorCaches.apply((Option<String>)Some$.MODULE$.apply((Object)varName)), this.distanceCaches.apply((Option<String>)Some$.MODULE$.apply((Object)varName)));
            }
            throw new MatchError((Object)option);
        });
        this.lastSource = None$.MODULE$;
        this.lastDest = None$.MODULE$;
    }

    private void expandBestTraversal(Option<String> variable, V source, V dest) {
        Iterator<V> sourceTraversal = this.singleSourceTraversalCaches.apply(variable).apply(source);
        Iterator<V> destTraversal = this.singleDestTraversalCaches.apply(variable).apply(dest);
        if (sourceTraversal.hasNext() && destTraversal.hasNext()) {
            if (this.lastSource.exists((Function1 & Serializable)_$3 -> BoxesRunTime.equals((Object)_$3, (Object)source))) {
                sourceTraversal.find((Function1 & Serializable)_$4 -> BoxesRunTime.equals((Object)_$4, (Object)dest));
            } else if (this.lastDest.exists((Function1 & Serializable)_$5 -> BoxesRunTime.equals((Object)_$5, (Object)dest))) {
                destTraversal.find((Function1 & Serializable)_$6 -> BoxesRunTime.equals((Object)_$6, (Object)source));
            } else {
                Object sourcePosition = sourceTraversal.next();
                Object destPosition = destTraversal.next();
                if (!BoxesRunTime.equals((Object)sourcePosition, dest) && !BoxesRunTime.equals((Object)destPosition, source)) {
                    if (BoxesRunTime.unboxToDouble((Object)this.distanceCaches.apply(variable).apply(Tuple2$.MODULE$.apply(source, sourcePosition))) >= BoxesRunTime.unboxToDouble((Object)this.distanceCaches.apply(variable).apply(Tuple2$.MODULE$.apply(destPosition, dest)))) {
                        sourceTraversal.find((Function1 & Serializable)_$7 -> BoxesRunTime.equals((Object)_$7, (Object)dest));
                    }
                    if (BoxesRunTime.unboxToDouble((Object)this.distanceCaches.apply(variable).apply(Tuple2$.MODULE$.apply(source, sourcePosition))) <= BoxesRunTime.unboxToDouble((Object)this.distanceCaches.apply(variable).apply(Tuple2$.MODULE$.apply(destPosition, dest)))) {
                        destTraversal.find((Function1 & Serializable)_$8 -> BoxesRunTime.equals((Object)_$8, (Object)source));
                    }
                }
            }
        }
        this.lastSource = Some$.MODULE$.apply(source);
        this.lastDest = Some$.MODULE$.apply(dest);
    }

    private Option<List<V>> cachedPath(Function1<Tuple2<V, V>, ArrayBuffer<V>> cache, V source, V dest, Random rng) {
        if (BoxesRunTime.equals(source, dest)) {
            return Some$.MODULE$.apply(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{dest})));
        }
        ArrayBuffer availableSuccessors = (ArrayBuffer)cache.apply((Object)Tuple2$.MODULE$.apply(source, dest));
        if (availableSuccessors.nonEmpty()) {
            Object succ = availableSuccessors.apply(rng.nextInt(availableSuccessors.length()));
            return this.cachedPath(cache, succ, dest, rng).map((Function1 & Serializable)_$9 -> _$9.$colon$colon(source));
        }
        return None$.MODULE$;
    }

    private Option<List<V>> cachedPath(Option<String> variable, V source, V dest, Random rng) {
        return this.cachedPath(this.successorCaches.apply(variable), source, dest, rng).orElse(() -> this.cachedPath$$anonfun$2(variable, dest, source, rng));
    }

    public Option<Iterable<V>> path(V source, V dest, Random rng, Option<String> weightVariable) {
        return this.cachedPath(weightVariable, source, dest, rng).orElse(() -> this.path$$anonfun$1(weightVariable, source, dest, rng));
    }

    public Option<String> path$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> distance(V source, V dest, Option<String> weightVariable) {
        return this.distanceCaches.apply(weightVariable).get(Tuple2$.MODULE$.apply(source, dest)).orElse(() -> this.distance$$anonfun$1(weightVariable, source, dest));
    }

    public Option<String> distance$default$3() {
        return None$.MODULE$;
    }

    private Iterator<V> cachingBFS(V start, boolean reverse, Function1<Tuple2<V, V>, ArrayBuffer<V>> predecessorCache) {
        Function1 & Serializable neighbors = reverse ? (Function1 & Serializable)node -> this.graph.inNeighbors(node) : (Function1 & Serializable)node -> this.graph.outNeighbors(node);
        Map dists = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        dists.update((Object)Tuple2$.MODULE$.apply(start, start), (Object)BoxesRunTime.boxToInteger((int)0));
        Cache distances = this.distanceCaches.apply((Option<String>)None$.MODULE$);
        distances.update(Tuple2$.MODULE$.apply(start, start), BoxesRunTime.boxToDouble((double)0.0));
        return package$.MODULE$.Iterator().iterate(package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{start})), (Function1 & Serializable)last -> {
            ObjectRef layer = ObjectRef.create((Object)((List)Nil$.MODULE$));
            last.map((Function1 & Serializable)node -> {
                int distance = BoxesRunTime.unboxToInt((Object)dists.apply((Object)Tuple2$.MODULE$.apply(start, node)));
                return Tuple2$.MODULE$.apply(node, (Object)BoxesRunTime.boxToInteger((int)distance));
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object node = tuple2._1();
                    int distance = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    ((IterableOnceOps)neighbors.apply(node)).foreach((Function1)(JProcedure1 & Serializable)neighbor -> {
                        if (!dists.contains((Object)Tuple2$.MODULE$.apply(start, neighbor))) {
                            dists.update((Object)Tuple2$.MODULE$.apply(start, neighbor), (Object)BoxesRunTime.boxToInteger((int)(distance + 1)));
                            if (reverse) {
                                distances.update(Tuple2$.MODULE$.apply(neighbor, start), BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(distance + 1)));
                            } else {
                                distances.update(Tuple2$.MODULE$.apply(start, neighbor), BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(distance + 1)));
                            }
                            layer$2.elem = ((List)layer$2.elem).$colon$colon(neighbor);
                        }
                        if (BoxesRunTime.unboxToInt((Object)dists.apply((Object)Tuple2$.MODULE$.apply(start, neighbor))) == distance + 1) {
                            ((Buffer)predecessorCache.apply((Object)Tuple2$.MODULE$.apply(neighbor, start))).append(node);
                            return;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return (List)layer.elem;
        }).takeWhile((Function1 & Serializable)_$11 -> _$11.nonEmpty()).flatten(Predef$.MODULE$.$conforms());
    }

    private Iterator<V> cachingDijkstra(V start, Function1<E, Object> weight, boolean reverse, Function1<Tuple2<V, V>, ArrayBuffer<V>> predecessorCache, Cache<Tuple2<V, V>, Object> distanceCache) {
        Function1 & Serializable edges = reverse ? (Function1 & Serializable)node -> this.graph.inEdges(node) : (Function1 & Serializable)node -> this.graph.outEdges(node);
        Map dists = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        PriorityQueue heap = (PriorityQueue)PriorityQueue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[0]), (Object)package$.MODULE$.Ordering().apply((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).on((Function1 & Serializable)_$12 -> -BoxesRunTime.unboxToDouble((Object)_$12._2())));
        Object object = Predef$.MODULE$.ArrowAssoc(start);
        distanceCache.update(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, start), BoxesRunTime.boxToDouble((double)0.0));
        return package$.MODULE$.Iterator().continually(() -> this.cachingDijkstra$$anonfun$1(heap, start, dists, reverse, distanceCache, edges, weight, predecessorCache)).takeWhile((Function1 & Serializable)x -> heap.nonEmpty()).flatten(Predef$.MODULE$.$conforms());
    }

    private final Option cachedPath$$anonfun$2(Option variable$1, Object dest$4, Object source$5, Random rng$1) {
        return this.cachedPath(this.predecessorCaches.apply((Option<String>)variable$1), dest$4, source$5, rng$1).map((Function1 & Serializable)_$10 -> _$10.reverse());
    }

    private final Option path$$anonfun$1(Option weightVariable$1, Object source$6, Object dest$5, Random rng$2) {
        this.expandBestTraversal((Option<String>)weightVariable$1, source$6, dest$5);
        return this.cachedPath((Option<String>)weightVariable$1, source$6, dest$5, rng$2);
    }

    private final Option distance$$anonfun$1(Option weightVariable$2, Object source$7, Object dest$6) {
        this.expandBestTraversal((Option<String>)weightVariable$2, source$7, dest$6);
        return this.distanceCaches.apply((Option<String>)weightVariable$2).get(Tuple2$.MODULE$.apply(source$7, dest$6));
    }

    private static final double $anonfun$7() {
        return 0.0;
    }

    private final List cachingDijkstra$$anonfun$1(PriorityQueue heap$1, Object start$5, Map dists$5, boolean reverse$4, Cache distanceCache$1, Function1 edges$1, Function1 weight$1, Function1 predecessorCache$4) {
        double curDistance = BoxesRunTime.unboxToDouble((Object)heap$1.headOption().map((Function1 & Serializable)_$13 -> BoxesRunTime.unboxToDouble((Object)_$13._2())).getOrElse(PathFinder::$anonfun$7));
        heap$1.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{Tuple3$.MODULE$.apply(start$5, (Object)BoxesRunTime.boxToDouble((double)0.0), start$5)}));
        List layer = (List)Nil$.MODULE$;
        while (heap$1.nonEmpty() && BoxesRunTime.unboxToDouble((Object)((Tuple3)heap$1.head())._2()) <= curDistance) {
            Tuple3 tuple3 = (Tuple3)heap$1.dequeue();
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Object turtle = tuple3._1();
            double distance = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            Object predecessor = tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply(turtle, (Object)BoxesRunTime.boxToDouble((double)distance), predecessor);
            Object turtle2 = tuple32._1();
            double distance2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            Object predecessor2 = tuple32._3();
            boolean alreadyAdded = dists$5.contains(turtle2);
            if (alreadyAdded && !(BoxesRunTime.unboxToDouble((Object)dists$5.apply(turtle2)) >= distance2)) continue;
            if (!alreadyAdded) {
                layer = layer.$colon$colon(turtle2);
                dists$5.update(turtle2, (Object)BoxesRunTime.boxToDouble((double)distance2));
                if (reverse$4) {
                    Object object = Predef$.MODULE$.ArrowAssoc(turtle2);
                    distanceCache$1.update(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, start$5), BoxesRunTime.boxToDouble((double)distance2));
                } else {
                    Object object = Predef$.MODULE$.ArrowAssoc(start$5);
                    distanceCache$1.update(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, turtle2), BoxesRunTime.boxToDouble((double)distance2));
                }
                ((IterableOnceOps)edges$1.apply(turtle2)).foreach((Function1)(JProcedure1 & Serializable)link -> {
                    Object other = this.graph.otherEnd(turtle2, link);
                    double dist = distance2 + BoxesRunTime.unboxToDouble((Object)weight$1.apply(link));
                    if (!dists$5.contains(other)) {
                        heap$1.enqueue((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{Tuple3$.MODULE$.apply(other, (Object)BoxesRunTime.boxToDouble((double)dist), turtle2)}));
                        return;
                    }
                });
            }
            if (BoxesRunTime.equals((Object)turtle2, (Object)predecessor2)) continue;
            ((Buffer)predecessorCache$4.apply((Object)Tuple2$.MODULE$.apply(turtle2, start$5))).append(predecessor2);
        }
        return layer;
    }
}

