/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.nw.jung.io;

import edu.uci.ics.jung.graph.Hypergraph;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.Link;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentVariables$;
import org.nlogo.api.Dump$;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.Program;
import org.nlogo.extensions.nw.GraphContext;
import org.nlogo.extensions.nw.NetworkExtensionUtil$;
import org.nlogo.extensions.nw.jung.io.GraphMLWriterWithAttribType;
import scala.Function1;
import scala.Function2;
import scala.Function5;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure5;

public final class GraphMLExport$
implements Serializable {
    public static final GraphMLExport$ MODULE$ = new GraphMLExport$();

    private GraphMLExport$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GraphMLExport$.class);
    }

    public void save(GraphContext graphContext, String filename) {
        World world = graphContext.world();
        GraphMLWriterWithAttribType graphMLWriter = new GraphMLWriterWithAttribType();
        this.addImplicitVariables$1((Iterable)Predef$.MODULE$.wrapRefArray((Object[])AgentVariables$.MODULE$.getImplicitTurtleVariables(false)), (Function5)(JProcedure5 & Serializable)(id, description, default_value, attrType, vertex_transformer) -> graphMLWriter.addVertexData((String)id, (String)description, (String)default_value, (String)attrType, vertex_transformer));
        this.addImplicitVariables$1((Iterable)Predef$.MODULE$.wrapRefArray((Object[])AgentVariables$.MODULE$.getImplicitLinkVariables()), (Function5)(JProcedure5 & Serializable)(id, description, default_value, attrType, edge_transformer) -> graphMLWriter.addEdgeData((String)id, (String)description, (String)default_value, (String)attrType, edge_transformer));
        Program program = world.program();
        SortedSet<Turtle> turtles = graphContext.nodes();
        Iterable<Link> links = graphContext.links();
        Seq turtlesOwn = program.turtlesOwn();
        Seq linksOwn = program.linksOwn();
        this.addVariables$1((Iterable)turtles, (Iterable)turtlesOwn, (Function2 & Serializable)(t, v) -> turtlesOwn.contains(v), (Function2 & Serializable)(t, v) -> t.getVariable(turtlesOwn.indexOf(v)), (Function5)(JProcedure5 & Serializable)(id, description, default_value, attrType, vertex_transformer) -> graphMLWriter.addVertexData((String)id, (String)description, (String)default_value, (String)attrType, vertex_transformer));
        this.addVariables$1(links, (Iterable)linksOwn, (Function2 & Serializable)(t, v) -> linksOwn.contains(v), (Function2 & Serializable)(t, v) -> t.getVariable(linksOwn.indexOf(v)), (Function5)(JProcedure5 & Serializable)(id, description, default_value, attrType, edge_transformer) -> graphMLWriter.addEdgeData((String)id, (String)description, (String)default_value, (String)attrType, edge_transformer));
        this.addVariables$1((Iterable)turtles, (Iterable)program.breeds().values().flatMap((Function1 & Serializable)_$1 -> _$1.owns()), (Function2 & Serializable)(t, v) -> world.breedOwns((AgentSet)t.getBreed(), v), (Function2 & Serializable)(t, v) -> t.getBreedVariable(v), (Function5)(JProcedure5 & Serializable)(id, description, default_value, attrType, vertex_transformer) -> graphMLWriter.addVertexData((String)id, (String)description, (String)default_value, (String)attrType, vertex_transformer));
        this.addVariables$1(links, (Iterable)program.linkBreeds().values().flatMap((Function1 & Serializable)_$2 -> _$2.owns()), (Function2 & Serializable)(l, v) -> world.linkBreedOwns((AgentSet)l.getBreed(), v), (Function2 & Serializable)(l, v) -> l.getLinkBreedVariable(v), (Function5)(JProcedure5 & Serializable)(id, description, default_value, attrType, edge_transformer) -> graphMLWriter.addEdgeData((String)id, (String)description, (String)default_value, (String)attrType, edge_transformer));
        try {
            NetworkExtensionUtil$.MODULE$.using(new PrintWriter(new BufferedWriter(new FileWriter(filename))), (JProcedure1 & Serializable)printWriter -> graphMLWriter.save((Hypergraph)graphContext.asJungGraph(), (Writer)printWriter));
        }
        catch (Exception e) {
            throw new ExtensionException(e);
        }
    }

    public <T extends Agent> String findAttrType(Iterable<T> agents, Function1<T, Object> varChecker, Function1<T, Object> varGetter) {
        return (String)agents.headOption().withFilter(varChecker).map((Function1 & Serializable)agent -> {
            Object object = varGetter.apply(agent);
            if (object instanceof Double) {
                return "double";
            }
            if (object instanceof Boolean) {
                return "boolean";
            }
            return "string";
        }).getOrElse(GraphMLExport$::findAttrType$$anonfun$2);
    }

    private final void addImplicitVariables$1(Iterable vars, Function5 adder) {
        ((IterableOnceOps)vars.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String variableName = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Function1 & Serializable transformer = (Function1 & Serializable)a -> Dump$.MODULE$.logoObject(a.getVariable(i));
                adder.apply((Object)variableName, null, null, (Object)"string", NetworkExtensionUtil$.MODULE$.functionToTransformer(transformer));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final void addVariables$1(Iterable agents, Iterable vars, Function2 varChecker, Function2 varGetter, Function5 adder) {
        vars.foreach((Function1)(JProcedure1 & Serializable)variableName -> {
            String attrType = MODULE$.findAttrType(agents, (Function1 & Serializable)_$3 -> BoxesRunTime.unboxToBoolean((Object)varChecker.apply(_$3, variableName)), (Function1 & Serializable)_$4 -> varGetter.apply(_$4, variableName));
            Function1 & Serializable transformer = (Function1 & Serializable)a -> {
                if (BoxesRunTime.unboxToBoolean((Object)varChecker.apply(a, variableName))) {
                    return Dump$.MODULE$.logoObject(varGetter.apply(a, variableName));
                }
                return null;
            };
            adder.apply(variableName, null, null, (Object)attrType, NetworkExtensionUtil$.MODULE$.functionToTransformer(transformer));
        });
    }

    private static final String findAttrType$$anonfun$2() {
        return "";
    }
}

